/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.shaker.processors.geo.Geocoder;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.StatusLine;
import com.dataiku.dss.shadelib.org.apache.http.client.ResponseHandler;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeocoderMapBox
extends Geocoder {
    private String mapID;
    private String fullUrl;

    @Override
    protected int getLimit() {
        return 50;
    }

    private GeocoderMapBox() {
    }

    public static GeocoderMapBox getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void setAPIKey(String apiKey) throws IllegalArgumentException {
        this.apiKey = apiKey;
        this.fullUrl = "http://api.tiles.mapbox.com/v3/" + this.mapID + "/geocode/";
        try {
            new URI(this.fullUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("MapBox map ID '" + this.mapID + "' contains invalid character");
        }
    }

    @Override
    protected List<Geocoder.Coord> callAPI(LinkedHashSet<String> queries) {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        if (queries == null || queries.size() == 0) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(this.fullUrl + URLEncoder.encode(StringUtils.join(queries, (String)";"), "UTF-8") + ".json");
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            logger.error((Object)"Couldn't build URI for MapBox API call");
            return null;
        }
        HttpGet httpget = new HttpGet(uri);
        ResponseHandler<JSONArray> rh = new ResponseHandler<JSONArray>(){

            public JSONArray handleResponse(HttpResponse response) {
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    Geocoder.logger.error((Object)("MapBox API error: " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase()));
                    return null;
                }
                if (entity == null) {
                    Geocoder.logger.error((Object)"MapBox API error : empty response");
                    return null;
                }
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                String read = null;
                try {
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                    read = IOUtils.toString((Reader)reader);
                }
                catch (Exception e) {
                    Geocoder.logger.error((Object)"MapBox API error : could not read response");
                    return null;
                }
                try {
                    return new JSONArray(read);
                }
                catch (JSONException e) {
                    JSONArray a = new JSONArray();
                    try {
                        a.put(0, (Object)new JSONObject(read));
                    }
                    catch (JSONException e1) {
                        Geocoder.logger.error((Object)("MapBox API error : not a valid JSON array : " + read));
                        return null;
                    }
                    return a;
                }
            }
        };
        JSONArray myjson = null;
        try {
            myjson = (JSONArray)client.execute((HttpUriRequest)httpget, (ResponseHandler)rh);
        }
        catch (Exception e) {
            logger.error((Object)"MapBox API http execute error");
            return null;
        }
        ArrayList<Geocoder.Coord> results = new ArrayList<Geocoder.Coord>();
        if (myjson != null) {
            for (int i = 0; i < myjson.length(); ++i) {
                try {
                    JSONObject qo = myjson.getJSONObject(i);
                    if (!qo.has("results")) continue;
                    double lat = qo.getJSONArray("results").getJSONArray(0).getJSONObject(0).getDouble("lat");
                    double lon = qo.getJSONArray("results").getJSONArray(0).getJSONObject(0).getDouble("lon");
                    results.add(new Geocoder.Coord(lat, lon, null));
                    continue;
                }
                catch (JSONException e) {
                    results.add(new Geocoder.Coord());
                }
            }
        }
        return results;
    }

    private static class SingletonHolder {
        private static final GeocoderMapBox instance = new GeocoderMapBox();

        private SingletonHolder() {
        }
    }
}

