/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.DateParser;
import com.dataiku.dip.shaker.processors.time.DateProcessor;
import com.dataiku.dip.shaker.processors.time.Language;
import com.dataiku.dip.shaker.processors.time.TimezonableProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class DateFormatter
extends TimezonableProcessor {
    public static final ProcessorMeta<DateFormatter, Parameter> META = new DateProcessor.DateProcessorMeta<DateFormatter, Parameter>(){

        @Override
        public String getName() {
            return "DateFormatter";
        }

        @Override
        public String getDocPage() {
            return "date-formatter";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.DateFormatter.HELP", "Format data in standard ISO-8601 format (*yyyy-MM-ddTHH:mm:ss.SSSZ*) to another custom date format. Use this processor to convert an ISO-8601 date into a string that may be easier to read. \n\n# Options\n\n**Input column**\n\nColumn containing data in ISO-8601 format. Use a Prepare step to parse your data into this format if it isn\u2019t already. \n\n**Date format**\n\nSpecify the custom date format of the output column using the <a target=\"_blank\" href=\"http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html\">Java syntax for date specifier</a>. \n\n<u>*Note*</u>\nCommon patterns include y (year), M (month in year), w (week in year), d (day in month), E (day name in week), a (am/pm marker), H (hour in day 0-24), h (hour in am/pm 1-12), m (minute in hour), s (second in minute), S (millisecond), Z (time zone).\n\n**Locale**\n\nTranslate date information in locale format (like \u2018mercredi\u2019 or \u2018janvier\u2019 in French). \n\n**Timezone**\n\nChange the timezone from the UTC default. Options include using a TZ column, an IP column, or specifying a timezone from the dropdown.\n\n**Output column**\n\nLeave blank to format data in place, or create a separate output column.\n\n<u>*Warning*</u>\nIf the output format is not ISO-8601, DSS will treat it as an unparsed date. \n\n# Related resources\n\nFor more information on managing dates with Dataiku DSS, please see the <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/latest/preparation/dates.html\">reference documentation</a>.\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            ProcessorDesc desc = new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.DateFormatter.DESCRIPTION", 1.actionVerb("Format") + " date with custom format"), false).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.INPUT_COLUMN", "Input column")).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)")).withMNESParam("format", this.translate(language, "SHAKER.PROCESSOR.DateFormatter.DESCRIPTION.FORMAT", "Output date format")).withParam(ParamDesc.advancedSelect("lang", this.translate(language, "SHAKER.PROCESSOR.DateFormatter.DESCRIPTION.LANG", "Locale"), "", Language.class).withDefaultValue("auto"));
            TimezonableProcessor.appendTimezoneParams(language, desc);
            return desc;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if ("extract_from_ip".equals(p.timezone_id)) {
                ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Only fixed or column timezone is supported");
            } else {
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            }
            if ("extract_from_ip".equals(p.timezone_id) || "extract_from_column".equals(p.timezone_id)) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Only fixed timezone is supported");
            } else if (dialect.getOperator(QueryUtils.OperatorType.FORMAT) == null) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Format to string to date is not available");
            } else {
                SQLCapability capability = dialect.canFormatDate(p.format, false);
                if (!capability.capable) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot handle format '" + p.format + "' : " + capability.reason);
                } else {
                    ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                }
            }
            return ret;
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"inCol", "outCol"});
        }

        @Override
        public DateFormatter build(Parameter parameter) {
            return new DateFormatter(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.time.DateFormatterNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = super.getUpdatedDatasetPairLineage(pss.params, (DatasetPairLineage)previousDatasetPairLineage, false);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private SimpleDateFormat dateFormat;
    private Column inCD;
    private Column outCD;
    private final Date dateMeaning = new Date();
    private final DateOnly dateOnlyMeaning = new DateOnly();
    private final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private final TimeZone utcTz = TimeZone.getTimeZone("UTC");
    private Parameter params;

    public DateFormatter(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.dateFormat = DateParser.getFormat(this.params.format, this.params.lang);
        this.inCD = this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = StringUtils.isNotBlank((String)this.params.outCol) ? this.getColumnFactory().columnAfter(this.params.inCol, this.params.outCol, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.initTimezonableWithParams(this.params.timezone_id, this.params.timezone_src);
    }

    public void processRow(Row row) throws Exception {
        boolean inputHasTzInfo;
        String rowVal = row.get(this.inCD);
        long dateVal = this.dateMeaning.longValue(rowVal);
        if (dateVal == Long.MAX_VALUE) {
            inputHasTzInfo = false;
            dateVal = this.datetimeNoTzMeaning.longValue(rowVal);
            if (dateVal == Long.MAX_VALUE && (dateVal = this.dateOnlyMeaning.longValue(rowVal)) == Long.MAX_VALUE) {
                return;
            }
        } else {
            inputHasTzInfo = true;
        }
        if (inputHasTzInfo) {
            DateTimeZone tz = this.getTimezone(row);
            if (tz != null) {
                java.util.Date date = new java.util.Date(dateVal);
                this.dateFormat.setTimeZone(tz.toTimeZone());
                String outputDate = this.dateFormat.format(date);
                row.put(this.outCD, outputDate);
            }
        } else {
            java.util.Date date = new java.util.Date(dateVal);
            this.dateFormat.setTimeZone(this.utcTz);
            String outputDate = this.dateFormat.format(date);
            row.put(this.outCD, outputDate);
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    extends DateProcessor.DateParameter {
        private static final long serialVersionUID = -1L;
        String format;
        Language lang = Language.en_US;
        String timezone_id = "UTC";
        String timezone_src;

        @Override
        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;
        private final ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            if (StringUtils.equals((String)this.parameter.inCol, (String)this.parameter.outCol)) {
                this.parameter.outCol = null;
            }
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.inCol});
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            if (StringUtils.isNotBlank((String)this.parameter.outCol)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.outCol);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            Locale locale = this.parameter.lang.toLocale();
            if (!input.getDialect().canFormatDate((String)this.parameter.format, (boolean)false).capable) {
                throw new IllegalArgumentException("Cannot handle format '" + this.parameter.format + "'");
            }
            if (input.getDialect().getOperator(QueryUtils.OperatorType.FORMAT) == null) {
                throw new IllegalArgumentException("Cannot handle parse dates in " + input.getDialect().getId());
            }
            for (String column : affectedColumns) {
                SchemaColumn inputSchemaColumn = input.getCurrentColumn(column);
                Type inputType = inputSchemaColumn.getType();
                if (!inputType.isTemporal()) {
                    inputType = Type.DATE;
                }
                ExpressionBuilder col = input.col(inputSchemaColumn);
                ExpressionBuilder e = col.format(this.ebf.cst(inputType), this.ebf.cst(this.parameter.format), this.ebf.cst(locale), this.ebf.cst(this.parameter.timezone_id));
                input.addAfterOrReplaceColumn(inputSchemaColumn, e, Type.STRING, this.parameter.outCol, false);
            }
            return input;
        }
    }
}

