/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DatasetDependency;
import com.dataiku.dip.ProcessorWithSingleCopyAdditionalInputs;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.dynamic.SmallDatasetEasyLoadHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.regex.RegexDatabaseSupport;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PerfUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FindReplace {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    public static final ProcessorMeta<StreamImpl, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FindReplace";
        }

        @Override
        public String getDocPage() {
            return "find-replace";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.STRING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FindReplace.HELP", "Find and replace strings in one or more columns. Find/Replace supports multiple replacements: Several replacements can be applied on the same cell, one after the other. \n\nTo stop the replacement after the first occurrence, select **Only perform the first matching replacement**.\n\n# Options\n**Column**\nApply find and replace to the following: \n* A single column\n* An explicit list of columns\n* All columns matching a regex pattern\n* All columns\n\n**Output column**\nCreate a separate output column or leave blank to perform find and replace in-column.\n\n**Replacements**\nList the strings to match and their corresponding replacements.\n\n**Matching mode**\n\nDetermine the type of replacement for find and replace to perform.\n* **Complete value:** replace the entire content of the matched cell\n* **Substring:** replace all occurrences of a string within the cell\n* **Regular expression:** replace matches of a regular expression\n\n<u>*Note:*</u>\n* Regular expression matching supports group captures. Reference groups using the $index notation. If you want to find/replace *val-17-x* into *V17*, use the following replacement *val-([0-9]*)-.** \u2192 *V$1*\n* To replace the symbol *$* in a regular expression match, escape it and type *\\$*.\n\n**Normalization mode**\nSpecify how to find the match: \n* **Exact (no transformation):** use case-sensitive search\n* **Ignore case:** use case-insenstive search\n* **Normalize (ignore accents):** use accents-insensitive search\n\n<u>*Note:*</u>\nAccent-insensitive normalization is only available for complete value matching.\n# Related resources\nTo extract multiple values from a cell using a regular expression, use the <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/11.0/preparation/processors/pattern-extract.html\">extract with regular expression</a> processor. \n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FindReplace.DESCRIPTION", 1.actionVerb("Find") + " and " + 1.actionVerb("replace")), null, false).withBool("stopAfterFirstMatch", this.translate(language, "SHAKER.PROCESSOR.FindReplace.DESCRIPTION.STOP_AFTER_FIRST_MATCH", "Stop after the first match"), "").withParam(ParamDesc.advancedSelect("normalization", this.translate(language, "SHAKER.PROCESSOR.FindReplace.DESCRIPTION.NORMALIZATION", "Normalization mode"), "", StringNormalizationMode.class, language).withDefaultValue(StringNormalizationMode.EXACT)).withParam(ParamDesc.advancedSelect("matching", this.translate(language, "SHAKER.PROCESSOR.FindReplace.DESCRIPTION.MATCHING", "Matching mode"), "", StringMatchingMode.class, language).withDefaultValue(StringMatchingMode.SUBSTRING)).withParam("mapping", "map", true, true, this.translate(language, "SHAKER.PROCESSOR.FindReplace.DESCRIPTION.MAPPING", "Replacements from highest to lowest priority")).withParam("output", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)")).withHiddenDescription("regexp pattern regex");
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = AppliesToProcessor.selfReport(parameter);
            obj.remove("mapping");
            obj.remove("output");
            obj.addProperty("nbMappings", (Number)parameter.mapping.size());
            return obj;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)sp;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            if (p.normalization != StringNormalizationMode.EXACT && p.normalization != StringNormalizationMode.LOWERCASE) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string normalization is not translatable", p.normalization));
                return ret;
            }
            if (p.matching == StringMatchingMode.SUBSTRING && p.normalization == StringNormalizationMode.LOWERCASE) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: lowercase substring matching is not translatable");
                return ret;
            }
            if (p.matching == StringMatchingMode.PATTERN) {
                if (!DKUApp.getParams().getBoolParam("dip.regex.sqlPushdown.disabled", false)) {
                    if (!dialect.supportsOperator(QueryUtils.OperatorType.REGEXP_REPLACE)) {
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: Pattern string matching is not translatable");
                        return ret;
                    }
                    if (!dialect.supportsCaseInsensitivityRegExp() && p.normalization == StringNormalizationMode.LOWERCASE) {
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: Pattern string matching with case insensitivity is not translatable");
                        return ret;
                    }
                    for (Substitution s : ((Parameter)sp).mapping) {
                        RegexDatabaseSupport.RegexSupportStatus supported = dialect.supportsRegExpReplaceExpressions(s.from, s.to);
                        if (supported.ok) continue;
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: Pattern expressions are not translatable, the given expressions are not supported : " + supported.reason);
                        return ret;
                    }
                } else {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: Pattern string matching is not translatable");
                    return ret;
                }
            }
            ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            return ret;
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.transform.FindReplaceNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter findReplaceParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(findReplaceParams, (DatasetPairLineage)previousDatasetPairLineage, findReplaceParams.output, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, true);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.shaker.transform.findreplace");

    public static int getDatasetSubstitutionsLimit(boolean stopAfterFirstMatch) {
        if (stopAfterFirstMatch) {
            return DKUApp.getParams().getIntParamOrElse("dku.processors.findReplace.datasetSubstitutionsLimit", 10000);
        }
        return DKUApp.getParams().getIntParamOrElse("dku.processors.findReplace.recursive.datasetSubstitutionsLimit", 500);
    }

    private static List<Substitution> getMappingFromDataset(AuthCtx authCtx, String contextProjectKey, Parameter parameter, boolean isRecipeValidation) {
        Preconditions.checkArgument((boolean)parameter.useDatasetForMapping, (Object)"Read replacements from dataset is disabled");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)parameter.mappingDatasetRef), (Object)"Dataset to read from is not specified");
        logger.info((Object)("Using mapping from dataset " + parameter.mappingDatasetRef + " isRecipeValidation=" + isRecipeValidation));
        if (isRecipeValidation) {
            return Lists.newArrayList((Object[])new Substitution[]{new Substitution("sample_replacement_from_1", "sample_replacement_to_1"), new Substitution("sample_replacement_from_2", "sample_replacement_to_2")});
        }
        try {
            MemTable mt = SmallDatasetEasyLoadHelper.load_AutoTXN(authCtx, AnyLoc.resolveSmart(contextProjectKey, parameter.mappingDatasetRef), FindReplace.getDatasetSubstitutionsLimit(parameter.stopAfterFirstMatch));
            ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
            for (MemRow row : mt.rows) {
                String from = row.get(mt.column(parameter.mappingDatasetFromColumn));
                String to = row.get(mt.column(parameter.mappingDatasetToColumn));
                Substitution subst = new Substitution(from, to);
                substitutions.add(subst);
            }
            return substitutions;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to gather mapping", e);
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = 1L;
        public String output = "";
        public StringNormalizationMode normalization = StringNormalizationMode.EXACT;
        public StringMatchingMode matching = StringMatchingMode.SUBSTRING;
        public boolean stopAfterFirstMatch = false;
        public List<Substitution> mapping = new ArrayList<Substitution>();
        public boolean useDatasetForMapping;
        @Nullable
        public String mappingDatasetRef;
        @Nullable
        public String mappingDatasetFromColumn;
        @Nullable
        public String mappingDatasetToColumn;
    }

    public static class Substitution
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String from;
        public String to;

        public Substitution(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    private static class StreamImpl
    extends AppliesToProcessor
    implements ProcessorWithSingleCopyAdditionalInputs<RightDataLoader>,
    Processor {
        private final Parameter param;
        private List<Substitution> normalizedSubstitutions;
        private Map<String, Pattern> regexpPatterns;
        private boolean mappingInitialized = false;
        Column outCD;

        private StreamImpl(Parameter param) {
            this.param = param;
        }

        public void postProcess() {
        }

        @Override
        public void init() throws Exception {
            super.init();
            if (this.param.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)this.param.output)) {
                this.outCD = this.getColumnFactory().columnAfter((String)this.param.columns.get(0), this.param.output, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
            if (!this.param.useDatasetForMapping) {
                this.initMapping(this.param.mapping);
            }
        }

        private void initMapping(List<Substitution> mapping) {
            block11: {
                String s;
                int flag;
                block10: {
                    assert (!this.mappingInitialized);
                    this.mappingInitialized = true;
                    flag = 0;
                    if (this.param.normalization == StringNormalizationMode.NORMALIZED && (this.param.matching == StringMatchingMode.PATTERN || this.param.matching == StringMatchingMode.SUBSTRING)) {
                        logger.error((Object)("Error: Normalization not available for " + this.param.matching.getLabel()));
                        this.param.normalization = StringNormalizationMode.LOWERCASE;
                    }
                    if (this.param.normalization == StringNormalizationMode.LOWERCASE) {
                        flag = 66;
                    }
                    this.normalizedSubstitutions = new ArrayList<Substitution>();
                    for (Substitution p : mapping) {
                        if (p.to == null) {
                            p.to = "";
                        }
                        if (p.from == null) {
                            p.from = "";
                        }
                        String normalized = this.param.normalization.apply(p.from);
                        this.normalizedSubstitutions.add(new Substitution(normalized, p.to.replace("\\", "\\\\")));
                    }
                    if (this.param.matching != StringMatchingMode.PATTERN) break block10;
                    this.regexpPatterns = new LinkedHashMap<String, Pattern>();
                    for (Substitution m : this.normalizedSubstitutions) {
                        s = m.from;
                        if (StringUtils.isEmpty((String)s)) {
                            this.regexpPatterns.put(s, Pattern.compile("^$", flag));
                            continue;
                        }
                        this.regexpPatterns.put(s, Pattern.compile(s, flag));
                    }
                    break block11;
                }
                if (this.param.matching != StringMatchingMode.SUBSTRING) break block11;
                this.regexpPatterns = new LinkedHashMap<String, Pattern>();
                for (Substitution m : this.normalizedSubstitutions) {
                    s = m.from;
                    if (StringUtils.isEmpty((String)s)) {
                        this.regexpPatterns.put(s, Pattern.compile("^$", flag));
                        continue;
                    }
                    this.regexpPatterns.put(s, Pattern.compile(Pattern.quote(s), flag));
                }
            }
        }

        @Override
        public AppliesToProcessor.AppliesToParams getParams() {
            return this.param;
        }

        @Override
        public void processRowForColumns(Row row, Iterable<Column> columns) {
            assert (this.mappingInitialized);
            for (Column cd : columns) {
                String v = StringUtils.defaultIfEmpty((String)row.get(cd), (String)"");
                boolean modified = false;
                for (Substitution entry : this.normalizedSubstitutions) {
                    Matcher m;
                    String searchValue = entry.from;
                    String replaceValue = entry.to;
                    if (this.param.matching == StringMatchingMode.FULL_STRING) {
                        String normalized = this.param.normalization.apply(v);
                        if (searchValue.equals(normalized)) {
                            v = replaceValue;
                            modified = true;
                        }
                    } else if (this.param.matching == StringMatchingMode.PATTERN) {
                        m = this.regexpPatterns.get(searchValue).matcher(v);
                        if (m.find()) {
                            v = m.replaceAll(replaceValue);
                            modified = true;
                        }
                    } else if (this.param.matching == StringMatchingMode.SUBSTRING && (m = this.regexpPatterns.get(searchValue).matcher(v)).find()) {
                        v = m.replaceAll(replaceValue);
                        modified = true;
                    }
                    if (!modified || !this.param.stopAfterFirstMatch) continue;
                    break;
                }
                if (this.outCD != null) {
                    row.put(this.outCD, v);
                    continue;
                }
                if (!modified) continue;
                row.put(cd, v);
            }
        }

        @Override
        public RightDataLoader buildLoader() {
            return new RightDataLoader();
        }

        @Override
        public void setAdditionalInputs(RightDataLoader rightDataLoader) {
            if (this.param.useDatasetForMapping) {
                this.initMapping(rightDataLoader.substitutions);
            }
        }

        @Override
        public List<DatasetDependency> listDependencies() {
            if (!this.param.useDatasetForMapping) {
                return Collections.emptyList();
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.param.mappingDatasetRef), (Object)"Dataset to read from is not specified");
            return Lists.newArrayList((Object[])new DatasetDependency[]{new DatasetDependency(this.param.mappingDatasetRef, Lists.newArrayList((Object[])new String[]{this.param.mappingDatasetFromColumn, this.param.mappingDatasetToColumn}), "reference")});
        }

        class RightDataLoader
        implements SingleCopyAdditionalInputsLoader {
            final List<Substitution> substitutions = new ArrayList<Substitution>();

            public RightDataLoader() {
                logger.info((Object)"Creating data loader for find-replace");
            }

            @Override
            public Callable<Void> loadAdditionalInputs(AdditionalInputAccessor srunner) throws Exception {
                if (!StreamImpl.this.param.useDatasetForMapping || StringUtils.isBlank((String)StreamImpl.this.param.mappingDatasetRef)) {
                    return () -> null;
                }
                AdditionalInputAccessor.AdditionalInput ai = srunner.getAdditionalInput(StreamImpl.this.param.mappingDatasetRef);
                final RowInputStream rightIS = ai.getInput();
                final ColumnFactory rightCF = ai.getColumnFactory();
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Row row;
                        PerfUtils.markSlowCode();
                        logger.info((Object)"Starting to load find-replace data");
                        int substitutionsLimit = FindReplace.getDatasetSubstitutionsLimit(StreamImpl.this.param.stopAfterFirstMatch);
                        while ((row = rightIS.next()) != null) {
                            if (RightDataLoader.this.substitutions.size() == substitutionsLimit) {
                                throw new RuntimeException("Reached maximum number of substitutions: " + substitutionsLimit);
                            }
                            String from = row.get(rightCF.column(StreamImpl.this.param.mappingDatasetFromColumn));
                            String to = row.get(rightCF.column(StreamImpl.this.param.mappingDatasetToColumn));
                            Substitution subst = new Substitution(from, to);
                            RightDataLoader.this.substitutions.add(subst);
                        }
                        return null;
                    }
                };
            }
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(AuthCtx authCtx, String contextProjectKey, ShakerSQLTranslator.ShakerSQLTranslatorContext context, SQLQueryWithSchema input) {
            List<Substitution> mapping = this.parameter.useDatasetForMapping ? FindReplace.getMappingFromDataset(authCtx, contextProjectKey, this.parameter, context == ShakerSQLTranslator.ShakerSQLTranslatorContext.RECIPE_STATUS_COMPUTE) : this.parameter.mapping;
            if (mapping.isEmpty()) {
                return input;
            }
            List<String> affectedColumns = input.getAppliesToColumns(this.parameter);
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            if (StringUtils.isNotBlank((String)this.parameter.output)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.output);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            for (String column : affectedColumns) {
                this.buildColumnSQLTranslator(input, column, mapping).apply();
            }
            return input;
        }

        private AbstractColumnSQLTranslator buildColumnSQLTranslator(SQLQueryWithSchema input, String column, List<Substitution> mapping) {
            return switch (this.parameter.matching) {
                case StringMatchingMode.FULL_STRING -> new FullStringColumnSQLTranslator(input, column, mapping);
                case StringMatchingMode.SUBSTRING -> new SubStringColumnSQLTranslator(input, column, mapping);
                case StringMatchingMode.PATTERN -> new PatternColumnSQLTranslator(input, column, mapping);
                default -> throw new NotImplementedException();
            };
        }

        private abstract class AbstractColumnSQLTranslator {
            private final boolean usesOutputColumn;
            private final boolean lowercase;
            private final boolean setCaseSensitive;
            private final boolean stopAfterFirstMatch;
            private final SQLQueryWithSchema input;
            private final String inputColumnName;
            final Type inputColumnType;
            final String outputColumnName;
            final List<Substitution> mapping;
            final List<Substitution> normalizedSubstitutions;
            final SchemaColumn inputSchemaColumn;

            AbstractColumnSQLTranslator(SQLQueryWithSchema input, String inputColumnName, List<Substitution> mapping) {
                this.input = input;
                this.inputColumnName = inputColumnName;
                this.mapping = mapping;
                this.inputSchemaColumn = input.getMandatoryCurrentColumn(inputColumnName);
                this.usesOutputColumn = SQLTranslator.this.parameter.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)SQLTranslator.this.parameter.output);
                this.lowercase = SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE && !input.getDialect().hasCaseInsensitiveComparisons();
                this.setCaseSensitive = SQLTranslator.this.parameter.normalization == StringNormalizationMode.EXACT && input.getDialect().hasCaseInsensitiveComparisons();
                this.stopAfterFirstMatch = SQLTranslator.this.parameter.stopAfterFirstMatch;
                this.inputColumnType = this.inputSchemaColumn.getType();
                this.normalizedSubstitutions = Lists.newArrayList();
                for (Substitution subst : mapping) {
                    String normalizedFrom = subst.from;
                    if (this.lowercase) {
                        normalizedFrom = normalizedFrom.toLowerCase(Locale.ENGLISH);
                    }
                    this.normalizedSubstitutions.add(new Substitution(normalizedFrom, subst.to));
                }
                this.outputColumnName = this.usesOutputColumn ? SQLTranslator.this.parameter.output : inputColumnName;
            }

            public SQLQueryWithSchema getInput() {
                return this.input;
            }

            void apply() {
                ExpressionBuilder col = this.getExpressionBuilderOnInputColumn();
                ExpressionBuilder cw = this.stopAfterFirstMatch ? this.buildSubstitutionsCaseWhenExpression(col) : this.buildSubstitutionsNestedExpression(col);
                this.input.addAfterOrReplaceColumn(this.inputSchemaColumn, cw, Type.STRING, this.outputColumnName, false);
            }

            String normalizeString(String x) {
                if (this.lowercase) {
                    return x.toLowerCase(Locale.ENGLISH);
                }
                return x;
            }

            boolean shouldLowerCaseInput() {
                return true;
            }

            ExpressionBuilder normalizeColumn(ExpressionBuilder col) {
                ExpressionBuilder normalizedCol = col;
                if (this.lowercase && this.shouldLowerCaseInput()) {
                    normalizedCol = normalizedCol.lower();
                }
                if (this.setCaseSensitive) {
                    normalizedCol = normalizedCol.caseSensitivity(true);
                }
                return normalizedCol;
            }

            private ExpressionBuilder buildSubstitutionsCaseWhenExpression(ExpressionBuilder col) {
                ExpressionBuilder normalizedCol = this.normalizeColumn(col);
                ExpressionBuilder cw = EBF.caseWhen(new Object[0]);
                for (Substitution subst : this.normalizedSubstitutions) {
                    cw = this.addSubstitutionCaseWhen(normalizedCol, cw, subst);
                }
                return cw.caseWhen(col);
            }

            private ExpressionBuilder addSubstitutionCaseWhen(ExpressionBuilder normalizedInCol, ExpressionBuilder cwToUpdate, Substitution subst) {
                return cwToUpdate.caseWhen(this.buildCondition(normalizedInCol, subst), this.buildSubstitution(normalizedInCol, subst));
            }

            private ExpressionBuilder getExpressionBuilderOnInputColumn() {
                ExpressionBuilder result = this.input.col(this.inputColumnName);
                if (this.inputColumnType != Type.STRING) {
                    return result.castToString(200);
                }
                return result;
            }

            protected abstract ExpressionBuilder buildSubstitutionsNestedExpression(ExpressionBuilder var1);

            protected abstract ExpressionBuilder buildCondition(ExpressionBuilder var1, Substitution var2);

            protected abstract ExpressionBuilder buildSubstitution(@Nullable ExpressionBuilder var1, Substitution var2);
        }

        private class FullStringColumnSQLTranslator
        extends AbstractColumnSQLTranslator {
            FullStringColumnSQLTranslator(SQLQueryWithSchema input, String inputColumnName, List<Substitution> mapping) {
                super(input, inputColumnName, mapping);
            }

            @Override
            protected ExpressionBuilder buildSubstitutionsNestedExpression(ExpressionBuilder col) {
                Object subst2;
                HashSet affectedValues = Sets.newHashSet();
                for (Object subst2 : this.mapping) {
                    affectedValues.add(((Substitution)subst2).from);
                }
                ArrayList effectiveSubstitutions = Lists.newArrayList();
                subst2 = affectedValues.iterator();
                while (subst2.hasNext()) {
                    String affectedValue;
                    String x = affectedValue = (String)subst2.next();
                    for (Substitution subst3 : this.mapping) {
                        if (SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE) {
                            if (!StringUtils.equalsIgnoreCase((String)x, (String)subst3.from)) continue;
                            x = StringUtils.defaultIfEmpty((String)subst3.to, (String)"");
                            continue;
                        }
                        if (!StringUtils.equals((String)x, (String)subst3.from)) continue;
                        x = StringUtils.defaultIfEmpty((String)subst3.to, (String)"");
                    }
                    effectiveSubstitutions.add(new Substitution(this.normalizeString(affectedValue), x));
                }
                ExpressionBuilder result = col;
                ExpressionBuilder normalizedCol = this.normalizeColumn(col);
                for (Substitution subst4 : effectiveSubstitutions) {
                    if (StringUtils.isEmpty((String)subst4.from)) {
                        result = EBF.caseWhen(normalizedCol.eq(subst4.from).or(normalizedCol.isnull()), this.buildSubstitution(null, subst4), result);
                        continue;
                    }
                    result = EBF.caseWhen(normalizedCol.eq(subst4.from), this.buildSubstitution(null, subst4), result);
                }
                return result;
            }

            @Override
            protected ExpressionBuilder buildCondition(ExpressionBuilder expression, Substitution subst) {
                if (StringUtils.isEmpty((String)subst.from)) {
                    return expression.isNullOrEmptyString();
                }
                return expression.eq(EBF.cst(subst.from));
            }

            @Override
            protected ExpressionBuilder buildSubstitution(@Nullable ExpressionBuilder expression, Substitution subst) {
                return EBF.cst(subst.to).cast(Type.STRING, 200);
            }
        }

        private class SubStringColumnSQLTranslator
        extends AbstractColumnSQLTranslator {
            SubStringColumnSQLTranslator(SQLQueryWithSchema input, String inputColumnName, List<Substitution> mapping) {
                super(input, inputColumnName, mapping);
            }

            @Override
            protected ExpressionBuilder buildSubstitutionsNestedExpression(ExpressionBuilder col) {
                ArrayList effectiveSubstitutions = Lists.newArrayList();
                for (Substitution subst : this.normalizedSubstitutions) {
                    if (StringUtils.isEmpty((String)subst.from) && StringUtils.isEmpty((String)subst.to)) continue;
                    effectiveSubstitutions.add(subst);
                }
                ExpressionBuilder result = col;
                for (Substitution subst : effectiveSubstitutions) {
                    result = this.normalizeColumn(result);
                    result = this.buildSubstitution(result, subst);
                }
                return result;
            }

            @Override
            protected ExpressionBuilder buildCondition(ExpressionBuilder expression, Substitution subst) {
                if (StringUtils.isEmpty((String)subst.from)) {
                    return expression.isNullOrEmptyString();
                }
                return expression.contains(EBF.cst(subst.from));
            }

            @Override
            protected ExpressionBuilder buildSubstitution(@Nullable ExpressionBuilder expression, Substitution subst) {
                assert (expression != null);
                if (StringUtils.isEmpty((String)subst.from)) {
                    return expression.coalesceNullOrEmptyString(EBF.cst(subst.to));
                }
                return expression.replace(EBF.cst(subst.from), EBF.cst(subst.to));
            }
        }

        private class PatternColumnSQLTranslator
        extends AbstractColumnSQLTranslator {
            private static final Pattern CAPTURE_MATCHER = Pattern.compile("\\$(\\d+)");

            PatternColumnSQLTranslator(SQLQueryWithSchema input, String inputColumnName, List<Substitution> mapping) {
                super(input, inputColumnName, mapping);
            }

            @Override
            boolean shouldLowerCaseInput() {
                return false;
            }

            @Override
            protected ExpressionBuilder buildCondition(ExpressionBuilder expression, Substitution subst) {
                if (StringUtils.isEmpty((String)subst.from)) {
                    return expression.isNullOrEmptyString();
                }
                boolean hasSubstr = this.getInput().getDialect().supportsOperator(QueryUtils.OperatorType.REGEXP_SUBSTR);
                if (hasSubstr) {
                    if (SQLTranslator.this.parameter.normalization == StringNormalizationMode.EXACT) {
                        return expression.regexpSubstr(EBF.cst(subst.from)).isNullOrEmptyString().not();
                    }
                    return expression.regexpSubstr(EBF.cst(subst.from), SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE).isnotnull();
                }
                if (SQLTranslator.this.parameter.normalization == StringNormalizationMode.EXACT) {
                    return expression.regexpReplace(EBF.cst(subst.from), "dku_marker_test").contains("dku_marker_test");
                }
                return expression.regexpReplace(EBF.cst(subst.from), "dku_marker_test", SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE).contains("dku_marker_test");
            }

            @Override
            protected ExpressionBuilder buildSubstitutionsNestedExpression(ExpressionBuilder col) {
                ArrayList effectiveSubstitutions = Lists.newArrayList();
                for (Substitution subst : this.normalizedSubstitutions) {
                    if (StringUtils.isEmpty((String)subst.from) && StringUtils.isEmpty((String)subst.to)) continue;
                    effectiveSubstitutions.add(subst);
                }
                ExpressionBuilder result = col;
                for (Substitution subst : effectiveSubstitutions) {
                    result = this.buildSubstitution(result, subst);
                }
                return result;
            }

            private String replaceCaptureGroupInSubstitution(String s) {
                Matcher matcher = CAPTURE_MATCHER.matcher(s);
                SQLDialect dialect = this.getInput().getDialect();
                StringBuilder builder = new StringBuilder();
                int start = 0;
                while (matcher.find()) {
                    String index = matcher.group(1);
                    MatchResult res = matcher.toMatchResult();
                    builder.append(s.substring(start, res.start()));
                    builder.append(dialect.captureGroup(Integer.parseInt(index)));
                    start = res.end();
                }
                builder.append(s.substring(start));
                return builder.toString();
            }

            @Override
            protected ExpressionBuilder buildSubstitution(@Nullable ExpressionBuilder expression, Substitution subst) {
                assert (expression != null);
                String to = this.replaceCaptureGroupInSubstitution(subst.to);
                if (StringUtils.isEmpty((String)subst.from)) {
                    return expression.coalesceNullOrEmptyString(EBF.cst(to));
                }
                if (SQLTranslator.this.parameter.normalization == StringNormalizationMode.EXACT) {
                    return expression.regexpReplace(EBF.cst(subst.from), EBF.cst(to));
                }
                return expression.regexpReplace(EBF.cst(subst.from), EBF.cst(to), SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE);
            }
        }
    }
}

