/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.typespecific.VisitorIdGeneratorAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class VisitorIdGenerator {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "VisitorIdGenerator";
        }

        @Override
        public String getDocPage() {
            return "visitor-id";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.WEB, ProcessorTag.ENRICH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.HELP", "This processor generates visitor identifiers for web logs that don't already have one.\n\nWhen processing web logs, it is often required to have a unique identifier for each visitor.\n\n When processing logs coming from a full-featured web tracker, like [Dataiku's WT1](https://doc.dataiku.com/display/WT1), each log line already features a unique visitor id.\n\nHowever, when processing more raw logs, like Apache Access logs, you generally don't have one. It is also possible to have no visitor id if the visitor disabled cookies.\n\nThis processor will try to assign a visitor-id to each line, using as much information to identify the visitor as possible.\nYou need to specify a name for the output column, and to fill information about which columns are available. All input columns are optional.\n\nThis processor will try to use:\n\n* The IP address\n* The user-agent string\n* The language of the user's browser\n* The timezone offset of the user's browser\n# Important note\nAlthough these information will often lead to uniquely identifying each visitor (especially for home users), this is a best-effort and some collisions (two distinct visitors being assigned the same id) will happen, especially for visitors from large companies.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.DESCRIPTION", 1.actionVerb("Generate") + " a best-effort visitor id")).withMNESParam("outputColumn", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withParam("ipColumn", "column", false, true, this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.DESCRIPTION.IP_COLUMN", "IP address column")).withParam("userAgentColumn", "column", false, true, this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.DESCRIPTION.USER_AGENT_COLUMN", "User-Agent column")).withParam("browserLanguageColumn", "column", false, true, this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.DESCRIPTION.BROWSER_LANGUAGE_COLUMN", "Browser Language column")).withParam("timezoneOffsetColumn", "column", false, true, this.translate(language, "SHAKER.PROCESSOR.VisitorIdGenerator.DESCRIPTION.TIMEZONE_OFFSET_COLUMN", "Timezone offset column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return new ProcessorMeta.ProcessorCapabilitiesSummary();
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter params = (Parameter)pss.params;
            if (StringUtils.isBlank((String)params.outputColumn)) {
                throw new IllegalConfigurationException("Missing output column for Visitor ID Generator processor");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                updatedDatasetPairLineage.removeRelationsOnColumn(params.outputColumn);
                Stream.of(params.ipColumn, params.userAgentColumn, params.browserLanguageColumn, params.timezoneOffsetColumn).filter(StringUtils::isNotBlank).forEach(inputColumn -> updatedDatasetPairLineage.addFactorizedColumnRelations((String)inputColumn, params.outputColumn));
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter parameter;
        private final List<Column> columns = new ArrayList<Column>();
        private Column outputCD;

        public StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void init() {
            this.addInputColumnIfNotEmpty(this.parameter.ipColumn);
            this.addInputColumnIfNotEmpty(this.parameter.userAgentColumn);
            this.addInputColumnIfNotEmpty(this.parameter.browserLanguageColumn);
            this.addInputColumnIfNotEmpty(this.parameter.timezoneOffsetColumn);
            this.outputCD = this.getColumnFactory().column(this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        }

        public void processRow(Row row) {
            List input = this.columns.stream().map(arg_0 -> ((Row)row).get(arg_0)).collect(Collectors.toList());
            row.put(this.outputCD, new VisitorIdGeneratorAlgorithm().generateId(input));
        }

        public void postProcess() throws Exception {
        }

        private void addInputColumnIfNotEmpty(String column) {
            if (!StringUtils.isBlank((String)column)) {
                this.columns.add(this.getColumnFactory().column(column, Processor.ProcessorRole.INPUT_COLUMN));
            }
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final String functionName = "visitorIdGenerator_" + SecretKeyGenerator.generate();
        private final Parameter parameter;

        private SnowflakeUDFSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.typespecific.VisitorIdGeneratorUDF.process", "input ARRAY", "ARRAY", "STRING");
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            StringJoiner joiner = new StringJoiner(", ");
            boolean needSubquery = this.addColumnIfNotEmptyAndNeedsSubquery(chain, joiner, this.parameter.ipColumn);
            needSubquery = needSubquery || this.addColumnIfNotEmptyAndNeedsSubquery(chain, joiner, this.parameter.userAgentColumn);
            needSubquery = needSubquery || this.addColumnIfNotEmptyAndNeedsSubquery(chain, joiner, this.parameter.browserLanguageColumn);
            boolean bl = needSubquery = needSubquery || this.addColumnIfNotEmptyAndNeedsSubquery(chain, joiner, this.parameter.timezoneOffsetColumn);
            if (needSubquery) {
                chain = chain.makeSubquery();
            }
            ExpressionBuilder expr = ebf.expr(String.format("%s(ARRAY_CONSTRUCT(%s))", this.functionName, joiner.toString()));
            chain.addAfterOrReplaceColumn(null, expr, Type.STRING, this.parameter.outputColumn, false);
            return chain;
        }

        private boolean addColumnIfNotEmptyAndNeedsSubquery(SQLQueryWithSchema chain, StringJoiner joiner, String column) {
            SQLDialect d = chain.getDialect();
            if (!StringUtils.isEmpty((String)column)) {
                joiner.add(d.quoteIdentifier(column));
                return chain.isCreatedOrModifiedByCurrentQuery(column);
            }
            return false;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String ipColumn;
        public String userAgentColumn;
        public String browserLanguageColumn;
        public String timezoneOffsetColumn;
        public String outputColumn;

        public void validate() throws IllegalArgumentException {
        }
    }
}

