/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.logging.LimitedLogContext;
import com.dataiku.dip.logging.LimitedLogFactory;
import com.dataiku.dip.sql.bigquery.BigQuerySimbaResultReader;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.log4j.Level;

public class BigQueryColumnReader {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery");
    private static final LimitedLogContext limitedErrorLogger = LimitedLogFactory.get((DKULogger)logger, (String)"dku.sql.bigquery.simba", (Level)Level.ERROR);

    @Nullable
    public static String readStructOrArray(ResultSet rs2, int colIdx, SchemaColumn schemaColumn) {
        try {
            String jsonText = BigQuerySimbaResultReader.readStructOrArray(rs2, colIdx, schemaColumn);
            if (jsonText == null) {
                return null;
            }
            JsonElement jsonElement = new JsonParser().parse(jsonText);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            if (jsonElement.isJsonObject()) {
                return JSON.gson().toJson(BigQueryColumnReader.parseHierarchicalValue(jsonElement.getAsJsonObject(), schemaColumn));
            }
            throw new JsonSyntaxException("Invalid json object: " + String.valueOf(jsonElement));
        }
        catch (Exception e) {
            limitedErrorLogger.log("BigQuery Simba driver provided invalid json data for column \"" + schemaColumn.getName() + "\".", (Throwable)e);
            return null;
        }
    }

    public static String readBytes(ResultSet rs2, int colIdx) throws SQLException {
        byte[] bytes = rs2.getBytes(colIdx);
        return bytes == null ? null : BaseEncoding.base64().encode(bytes);
    }

    @Nullable
    public static String readDateTime(ResultSet rs2, int colIdx, DateTimeZone assumedTz, SimpleDateFormat parser) throws SQLException {
        Date dt;
        String s = rs2.getString(colIdx);
        TimeZone tz = assumedTz != null ? assumedTz.toTimeZone() : TimeZone.getTimeZone("UTC");
        parser.setTimeZone(tz);
        try {
            dt = parser.parse(s);
        }
        catch (ParseException e) {
            dt = null;
        }
        if (dt == null) {
            return null;
        }
        return DKUtils.isoFormatReadableByDateFormat((long)dt.getTime());
    }

    private static JsonElement parseHierarchicalValue(JsonObject inputFields, SchemaColumn schemaColumn) {
        if (inputFields.has("v")) {
            if (inputFields.get("v").isJsonObject() && inputFields.getAsJsonObject("v").has("f") && inputFields.getAsJsonObject("v").get("f").isJsonArray()) {
                JsonObject outputObject = new JsonObject();
                int colId = 0;
                for (JsonElement inputField : inputFields.getAsJsonObject("v").getAsJsonArray("f")) {
                    JsonElement subObject;
                    SchemaColumn fieldColumn;
                    if (inputField.isJsonObject() && colId < schemaColumn.objectFields.size()) {
                        fieldColumn = (SchemaColumn)schemaColumn.objectFields.get(colId);
                        subObject = BigQueryColumnReader.parseHierarchicalValue(inputField.getAsJsonObject(), fieldColumn);
                        if (fieldColumn.getType() == Type.DATE && subObject.isJsonPrimitive() && ((JsonPrimitive)subObject).isString()) {
                            subObject = BigQueryColumnReader.fixDate(subObject);
                        }
                    } else {
                        throw new JsonSyntaxException("Invalid json object: " + String.valueOf(inputFields));
                    }
                    outputObject.add(fieldColumn.getName(), subObject);
                    ++colId;
                }
                return outputObject;
            }
            if (inputFields.get("v").isJsonArray()) {
                JsonArray outputArray = new JsonArray();
                for (JsonElement inputField : inputFields.getAsJsonArray("v")) {
                    if (inputField.isJsonObject()) {
                        outputArray.add(BigQueryColumnReader.parseHierarchicalValue(inputField.getAsJsonObject(), schemaColumn.arrayContent));
                        continue;
                    }
                    throw new JsonSyntaxException("Invalid json object: " + String.valueOf(inputFields));
                }
                return outputArray;
            }
            if (inputFields.get("v").isJsonPrimitive() || inputFields.get("v").isJsonNull()) {
                return inputFields.get("v");
            }
            throw new JsonSyntaxException("Invalid json value: " + String.valueOf(inputFields));
        }
        throw new JsonSyntaxException("Invalid json object: " + String.valueOf(inputFields));
    }

    private static JsonElement fixDate(JsonElement subObject) {
        String str = subObject.getAsString();
        if (str.length() > 8 && str.charAt(4) == '-' && str.charAt(7) == '-') {
            return subObject;
        }
        try {
            long millis = (long)(Double.parseDouble(str) * 1000.0);
            return new JsonPrimitive(DKUDateUtils.isoFormatUTC((long)millis));
        }
        catch (NumberFormatException e2) {
            return subObject;
        }
    }
}

