/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.H2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class H2SQLDialect
extends GenericSQLDialect {
    public static final String DIALECT_ID = "H2";

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        if (schemaColumn.getType() == Type.STRING) {
            return new DSSTypeSQLMapping(Type.STRING, 12, "varchar", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setTimestamp(colIdx, new Timestamp(timestamp));
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 93: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx);
                    if (ts == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                }
                return rs2.getString(colIdx);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public boolean canSQL99() {
        return false;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.INNER_ONLY;
    }

    @Override
    public boolean isNaturalJoinImplicitlyInner() {
        return true;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 0x40000000;
    }

    public String createCreateTableFromCsvStatementSQL(Dataset dataset, List<SchemaColumn> columns, String fileName, CSVFormatConfig csvConfig, String csvOpts) {
        List columnNames = columns.stream().map(SchemaColumn::getName).collect(Collectors.toList());
        List columnNamesQuoted = columnNames.stream().map(this::quoteIdentifier).collect(Collectors.toList());
        return this.getCreateTableStatementSQL(new H2Connection(), dataset, new InfoMessage.InfoMessages(), false) + " AS SELECT " + StringUtils.join(columnNamesQuoted, (char)',') + " FROM CSVREAD('" + fileName + "', '" + StringUtils.join(columnNames, (String)csvConfig.getSeparatorStr()) + "', '" + csvOpts + "')";
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.DATE) {
            return "TIMESTAMP " + expr;
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.NARY){

            private String replace(String str, String x, String y) {
                return "REPLACE(" + str + ", " + H2SQLDialect.this.quoteString(x) + ", " + H2SQLDialect.this.quoteString(y) + ")";
            }

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String ret = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                for (int i = 0; i < from.length() && i < to.length(); ++i) {
                    ret = this.replace(ret, from.substring(i, i + 1), to.substring(i, i + 1));
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String unit;
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                switch (unit = this.getParamAs(args[2], String.class)) {
                    case "YEAR": 
                    case "MONTH": 
                    case "WEEK": 
                    case "DAY": 
                    case "HOUR": 
                    case "MINUTE": 
                    case "SECOND": {
                        return "DATEDIFF(" + unit + "," + start + ", " + end + ")";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.SUBSTR, "SUBSTRING", QueryUtils.Arity.NARY);
        this.addAggregateConcat();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LOG, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 1 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                double base = 10.0;
                String arg = this.toSQLNoBrackets(args[0]);
                if (args.length > 1) {
                    base = this.getParamAs(args[1], Double.class);
                }
                if (base == 2.0) {
                    return "LN(" + arg + ")";
                }
                return "LN(" + arg + ") / LN(" + base + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return H2SQLDialect.this.doQuoteDate(ret);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                return "DATEADD(" + unit + ", " + addIntLong + ", " + datetimeNoTz + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = H2SQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "CAST(PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', 'UTC') AS DATE)";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "CAST(PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', 'UTC') AS TIMESTAMP)";
                    }
                    return "PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    timezoneId = StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC");
                    String sqlFormat = H2SQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "FORMATDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', 'UTC')";
                    }
                    return "FORMATDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
    }

    protected void addAggregateConcat() {
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "group_concat", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                String separator = null;
                boolean distinct = false;
                if (args.length > 1) {
                    QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                    String string = separator = separatorExpr == null ? null : this.toSQLNoBrackets(separatorExpr);
                }
                if (args.length > 2) {
                    QueryAst.ConstExpr distinctExpr = (QueryAst.ConstExpr)args[2];
                    boolean bl = distinct = distinctExpr == null ? false : (Boolean)distinctExpr.value;
                }
                if (separator == null) {
                    return "group_concat(" + (distinct ? "DISTINCT " : "") + "CAST(" + column + " AS VARCHAR) separator '')";
                }
                return "group_concat(" + (distinct ? "DISTINCT " : "") + "CAST(" + column + " AS VARCHAR) separator " + separator + ")";
            }
        });
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd','en','UTC'), ' 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case HOUR: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH','en','UTC'), ':00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case MONTH: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM','en','UTC'), '-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case YEAR: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy','en','UTC'), '-01-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case MINUTE: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm','en','UTC'), ':00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case SECOND: {
                return "PARSEDATETIME(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm:ss','en','UTC'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case WEEK: {
                return "PARSEDATETIME(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-ww','fr','UTC'), 'yyyy-ww','fr','UTC')";
            }
            case QUARTER: {
                return "PARSEDATETIME(concat(FORMATDATETIME(" + inputDateExpression + ", 'yyyy','en','UTC'), decode(FORMATDATETIME(" + inputDateExpression + ", 'MM','en','UTC'),'01','01','02','01','03','01','04','04','05','04','06','04','07','07','08','07','09','07','10','10','11','10','12','10'), '-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
        }
        throw new QueryUtils.SQLGenerationException("Rounding mode not implemented for H2:" + String.valueOf(rounding));
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "DAY_OF_MONTH(" + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "HOUR(" + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "MINUTE(" + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "SECOND(" + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "MONTH(" + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "ISO_WEEK(" + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "QUARTER(" + inputDateExpression + ")";
            }
            case YEAR: {
                return "YEAR(" + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "ISO_DAY_OF_WEEK(" + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(" + this.datePartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH) + " * 1000 + " + this.datePartExpression(inputDateExpression, DatePart.MILLISECOND_OF_SECOND) + ")";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on H2", part));
    }

    @Override
    public String quoteDate(String str) {
        return this.doQuoteDate(this.quoteString(str));
    }

    protected String doQuoteDate(String str) {
        return "PARSEDATETIME(" + str + ", 'yyyy-MM-dd HH:mm:ss','en','UTC')";
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public int getIdentifiersMaxLength() {
        return -1;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return false;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (forParsing) {
            if (part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
                return part.text.replace('x', 'Y');
            }
            if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && part.numeric) {
                return "F";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(part.text).matches()) {
                return "'" + part.text.replace("'", "''") + "'";
            }
            return part.text;
        }
        return part.text;
    }

    @Override
    public String getId() {
        return DIALECT_ID;
    }
}

