/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;

public class VerticaCopyHelper {
    Class<?> verticaConnectionClass;
    Class<?> verticaCopyStreamClass;
    Constructor<?> verticaCopyStreamCtor;
    Method addStreamMethod;
    Method executeMethod;
    Method getRowCountMethod;
    Method getRejectsMethod;
    Method finishMethod;
    Object verticaCopyStream = null;

    private void setupClasses(Connection conn) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        if (this.verticaConnectionClass == null) {
            ClassLoader classLoader = conn.getClass().getClassLoader();
            this.verticaConnectionClass = classLoader.loadClass("com.vertica.jdbc.VerticaConnection");
            this.verticaCopyStreamClass = classLoader.loadClass("com.vertica.jdbc.VerticaCopyStream");
            this.verticaCopyStreamCtor = this.verticaCopyStreamClass.getConstructor(this.verticaConnectionClass, String.class);
            this.addStreamMethod = this.verticaCopyStreamClass.getMethod("addStream", InputStream.class);
            this.executeMethod = this.verticaCopyStreamClass.getMethod("execute", new Class[0]);
            this.getRowCountMethod = this.verticaCopyStreamClass.getMethod("getRowCount", new Class[0]);
            this.getRejectsMethod = this.verticaCopyStreamClass.getMethod("getRejects", new Class[0]);
            this.finishMethod = this.verticaCopyStreamClass.getMethod("finish", new Class[0]);
        }
    }

    public void createCopyStream(SQLConnectionProvider.SQLConnectionWrapper conn, String sql) throws Exception {
        Connection actualConnection = conn.getConnectionUnsafe(true);
        this.setupClasses(actualConnection);
        this.createCopyStream(actualConnection, sql);
    }

    private void createCopyStream(Connection conn, String sql) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.verticaCopyStream = this.verticaCopyStreamCtor.newInstance(conn, sql);
    }

    public void addStream(InputStream is) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.addStreamMethod.invoke(this.verticaCopyStream, is);
    }

    public void execute() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.executeMethod.invoke(this.verticaCopyStream, new Object[0]);
    }

    public long getRowCount() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Long)this.getRowCountMethod.invoke(this.verticaCopyStream, new Object[0]);
    }

    public List<Long> getRejects() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (List)this.getRejectsMethod.invoke(this.verticaCopyStream, new Object[0]);
    }

    public void finish() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.finishMethod.invoke(this.verticaCopyStream, new Object[0]);
    }
}

