/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.sql.bigquery.EncryptionConfiguration;
import com.dataiku.dip.sql.bigquery.Schema;
import com.dataiku.dip.sql.bigquery.TablePartitioning;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;

public class CreateTableInfo {
    public String tableId;
    public Schema schema;
    public String friendlyName;
    public String description;
    public Long expirationTime;
    public TablePartitioning partitioning;
    public EncryptionConfiguration encryptionConfiguration;

    public static CreateTableInfo of(String tableId, Schema schema) {
        return CreateTableInfo.of(tableId, null, schema);
    }

    public static CreateTableInfo of(String tableId, String friendlyName, Schema schema) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableId) ? 1 : 0) != 0, (Object)"tableId cannot be null or empty.");
        Preconditions.checkNotNull((Object)schema, (Object)"schema cannot be null.");
        CreateTableInfo result = new CreateTableInfo();
        result.tableId = tableId;
        result.schema = schema;
        result.friendlyName = friendlyName;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableInfo that = (CreateTableInfo)o;
        return this.tableId != null ? this.tableId.equals(that.tableId) : that.tableId == null;
    }

    public int hashCode() {
        return this.tableId != null ? this.tableId.hashCode() : 0;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

