/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.regex;

import com.dataiku.dip.sql.regex.RegexParser;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;

public class RegexDatabaseSupport {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sql.regex");

    public RegexSupportStatus isSupported(String pattern, String databaseKind) {
        Set capabilitiesAvailable;
        try {
            String supportFile = databaseKind + ".support.json";
            logger.info((Object)("Get regex support from " + supportFile));
            InputStream is = this.getClass().getResourceAsStream(supportFile);
            if (is == null) {
                return RegexSupportStatus.nok("Regex pushdown not supported for " + databaseKind);
            }
            capabilitiesAvailable = (Set)JSON.parse((InputStream)is, (TypeToken)new TypeToken<Set<RegexParser.Capability>>(){});
            is.close();
        }
        catch (IOException e) {
            return RegexSupportStatus.nok("Regex pushdown not supported for " + databaseKind);
        }
        try {
            Set<RegexParser.Capability> capabilitiesNeeded = new RegexParser(pattern).listCapabilitiesNeeded();
            Sets.SetView missing = Sets.difference(capabilitiesNeeded, (Set)capabilitiesAvailable);
            if (missing.isEmpty()) {
                return RegexSupportStatus.ok();
            }
            return RegexSupportStatus.nok("Database is not known to handle " + missing.stream().map(c2 -> c2.desc()).collect(Collectors.joining(", ")));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to parse regex and evaluate support", (Throwable)e);
            return RegexSupportStatus.nok("Regex not parsed");
        }
    }

    public static class RegexSupportStatus {
        public final boolean ok;
        public final String reason;

        private RegexSupportStatus(boolean ok, String reason) {
            this.ok = ok;
            this.reason = reason;
        }

        public static RegexSupportStatus ok() {
            return new RegexSupportStatus(true, null);
        }

        public static RegexSupportStatus nok(String reason) {
            return new RegexSupportStatus(false, reason);
        }
    }
}

