/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.theming.service;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.theming.dao.DSSVisualizationThemeDAO;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSVisualizationThemeService {
    @Autowired
    private DSSVisualizationThemeDAO dao;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TranslationService translationService;

    public List<DSSVisualizationTheme> list() throws IOException {
        return this.dao.list();
    }

    public void create(DSSVisualizationTheme dssVisualizationTheme, String lang) throws IOException {
        this.isThemeValid(dssVisualizationTheme, lang);
        if (this.dao.exists(dssVisualizationTheme.getId())) {
            throw new DKUControllerBase.MalformedRequestException(this.translationService.translate(lang, "THEME.CREATE.ALREADY_EXIST", "Charts & Dashboards theme {{id}} already exists.", "id", dssVisualizationTheme.getId()));
        }
        if (dssVisualizationTheme.getId().startsWith("__dku_")) {
            throw new DKUControllerBase.MalformedRequestException(this.translationService.translate(lang, "THEME.CREATE.FORBIDDEN_NAME", "Charts & Dashboards theme {{id}} cannot begin with __dku_.", "id", dssVisualizationTheme.getId()));
        }
        this.dao.save(dssVisualizationTheme);
    }

    public DSSVisualizationTheme get(String id) throws IOException {
        return (DSSVisualizationTheme)this.dao.getOrNull(id);
    }

    public void delete(String id) throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        if (generalSettings.selectedDSSVisualizationThemeId != null && generalSettings.selectedDSSVisualizationThemeId.equals(id)) {
            generalSettings.selectedDSSVisualizationThemeId = "__dku_dss_default_theme__";
            this.generalSettingsDAO.save(generalSettings);
        }
        this.dao.delete(id);
    }

    public void isThemeValid(DSSVisualizationTheme dssVisualizationTheme, String lang) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)dssVisualizationTheme.getName())) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.MISSING_NAME", "Theme is missing a name", new Object[0]));
        }
        if (dssVisualizationTheme.getChartTitleFormatting() == null) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.CHART_TITLE_FORMATTING_MISSING", "Chart title formatting is missing", new Object[0]));
        }
        if (dssVisualizationTheme.getGeneralFormatting() == null) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.GENERAL_FORMATTING_MISSING", "General formatting is missing", new Object[0]));
        }
        if (dssVisualizationTheme.getLegendFormatting() == null) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.LEGEND_FORMATTING_MISSING", "Legend formatting is missing", new Object[0]));
        }
        if (dssVisualizationTheme.getPageTitleFormatting() == null) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.PAGE_TITLE_FORMATTING_MISSING", "Page title formatting is missing", new Object[0]));
        }
        if (dssVisualizationTheme.getTileTitleFormatting() == null) {
            throw new IllegalArgumentException(this.translationService.translate(lang, "THEME.CREATE.TILE_TITLE_FORMATTING_MISSING", "Tile title formatting is missing", new Object[0]));
        }
    }
}

