/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class TimelineItem
implements EnrichmentService.Enrichable {
    public String user;
    public TaggableObjectChangedEvent.ActionType action;
    public String projectKey;
    public ITaggingService.TaggableType objectType;
    public String objectId;
    public String workspaceKey;
    public JsonObject details;
    public long time;

    public TimelineItem() {
        this.details = new JsonObject();
    }

    public TimelineItem(String user, TaggableObjectChangedEvent.ActionType action, String projectKey, ITaggingService.TaggableType objectType, String objectId, String workspaceKey, long time) {
        this.user = user;
        this.action = action;
        this.projectKey = projectKey;
        this.objectType = objectType;
        this.objectId = objectId;
        this.workspaceKey = workspaceKey;
        this.details = new JsonObject();
        this.time = time;
    }

    public TimelineItem(String user, TaggableObjectChangedEvent.ActionType action, String projectKey, ITaggingService.TaggableType objectType, String objectId, String workspaceKey) {
        this(user, action, projectKey, objectType, objectId, workspaceKey, System.currentTimeMillis());
    }

    public TimelineItem withDetails(JsonObject details) {
        this.details = details;
        return this;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return this.objectType;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getWorkspaceKey() {
        return this.workspaceKey;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public JsonObject getDetails() {
        return this.details;
    }

    private String getActionLabel() {
        return switch (this.action) {
            case TaggableObjectChangedEvent.ActionType.COMMENT -> "commented on";
            case TaggableObjectChangedEvent.ActionType.EDIT_COLLABORATIVE_METADATA -> {
                if (this.details != null) {
                    if (TaggableObjectDiffService.TaggableObjectsDiff.isAboutTagsOnly(this.details)) {
                        yield "tagged";
                    }
                    if (TaggableObjectDiffService.TaggableObjectsDiff.isAboutTasksOnly(this.details)) {
                        yield "edited tasks on";
                    }
                    yield "edited metadata of";
                }
                yield "edited metadata of";
            }
            case TaggableObjectChangedEvent.ActionType.SAVED_MODEL_CHANGE_ACTIVE_VERSION -> "changed the active model version for";
            case TaggableObjectChangedEvent.ActionType.INSIGHT_LISTED, TaggableObjectChangedEvent.ActionType.DASHBOARD_LISTED -> "made public";
            case TaggableObjectChangedEvent.ActionType.DASHBOARD_UNLISTED, TaggableObjectChangedEvent.ActionType.INSIGHT_UNLISTED -> "made private";
            case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT -> "switched";
            case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_PULL -> "pulled remote changes for";
            case TaggableObjectChangedEvent.ActionType.DASHBOARD_SHARED_TO_WORKSPACE, TaggableObjectChangedEvent.ActionType.INSIGHT_SHARED_TO_WORKSPACE, TaggableObjectChangedEvent.ActionType.WEB_APP_SHARED_TO_WORKSPACE, TaggableObjectChangedEvent.ActionType.ARTICLE_SHARED_TO_WORKSPACE, TaggableObjectChangedEvent.ActionType.DATASET_SHARED_TO_WORKSPACE -> "shared";
            default -> {
                switch (this.action.category) {
                    case CREATED: 
                    case DELETED: 
                    case EDITED: 
                    case RENAMED: {
                        yield this.action.category.toString().toLowerCase();
                    }
                    case EDITED_DESCRIPTION: {
                        yield "edited description for";
                    }
                    case METRICS_UPDATED: {
                        yield "updated metrics for";
                    }
                }
                yield "updated (" + this.action.toString() + ")";
            }
        };
    }

    public String toHumanReadableString(MarkupFormatter markup) {
        String actionLabel = this.getActionLabel();
        String userLabel = this.details.has("userDisplayName") ? this.details.get("userDisplayName").getAsString() : null;
        String objectLabel = this.details.has("objectDisplayName") ? this.details.get("objectDisplayName").getAsString() : this.objectId;
        String objectTypeLabel = this.objectType.toString().toLowerCase().replace("_", " ");
        String markupObject = this.details.has("itemNotFound") ? markup.text(objectLabel) : markup.dssOrWorkspaceObject(this.objectType, this.projectKey, this.objectId, this.workspaceKey, objectLabel);
        String oldNameRenamed = this.action.category == TaggableObjectChangedEvent.ActionCategory.RENAMED && this.details.has("oldName") ? this.details.get("oldName").getAsString() + " to " : "";
        return String.format("%s %s %s %s%s%s", markup.user(this.user, userLabel), markup.text(actionLabel), markup.text(objectTypeLabel), markup.text(oldNameRenamed), markupObject, this.moreDetails(markup));
    }

    private String moreDetails(MarkupFormatter markup) {
        StringBuilder result = new StringBuilder();
        if (this.action == TaggableObjectChangedEvent.ActionType.EDIT_COLLABORATIVE_METADATA && TaggableObjectDiffService.TaggableObjectsDiff.isAboutTasks(this.details)) {
            result.append(this.moreDetails(markup, "addedTasks", "Add"));
            result.append(this.moreDetails(markup, "removedTasks", "Del"));
            result.append(this.moreDetails(markup, "doneTasks", "Done"));
            result.append(this.moreDetails(markup, "undoneTasks", "Todo"));
        } else if (this.action == TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT || this.action == TaggableObjectChangedEvent.ActionType.PROJECT_GIT_PULL) {
            result.append(" to branch ").append(this.details.get("branchName").getAsString());
        } else if (TimelineItem.isShareToWorkspaceAction(this.action) && StringUtils.isNotBlank((String)this.workspaceKey) && this.details.has("workspaceDisplayName")) {
            String markupWorkspace = markup.workspace(this.workspaceKey, this.details.get("workspaceDisplayName").getAsString());
            result.append(" to workspace ").append(markupWorkspace);
        }
        return result.toString();
    }

    private String moreDetails(MarkupFormatter markup, String taskPropertyName, String taskLabel) {
        StringBuilder result = new StringBuilder();
        for (JsonElement added : JsonUtils.getArrayDefault(this.details, taskPropertyName)) {
            result.append(markup.lineBreak());
            result.append(markup.nbspace());
            result.append(markup.nbspace());
            result.append(markup.text(taskLabel + ":"));
            for (int i = 0; i < 5 - taskLabel.length(); ++i) {
                result.append(markup.nbspace());
            }
            result.append(markup.text(added.getAsString()));
        }
        return result.toString();
    }

    private static boolean isShareToWorkspaceAction(TaggableObjectChangedEvent.ActionType action) {
        return action == TaggableObjectChangedEvent.ActionType.ARTICLE_SHARED_TO_WORKSPACE || action == TaggableObjectChangedEvent.ActionType.DATASET_SHARED_TO_WORKSPACE || action == TaggableObjectChangedEvent.ActionType.INSIGHT_SHARED_TO_WORKSPACE || action == TaggableObjectChangedEvent.ActionType.WEB_APP_SHARED_TO_WORKSPACE || action == TaggableObjectChangedEvent.ActionType.DASHBOARD_SHARED_TO_WORKSPACE;
    }
}

