/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.actual.MultiNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.apideployer.datamodel.actual.SingleNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.apideployer.datamodel.config.PublishedItem;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.apideployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.apideployer.infra.MultiAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.infra.SingleAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.published.PublishedProjectsDAO;
import com.dataiku.dip.apideployer.published.PublishedProjectsService;
import com.dataiku.dip.badges.ApiServiceTypeBadgesService;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.gh.SingleGovernIntegrationClientHandle;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.nodeclients.IUnifiedMonitoringClient;
import com.dataiku.dip.savedmodels.externalmodelidentifier.ExternalEndpointIdentifier;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringDeployedProjectComputationTaskCompletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent;
import com.dataiku.dip.server.notifications.backend.UnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.AbstractMonitoredThing;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringCodes;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerCRUDService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringRemoteNodesManager;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertingService;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.ManagedEndpointIdentifier;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.MonitoredManagedApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.MonitoredMultiNodeProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.MonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.ProjectExecutionStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectWebappMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.settings.SourceNodeWithLocalInfo;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.governance_status.GovernanceStatus;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringDeployerComputationService {
    private static final String GLOBAL_REPORT_BATCH_DATAIKU_INFRA = "DATAIKU";
    private static final String GLOBAL_REPORT_RT_DATAIKU_STATIC = "DKU_STATIC";
    private static final String GLOBAL_REPORT_RT_DATAIKU_K8S = "DKU_K8S";
    private static final String GLOBAL_REPORT_RT_SAGEMAKER = "SAGEMAKER";
    private static final String GLOBAL_REPORT_RT_VERTEX_AI = "VERTEX_AI";
    private static final String GLOBAL_REPORT_RT_AZURE_ML = "AZURE_ML";
    private static final String GLOBAL_REPORT_RT_DATABRICKS = "DATABRICKS";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private PublishedProjectsDAO publishedProjectsDAO;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    private UnifiedMonitoringAlertingService unifiedMonitoringAlertingService;
    @Autowired
    private UnifiedMonitoringDeployerCRUDService unifiedMonitoringDeployerCRUDService;
    @Autowired
    private UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    private NodesService nodesService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private ICredentialsService credentialsService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ApiServiceTypeBadgesService apiServiceTypeBadgesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.computation");

    public void computeMonitoredProjects_NT(AuthCtx user, int connectTimeout, int socketTimeout) throws IOException {
        List infraStatusList;
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Starting monitored project snapshots computation");
        try (Transaction t = this.transactionService.beginRead();){
            List<String> infrastructureIdsNotToMonitor = this.unifiedMonitoringSettingsDAO.read().unmonitoredProjectInfrastructures;
            if (!infrastructureIdsNotToMonitor.isEmpty()) {
                logger.infoV("The following infras for deployed projects are not to be monitored : %s", new Object[]{infrastructureIdsNotToMonitor});
            }
            infraStatusList = this.automationNodeInfrasService.listLightStatusUnsafe_Check(user).stream().filter(infraLightStatus -> !infrastructureIdsNotToMonitor.contains(infraLightStatus.infraBasicInfo.id)).collect(Collectors.toList());
        }
        logger.infoV("The status of the following infras for deployed projects will be computed : %s", new Object[]{infraStatusList.stream().map(infra -> infra.infraBasicInfo.id).collect(Collectors.toList())});
        try (SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            for (InfraLightStatus infraLightStatus2 : infraStatusList) {
                try {
                    this.computeMonitoredProjectDeployments(user, infraLightStatus2, connectTimeout, socketTimeout);
                }
                catch (Exception e) {
                    logger.warnV("Unable to compute monitoring snapshots for infra %s: %s", new Object[]{infraLightStatus2.infraBasicInfo.id, e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeMonitoredProjectDeployments(AuthCtx authCtx, InfraLightStatus infraLightStatus, int connectTimeout, int socketTimeout) throws UnauthorizedException, IOException {
        String infraId = infraLightStatus.infraBasicInfo.id;
        logger.infoV("Starting to compute the status of infra %s", new Object[]{infraId});
        AbstractProjectDeploymentInfra infra = this.automationNodeInfrasService.getAutomationNodeInfra_CheckRead(authCtx, infraLightStatus.infraBasicInfo.id);
        Map deploymentHeavyStatuses = this.projectDeploymentsService.listHeavyStatusUnsafe_NT_Check(authCtx, infraId, connectTimeout, socketTimeout).stream().collect(Collectors.toMap(dep -> dep.deploymentId, Functions.identity()));
        List<String> deploymentIds = infraLightStatus.deployments.stream().map(deploymentBasicInfo -> deploymentBasicInfo.id).collect(Collectors.toList());
        if (deploymentIds.isEmpty()) {
            logger.infoV("There is no deployment to monitor on the infra %s", new Object[]{infraId});
            return;
        }
        logger.infoV("The following deployments of the infra %s will be monitored : %s", new Object[]{infraId, deploymentIds});
        HashMap<String, AbstractMonitoredProjectDeployment> previousSnapshots = new HashMap<String, AbstractMonitoredProjectDeployment>();
        HashMap<String, AbstractMonitoredProjectDeployment> newSnapshots = new HashMap<String, AbstractMonitoredProjectDeployment>();
        this.unifiedMonitoringDeployerCRUDService.listMonitoredProjectDeployments(deploymentIds).forEach(monitoredProjectDeployment -> previousSnapshots.put(monitoredProjectDeployment.deploymentId, (AbstractMonitoredProjectDeployment)monitoredProjectDeployment));
        AbstractAutomationNodeInfraManager infraManager = infra.getInfraManager(authCtx, connectTimeout, socketTimeout);
        infraManager.openAutomationNodeClientConnections();
        try {
            for (AbstractDeploymentBasicInfo abstractDeploymentBasicInfo : infraLightStatus.deployments) {
                AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeployment = (AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo)abstractDeploymentBasicInfo;
                logger.infoV("Starting to compute the status of deployment %s", new Object[]{projectDeployment.id});
                try {
                    MonitoredMultiNodeProjectDeployment monitoredProjectDeployment2;
                    AbstractProjectDeploymentHeavyStatus automationNodeHeavyStatus = (AbstractProjectDeploymentHeavyStatus)deploymentHeavyStatuses.get(projectDeployment.id);
                    Preconditions.checkNotNull((Object)automationNodeHeavyStatus, (Object)String.format("We could not find a infrastructure heavy status for deployment %s", projectDeployment.id));
                    if (infra.getInfraType().equals((Object)AbstractDeploymentInfra.InfraType.AUTOMATION_NODE)) {
                        MonitoredProjectDeployment monitoredProjectDeployment22 = this.computeMonitoredProject(authCtx, infra, projectDeployment, (SingleNodeProjectDeploymentHeavyStatus)automationNodeHeavyStatus, (SingleAutomationNodeInfraManager)infraManager);
                    } else if (infra.getInfraType().equals((Object)AbstractDeploymentInfra.InfraType.MULTI_AUTOMATION_NODE)) {
                        monitoredProjectDeployment2 = this.computeMonitoredMultiNodeProject(authCtx, (MultiAutomationNodeInfra)infra, projectDeployment, (MultiNodeProjectDeploymentHeavyStatus)automationNodeHeavyStatus, (MultiAutomationNodeInfraManager)infraManager);
                    } else {
                        throw ErrorContext.iaef((String)"The infra type %s is not supported for deployed project monitoring", (Object)((Object)infra.getInfraType()), (Object[])new Object[0]);
                    }
                    ((AbstractMonitoredThing)monitoredProjectDeployment2).computeUMStatuses();
                    newSnapshots.put(monitoredProjectDeployment2.deploymentId, monitoredProjectDeployment2);
                    this.unifiedMonitoringDeployerCRUDService.save(monitoredProjectDeployment2);
                }
                catch (Exception e) {
                    logger.warnV("Could not read monitored project %s, skipping: %s", new Object[]{projectDeployment.id, e.getMessage()});
                }
            }
        }
        finally {
            infraManager.closeAutomationNodeClientConnections();
        }
        logger.infoV("Finished computing the status of infra %s", new Object[]{infraId});
        this.pubSub.publish((DSSEvent)new UnifiedMonitoringDeployedProjectComputationTaskCompletedEvent(infraId, previousSnapshots, newSnapshots));
    }

    MonitoredProjectDeployment computeMonitoredProject(AuthCtx authCtx, AbstractProjectDeploymentInfra infra, AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeploymentBasicInfo, @Nonnull SingleNodeProjectDeploymentHeavyStatus automationNodeHeavyStatus, SingleAutomationNodeInfraManager infraManager) {
        AutomationNodeClient automationNodeClient = infraManager.automationNodeClient;
        if (automationNodeClient == null) {
            logger.warnV("Could not find a suitable source node client for project infrastructure %s. Some monitoring information will be unavailable.", new Object[]{infra.id});
        }
        MonitoredProjectDeployment monitoredProjectDeployment = new MonitoredProjectDeployment();
        this.initializeMonitoredProjectDeployment(authCtx, monitoredProjectDeployment, infra, projectDeploymentBasicInfo, automationNodeHeavyStatus);
        ProjectWebappMonitoringStatus webappMonitoringStatus = new ProjectWebappMonitoringStatus(automationNodeHeavyStatus.webappBackendInfoList, true);
        monitoredProjectDeployment.projectExecutionStatus = new ProjectExecutionStatus(automationNodeHeavyStatus.monitoring, webappMonitoringStatus);
        if (automationNodeHeavyStatus.getHealth() == DeploymentHealth.ERROR || automationNodeHeavyStatus.getHealth() == DeploymentHealth.DISABLED) {
            logger.debugV("Health of project %s on deployment %s on infra %s is %s. Not fetching last scenario runs, data quality status nor project model status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, automationNodeHeavyStatus.getHealth()});
            monitoredProjectDeployment.dataQualityStatusMessages.withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving data quality status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), automationNodeHeavyStatus.getHealth()});
            monitoredProjectDeployment.projectModelStatusMessages.withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving model status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), automationNodeHeavyStatus.getHealth()});
            monitoredProjectDeployment.projectLastScenarioRunsMessages.withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving last scenario runs status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), automationNodeHeavyStatus.getHealth()});
            monitoredProjectDeployment.dataQualityStatus = null;
            monitoredProjectDeployment.projectLastScenarioRuns = null;
            logger.infoV("Finished computing the status of deployment %s", new Object[]{monitoredProjectDeployment.deploymentId});
            return monitoredProjectDeployment;
        }
        if (automationNodeClient == null) {
            throw new IllegalStateException("The infra manager automation node client must be open");
        }
        try {
            monitoredProjectDeployment.projectLastScenarioRuns = automationNodeClient.getLastScenariosRun(projectDeploymentBasicInfo.getDeployedItemId());
        }
        catch (Exception e) {
            logger.infoV("Could not read scenarios run of project %s on deployment %s on infra %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, e.getMessage()});
            monitoredProjectDeployment.projectLastScenarioRunsMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_LAST_SCENARIO_RUNS_MISSING, e.getMessage());
        }
        try {
            monitoredProjectDeployment.dataQualityStatus = automationNodeClient.getDataQualityStatus(projectDeploymentBasicInfo.getDeployedItemId());
        }
        catch (Exception e) {
            logger.infoV("Could not read scenarios run of project %s on deployment %s on infra %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, e.getMessage()});
            monitoredProjectDeployment.dataQualityStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_DATA_QUALITY_STATUS_MISSING, e.getMessage());
        }
        try {
            monitoredProjectDeployment.projectModelStatus = automationNodeClient.getProjectModelStatus(projectDeploymentBasicInfo.getDeployedItemId());
        }
        catch (Exception e) {
            logger.infoV("Could not read models status of project %s on deployment %s on infra %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, e.getMessage()});
            monitoredProjectDeployment.projectModelStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_PROJECT_MODEL_STATUS_COMPUTATION_MISSING, e.getMessage());
        }
        logger.infoV("Finished computing the status of deployment %s", new Object[]{monitoredProjectDeployment.deploymentId});
        return monitoredProjectDeployment;
    }

    MonitoredMultiNodeProjectDeployment computeMonitoredMultiNodeProject(AuthCtx authCtx, MultiAutomationNodeInfra infra, AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeploymentBasicInfo, @Nonnull MultiNodeProjectDeploymentHeavyStatus automationNodeHeavyStatus, MultiAutomationNodeInfraManager infraManager) {
        if (infraManager.nodeConnections.isEmpty()) {
            logger.debugV("Not computing monitored projects due to '%s' infra having no attached automation nodes", new Object[]{infra.id});
            String displayedName = automationNodeHeavyStatus.name + " > " + projectDeploymentBasicInfo.bundleId;
            return new MonitoredMultiNodeProjectDeployment(projectDeploymentBasicInfo.id, displayedName);
        }
        MonitoredMultiNodeProjectDeployment monitoredProjectDeployment = new MonitoredMultiNodeProjectDeployment(infraManager.nodeConnections.stream().map(nodeConnection -> nodeConnection.automationNodeId).collect(Collectors.toList()));
        this.initializeMonitoredProjectDeployment(authCtx, monitoredProjectDeployment, infra, projectDeploymentBasicInfo, automationNodeHeavyStatus);
        for (NodeConnection nodeConnection2 : infraManager.nodeConnections) {
            String automationNodeId = nodeConnection2.automationNodeId;
            SingleNodeProjectDeploymentHeavyStatus heavyStatus = automationNodeHeavyStatus.heavyStatusPerNode.get(automationNodeId);
            ProjectWebappMonitoringStatus webappMonitoringStatus = new ProjectWebappMonitoringStatus(heavyStatus.webappBackendInfoList, true);
            ProjectExecutionStatus projectExecutionStatus = new ProjectExecutionStatus(heavyStatus.monitoring, webappMonitoringStatus);
            monitoredProjectDeployment.projectExecutionStatuses.put(automationNodeId, projectExecutionStatus);
            monitoredProjectDeployment.deploymentHealthPerNode.put(automationNodeId, heavyStatus.getHealth());
            monitoredProjectDeployment.deploymentHealthMessagesPerNode.put(automationNodeId, heavyStatus.healthMessages);
            if (heavyStatus.getHealth() == DeploymentHealth.ERROR || heavyStatus.getHealth() == DeploymentHealth.DISABLED) {
                logger.debugV("Health of project %s on deployment %s on infra %s is %s on node %s. Not fetching last scenario runs, data quality status nor project model status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, heavyStatus.getHealth(), automationNodeId});
                monitoredProjectDeployment.dataQualityStatusMessages.get(automationNodeId).withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving data quality status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), heavyStatus.getHealth()});
                monitoredProjectDeployment.projectModelStatusMessages.get(automationNodeId).withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving model status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), heavyStatus.getHealth()});
                monitoredProjectDeployment.projectLastScenarioRunsMessages.get(automationNodeId).withWarningV((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_PROJECT_HEALTH, "Health of project %s is %s. Not retrieving last scenario runs status", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), heavyStatus.getHealth()});
                monitoredProjectDeployment.dataQualityStatuses.put(automationNodeId, null);
                monitoredProjectDeployment.projectModelStatuses.put(automationNodeId, null);
                monitoredProjectDeployment.projectLastScenarioRuns.put(automationNodeId, null);
                continue;
            }
            AutomationNodeClient automationNodeClient = infraManager.getAutomationNodeClientOrNull(nodeConnection2);
            if (automationNodeClient == null) {
                logger.warnV("Could not find a suitable source node client for project infrastructure %s. Some monitoring information will be unavailable.", new Object[]{infra.id});
                continue;
            }
            try {
                monitoredProjectDeployment.projectLastScenarioRuns.put(automationNodeId, automationNodeClient.getLastScenariosRun(projectDeploymentBasicInfo.getDeployedItemId()));
            }
            catch (Exception e) {
                logger.infoV("Could not read scenarios run of project %s on deployment %s on infra %s, node id %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, automationNodeId, e.getMessage()});
                InfoMessage.InfoMessages projectLastScenarioRunsMessages = monitoredProjectDeployment.projectLastScenarioRunsMessages.get(automationNodeId);
                projectLastScenarioRunsMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_LAST_SCENARIO_RUNS_MISSING, e.getMessage());
            }
            try {
                monitoredProjectDeployment.dataQualityStatuses.put(automationNodeId, automationNodeClient.getDataQualityStatus(projectDeploymentBasicInfo.getDeployedItemId()));
            }
            catch (Exception e) {
                logger.infoV("Could not read scenarios run of project %s on deployment %s on infra %s, node id %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, automationNodeId, e.getMessage()});
                InfoMessage.InfoMessages dataQualityStatusMessages = monitoredProjectDeployment.dataQualityStatusMessages.get(automationNodeId);
                dataQualityStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_DATA_QUALITY_STATUS_MISSING, e.getMessage());
            }
            try {
                monitoredProjectDeployment.projectModelStatuses.put(automationNodeId, automationNodeClient.getProjectModelStatus(projectDeploymentBasicInfo.getDeployedItemId()));
            }
            catch (Exception e) {
                logger.infoV("Could not read models status of project %s on deployment %s on infra %s, node id %s, skipping: %s", new Object[]{projectDeploymentBasicInfo.getDeployedItemId(), monitoredProjectDeployment.deploymentId, infra.id, automationNodeId, e.getMessage()});
                InfoMessage.InfoMessages projectModelStatusMessages = monitoredProjectDeployment.projectModelStatusMessages.get(automationNodeId);
                projectModelStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_PROJECT_MODEL_STATUS_COMPUTATION_MISSING, e.getMessage());
            }
        }
        logger.infoV("Finished computing the status of deployment %s", new Object[]{monitoredProjectDeployment.deploymentId});
        return monitoredProjectDeployment;
    }

    public void computeMonitoredManagedApiEndpoints_NT(AuthCtx user, String infrastructureId, @Nullable String overridingConnectionName) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.infoV("Starting api endpoints monitoring snapshots computation for infra %s", new Object[]{infrastructureId});
        try (UnifiedMonitoringRemoteNodesManager unifiedMonitoringRemoteNodesManager = new UnifiedMonitoringRemoteNodesManager(user, true);
             SingleGovernIntegrationClientHandle handle = SingleGovernIntegrationClientHandle.getHandle();){
            UnifiedMonitoringSettings settings;
            InfraLightStatus infra;
            try (Transaction t = this.transactionService.beginRead();){
                infra = this.apiNodeInfrasService.getLightStatusUnsafe_Check(infrastructureId, DSSAuthCtx.internalAdminAuth());
                settings = this.unifiedMonitoringSettingsDAO.getUnsafe();
            }
            MonitoredManagedApiEndpoint.ConnectionType connectionType = this.getConnectionType(user, overridingConnectionName, infra.getInfraBasicInfo().getId(), settings.apiRunAsUserLogin);
            List<String> deploymentIds = infra.deployments.stream().map(AbstractDeploymentBasicInfo::getId).collect(Collectors.toList());
            if (deploymentIds.isEmpty()) {
                logger.infoV("There is no deployment on infra %s", new Object[]{infrastructureId});
            } else {
                logger.infoV("Will compute the status of the following deployments of the infra %s: %s", new Object[]{infrastructureId, deploymentIds});
            }
            HashMap<ManagedEndpointIdentifier, MonitoredManagedApiEndpoint> previousSnapshots = new HashMap<ManagedEndpointIdentifier, MonitoredManagedApiEndpoint>();
            HashMap<ManagedEndpointIdentifier, MonitoredManagedApiEndpoint> newSnapshots = new HashMap<ManagedEndpointIdentifier, MonitoredManagedApiEndpoint>();
            this.unifiedMonitoringDeployerCRUDService.listMonitoredManagedApiEndpoints(deploymentIds).forEach(monitoredManagedApiEndpoint -> previousSnapshots.put(new ManagedEndpointIdentifier(monitoredManagedApiEndpoint.endpointId, monitoredManagedApiEndpoint.deploymentId), (MonitoredManagedApiEndpoint)monitoredManagedApiEndpoint));
            List deploymentStatusList = this.apiServiceDeploymentsService.listLightStatusUnsafe_NT_Check(DSSAuthCtx.internalAdminAuth()).stream().map(AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.class::cast).filter(deployment -> deploymentIds.contains(deployment.deploymentBasicInfo.id)).collect(Collectors.toList());
            for (AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus deploymentLightStatus : deploymentStatusList) {
                String deploymentId = deploymentLightStatus.deploymentBasicInfo.id;
                logger.infoV("Starting to compute the status of deployment %s", new Object[]{deploymentId});
                try {
                    AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo deploymentBasicInfo = (AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)deploymentLightStatus.deploymentBasicInfo;
                    String publishedServiceId = deploymentBasicInfo.publishedServiceId;
                    String generationForSourceProject = deploymentBasicInfo.generationsMapping.getEntries().get((int)0).generation;
                    PublishedApiServicePackageInfo publishedPackageInfo = deploymentLightStatus.packages.stream().filter(packageInfo -> packageInfo.id.equals(generationForSourceProject)).findFirst().orElse(null);
                    if (publishedPackageInfo == null) {
                        logger.warnV("Could not retrieve the API package of the currently active generation of deployment %s, won't compute the status of its endpoints", new Object[]{deploymentId});
                        HashMap copiedSnapshots = new HashMap();
                        this.unifiedMonitoringDeployerCRUDService.listMonitoredManagedApiEndpoints(deploymentIds).forEach(monitoredManagedEndpoint -> copiedSnapshots.put(new ManagedEndpointIdentifier(monitoredManagedEndpoint.endpointId, monitoredManagedEndpoint.deploymentId), monitoredManagedEndpoint));
                        for (Map.Entry snapshot : copiedSnapshots.entrySet()) {
                            ManagedEndpointIdentifier managedEndpointIdentifier = (ManagedEndpointIdentifier)snapshot.getKey();
                            MonitoredManagedApiEndpoint monitoredManagedApiEndpoint2 = (MonitoredManagedApiEndpoint)snapshot.getValue();
                            if (!Objects.equals(managedEndpointIdentifier.deploymentId, deploymentId)) continue;
                            monitoredManagedApiEndpoint2.deploymentHealth = DeploymentHealth.OUT_OF_SYNC;
                            monitoredManagedApiEndpoint2.deploymentHealthMessages = new InfoMessage.InfoMessages();
                            monitoredManagedApiEndpoint2.deploymentHealthMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_BAD_DEPLOYMENT_VERSION, "The deployment version does not correspond to any existing API package version. Modify the deployment settings to set it to an existing one.");
                            monitoredManagedApiEndpoint2.modelStatus = null;
                            monitoredManagedApiEndpoint2.modelStatusMessages = new InfoMessage.InfoMessages();
                            monitoredManagedApiEndpoint2.governanceStatus = null;
                            monitoredManagedApiEndpoint2.governanceStatusMessages = new InfoMessage.InfoMessages();
                            monitoredManagedApiEndpoint2.computeUMStatuses();
                            newSnapshots.put(managedEndpointIdentifier, monitoredManagedApiEndpoint2);
                            this.unifiedMonitoringDeployerCRUDService.save(monitoredManagedApiEndpoint2);
                        }
                        continue;
                    }
                    SourceNodeWithLocalInfo sourceNode = this.nodesService.getSourceNodeWithLocalInfo(publishedPackageInfo.designNodeInfo);
                    IUnifiedMonitoringClient sourceNodeClient = unifiedMonitoringRemoteNodesManager.getSourceNodeClientOrNull(sourceNode);
                    if (sourceNodeClient == null) {
                        logger.warnV("Could not find a suitable source node client for deployment %s. Some monitoring information will be unavailable.", new Object[]{deploymentId});
                    }
                    APIServiceDeploymentHeavyStatus deploymentHeavyStatus = null;
                    String failedToGetHeavyStatusMessage = null;
                    try {
                        deploymentHeavyStatus = this.apiServiceDeploymentsService.getHeavyStatus_Unsafe_NT_Check(DSSAuthCtx.internalAdminAuth(), user, deploymentId, false, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout(), overridingConnectionName, true);
                    }
                    catch (Exception e) {
                        logger.warnV("Could not retrieve the deployment status of deployment %s: %s", new Object[]{deploymentId, e.getMessage()});
                        failedToGetHeavyStatusMessage = e.getMessage();
                    }
                    for (LambdaEndpointConfig endpointConfig : publishedPackageInfo.endpoints) {
                        logger.infoV("Starting to compute the status of endpoint %s", new Object[]{endpointConfig.id});
                        String projectKey = publishedPackageInfo.designNodeInfo != null && publishedPackageInfo.designNodeInfo.projectKey != null ? publishedPackageInfo.designNodeInfo.projectKey : "";
                        String projectName = this.retrieveProjectDisplayName(projectKey, sourceNodeClient);
                        MonitoredManagedApiEndpoint monitoredManagedEndpoint2 = new MonitoredManagedApiEndpoint(endpointConfig.id, deploymentId, sourceNode, publishedServiceId, projectKey, projectName);
                        monitoredManagedEndpoint2.infrastructureId = infra.infraBasicInfo.id;
                        monitoredManagedEndpoint2.stage = infra.infraBasicInfo.stage;
                        monitoredManagedEndpoint2.infraType = infra.infraBasicInfo.getInfraType();
                        monitoredManagedEndpoint2.connectionType = connectionType;
                        monitoredManagedEndpoint2.tags = Stream.concat(Optional.ofNullable(deploymentBasicInfo.tags).orElse(Collections.emptySet()).stream(), Optional.ofNullable(endpointConfig.tags).orElse(Collections.emptyList()).stream()).collect(Collectors.toSet());
                        monitoredManagedEndpoint2.typeBadges = endpointConfig.typeBadges;
                        if (deploymentHeavyStatus != null) {
                            monitoredManagedEndpoint2.deploymentHealth = deploymentHeavyStatus.getHealth();
                            monitoredManagedEndpoint2.deploymentHealthMessages = deploymentHeavyStatus.healthMessages;
                        } else {
                            monitoredManagedEndpoint2.deploymentHealthMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_DEPLOYMENT_STATUS_MISSING, failedToGetHeavyStatusMessage);
                        }
                        try {
                            this.computeModelStatus(deploymentLightStatus, endpointConfig, monitoredManagedEndpoint2, sourceNodeClient);
                        }
                        catch (Exception e) {
                            logger.infoV("Could not retrieve the model status of the deployment %s and endpoint %s: %s", new Object[]{deploymentId, endpointConfig.id, e.getMessage()});
                            monitoredManagedEndpoint2.modelStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_MODEL_STATUS_COMPUTATION_MISSING, e.getMessage());
                        }
                        try {
                            if (GovernIntegrationService.enabledWithSanityChecksIfEnabled()) {
                                GovernStatusAndMessages governStatusAndMessages = this.computeGovernStatus(deploymentLightStatus, endpointConfig, monitoredManagedEndpoint2.designNodeInfo.nodeId);
                                monitoredManagedEndpoint2.governanceStatus = governStatusAndMessages.getGovernanceStatus();
                                monitoredManagedEndpoint2.governanceStatusMessages = governStatusAndMessages.getGovernanceStatusMessages();
                            } else {
                                monitoredManagedEndpoint2.governanceStatusMessages = monitoredManagedEndpoint2.governanceStatusMessages.withInfo((InfoMessage.MessageCode)UnifiedMonitoringCodes.INFO_GOVERN_INTEGRATION_DISABLED, "");
                            }
                        }
                        catch (Exception e) {
                            logger.warnV("Could not retrieve the governance status of the deployment %s and endpoint %s: %s", new Object[]{deploymentId, endpointConfig.id, e.getMessage()});
                            monitoredManagedEndpoint2.governanceStatusMessages = monitoredManagedEndpoint2.governanceStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_GOVERN_STATUS_MISSING, e.getMessage());
                        }
                        try {
                            AbstractAPIDeploymentInfra inf = this.apiNodeInfrasService.getApiNodeInfra_CheckRead(user, monitoredManagedEndpoint2.infrastructureId);
                            monitoredManagedEndpoint2.governCheckPolicy = inf.governCheckPolicy;
                        }
                        catch (Exception e) {
                            logger.infoV("Could not retrieve the governance policy of the deployment %s and endpoint %s: %s", new Object[]{deploymentId, endpointConfig.id, e.getMessage()});
                            monitoredManagedEndpoint2.governanceStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_GOVERN_POLICY_MISSING, e.getMessage());
                        }
                        monitoredManagedEndpoint2.computeUMStatuses();
                        newSnapshots.put(new ManagedEndpointIdentifier(monitoredManagedEndpoint2.endpointId, monitoredManagedEndpoint2.deploymentId), monitoredManagedEndpoint2);
                        this.unifiedMonitoringDeployerCRUDService.save(monitoredManagedEndpoint2);
                        logger.infoV("Finished computing the status of endpoint %s", new Object[]{endpointConfig.id});
                    }
                    logger.infoV("Finished computing the status of deployment %s", new Object[]{deploymentId});
                }
                catch (Exception e) {
                    logger.warnV("Could not compute the status of api deployment %s, skipping: %s", new Object[]{deploymentId, e.getMessage()});
                }
            }
            this.pubSub.publish((DSSEvent)new UnifiedMonitoringManagedApiEndpointComputationTaskCompletedEvent(infrastructureId, previousSnapshots, newSnapshots));
            logger.infoV("Finished computing the status of infra %s", new Object[]{infrastructureId});
        }
    }

    @Nonnull
    private MonitoredManagedApiEndpoint.ConnectionType getConnectionType(AuthCtx user, String overridingConnectionName, String infraId, String apiRunAsUserLogin) throws UnauthorizedException, IOException {
        UsersDAO.User runAsUser;
        String connectionName;
        String string = connectionName = overridingConnectionName == null ? this.apiNodeInfrasService.getInfraAuthConnection(DSSAuthCtx.internalAdminAuth(), infraId) : overridingConnectionName;
        if (connectionName == null) {
            return MonitoredManagedApiEndpoint.ConnectionType.NONE;
        }
        DSSConnection connection = this.connectionsService.get(connectionName);
        if (connection == null) {
            return MonitoredManagedApiEndpoint.ConnectionType.NONE;
        }
        if (connection.credentialsMode != DSSConnection.CredentialsMode.PER_USER) {
            return MonitoredManagedApiEndpoint.ConnectionType.GLOBAL;
        }
        if (StringUtils.isBlank((String)apiRunAsUserLogin)) {
            return MonitoredManagedApiEndpoint.ConnectionType.PER_USER_WITHOUT_USER;
        }
        try (Transaction t = this.transactionService.beginRead();){
            runAsUser = this.usersDAO.getOrNull(apiRunAsUserLogin);
        }
        if (null == runAsUser) {
            return MonitoredManagedApiEndpoint.ConnectionType.PER_USER_BAD_USER;
        }
        ICredentialsService.Credential cred = null;
        try {
            cred = this.credentialsService.getCredential_AutoTXN(user, connection);
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        if (null == cred) {
            logger.debugV("Could not retrieve credentials for per-user connection %s of infra %s", new Object[]{connectionName, infraId});
            return MonitoredManagedApiEndpoint.ConnectionType.PER_USER_WITHOUT_CREDENTIALS;
        }
        return MonitoredManagedApiEndpoint.ConnectionType.PER_USER_WITH_CREDENTIALS;
    }

    private void initializeMonitoredProjectDeployment(AuthCtx authCtx, AbstractMonitoredProjectDeployment monitoredProjectDeployment, AbstractProjectDeploymentInfra infra, AbstractDeploymentBasicInfo.ProjectDeploymentBasicInfo projectDeploymentBasicInfo, AbstractProjectDeploymentHeavyStatus automationNodeHeavyStatus) {
        String deploymentId = projectDeploymentBasicInfo.id;
        String publishedProjectName = null;
        try (Transaction t = this.transactionService.beginRead();){
            PublishedItem pub = (PublishedItem)this.publishedProjectsDAO.getMandatory(projectDeploymentBasicInfo.publishedProjectKey);
            publishedProjectName = this.publishedProjectsService.basicInfoUnsafe((PublishedItem)pub).name;
        }
        catch (IOException e) {
            logger.warnV("Could not retrieve published project name of %s: %s", new Object[]{projectDeploymentBasicInfo.publishedProjectKey, e.getMessage()});
        }
        monitoredProjectDeployment.deploymentId = deploymentId;
        monitoredProjectDeployment.deployedProjectKey = projectDeploymentBasicInfo.getDeployedItemId();
        monitoredProjectDeployment.publishedProjectKey = projectDeploymentBasicInfo.publishedProjectKey;
        monitoredProjectDeployment.bundleName = projectDeploymentBasicInfo.bundleId;
        monitoredProjectDeployment.deployedProjectName = automationNodeHeavyStatus.name;
        monitoredProjectDeployment.displayedName = (automationNodeHeavyStatus.name != null ? automationNodeHeavyStatus.name : projectDeploymentBasicInfo.getDeployedItemId()) + " > " + projectDeploymentBasicInfo.bundleId;
        monitoredProjectDeployment.publishedProjectName = publishedProjectName;
        monitoredProjectDeployment.infrastructureId = infra.id;
        monitoredProjectDeployment.infraType = infra.getInfraType();
        monitoredProjectDeployment.deploymentHealth = automationNodeHeavyStatus.getHealth();
        monitoredProjectDeployment.deploymentHealthMessages = automationNodeHeavyStatus.healthMessages;
        monitoredProjectDeployment.stage = infra.stage;
        monitoredProjectDeployment.governCheckPolicy = infra.governCheckPolicy;
        monitoredProjectDeployment.tags = projectDeploymentBasicInfo.tags;
        monitoredProjectDeployment.typeBadges = projectDeploymentBasicInfo.typeBadges;
        try {
            if (GovernIntegrationService.enabledWithSanityChecksIfEnabled()) {
                DSSItemGovernanceStatus dssItemGovernanceStatus = this.publishedProjectsService.getGovernanceStatusForSinglePublishedPackage_NT_Check(projectDeploymentBasicInfo.publishedProjectKey, projectDeploymentBasicInfo.bundleId, authCtx);
                monitoredProjectDeployment.governanceStatus = dssItemGovernanceStatus.governanceStatus;
            }
        }
        catch (CodedException | UnauthorizedException | IOException | IllegalArgumentException e) {
            logger.warnV("Could not get govern status of %s, skipping. Exception was: %s", new Object[]{projectDeploymentBasicInfo.bundleId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
            monitoredProjectDeployment.governanceStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_GOVERN_STATUS_MISSING, e.getMessage());
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Could not get govern status of %s, skipping", new Object[]{projectDeploymentBasicInfo.bundleId});
            monitoredProjectDeployment.governanceStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_GOVERN_STATUS_MISSING, e.getMessage());
        }
    }

    private void computeModelStatus(AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus deploymentLightStatus, LambdaEndpointConfig endpointConfig, MonitoredManagedApiEndpoint monitoredManagedEndpoint, @Nullable IUnifiedMonitoringClient sourceNodeClient) throws Exception {
        if (!deploymentLightStatus.isSingleGeneration()) {
            monitoredManagedEndpoint.modelStatus = null;
            monitoredManagedEndpoint.modelStatusMessages.withInfo((InfoMessage.MessageCode)UnifiedMonitoringCodes.INFO_MODEL_STATUS_UNAVAILABLE_FOR_MULTI_GENERATION_DEPLOYMENTS, "");
        } else if (!endpointConfig.type.equals((Object)LambdaEndpointConfig.EndpointType.STD_PREDICTION)) {
            monitoredManagedEndpoint.modelStatus = null;
            monitoredManagedEndpoint.modelStatusMessages.withInfo((InfoMessage.MessageCode)UnifiedMonitoringCodes.INFO_MODEL_STATUS_UNAVAILABLE_FOR_NON_STANDARD_PREDICTION_ENDPOINTS, "");
        } else {
            monitoredManagedEndpoint.modelStatus = this.retrieveModelStatus(deploymentLightStatus, endpointConfig, sourceNodeClient);
        }
    }

    private GovernStatusAndMessages computeGovernStatus(AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus deploymentLightStatus, LambdaEndpointConfig endpointConfig, @Nullable String nodeId) {
        DSSItemGovernanceStatusList dssItemGovernanceStatusList;
        if (!deploymentLightStatus.isSingleGeneration()) {
            return new GovernStatusAndMessages(null, new InfoMessage.InfoMessages().withInfo((InfoMessage.MessageCode)UnifiedMonitoringCodes.INFO_GOVERN_STATUS_UNAVAILABLE_FOR_MULTI_GENERATION_DEPLOYMENTS, ""));
        }
        if (!endpointConfig.type.equals((Object)LambdaEndpointConfig.EndpointType.STD_PREDICTION)) {
            return new GovernStatusAndMessages(null, new InfoMessage.InfoMessages().withInfo((InfoMessage.MessageCode)UnifiedMonitoringCodes.INFO_GOVERN_STATUS_UNAVAILABLE_FOR_NON_STANDARD_PREDICTION_ENDPOINTS, ""));
        }
        BundledSMVersion bundledSMV = deploymentLightStatus.getSMVersion(endpointConfig.id);
        FullModelId fullModelId = bundledSMV.getOriginalFullModelId();
        DSSSavedModelVersionIdentifier dssSavedModelVersionIdentifier = this.governIntegrationService.buildDSSSavedModelVersionIdentifier(fullModelId, nodeId);
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        dssItemIdentifierList.dssItemItentifiers.add(dssSavedModelVersionIdentifier);
        try {
            dssItemGovernanceStatusList = this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
        }
        catch (CodedException | IOException e) {
            logger.warnV("Could not retrieve governance status for model version %s: %s", new Object[]{fullModelId, e.getMessage()});
            return new GovernStatusAndMessages(null, new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_UNIFIED_MONITORING_GOVERN_STATUS_MISSING, e.getMessage()));
        }
        if (dssItemGovernanceStatusList.dssItemGovernanceStatuses.isEmpty()) {
            throw new IllegalStateException(String.format("Unexpected error: cannot retrieve governance status for model version: %s", fullModelId));
        }
        return new GovernStatusAndMessages(((DSSItemGovernanceStatus)dssItemGovernanceStatusList.dssItemGovernanceStatuses.get((int)0)).governanceStatus, new InfoMessage.InfoMessages());
    }

    @Nullable
    private ModelStatus retrieveModelStatus(AbstractDeploymentLightStatus abstractDeployment, LambdaEndpointConfig endpointConfig, @Nullable IUnifiedMonitoringClient sourceNodeClient) throws Exception {
        if (sourceNodeClient == null) {
            return null;
        }
        BundledSMVersion bundledSMV = ((AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus)abstractDeployment).getSMVersion(endpointConfig.id);
        FullModelId fullModelId = bundledSMV.getOriginalFullModelId();
        return sourceNodeClient.getModelStatus(fullModelId.getProjectKey(), fullModelId.toString(), null);
    }

    @Nullable
    private String retrieveProjectDisplayName(String projectKey, @Nullable IUnifiedMonitoringClient sourceNodeClient) {
        if (sourceNodeClient == null) {
            return null;
        }
        try {
            ProjectsService.UIProject uiDesignProj = sourceNodeClient.getProjectSummary(projectKey);
            if (uiDesignProj != null) {
                return uiDesignProj.getDisplayName();
            }
        }
        catch (Exception e) {
            logger.warnV("Could not read name of project %s, using key instead: %s", new Object[]{projectKey, e.getMessage()});
        }
        return null;
    }

    public void computeMonitoredExternalApiEndpoints_NT(AuthCtx user, String externalEndpointsScopeName) throws Exception {
        List<MonitoredExternalApiEndpoint> monitoredExternalApiEndpoints;
        UnifiedMonitoringExternalEndpointsScope externalEndpointsScope;
        try (Transaction t = this.transactionService.beginRead();){
            externalEndpointsScope = this.unifiedMonitoringSettingsDAO.read().externalEndpointsScopes.stream().filter(monitoredExternalConnectionConfig -> Objects.equals(monitoredExternalConnectionConfig.name, externalEndpointsScopeName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The monitored external endpoint scope %s is not found in the unified monitoring settings", externalEndpointsScopeName)));
        }
        boolean errorListingEndpoints = false;
        try {
            monitoredExternalApiEndpoints = externalEndpointsScope.listEndpoints(user);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to retrieve the list of endpoints of scope %s", new Object[]{externalEndpointsScopeName});
            monitoredExternalApiEndpoints = new ArrayList<MonitoredExternalApiEndpoint>();
            errorListingEndpoints = true;
        }
        boolean finalErrorListingEndpoints = errorListingEndpoints;
        List<MonitoredExternalApiEndpoint> finalMonitoredExternalApiEndpoints = monitoredExternalApiEndpoints;
        Map<ExternalEndpointIdentifier, MonitoredExternalApiEndpoint> previousSnapshots = this.unifiedMonitoringDeployerCRUDService.listMonitoredExternalApiEndpoints(externalEndpointsScopeName).stream().collect(Collectors.toMap(endpoint -> endpoint.externalEndpointIdentifier, endpoint -> endpoint));
        HashMap<ExternalEndpointIdentifier, MonitoredExternalApiEndpoint> newSnapshots = new HashMap<ExternalEndpointIdentifier, MonitoredExternalApiEndpoint>();
        try (UnifiedMonitoringRemoteNodesManager unifiedMonitoringRemoteNodesManager = new UnifiedMonitoringRemoteNodesManager(user, false);){
            if (!unifiedMonitoringRemoteNodesManager.hasNodes()) {
                logger.warn((Object)"No design nodes are set in the Deployer settings. Information about proxification of external models will not be available.");
            }
            HashMap<SourceNodeWithLocalInfo, List<UnifiedMonitoringProxySMVWithModelStatus>> proxyModelVersionsByDesignNode = new HashMap<SourceNodeWithLocalInfo, List<UnifiedMonitoringProxySMVWithModelStatus>>();
            logger.infoV("Querying the following design nodes to get the list of proxy saved model versions : %s", new Object[]{unifiedMonitoringRemoteNodesManager.listNodes().toString()});
            for (UnifiedMonitoringRemoteNodesManager.SourceNodeWithLocalInfoAndClient sourceNodeWithClient : unifiedMonitoringRemoteNodesManager.listNodes()) {
                try {
                    List<UnifiedMonitoringProxySMVWithModelStatus> localProxyModels = sourceNodeWithClient.nodeClient.listProxyModelVersionWithModelStatus();
                    proxyModelVersionsByDesignNode.put(sourceNodeWithClient.toNodeInfo(), localProxyModels);
                }
                catch (Exception e) {
                    logger.warnV("Could not fetch the list of proxy models of node %s: %s", new Object[]{sourceNodeWithClient.toString(), e.getMessage()});
                }
            }
            List<MonitoredExternalApiEndpoint> monitoredExternalApiEndpointsNotFound = this.unifiedMonitoringDeployerCRUDService.listMonitoredExternalApiEndpoints(externalEndpointsScopeName).stream().filter(externalEndpointMonitoring -> !finalMonitoredExternalApiEndpoints.contains(externalEndpointMonitoring)).collect(Collectors.toList());
            monitoredExternalApiEndpointsNotFound.forEach(monitoredExternalApiEndpoint -> {
                monitoredExternalApiEndpoint.resetMonitoringAttributes();
                monitoredExternalApiEndpoint.deploymentHealth = DeploymentHealth.ERROR;
                monitoredExternalApiEndpoint.deploymentHealthMessages = new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)(finalErrorListingEndpoints ? UnifiedMonitoringCodes.ERR_UNIFIED_MONITORING_COULD_NOT_LIST_EXTERNAL_ENDPOINTS : UnifiedMonitoringCodes.ERR_UNIFIED_MONITORING_EXTERNAL_ENDPOINT_NOT_FOUND), "");
                monitoredExternalApiEndpoint.isNotFound = !finalErrorListingEndpoints;
            });
            monitoredExternalApiEndpoints.addAll(monitoredExternalApiEndpointsNotFound);
            monitoredExternalApiEndpoints.forEach(monitoredExternalApiEndpoint -> {
                this.addProxifiedModelVersionsInfo((MonitoredExternalApiEndpoint)monitoredExternalApiEndpoint, (Map<SourceNodeWithLocalInfo, List<UnifiedMonitoringProxySMVWithModelStatus>>)proxyModelVersionsByDesignNode);
                monitoredExternalApiEndpoint.computeUMStatuses();
            });
            monitoredExternalApiEndpoints.forEach(monitoredExternalApiEndpoint -> newSnapshots.put(monitoredExternalApiEndpoint.externalEndpointIdentifier, (MonitoredExternalApiEndpoint)monitoredExternalApiEndpoint));
            this.persistMonitoredExternalApiEndpoints(externalEndpointsScopeName, monitoredExternalApiEndpoints);
        }
        this.pubSub.publish((DSSEvent)new UnifiedMonitoringExternalApiEndpointComputationTaskCompletedEvent(externalEndpointsScopeName, previousSnapshots, newSnapshots));
    }

    public UsageSummaryModel.UnifiedMonitoringReport getReportData_NT() {
        UsageSummaryModel.UnifiedMonitoringReport report = new UsageSummaryModel.UnifiedMonitoringReport();
        try {
            List endpointsInfraStatusList;
            List projectInfraStatusList;
            UnifiedMonitoringSettings settings;
            DSSAuthCtx auth = DSSAuthCtx.internalAdminAuth();
            try (Transaction t = this.transactionService.beginRead();){
                settings = this.unifiedMonitoringSettingsDAO.read();
                projectInfraStatusList = this.automationNodeInfrasService.listLightStatusUnsafe_Check(auth).stream().filter(infraLightStatus -> !settings.unmonitoredProjectInfrastructures.contains(infraLightStatus.infraBasicInfo.id)).collect(Collectors.toList());
                endpointsInfraStatusList = this.apiNodeInfrasService.listLightStatusUnsafe_Check(auth).stream().filter(infraLightStatus -> !settings.unmonitoredEndpointInfrastructures.contains(infraLightStatus.infraBasicInfo.id)).map(infraLightStatus -> infraLightStatus.infraBasicInfo).collect(Collectors.toList());
            }
            report.nbBatchInfrasByType.put(GLOBAL_REPORT_BATCH_DATAIKU_INFRA, projectInfraStatusList.size());
            block26: for (AbstractInfraBasicInfo endpointInfra : endpointsInfraStatusList) {
                switch (endpointInfra.getInfraType()) {
                    case STATIC: {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_DATAIKU_STATIC, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_DATAIKU_STATIC, 0) + 1);
                        continue block26;
                    }
                    case K8S: {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_DATAIKU_K8S, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_DATAIKU_K8S, 0) + 1);
                        continue block26;
                    }
                    case SAGEMAKER: {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_SAGEMAKER, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_SAGEMAKER, 0) + 1);
                        continue block26;
                    }
                    case VERTEX_AI: {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_VERTEX_AI, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_VERTEX_AI, 0) + 1);
                        continue block26;
                    }
                    case AZURE_ML: {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_AZURE_ML, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_AZURE_ML, 0) + 1);
                        continue block26;
                    }
                }
                throw new IllegalArgumentException(String.format("Endpoint infrastructure type not handled : %s", endpointInfra.getInfraType().name()));
            }
            block27: for (UnifiedMonitoringExternalEndpointsScope scope : settings.externalEndpointsScopes) {
                switch (scope.getType()) {
                    case "SageMaker": {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_SAGEMAKER, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_SAGEMAKER, 0) + 1);
                        continue block27;
                    }
                    case "AzureML": {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_AZURE_ML, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_AZURE_ML, 0) + 1);
                        continue block27;
                    }
                    case "VertexAIModelDeployment": {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_VERTEX_AI, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_VERTEX_AI, 0) + 1);
                        continue block27;
                    }
                    case "DatabricksModelDeployment": {
                        report.nbRealTimeInfrasByType.put(GLOBAL_REPORT_RT_DATABRICKS, report.nbRealTimeInfrasByType.getOrDefault(GLOBAL_REPORT_RT_DATABRICKS, 0) + 1);
                        continue block27;
                    }
                }
                throw new IllegalArgumentException(String.format("External endpoint scope type not handled : %s", scope.getType()));
            }
            report.unifiedMonitoringAlerting = this.unifiedMonitoringAlertingService.getReportData();
            return report;
        }
        catch (Exception e) {
            logger.warn((Object)"Could not compute report data for unified monitoring", (Throwable)e);
            return null;
        }
    }

    private void persistMonitoredExternalApiEndpoints(String externalEndpointsScopeName, List<MonitoredExternalApiEndpoint> monitoredExternalApiEndpoints) throws IOException {
        if (monitoredExternalApiEndpoints.isEmpty()) {
            logger.infoV("No external endpoints have been found for connection %s", new Object[]{externalEndpointsScopeName});
        } else {
            List endpointsIds = monitoredExternalApiEndpoints.stream().map(monitoring -> monitoring.endpointName).collect(Collectors.toList());
            logger.infoV("Will monitor following external endpoints for connection %s : %s", new Object[]{externalEndpointsScopeName, endpointsIds});
        }
        this.unifiedMonitoringDeployerCRUDService.save(externalEndpointsScopeName, monitoredExternalApiEndpoints);
    }

    private void addProxifiedModelVersionsInfo(MonitoredExternalApiEndpoint monitoredExternalApiEndpoint, Map<SourceNodeWithLocalInfo, List<UnifiedMonitoringProxySMVWithModelStatus>> proxyModelVersionsByDesignNode) {
        boolean invalidateModelStatus = false;
        for (Map.Entry<SourceNodeWithLocalInfo, List<UnifiedMonitoringProxySMVWithModelStatus>> entry : proxyModelVersionsByDesignNode.entrySet()) {
            SourceNodeWithLocalInfo designNodeInfo = entry.getKey();
            List unifiedMonitoringProxySMVWithModelStatuses = entry.getValue().stream().filter(unifiedMonitoringProxySMVWithModelStatus -> unifiedMonitoringProxySMVWithModelStatus.proxySmv.externalEndpointIdentifier != null).filter(unifiedMonitoringProxySMVWithModelStatus -> Objects.equals(monitoredExternalApiEndpoint.externalEndpointIdentifier, unifiedMonitoringProxySMVWithModelStatus.proxySmv.externalEndpointIdentifier)).collect(Collectors.toList());
            for (UnifiedMonitoringProxySMVWithModelStatus unifiedMonitoringProxySMVWithModelStatus2 : unifiedMonitoringProxySMVWithModelStatuses) {
                monitoredExternalApiEndpoint.proxifiedSavedModelVersions.add(new MonitoredExternalApiEndpoint.SavedModelVersionOfProxyModel(unifiedMonitoringProxySMVWithModelStatus2.proxySmv.fullModelId, designNodeInfo));
                if (invalidateModelStatus || unifiedMonitoringProxySMVWithModelStatus2.modelStatus == null || unifiedMonitoringProxySMVWithModelStatus2.modelStatus.isEmpty()) continue;
                if (monitoredExternalApiEndpoint.modelStatus == null) {
                    monitoredExternalApiEndpoint.modelStatus = unifiedMonitoringProxySMVWithModelStatus2.modelStatus;
                    continue;
                }
                invalidateModelStatus = true;
                monitoredExternalApiEndpoint.modelStatus = null;
                monitoredExternalApiEndpoint.modelStatusMessages.withWarning((InfoMessage.MessageCode)UnifiedMonitoringCodes.WARN_MODEL_STATUS_MISSING_MULTIPLE_PROXIFICATION, "");
            }
        }
        monitoredExternalApiEndpoint.nbProxifiedSavedModelVersions = monitoredExternalApiEndpoint.proxifiedSavedModelVersions.size();
    }

    private static class GovernStatusAndMessages {
        @Nullable
        private final GovernanceStatus governanceStatus;
        @Nonnull
        private final InfoMessage.InfoMessages governanceStatusMessages;

        public GovernStatusAndMessages(@Nullable GovernanceStatus governanceStatus, @Nonnull InfoMessage.InfoMessages governanceStatusMessages) {
            this.governanceStatus = governanceStatus;
            this.governanceStatusMessages = governanceStatusMessages;
        }

        @Nullable
        public GovernanceStatus getGovernanceStatus() {
            return this.governanceStatus;
        }

        @Nonnull
        public InfoMessage.InfoMessages getGovernanceStatusMessages() {
            return this.governanceStatusMessages;
        }
    }
}

