/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.apiendpoint;

import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.settings.SourceNodeWithLocalInfo;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

@UIModel
public class MonitoredManagedApiEndpoint
extends AbstractMonitoredApiEndpoint {
    public static final String ENDPOINT_TYPE = "MANAGED_API_ENDPOINT";
    public SourceNodeWithLocalInfo designNodeInfo;
    public String projectKey;
    @Nullable
    public String projectName;
    public String endpointId;
    public boolean disabledInfra;
    public String apiServiceName;
    @Nonnull
    public ConnectionType connectionType = ConnectionType.NONE;

    public MonitoredManagedApiEndpoint(String endpointId, String deploymentId, SourceNodeWithLocalInfo designNodeInfo, String apiServiceName, String projectKey, @Nullable String projectName) {
        this.endpointName = endpointId;
        this.endpointId = endpointId;
        this.deploymentId = deploymentId;
        this.designNodeInfo = designNodeInfo;
        this.apiServiceName = apiServiceName;
        this.projectKey = projectKey;
        this.projectName = projectName;
        this.displayedName = (projectName != null ? projectName : projectKey) + " > " + apiServiceName + " > " + this.endpointName;
    }

    public MonitoredManagedApiEndpoint() {
    }

    public static MonitoredManagedApiEndpoint readMonitoredManagedApiEndpoint(File endpointFile, String deploymentId) throws IOException {
        MonitoredManagedApiEndpoint ret = (MonitoredManagedApiEndpoint)JSON.parseFile((File)endpointFile, MonitoredManagedApiEndpoint.class);
        ret.deploymentId = deploymentId;
        ret.endpointName = endpointFile.getName().replaceAll(".json$", "");
        return ret;
    }

    @Override
    public void computeUMStatuses() {
        this.umDeploymentStatus = UnifiedMonitoringStatus.map(this.deploymentHealth);
        if (this.connectionType.equals((Object)ConnectionType.PER_USER_WITHOUT_CREDENTIALS) || this.connectionType.equals((Object)ConnectionType.PER_USER_WITHOUT_USER)) {
            this.umDeploymentStatus = this.umDeploymentStatus.equals((Object)UnifiedMonitoringStatus.ERROR) ? UnifiedMonitoringStatus.ERROR : UnifiedMonitoringStatus.WARNING;
        }
        this.umGovernanceStatus = UnifiedMonitoringStatus.map(this.governanceStatus);
        if (this.governanceStatusMessages.anyMessage && this.governanceStatusMessages.maxSeverity != null) {
            this.umGovernanceStatus = UnifiedMonitoringStatus.worstStatus(this.umGovernanceStatus, UnifiedMonitoringStatus.map(this.governanceStatusMessages.maxSeverity));
        }
        this.umModelStatus = UnifiedMonitoringStatus.map(this.modelStatus);
        if (this.modelStatusMessages.anyMessage && this.modelStatusMessages.maxSeverity != null) {
            this.umModelStatus = UnifiedMonitoringStatus.worstStatus(this.umModelStatus, UnifiedMonitoringStatus.map(this.modelStatusMessages.maxSeverity));
        }
        this.umGlobalStatus = UnifiedMonitoringStatus.worstStatus(this.umDeploymentStatus, this.umGovernanceStatus, this.umModelStatus);
    }

    public static enum ConnectionType {
        NONE,
        GLOBAL,
        PER_USER_WITH_CREDENTIALS,
        PER_USER_WITHOUT_CREDENTIALS,
        PER_USER_WITHOUT_USER,
        PER_USER_BAD_USER;

    }
}

