/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONFinder {
    private static boolean matches(String data, String filter) {
        return data.toLowerCase().contains(filter);
    }

    private static boolean matches(JSONArray obj, String filter) throws JSONException {
        for (int i = 0; i < obj.length(); ++i) {
            Object o;
            Object val = obj.get(i);
            if (!(val instanceof JSONObject ? JSONFinder.matches((JSONObject)val, filter) : (val instanceof JSONArray ? JSONFinder.matches((JSONArray)val, filter) : (o = obj.get(i)) != null && JSONFinder.matches(o.toString(), filter)))) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(JSONObject obj, String filter) throws JSONException {
        filter = filter.toLowerCase();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            Object o;
            String field = (String)it.next();
            Object val = obj.get(field);
            if (!(val instanceof JSONObject ? JSONFinder.matches((JSONObject)val, filter) : (val instanceof JSONArray ? JSONFinder.matches((JSONArray)val, filter) : (o = obj.get(field)) != null && JSONFinder.matches(o.toString(), filter)))) continue;
            return true;
        }
        return false;
    }

    public static boolean jsonMatches(String jsonString, String filter) {
        try {
            JSONObject obj = (JSONObject)new JSONTokener(jsonString).nextValue();
            return JSONFinder.matches(obj, filter);
        }
        catch (Exception e) {
            return false;
        }
    }
}

