/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectPut
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 3) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 3 arguments: object, new key, new value");
        }
        JSONObject prev = DKUFormulaUtils.asJSONObject(args[0]);
        try {
            Object k = args[1];
            Object v = args[2];
            if (k == null) {
                return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " got a null key");
            }
            prev.put(k.toString(), v);
            return prev;
        }
        catch (JSONException e) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " error: " + e.getMessage());
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ObjectPut.DOCUMENTATION", "Adds a key/value pair to an object and returns it. The key must not be null.").withParams("object o, key, value").withReturns("object").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions").withExample(Example.with("{\"name\":\"Smith\"}", "\"age\"", "42").returns("{\"name\":\"Smith\",\"age\":42}"));
    }
}

