/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.impl;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StreamTracker
implements AutoCloseable {
    private final Map<AutoCloseable, RelFile> streams = new HashMap<AutoCloseable, RelFile>();
    private final Transaction transaction;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.transactions");

    public StreamTracker(Transaction transaction) {
        this.transaction = transaction;
    }

    public synchronized RelFileInputStream track(RelFileInputStream stream) {
        RelFileInputStream proxiedStream = new RelFileInputStream(stream){

            protected void beforeRead(int n) {
                StreamTracker.this.checkAlive();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                StreamTracker streamTracker = StreamTracker.this;
                synchronized (streamTracker) {
                    StreamTracker.this.streams.remove((Object)this);
                }
                super.close();
            }
        };
        this.streams.put((AutoCloseable)((Object)proxiedStream), stream.file);
        return proxiedStream;
    }

    private void checkAlive() {
        if (!this.transaction.isAlive()) {
            throw new RuntimeException("The transaction has been closed");
        }
    }

    public synchronized RelFileOutputStream track(RelFileOutputStream stream) {
        RelFileOutputStream proxiedStream = new RelFileOutputStream(stream){

            protected void beforeWrite(int n) {
                StreamTracker.this.checkAlive();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                StreamTracker streamTracker = StreamTracker.this;
                synchronized (streamTracker) {
                    StreamTracker.this.streams.remove((Object)this);
                }
                super.close();
            }
        };
        this.streams.put((AutoCloseable)((Object)proxiedStream), stream.file);
        return proxiedStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<AutoCloseable, RelFile> copy;
        StreamTracker streamTracker = this;
        synchronized (streamTracker) {
            copy = new HashMap<AutoCloseable, RelFile>(this.streams);
            this.streams.clear();
        }
        for (Map.Entry entry : copy.entrySet()) {
            try {
                logger.warn((Object)("Unclosed stream in transaction: " + String.valueOf(entry.getValue())));
                ((AutoCloseable)entry.getKey()).close();
            }
            catch (Exception e) {
                logger.error((Object)"Error while closing stream", (Throwable)e);
            }
        }
    }
}

