/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.AbstractBackOff;
import com.treasuredata.client.BackOff;
import com.treasuredata.client.EqualJitterBackOff;
import com.treasuredata.client.ExponentialBackOff;
import com.treasuredata.client.FullJitterBackOff;
import com.treasuredata.client.TDClientConfig;

public enum BackOffStrategy {
    FullJitter,
    EqualJitter,
    Exponential;


    public static BackOff newBackOff(TDClientConfig config) {
        AbstractBackOff backoff;
        switch (config.retryStrategy.ordinal()) {
            case 2: {
                backoff = new ExponentialBackOff(config.retryInitialIntervalMillis, config.retryMaxIntervalMillis, config.retryMultiplier);
                break;
            }
            case 1: {
                backoff = new EqualJitterBackOff(config.retryInitialIntervalMillis, config.retryMaxIntervalMillis, config.retryMultiplier);
                break;
            }
            default: {
                backoff = new FullJitterBackOff(config.retryInitialIntervalMillis, config.retryMaxIntervalMillis, config.retryMultiplier);
            }
        }
        return backoff;
    }
}

