/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.impl;

import com.dataiku.dss.shadelibtd.okhttp3.Authenticator;
import com.dataiku.dss.shadelibtd.okhttp3.Credentials;
import com.dataiku.dss.shadelibtd.okhttp3.Request;
import com.dataiku.dss.shadelibtd.okhttp3.Response;
import com.dataiku.dss.shadelibtd.okhttp3.Route;
import com.dataiku.dss.shadelibtd.org.slf4j.Logger;
import com.dataiku.dss.shadelibtd.org.slf4j.LoggerFactory;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpException;
import java.io.IOException;
import java.util.Optional;

public class ProxyAuthenticator
implements Authenticator {
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private final Logger logger = LoggerFactory.getLogger(ProxyAuthenticator.class);
    private final ProxyConfig proxyConfig;
    private Optional<String> proxyAuthCache = Optional.empty();

    public ProxyAuthenticator(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        if (response.request().header(PROXY_AUTHORIZATION) != null) {
            throw new IOException(new TDClientHttpException(TDClientException.ErrorType.PROXY_AUTHENTICATION_FAILURE, "Proxy authentication failure", 407, null));
        }
        if (!this.proxyAuthCache.isPresent()) {
            this.logger.debug("Proxy authorization requested for " + route.address());
            this.proxyAuthCache = Optional.of(Credentials.basic(this.proxyConfig.getUser().orElse(""), this.proxyConfig.getPassword().orElse("")));
        }
        return response.request().newBuilder().addHeader(PROXY_AUTHORIZATION, this.proxyAuthCache.get()).build();
    }
}

