/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public class DefaultDecimalVector
extends AbstractColumnVector {
    private final BigDecimal[] values;

    public DefaultDecimalVector(DataType dataType, int n, BigDecimal[] bigDecimalArray) {
        super(n, dataType, Optional.empty());
        Preconditions.checkArgument((boolean)(dataType instanceof DecimalType), (String)"invalid type for decimal vector: %s", (Object[])new Object[]{dataType});
        this.values = Objects.requireNonNull(bigDecimalArray, "values is null");
        Preconditions.checkArgument((bigDecimalArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{bigDecimalArray.length, n});
    }

    @Override
    public boolean isNullAt(int n) {
        this.checkValidRowId(n);
        return this.values[n] == null;
    }

    @Override
    public BigDecimal getDecimal(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

