.dku__rstudio_style <- function(){
   tags$head(
    tags$style(HTML("
/* Note that at the time of writing this, RStudio does not support flex layout and
display: fixed for the header creates flickering
So the layout is very basic
*/

.container-fluid {
    margin: 0;
    padding: 0;
}
.row {
    padding: 5px 15px;
    margin: 0;
    border-bottom: 1px solid #ddd;
}
.dku-main-pane .row:nth-child(odd) {
    background-color: #f9f9f9;
}

h1 {
    font-size: 17px;
}
input[type=text], .selectize-input, .selectize-dropdown {
  border-radius: 0 !important;
  box-shadow: none !important;
  outline:0 !important;
}
.form-control:focus {
  border: 1px #4E8EF5 solid;
}
.btn {
    border-radius: 0;
    text-transform: uppercase;
    font-size: 10px;
}
button[id^=delete_] {
    float: right;
}

/* Default shiny style has @media (min-width: 768px), but we don't need that */
.col-sm-5 {
    float: left;
    width: 41.66666667%;
}
.col-sm-2 {
    float: left;
    width: 16.66666667%;
}
.dku-main-pane label {
    width: 120px;
}
.dku-main-pane .shiny-input-container {
  width: 100%;
  margin-bottom: 5px;
}
.dku-main-pane .form-control {
  display: inline-block;
  width: 300px;
}

#done {
    margin-top: 15px;
    color: #4E8EF5;
    border: 1px #4E8EF5 solid;
    background: white;
    font-size: 12px;
    font-weight: 500;
}
#done:hover {
    color: white;
    background: rgba(30, 111, 242, 0.8);
}

.dku-footer, .dku-main-pane .row.dku-instance-selection {
    text-align: center;
    padding: 10px;
    background-color: #2ab1ac;
}
    "))
  )
}

assignLastStuffOnce <- function(){
  if (!base:::exists("lastUsedProjectKey", .GlobalEnv)){ 
    if (is.na(Sys.getenv("DKU_CURRENT_PROJECT_KEY", unset=NA))) {
      assign("lastUsedProjectKey", NULL, .GlobalEnv)
    } else {
      assign("lastUsedProjectKey", Sys.getenv("DKU_CURRENT_PROJECT_KEY"), .GlobalEnv)
    }
    assign("lastUsedRecipeName", NULL, .GlobalEnv)
  }  
}

#  -------- Public API interaction --------

dkuListProjectsSettings <- function() {
  print("List projects")
  .dku_publicapi__request(GET, "/projects/")
}

dkuListRecipes <- function(projectKey, type=NULL) {
  print("List recipes")
  recipes <- .dku_publicapi__request(GET, paste0("/projects/", projectKey, "/recipes/"))
  if (!is.null(type)) {
    indices <- unlist(lapply(recipes, function(x) x$type == "r"))
    return(recipes[indices])
  }
  return(recipes)
}

dkuGetRecipe <- function(projectKey, recipeName) {
  return(.dku_publicapi__request(GET, paste0("/projects/", projectKey, "/recipes/", recipeName)))
}

dkuSaveRecipeCode <- function(projectKey, recipeName, code) {
  recipeAndPayload <- dkuGetRecipe(projectKey, recipeName)
  recipeAndPayload$payload <- code
  recipeAndPayloadStr <- RJSONIO::toJSON(recipeAndPayload)
  return(.dku_publicapi__request(PUT,paste0("/projects/", projectKey, "/recipes/", recipeName), recipeAndPayloadStr))
}


getLastUsedProjectKey <- function(){
  base:::get("lastUsedProjectKey", .GlobalEnv)

}
setLastUsedProjectKey <- function(newVal) {
  assign("lastUsedProjectKey", newVal, .GlobalEnv)
}
getLastUsedRecipeName <- function(){
  base:::get("lastUsedRecipeName", .GlobalEnv)
}
setLastUsedRecipeName <- function(newVal) {
  assign("lastUsedRecipeName", newVal, .GlobalEnv)
}


dku__make_recipe_selector <- function(input, output, session, projectKeys) {
    output$projectsSelector <- renderUI({
      if (!is.null(getLastUsedProjectKey())) { 
        selectInput("projectKey", "Project Key", choices=projectKeys, selected=getLastUsedProjectKey())
      } else {
        selectInput("projectKey", "Project Key", choices=projectKeys)
      }
    })
    output$recipeSelector <- renderUI({
      if (is.null(input$projectKey)) {
        print("No project key")
        return()
      }
      
      recipesNames <-listRecipesNames(input$projectKey)
      if (!is.null(getLastUsedRecipeName())) { 
        selectInput("recipeName", "Recipe id", choices=recipesNames, selected=getLastUsedRecipeName())
      } else {
        selectInput("recipeName", "Recipe id", choices=recipesNames)
      }
    })
}

dku__setup_api_gadget <- function() {
  library(shiny)
  
  config <- dku_configfile__read()
  # dss_instances <- config$dss_instances
  dss_instances <- c()
  print("READ CONFIG")
  print(config)
  for (instance_id in names(config$dss_instances)) {
  	print("ADD ")
  	print(instance_id)
  	print(config$dss_instances[[instance_id]])
  	config$dss_instances[[instance_id]]$tmp_id = instance_id
    dss_instances <- append(dss_instances, list(config$dss_instances[[instance_id]]))
  }
  print("DSS INSTANCES")
  print(dss_instances)

  #dss_instances <- .generate_tmp_ids(dss_instances)
  
  instance_widget <- function(instance) {
    tmp_id <- instance['tmp_id']
    fluidRow(class=paste0("instance_", tmp_id),
      #actionButton(paste0("delete_instance_", tmp_id), "Delete", icon("trash-o")),
      textInput(paste0("dss_instance_name_", tmp_id), "Name", value=instance['name']),
      textInput(paste0("dss_instance_url_", tmp_id), "URL", value=instance['url']),
      textInput(paste0("dss_instance_api_key_", tmp_id), "API key", value=instance['api_key'])
    )
  }
  
  server <- function(input, output, session) {
    output$controls <- renderUI({
      fluidPage(
        .dku__rstudio_style(),
        .dku_header("Setup DSS connections", "Save", "save"),
        fluidPage(
          class="dku-main-pane",
          fluidRow(class="dku-instance-selection",
             textInput("default_instance", "Active instance", value=config$default_instance)
          ),
          lapply(dss_instances, instance_widget)
        ),
        fluidRow(class="dku-footer",
          actionButton("add_instance", "Connect to another DSS instance", icon("plus"))
        )
      )
    })
    
    addDeleteListener <- function (tmp_id) {
      print(paste("Add delete listener for", tmp_id)) #WARNING: don't remove this. Otherwise, the code seems too lazy to execute... :()
      observeEvent(input[[paste0("delete_instance_", tmp_id)]], {
        index <- .lookup_by_field(dss_instances, 'tmp_id', tmp_id)
        if (index == -1) {
          stop("Unexpected error: instance not found")
        }
        dss_instances <<- dss_instances[-index]
        removeUI(selector = paste0(".instance_", tmp_id))
      })
    }
    
    for (instance in dss_instances) {
      addDeleteListener(instance['tmp_id'])
    }
    
    observeEvent(input$add_instance, {
      new_instance <- unlist(list(name='', api_key='', url='', tmp_id=.make_unique_instance_id(dss_instances) ))
      dss_instances <<- append(dss_instances, list(new_instance))
      
      shiny::insertUI(
        selector = ".dku-main-pane",
        where = "beforeEnd",
        ui = instance_widget(new_instance)
      )
      
      addDeleteListener(new_instance['tmp_id'])
    })
    
    observeEvent(input$done, {
      #TODO @rstudio check for duplicate names
      
      # Copy UI data to the config based on tmp_id
      dss_instances2 <- list()
      print("Instances2")
      print("DSS INSTANCES IS")
      print(dss_instances)
      for (instance in dss_instances) {

      	print("INSTANCE")
      	print(instance)
        instance['name'] <- input[[paste0("dss_instance_name_", instance['tmp_id'])]]
        instance['url'] <- input[[paste0("dss_instance_url_", instance['tmp_id'])]]
        instance['api_key'] <- input[[paste0("dss_instance_api_key_", instance['tmp_id'])]]
        print(paste("INSTANCE IS A"))
        	print(names(instance))
        iname <- instance[["name"]]
        print("DSS_instnaces2 before")
        print(dss_instances2)
        dss_instances2[iname] <- list(instance)
        print("Now dss_instances2")
        print(dss_instances2)
      }
      dss_instances <- dss_instances2
      
      #dss_instances <- .remove_unique_instance_id(dss_instances)
      config$dss_instances <- dss_instances
      config$default_instance <- input$default_instance

      print("Ready to write config")
      print(config)
      
      dku_configfile__write(config)
      dku_intercom__clear_location_info()
      
      stopApp()
    })
  }
  
  ui <- uiOutput("controls")
  
  viewer = dialogViewer("Dataiku DSS API", width=600, height=600)
  runGadget(ui, server, viewer=viewer)
  #runGadget(ui, server, viewer=shiny::browserViewer())
}

dku__recipe_get_gadget <- function() {
  library(shiny)
  
  projectKeys <- listProjectsKeys()
  recipeNames <- list()
  assignLastStuffOnce()
  
  ui <- fluidPage(
    .dku__rstudio_style(),
    .dku_header("Get recipe content", "download", "download"),
    fluidRow(clas="recipe-selection",
      uiOutput("projectsSelector"),
      uiOutput("recipeSelector")
    )
  )
  
  server <- function(input, output, session) {

    dku__make_recipe_selector(input, output, session, projectKeys)
    
    observeEvent(input$done, {
      setLastUsedProjectKey(input$projectKey)
      setLastUsedRecipeName(input$recipeName)

      recipe <- dkuGetRecipe(input$projectKey, input$recipeName)
      print("RETRIEVED RECIPE")
      print(recipe)
      dkuSetCurrentProjectKey(input$projectKey)
      rstudioapi::insertText(recipe$payload)
      stopApp()
    })
  }
  
  viewer = dialogViewer("Dataiku DSS API", width=800, height=400)
  runGadget(ui, server, viewer=viewer)
  #runGadget(ui, server, viewer=shiny::browserViewer())
}


dku__recipe_set_gadget <- function() {
  library(shiny)
  
  projectKeys <- listProjectsKeys()
  recipeNames <- list()
  assignLastStuffOnce()
  
  ui <- fluidPage(
    .dku__rstudio_style(),
    .dku_header("Save recipe content", "Send to DSS", "save"),
    fluidRow(clas="recipe-selection",
      uiOutput("projectsSelector"),
      uiOutput("recipeSelector")
    )
  )
  
  server <- function(input, output, session) {
    dku__make_recipe_selector(input, output, session, projectKeys)
    
    observeEvent(input$done, {
      setLastUsedProjectKey(input$projectKey)
      setLastUsedRecipeName(input$recipeName)

      code <- .get_current_window_code()
      dkuSaveRecipeCode(input$projectKey, input$recipeName, code)
      
      stopApp()
    })
  }
  
  viewer = dialogViewer("Dataiku DSS API", width=800, height=400)
  runGadget(ui, server, viewer=viewer)
}


# -- UI

.dku_header <- function(title, button_message, button_icon) {
  fluidRow(
    class="dku-header",
    column(5, img(src="https://www.dataiku.com/static/img/theme/logo/page.png")),
    column(5, h1(title)),
    column(2, actionButton("done", HTML(paste0("&nbsp;", button_message)), icon(button_icon)))
  )
}

# -------- public API helpers --------

listProjectsKeys <- function() {
  sapply(dkuListProjectsSettings(), function(x) x[['projectKey']])
}

listRecipesNames <- function(projectKey) {
  sapply(dkuListRecipes(projectKey, "r"), function(x) x[['name']])
}

# -------- utils --------

.generate_tmp_ids <- function(dss_instances) {
  ret <- list()
  for(instance in dss_instances) {
  	print("GENERATE ID FOR")
  	print(instance)
    instance[['tmp_id']] <- .make_unique_instance_id(dss_instances)
    ret <- append(ret, list(instance))
  }
  return(ret)
}

.lookup_by_field <- function(obj_list, field, value) {
  n <- 1
  for (obj in obj_list) {
    if (!is.na(value) && !is.na(obj[field]) && obj[field] == value) {
      return(n)
    }
    n <- n + 1
  }
  return(-1)
}

.make_unique_instance_id <- function(dss_instances) {
  #for (n in 1:100) {
    tmp_id <- floor(runif(1, min=0,max=10e8))  #sample(1:10e8, size = 1)
    #if (.lookup_by_field(dss_instances, 'tmp_id', tmp_id) == -1) {
    #  return(tmp_id)
    #}
  #}
  #stop("Failed to make unique instance id")
  tmp_id
}

.remove_unique_instance_id <- function(dss_instances) {
  ret = list();
  for (instance in dss_instances) {
    ret <- append(ret, list(.remove_key(instance, 'tmp_id')))
  }
  return(ret)
}

.remove_key <- function (vec, key) {
  vec[-match(key, names(vec))]
} 

.get_current_window_code <- function() {
  lines <- rstudioapi::getSourceEditorContext()$contents
  paste(lines, collapse="\n")
}
