(function() {
    'use strict';

    angular.module('dataiku.charts')
        .directive('animatedChartSlider', animatedChartSlider);

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/common/animation.js
     */
    function animatedChartSlider(ChartDimension, ChartUADimension) {
        return {
            scope: {
                labels: '=',
                currentFrame: '=',
                dimension: '='
            },
            template: '<div class="horizontal-flex animated-chart-slider" style="align-items: center;">'
                + '<div class="noflex">{{firstValue}}</div>'
                + '<div class="progress flex">'
                + '<div class="current" style="left:{{cursorLeft}}%; width: {{cursorWidth}}%;" ng-mousedown="startSliding($event)" ng-mouseup="stopSliding()"></div>'
                + '</div>'
                + '<div class="noflex">{{lastValue}}</div>'
                + '</div>',
            link: function($scope, $el) {

                let labelPositions;

                const findClosestIdx = function(x, arr) {
                    const indexArr = arr.map(function(k) {
                        return Math.abs(k.center - x)
                    });
                    const min = Math.min.apply(Math, indexArr);
                    return indexArr.indexOf(min);
                };

                $scope.$watch('labels', function(nv) {
                    if (!nv) {
                        return;
                    }

                    if (ChartDimension.isUngroupedNumerical($scope.dimension)) {
                        $scope.firstValue = $scope.labels[0].sortValue;
                        $scope.lastValue = $scope.labels[$scope.labels.length - 1].sortValue;
                        const scale = d3.scale.linear()
                            .domain([$scope.labels[0].sortValue, $scope.labels[$scope.labels.length - 1].sortValue])
                            .range([0, 100]);
                        labelPositions = $scope.labels.map(function(label) {
                            return {
                                center: scale(label.sortValue),
                                start: scale(label.sortValue) - 1,
                                width: 2
                            };
                        });
                    } else if (ChartDimension.isGroupedNumerical($scope.dimension)) {
                        $scope.firstValue = $scope.labels[0].min;
                        $scope.lastValue = $scope.labels[$scope.labels.length - 1].max;
                        const linearScale = d3.scale.linear()
                            .domain([$scope.labels[0].min, $scope.labels[$scope.labels.length - 1].max])
                            .range([0, 100]);
                        labelPositions = $scope.labels.map(function(label) {
                            return {
                                center: linearScale(label.sortValue),
                                start: linearScale(label.min),
                                width: linearScale(label.max) - linearScale(label.min)
                            };
                        });
                    } else if (ChartDimension.isAlphanumLike($scope.dimension) || ChartUADimension.isDiscreteDate($scope.dimension)) {
                        $scope.firstValue = null;
                        $scope.lastValue = null;
                        const ordinalScale = d3.scale.ordinal()
                            .domain($scope.labels.map(function(d, i) {
                                return i;
                            }))
                            .rangeBands([0, 100]);

                        labelPositions = $scope.labels.map(function(label, i) {
                            return {
                                start: ordinalScale(i),
                                width: ordinalScale.rangeBand(),
                                center: ordinalScale(i) + ordinalScale.rangeBand() / 2
                            };
                        });
                    }

                    if ($scope.currentFrame !== null) {
                        $scope.cursorLeft = labelPositions[$scope.currentFrame].start;
                        $scope.cursorWidth = labelPositions[$scope.currentFrame].width;
                    }
                });

                const slideCursor = function($evt) {
                    $evt.preventDefault(); // useful to avoid selecting content while sliding
                    const sliderPosition = $el.offset().left;
                    const xPosition = ($evt.pageX - sliderPosition) / $el.width() * 100;
                    $scope.$apply(function() {
                        $scope.currentFrame = findClosestIdx(xPosition, labelPositions);
                    });
                };

                $scope.startSliding = function($evt) {
                    $scope.sliding = true;
                    $(window).on('mouseup.chart-animation.' + $scope.$id, $scope.stopSliding);
                    $(window).on('mousemove.chart-animation' + $scope.$id, slideCursor);
                    $('body').css('cursor', 'move');
                };

                $scope.stopSliding = function() {
                    $scope.sliding = false;
                    $(window).off('mouseup.chart-animation.' + $scope.$id);
                    $(window).off('mousemove.chart-animation' + $scope.$id);
                    $('body').css('cursor', 'auto');
                };

                $scope.$watch('currentFrame', function(nv) {
                    if (nv == null) {
                        return;
                    }
                    $scope.cursorLeft = labelPositions[nv].start;
                    $scope.cursorWidth = labelPositions[nv].width;
                });
            }
        }
    }

})();
