angular.module('dataiku').run(['$templateCache', function($templateCache) {
'use strict';

$templateCache.put("/templates/404.html", "<div class=\"alert alert-error\">\nPage not found {{$stateParams}}\n</div>");
$templateCache.put("/templates/about-dss.html", "<div class=\"modal modal3\">\n    <div dku-modal-header ng-if=\"!wl.aboutModalTitle\" modal-title=\"About DSS\"  />\n    <div dku-modal-header ng-if=\"wl.aboutModalTitle\" modal-title=\"{{wl.aboutModalTitle}}\"  />\n    <div class=\"modal-body\">\n        <div class=\"about-modal\" ng-if=\"!wl.aboutModalText\">\n            <p class=\"about-title\">Dataiku DSS</p>\n            <p class=\"about-subtitle\">Version <strong ng-bind=\"appConfig.version.product_version || 'NA'\" /></p>\n            <p class=\"about-links\">\n                <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"http://www.dataiku.com\">Dataiku Website</a>\n                <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"{{$root.versionDocRoot}}\">Documentation</a>\n            </p>\n            <p class=\"about-footer\">&copy; 2013-{{currentYear}} Dataiku SAS – All rights reserved</p>\n        </div>\n        <div class=\"about-modal\" ng-if=\"wl.aboutModalText\" style=\"background-image: url({{wl.aboutModalLogoUrl}}\">\n            <p class=\"about-title\">{{wl.productLongName}}</p>\n            <p class=\"about-subtitle\">Version <strong ng-bind=\"appConfig.version.product_version || 'NA'\" /></p>\n            <div from-markdown=\"wl.aboutModalText\"></div>\n        </div>\n    </div>\n    <div class=\"modal-footer modal-footer-std-buttons\">\n        <button class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Close</button>\n    </div>\n</div>\n");
$templateCache.put("/templates/about-partitioning.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header-with-totem modal-title=\"Partitioning\" modal-totem=\"icon-question-sign\" />\n<div class=\"modal-body\" >\n\t<div ng-if=\"appConfig.communityEdition\" class=\"ce-unavail\" style=\"margin-bottom: 15px;\"> <strong>This feature is not available in DSS Free Edition</strong> \n\t\t<!-- TODO @community CTA -->\n\t</div>\n\t<div style=\"font-size: 0.85em;\">\n\t\t<p>\n\t\t\tPartitioning is the ability to split a dataset along meaningful dimensions. Each partition contains a subset of the dataset.\n\t\t</p>\n\t\t<p>\n\t\t\tFor example:\n\t\t</p>\n\t\t<ul>\n\t\t\t<li>\n\t\t\t\tA database of customers can be partitioned by country.\n\t\t\t</li>\n\t\t\t<li>\n\t\t\t\tWeb logs can be partitioned by day and by the server which generated the log line\n\t\t\t</li>\n\t\t</ul>\n\t\t<p>Partitions can be used for:</p>\n\t\t<ul>\n\t\t\t<li> <strong>Incrementality</strong>\n\t\t\t\t: When a dataset is partitioned, you don't need to build the full dataset, but instead partition by partition. Only out-of-date partitions need to be rebuilt\n\t\t\t</li>\n\t\t\t<li>\n\t\t\t\t<strong>Advanced dependencies</strong>\n\t\t\t\t: Partitioning a dataset allows you to have partition-level dependencies management. Instead of just having the recipe specify that an output dataset depends from an input dataset, you can define what partitions of the input are required to compute a given partition of the output.\n\t\t</ul>\n\t\t<p>\n\t\t\tMore info is available in\n\t\t\t<a href=\"{{$root.versionDocRoot}}/concepts/\">the Concepts page</a>\n\t\t</p>\n\t</div>\n</div>\n<div class=\"modal-footer modal-footer-std-buttons\">\n\t<button ng-click=\"dismiss()\" class=\"btn btn--text btn--secondary\">Close</button>\n</div>\n</div>\n");
$templateCache.put("/templates/achievement.html", "<div class=\"row-fluid\">\n\t<div class=\"span3 text-center\" style=\"padding-top: 10px;\">\n\t\t<i class=\"{{achievementIcon}} icon-4x\" />\n\t</div>\n\t<div class=\"span9\">\n\t\t<h3>Achievement unlocked</h3>\n\t\t<h4 style=\"color: #ccc;\">{{achievementTitle}}</h4>\n\t\t<p style=\"font-style: italic;\">{{achievementText}}</p>\n\t</div>\n</div>");
$templateCache.put("/templates/activity-indicator.html", "<div data-qa-activity-indicator class=\"activity-indicator\" ng-class=\"{in:!activityIndicator.hidden, fade: activityIndicator.faded}\">\n    <div ng-class=\"{['type-' + activityIndicator.type]: true}\">\n        <span ng-show=\"activityIndicator.spinner\">\n            <i class=\"icon-spin icon-spinner\"></i>\n        </span>\n        <span ng-bind-html=\"activityIndicator.text\"></span>\n\n        <button\n            ng-if=\"activityIndicator.action\"\n            ng-click=\"activityIndicator.action.callback()\"\n            class=\"btn btn--text btn--secondary mleft8\"\n            ng-class=\"{\n                'btn--dku-icon': activityIndicator.action.icon\n            }\"\n            data-qa-activity-indicator-action-button\n        >\n            <i\n                ng-if=\"activityIndicator.action.icon\"\n                class=\"{{activityIndicator.action.icon}}\"\n            ></i>\n            {{ activityIndicator.action.label }}\n        </button>\n\n        <button\n            ng-if=\"activityIndicator.action\"\n            ng-click=\"activityIndicator.hide()\"\n            class=\"btn btn--text btn--secondary btn--icon btn--dku-icon fr\"\n        >\n            <i class=\"dku-icon-dismiss-16\"></i>\n        </button>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/cloud-source-ips.html", "<div ng-if=\"appConfig.deploymentMode == 'CLOUD' && appConfig.dataikuCloudUISettings && appConfig.dataikuCloudUISettings.usedSourceIPs\">\n    <div class=\"alert alert-info mbot0\">\n        <p>Dataiku Cloud will connect from the following IP addresses:</p>\n        <ul>\n            <li ng-repeat=\"ip in appConfig.dataikuCloudUISettings.usedSourceIPs\">{{ip}}</li>\n        </ul>\n        <p class=\"mbot0\">Make sure to allow inbound traffic from these IPs in your firewall and to include them in any database grant / IP restriction</p>\n    </div>\n</div>");
$templateCache.put("/templates/admin/clusters/cluster-action-tile.html", "<div class=\"h100 vertical-flex\" full-click>\n    <a ng-click=\"showCallback(clusterId, action)\" main-click></a>\n    <div class=\"noflex runnables__tile-label\">\n        <i class=\"{{action.icon | toModernIcon:16}} runnables__tile-icon\"></i><br/>{{action.label}}\n    </div>\n    <div class=\"flex runnables__tile-description\">\n        {{description}}\n        <div class=\"fadeout\"></div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/clusters/cluster-actions-form.html", "<div class=\"runnables\">\n    <h1>Actions</h1>\n\n    <div class=\"oa runnables__tiles mtop20\">\n        <div ng-show=\"fatalAPIError\" block-api-error></div>\n        <div ng-if=\"clusterArchitecture==='KUBERNETES'\">\n            <div ng-if=\"!isManualOrRunning()\" style=\"margin-top: 10px\" class=\"alert alert-info\"> <i class=\"icon-info-sign\" />&nbsp;Cluster is not started/attached</div>\n            <div ng-repeat=\"k8sAction in k8sActions\" ng-if=\"isManualOrRunning() && (k8sAction.check && k8sAction.check() || !k8sAction.check)\" class=\"runnables__tile\">\n                <cluster-action-tile cluster-id=\"clusterId\" action=\"k8sAction\" show-callback=\"showRunK8sAction\">\n            </div>\n\n            <div ng-if=\"clusterActions.length > 0\">\n                <div ng-repeat=\"clusterAction in clusterActions\" class=\"runnables__tile\" full-click>\n                    <cluster-action-tile cluster-id=\"clusterId\" action=\"clusterAction\" show-callback=\"showCreateRunnable\" description=\"clusterAction.runnable.desc.meta.description\">\n                </div>\n            </div>\n        </div>\n\n        <div ng-if=\"clusterActions.length > 0 && clusterArchitecture!='KUBERNETES'\" ng-repeat=\"clusterAction in clusterActions\" class=\"runnables__tile\" full-click>\n            <cluster-action-tile cluster-id=\"clusterId\" action=\"clusterAction\" show-callback=\"showCreateRunnable\" description=\"clusterAction.runnable.desc.meta.description\">\n        </div>\n    </div>\n</div>\n\n");
$templateCache.put("/templates/admin/clusters/cluster-params-form.html", "<div ng-if=\"clusterType && clusterType != 'manual'\">\n    <div ng-if=\"desc.longDescription\">\n        <div style=\"padding: 0;\" class=\"larger-grey-text\"><span from-markdown=\"desc.longDescription\"/></div>\n    </div>\n    <div custom-params-form ng-if=\"desc && pluginDesc\"\n        desc=\"desc\"\n        plugin-desc=\"pluginDesc\"\n        component-id=\"loadedDesc.id\"\n        config=\"params.config\" >\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/clusters/cluster.html", "<div class=\"dss-page\">\n    <div class=\"cluster fh\" global-keydown=\"{'ctrl-s meta-s':'saveCluster()'}\">\n        <div class=\"top-level-tabs\">\n            <div class=\"horizontal-flex object-nav\">\n\n                <div class=\"object-breadcrumb object-breadcrumb--tooltip-on-overflow-no-expand\">\n                    <div class=\"item\">\n                        <div class=\"title\">\n                            <a ui-sref=\"admin.clusters.list\"\n                               class=\"object-breadcrumb__link\"\n                               title=\"Go back to clusters list\">\n                                Clusters</a>\n                            <i class=\"object-breadcrumb__divider\">/</i>\n                            <div class=\"object-breadcrumb__item\" show-tooltip-on-text-overflow text-tooltip=\"cluster.name\" tooltip-direction=\"'tooltip-bottom'\"></div>\n                        </div>\n                    </div>\n                </div>\n\n                <div class=\"cluster__nav-bar-tabs\">\n                    <a class=\"tab\" fw500-width\n                       ng-if=\"cluster.type === 'manual'\"\n                       ng-class=\"{'enabled': uiState.active === 'info'}\"\n                       ng-click=\"uiState.active = 'info'\">\n                       Details\n                    </a>\n                     <a class=\"tab\" fw500-width\n                       ng-if=\"cluster.type !== 'manual'\"\n                       ng-class=\"{'enabled': uiState.active === 'info'}\"\n                       ng-click=\"uiState.active = 'info'\">\n                       Configuration\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'monitoring'}\"\n                       ng-click=\"uiState.active = 'monitoring'; goToClusterObjectMonitoring(clusterObjects[0])\"\n                       ng-if=\"cluster.canUpdateCluster && cluster.architecture === 'KUBERNETES'\">\n                        Monitoring\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'usages'}\"\n                       ng-click=\"uiState.active = 'usages'\"\n                       ng-if=\"cluster.canUpdateCluster\">\n                        Usages\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'permissions'}\"\n                       ng-click=\"uiState.active = 'permissions'\"\n                       ng-if=\"cluster.canManageUsersCluster\">\n                        Permissions\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'hadoop'}\"\n                       ng-click=\"uiState.active = 'hadoop'\"\n                       ng-if=\"cluster.architecture === 'HADOOP'\">\n                        Hadoop\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'hive'}\"\n                       ng-click=\"uiState.active = 'hive'\"\n                       ng-if=\"cluster.architecture === 'HADOOP'\">\n                        Hive\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'impala'}\"\n                       ng-click=\"uiState.active = 'impala'\"\n                       ng-if=\"cluster.architecture === 'HADOOP'\">\n                        Impala\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'spark'}\"\n                       ng-if=\"cluster.architecture === 'HADOOP' || cluster.type == 'manual'\"\n                       ng-click=\"uiState.active = 'spark'\">\n                        Spark\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'container'}\"\n                       ng-click=\"uiState.active = 'container'\"\n                       ng-if=\"cluster.architecture === 'KUBERNETES' && cluster.type === 'manual'\">\n                        Containerized execution\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'actions'}\"\n                       ng-click=\"uiState.active = 'actions'\"\n                       ng-if=\"cluster.canUpdateCluster\">\n                        Actions\n                    </a>\n                    <a class=\"tab\" fw500-width\n                       ng-class=\"{'enabled': uiState.active === 'log'}\"\n                       ng-click=\"uiState.active = 'log'\"\n                       ng-if=\"cluster.type !== 'manual'\">\n                        Logs\n                    </a>\n\n                    <a class=\"tab\" fw500-width\n                       ng-if=\"cluster.architecture === 'KUBERNETES' && cluster.type !== 'manual'\"\n                       ng-class=\"{'enabled': uiState.active === 'internal-managed-k8s-settings'}\"\n                       ng-click=\"uiState.active = 'internal-managed-k8s-settings'\">\n                        Internal settings\n                    </a>\n                </div>\n\n                <div class=\"otherLinks cluster__nav-bar-otherlinks\">\n                    <span ng-if=\"cluster.type !== 'manual'\" class=\"btn-group flex\">\n                        <button ng-if=\"cluster.state === 'NONE'\" class=\"btn btn--primary btn--full\" ng-disabled=\"isLongClusterOperationRunning\" ng-click=\"startCluster()\">\n                            {{getStartStopButtonDisplayString(cluster, true)}}\n                        </button>\n                        <button ng-if=\"cluster.state === 'RUNNING'\" class=\"btn btn--danger btn--full\" ng-disabled=\"isLongClusterOperationRunning\" ng-click=\"stopCluster()\">\n                            {{getStartStopButtonDisplayString(cluster, false)}}\n                        </button>\n                    </span>\n\n                    <span ng-if=\"clusterIsDirty()\" class=\"btn-group save-button flex\">\n                        <button class=\"btn btn--outline btn--primary btn--full\" ng-click=\"saveCluster()\">\n                            <i class=\"icon-save\"></i>\n                            &nbsp;Save\n                        </button>\n                    </span>\n                    <span ng-if=\"!clusterIsDirty()\" class=\"btn-group save-button flex\">\n                        <button class=\"btn btn--outline btn--primary btn--full\" ng-disabled=\"true\">\n                            <i class=\"icon-save\"></i>\n                            &nbsp;Saved!\n                        </button>\n                    </span>\n                    <div class=\"btn-group\">\n                        <button class=\"btn btn--secondary dropdown-toggle\" data-toggle=\"dropdown\" href>\n                            Actions <span class=\"caret\"></span>\n                        </button>\n                        <ul class=\"dropdown-menu pull-right text-left\">\n                            <li>\n                                <a ng-click=\"downloadClusterDiagnostic()\">\n                                    <i class=\"icon-download\" />&nbsp;Download diagnostic\n                                </a>\n                            </li>\n                            <li>\n                                <a ng-if=\"cluster.state === 'RUNNING'\" ng-click=\"markStoppedCluster()\">\n                                    <i class=\"icon-stop\" />&nbsp;Mark as stopped\n                                </a>\n                            </li>\n                            <li>\n                                <a ng-if=\"cluster.type !== 'manual' && cluster.state !== 'RUNNING'\" ng-click=\"forceStopCluster()\">\n                                    <i class=\"icon-stop\" />&nbsp;Force stop\n                                </a>\n                            </li>\n                            <li>\n                                <a ng-click=\"deleteCluster()\">\n                                    <i class=\"icon-trash\" />&nbsp;Delete\n                                </a>\n                            </li>\n                        </ul>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"small-lr-padding page-top-padding boxed-under-subnav no-padding\" ng-switch=\"uiState.active\">\n            <div ng-switch-when=\"info\" class=\"paned-settings-page-pane h100 oa\" style=\"position: relative;\">\n                <h1>{{cluster.name}}\n                    - {{getDisplayType(cluster.type)}}\n                    <span ng-if=\"cluster.type !== 'manual'\"> - <span class=\"{{getStateDisplayClassNoIcon(cluster)}}\">{{getStateDisplayString(cluster)}}</span></span>\n                    <span ng-if=\"cluster.type !== 'manual' && getCreatedByString(cluster)\" class=\"created-by\">\n                        <i class=\"icon-dku-help\" title=\"{{getCreatedByString(cluster)}}\" data-placement=\"right\" toggle=\"tooltip\"/>\n                    </span>\n                </h1>\n\n                <div class=\"section\" ng-if=\"cluster.type === 'manual'\">\n                    <div block-api-error />\n                    <!-- Manual clusters don't have any configuration, so we put some not-so-useful stuff here, just\n                         to avoid a blank page -->\n                    <form class=\"dkuform-horizontal\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Owner</label>\n                            <div class=\"controls\">\n                                <div>{{cluster.owner}}</div>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Architecture</label>\n                            <div class=\"controls\">\n                                <div>{{cluster.architecture}}</div>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Created by</label>\n                            <div class=\"controls\">\n                                <div ng-if=\"cluster.origin == null\">N/A</div>\n                                <div ng-if=\"cluster.origin != null && cluster.origin.type == 'MANUAL'\">\n                                    User {{cluster.origin.identifier}}\n                                </div>\n                                <div ng-if=\"cluster.origin != null && cluster.origin.type == 'SCENARIO'\">\n                                    Scenario <a ui-sref=\"projects.project.scenarios.scenario.runs.list({projectKey: cluster.origin.scenarioProjectKey, scenarioId: cluster.origin.scenarioId})\">{{cluster.origin.scenarioId}}</a>\n                                </div>\n                            </div>\n                        </div>\n                    </form>\n                </div>\n                <div ng-if=\"cluster.type != 'manual'\" class=\"section\">\n                    <div block-api-error />\n                    <h2>Configuration</h2>\n                    <div ng-if=\"cluster.type != 'manual'\" class=\"params-form\">\n                        <div cluster-params-form cluster-type=\"cluster.type\" params=\"cluster.params\"/>\n                    </div>\n\n                    <div ng-if=\"cluster.type != 'manual' && cluster.state == 'RUNNING'\">\n                        <h3>Cluster data</h3>\n\n                        <pre class=\"debug\">{{cluster.data | json}}</pre>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"monitoring\" class=\"paned-settings-page-pane h100 oa vertical-flex\" style=\"position: relative;\" ng-if=\"cluster.canUpdateCluster\">\n                <div class=\"cluster__monitoring_title_section\">\n                    <h1>Monitoring</h1>\n\n                    <div class=\"cluster__namespace-filter\" ng-click=\"getNamespaces()\">\n                        Namespace&nbsp;\n                        <select dku-bs-select=\"{liveSearch: true}\"\n                                ng-model=\"namespaces.selectedMonitoringNamespaceFilter\"\n                                ng-options=\"o as o.name disable when o.filterType === 'LOADING' for o in namespaces.monitoringNamespaceFilterOptions\"\n                                ng-change=\"setMonitoringNamespaceFilter(namespaces.selectedMonitoringNamespaceFilter)\">\n                        </select>\n                    </div>\n                </div>\n                <div block-api-error />\n\n                <div class=\"section\">\n                    <div class=\"horizontal-flex object-nav\">\n                        <div class=\"cluster__monitoring_object_tabs\">\n                            <a ng-repeat=\"clusterObject in clusterObjects\" class=\"tab dku-fw500-width\" ng-class=\"{'enabled': uiState.activeMonitoring === clusterObject.name}\" ng-click=\"goToClusterObjectMonitoring(clusterObject)\" text-content=\"{{clusterObject.name}}s\">{{clusterObject.name}}s</a>\n                        </div>\n\n                        <div class=\"noflex\">\n                             <span class=\"dibvam cluster__monitoring-refresh\" ng-if=\"uiState.activeMonitoring === 'Pod'\">\n                                <label>\n                                    <input name=\"detailedPodData\" type=\"checkbox\" ng-model=\"uiState.detailedPodData\" />\n                                    <span class=\"help-inline\">Detailed pod data</span>\n                                </label>\n                            </span>\n                            <span class=\"dibvam cluster__monitoring-refresh\" ng-if=\"uiState.activeMonitoring === 'Node'\">\n                                <label>\n                                    <input name=\"detailedNodeData\" type=\"checkbox\" ng-model=\"uiState.detailedNodeData\" />\n                                    <span class=\"help-inline\">Detailed node data</span>\n                                </label>\n                            </span>\n                            <div class=\"std-list-search-box list-control-widget cluster__nav-bar-search-box\">\n                                <span class=\"add-on\"> <i class=\"icon-dku-search\"></i></span>\n                                <input type=\"search\" ng-model=\"uiState.monitoringQuery\" style=\"width: 150px;\" placeholder=\"Filter on results...\">\n                            </div>\n                            <button class=\"btn btn--secondary cluster__monitoring-refresh\" ng-click=\"refreshMonitoring()\">\n                                <i class=\"icon-refresh\"></i>\n                                &nbsp;Refresh\n                            </button>\n                        </div>\n                    </div>\n\n                    <div ng-repeat=\"clusterObject in clusterObjects\" ng-if=\"clusterObject.name === uiState.activeMonitoring\" class=\"flex oa\">\n                        <div ng-if=\"cluster.type !== 'manual' && cluster.state !== 'RUNNING'\" class=\"alert alert-info\"> <i class=\"icon-info-sign\" />&nbsp;Cluster is not started/attached</div>\n                        <div ng-if=\"clusterObject.state==='LOADING'\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />&nbsp;Please wait, getting {{clusterObject.name}}s</div>\n                        <div ng-if=\"clusterObject.state==='ERROR'\" class=\"alert alert-error\"> <i class=\"icon-dku-warning\" />&nbsp;Failed getting {{clusterObject.name}}s</div>\n                        <table ng-if=\"(cluster.type === 'manual' || cluster.state === 'RUNNING') && clusterObject.state==='LOADED'\" \n                               sort-table \n                               class=\"table table-striped table-hover\" \n                               style=\"width:100%\">\n                            <thead>\n                            <tr>\n                                <th sort-col=\"name\">Name</th>\n                                <th ng-repeat=\"col in clusterObject.cols\" \n                                    sort-col=\"{{col.key || col}}\">{{(col.columnName || col.key || col) | capitalize}}</th>\n                                <th ng-if=\"clusterObject.hasNamespace\"\n                                    sort-col=\"namespace\">Namespace&nbsp;<i ng-if=\"namespaces.selectedMonitoringNamespaceFilter.filterType !== 'NONE'\" class=\"icon-filter\" title=\"Namespace filter active: {{ namespaces.selectedMonitoringNamespaceFilter.name }}\" data-container=\"body\" toggle=\"tooltip-right\"></i></th>\n                            </tr>\n                            </thead>\n                            <tbody>\n                            <tr ng-repeat=\"item in clusterObject.data | toArray | filter:filterMonitoring | orderBy:sortColumn:sortDescending:resourceSort\" full-click>\n                                <td main-click ng-click=\"showObjectDescribe(item.name, clusterObject.name, item.namespace)\"><a>{{ item.name }}</a></td>\n                                <td ng-repeat=\"col in clusterObject.cols\"\n                                    ng-switch=\"col.type\"\n                                    class=\"ellipsed\"\n                                    style=\"max-width: 200px\">\n                                    <span ng-switch-when=\"pod-status\"\n                                          ng-switch=\"item[col.key]\">\n                                        <span ng-switch-when=\"Failed\" class=\"text-error\">Failed</span>\n                                        <span ng-switch-when=\"Running\" class=\"text-success\">Running</span>\n                                        <span ng-switch-when=\"Pending\" class=\"text-warning\">Pending</span>\n                                        <span ng-switch-default>{{ item[col.key] }}</span>\n                                    </span>\n                                    <span ng-switch-when=\"node-status\"\n                                          ng-switch=\"item[col.key]\">\n                                        <span ng-switch-when=\"Ready\" class=\"text-success\">Ready</span>\n                                        <span ng-switch-default class=\"text-warning\">{{ item[col.key] }}</span>\n                                    </span>\n                                    <div ng-switch-when=\"dss-project\" show-tooltip-on-text-overflow text-tooltip=\"item[col.key]\"></div>\n                                    <span ng-switch-when=\"dss-object\">\n                                        <span ng-if=\"item[col.key]\" class=\"mright8\">{{ item[col.key] }}</span>\n                                        <span ng-if=\"item[col.key] && !item['onLocalDssNode']\">(on other DSS node)</span>\n                                        <a ng-if=\"item['onLocalDssNode'] && item['dssLink']\" href=\"{{ item['dssLink'] }}\" target=\"blank\" title=\"Go to object\">\n                                            <i class=\"smaller-font icon-external-link\"></i>\n                                        </a>\n                                    </span>\n                                    <span ng-switch-default>{{ item[(col.key || col)] }}</span>\n                                </td>\n                                <td ng-if=\"clusterObject.hasNamespace\" class=\"ellipsed\" style=\"max-width: 200px\">{{ item.namespace }}</td>\n                            </tr>\n                            </tbody>\n                        </table>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"usages\" class=\"paned-settings-page-pane h100 vertical-flex\" style=\"position: relative;\" ng-if=\"cluster.canUpdateCluster\">\n                <h1>Cluster usage</h1>\n                <div block-api-error />\n                <div class=\"flex oa section\" ng-if=\"clusterStatus && clusterStatus.usages.length\">\n                    <div>\n                        <button type=\"button\" class=\"btn btn--secondary pull-right\" ng-click=\"refreshStatus()\">Refresh</button>\n                    </div>\n                    <ul>\n                        <li ng-repeat=\"usage in clusterStatus.usages\">\n                            <div ng-if=\"usage.scenarioId\">\n                                Scenario <a ui-sref=\"projects.project.scenarios.scenario.runs.list({projectKey: usage.scenarioProjectKey, scenarioId: usage.scenarioId})\">{{usage.scenarioId}}</a>\n                            </div>\n                            <div ng-if=\"!usage.scenarioId\">\n                                Project <a ui-sref=\"projects.project.home.regular({projectKey:usage.projectKey})\">{{usage.projectKey}}</a>\n                            </div>\n                        </li>\n                    </ul>\n                    <div>\n                        <span ng-if=\"clusterStatus.otherProjectUsagesCount > 0 || clusterStatus.otherScenarioUsagesCount > 0\"> + <strong>{{clusterStatus.otherProjectUsagesCount}}</strong> projects and <strong>{{clusterStatus.otherScenarioUsagesCount}}</strong> scenarios</span>\n                    </div>\n                </div>\n                <div class=\"flex empty-list-cta section\" ng-if=\"!clusterStatus || clusterStatus.usages.length == 0\">\n                     <div ng-if=\"clusterStatus.error\" api-error-alert=\"clusterStatus.error\" />\n                     <h1>\n                        No project or scenario is using this cluster\n                    </h1>\n                    <p>Projects can attach themselves to a cluster in their settings</p>\n                    <div>\n                        <a class=\"btn btn--secondary btn--large\" ng-click=\"refreshStatus()\">\n                            <i class=\"icon-refresh\" ></i>&nbsp;Refresh\n                        </a>\n                    </div>\n                </div>\n            </div>\n\n             <div ng-switch-when=\"actions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\" ng-if=\"cluster.canUpdateCluster\">\n                 <div class=\"actions-form\">\n                    <div cluster-actions-form cluster-id=\"cluster.id\" cluster-type=\"cluster.type\" cluster-architecture=\"cluster.architecture\"  cluster-state=\"cluster.state\" params=\"cluster.params\"/>\n                </div>\n             </div>\n\n            <div ng-switch-when=\"permissions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Permissions</h1>\n                <div class=\"section\">\n                    <div block-api-error />\n                    <div cluster-security-permissions cluster=\"cluster\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"hadoop\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Hadoop</h1>\n                <div ng-show=\"cluster.type != 'manual'\" class=\"alert alert-warning\">\n                     This is a managed cluster, you should generally not modify these settings. Changing these settings may make this cluster unusable. Modification may also be forbidden.\n                </div>\n                <div block-api-error />\n                <div ng-if=\"cluster.overrideHadoopSettings\" hadoop-cluster-settings-block settings=\"cluster.hadoopSettings\" mask=\"cluster.overrideHadoopSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\"/>\n            </div>\n\n            <div ng-switch-when=\"hive\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Hive</h1>\n                <div ng-show=\"cluster.type != 'manual'\" class=\"alert alert-warning\">\n                     This is a managed cluster, you should generally not modify these settings. Changing these settings may make this cluster unusable. Modification may also be forbidden.\n                </div>\n                <div block-api-error />\n                <div ng-if=\"cluster.overrideHiveSettings\" hive-cluster-settings-block settings=\"cluster.hiveSettings\" mask=\"cluster.overrideHiveSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\" hadoop-settings=\"cluster.hadoopSettings\"/>\n            </div>\n\n            <div ng-switch-when=\"impala\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Impala</h1>\n                <div ng-show=\"cluster.type != 'manual'\" class=\"alert alert-warning\">\n                     This is a managed cluster, you should generally not modify these settings. Changing these settings may make this cluster unusable. Modification may also be forbidden.\n                </div>\n                <div block-api-error />\n                <div ng-if=\"cluster.overrideImpalaSettings\" impala-cluster-settings-block settings=\"cluster.impalaSettings\" mask=\"cluster.overrideImpalaSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\"/>\n            </div>\n\n            <div ng-switch-when=\"container\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Containerized execution</h1>\n                <div block-api-error />\n                <div ng-if=\"!addLicInfo.containersLicensed\" class=\"alert alert-error\">\n                    <i class=\"icon-dku-error\" />&nbsp;Your license does not cover usage of containers\n                </div>\n\n                <div ng-if=\"addLicInfo.containersLicensed\">\n                    <div ng-if=\"cluster.overrideContainerSettings\" container-cluster-settings-block settings=\"cluster.containerSettings\" cluster-id=\"cluster.id\" cluster-defined-config=\"true\" mask=\"cluster.overrideContainerSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"spark\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Spark</h1>\n                <div block-api-error />\n                <div ng-if=\"!addLicInfo.sparkLicensed\" class=\"alert alert-error\">\n                    <i class=\"icon-dku-error\" />&nbsp;Your license does not cover usage of Spark\n                </div>\n\n                <div ng-if=\"addLicInfo.sparkLicensed\">\n                    <div ng-if=\"cluster.overrideSparkSettings\" spark-cluster-settings-block settings=\"cluster.sparkSettings\" cluster-id=\"cluster.id\" mask=\"cluster.overrideSparkSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\" hadoop-settings=\"cluster.hadoopSettings\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"internal-managed-k8s-settings\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Internal settings</h1>\n                <div class=\"alert alert-warning\">\n                    <h4>For information only</h4>\n                    This is a managed cluster, you should generally not modify these settings. Changing these settings may make this cluster unusable. Modification may also be forbidden.<br />\n                    To setup containerized execution using this cluster, setup container execution configs in global settings and enable this cluster at the project level.<br />\n                    To setup Spark-on-Kubernetes execution using this cluster, setup Spark configurations in global settings, enable \"Managed Spark on Kubernetes\" and enable this cluster at the project level.\n                </div>\n                <div block-api-error />\n                <div ng-if=\"!addLicInfo.containersLicensed\" class=\"alert alert-error\">\n                    <i class=\"icon-dku-error\" />&nbsp;Your license does not cover usage of containers\n                </div>\n                <div ng-if=\"addLicInfo.containersLicensed\">\n                    <h1>Containerized execution</h1>\n                    <div ng-if=\"cluster.overrideContainerSettings\" container-cluster-settings-block settings=\"cluster.containerSettings\" cluster-id=\"cluster.id\" cluster-defined-config=\"true\" mask=\"cluster.overrideContainerSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\"/>\n                </div>\n                <div ng-if=\"!addLicInfo.sparkLicensed\" class=\"alert alert-error\">\n                    <i class=\"icon-dku-error\" />&nbsp;Your license does not cover usage of Spark\n                </div>\n\n                <div ng-if=\"addLicInfo.sparkLicensed\">\n                    <h1>Spark</h1>\n                    <div ng-if=\"cluster.overrideSparkSettings\" spark-cluster-settings-block settings=\"cluster.sparkSettings\" cluster-id=\"cluster.id\" mask=\"cluster.overrideSparkSettings\" impersonation-enabled=\"appConfig.impersonationEnabled\" hadoop-settings=\"cluster.hadoopSettings\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"log\" class=\"h100 vertical-flex paned-settings-page-pane\">\n                <h1>Cluster logs</h1>\n                <div class=\"flex\">\n                <div class=\"fh\">\n                <div class=\"h100 section vertical-flex\">\n                <div block-api-error />\n                <div class=\"noflex std-list-header\">\n                    <div class=\"std-list-search-box\" style=\"display: inline-block;\">\n                        <span class=\"add-on\"> <i class=\"icon-dku-search\"></i>\n                        </span>\n                        <input type=\"search\" ng-model=\"uiState.logsQuery\" style=\"width: 190px;\" placeholder=\"Filter...\"/>\n                    </div>\n                    <button type=\"button\" class=\"btn btn--secondary pull-right\" ng-click=\"listLogs()\">Refresh</button>\n                </div>\n\n                <div class=\"noflex oa\" style=\"max-height: 200px;\">\n                    <table sort-table class=\"table table-striped table-hover\" style=\"width:100%\">\n                        <thead>\n                            <tr>\n                                <th sort-col=\"name\">Name</th>\n                                <th sort-col=\"totalSize\">Size</th>\n                                <th sort-col=\"lastModified\">Last modified</th>\n                                <th>&nbsp;</th>\n                            </tr>\n                        </thead>\n                        <tbody>\n                            <tr ng-repeat=\"log in logs | filter:uiState.logsQuery | orderBy:sortColumn:sortDescending\" full-click ng-class=\"{'active-log' : log.name == currentLogName}\">\n                                <td main-click ng-click=\"fetchLog(log.name)\">{{ log.name }}</td>\n                                <td>{{ log.totalSize | filesize }}</td>\n                                <td>{{ log.lastModified | friendlyDate }}</td>\n                                <td>\n                                    <a ng-click=\"streamLog(log.name)\" style=\"text-decoration:none\">\n                                        <i class=\"icon-download\"></i>\n                                    </a>\n                                </td>\n                            </tr>\n                        </tbody>\n                    </table>\n                </div>\n                <div class=\"noflex\" ng-if=\"currentLogName && currentLogName.length > 0\">\n                    <h4 class=\"log-name\">- {{currentLogName}}<span style=\"margin-left: 20px; font-weight: 300;\" ng-if=\"currentLog.lines.length < currentLog.totalLines\">(last {{currentLog.lines.length}} lines of {{currentLog.totalLines}})</span></h4>\n                </div>\n                <div class=\"flex oa\" ng-if=\"currentLogName && currentLogName.length > 0\">\n                    <pre smart-log-tail=\"currentLog\"></pre>\n                </div>\n                </div>\n                </div>\n                </div>\n            </div>\n\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/clusters/clusters.html", "<div class=\"dss-page\">\n    <div class=\"fh\">\n        <div class=\"top-level-tabs\">\n            <div class=\"horizontal-flex object-nav\">\n                <div class=\"object-breadcrumb object-breadcrumb--tooltip-on-overflow noflex\">\n                    <div class=\"item\">\n                        <div class=\"title\">\n                            <a class=\"object-breadcrumb__link\">Clusters</a>\n                        </div>\n                    </div>\n                </div>\n\n                <div class=\"flex\">\n                    <div class=\"std-list-search-box list-control-widget cluster__nav-bar-search-box\">\n                        <span class=\"add-on\"> <i class=\"icon-dku-search\"></i></span>\n                        <input type=\"search\" ng-model=\"uiState.query\" style=\"width: 190px;\" placeholder=\"Filter...\"/>\n                    </div>\n\n                    <button class=\"btn btn--secondary cluster__nav-bar-refresh\" ng-click=\"refreshList()\">\n                        <i class=\"icon-refresh\"></i>\n                        &nbsp;Refresh\n                    </button>\n                </div>\n\n                <div class=\"otherLinks noflex\">\n                    <button class=\"btn btn--primary\" ng-if=\"isPluginInstalled('gke')\" ng-click=\"createPluginCluster('gke')\">\n                        Create GKE cluster\n                    </button>\n\n                    <button class=\"btn btn--primary\" ng-if=\"isPluginInstalled('aks')\" ng-click=\"createPluginCluster('aks')\">\n                        Create AKS cluster\n                    </button>\n\n                    <button class=\"btn btn--primary\" ng-if=\"isPluginInstalled('eks')\" ng-click=\"createPluginCluster('eks')\">\n                        Create EKS cluster\n                    </button>\n\n                    <button class=\"btn btn--primary\" ng-click=\"createCluster()\">\n                        Add cluster\n                    </button>\n                </div>\n            </div>\n        </div>\n\n        <div block-api-error></div>\n\n        <div class=\"oa clusters\">\n            <div class=\"flex\" ng-if=\"clusters.length\">\n                <div class=\"tiles\">\n                    <div ng-repeat=\"cluster in clusters | filter:filterClusters\" class=\"tile overlay-disablable-item-container\">\n                        <div class=\"h100 vertical-flex\" full-click>\n                            <a ui-sref=\"admin.clusters.cluster({clusterId:cluster.id})\" main-click></a>\n                            <div class=\"top {{cluster.architecture}} vertical-flex\">\n                                <div class=\"cluster-infos horizontal-flex\">\n                                    <div title=\"{{getStateDisplayString(cluster)}}\" data-placement=\"right\" toggle=\"tooltip\" class=\"icon\">\n                                        <i class=\"{{getStateDisplayClass(cluster)}} icon\"></i>\n                                    </div>\n                                    <div class=\"title\">{{cluster.name}}</div>\n                                    <div class=\"cog\">\n                                        <div custom-element-popup cep-position=\"align-right-bottom\" close-on-click=\"true\">\n                                            <i class=\"icon-cog mainzone cursor-pointer icon\" ng-click=\"togglePopover()\"></i>\n                                            <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                                                <li>\n                                                    <a ng-click=\"downloadClusterDiagnostic(cluster.id, cluster.architecture, cluster.type)\">\n                                                    <i class=\"icon-download\"></i>&nbsp;Download diagnostic</a>\n                                                </li>\n                                                <li ng-if=\"cluster.state === 'RUNNING'\">\n                                                    <a ng-click=\"markStoppedCluster(cluster.id, cluster.architecture, cluster.type)\">\n                                                    <i class=\"icon-stop\" />&nbsp;Mark as stopped</a>\n                                                </li>\n                                                <li>\n                                                    <a ng-if=\"cluster.type !== 'manual' && cluster.state !== 'RUNNING'\" ng-click=\"forceStopCluster(cluster.id, cluster.architecture, cluster.type)\">\n                                                        <i class=\"icon-stop\" />&nbsp;Force stop\n                                                    </a>\n                                                </li>\n                                                <li>\n                                                    <a ng-click=\"deleteCluster(cluster.id, cluster.architecture, cluster.type)\">\n                                                    <i class=\"icon-trash\"></i>&nbsp;Delete</a>\n                                                </li>\n                                            </ul>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div class=\"cluster-infos cluster-type\">\n                                    <i class=\"icon-terminal icon\"></i>\n                                    <div class=\"title\">{{cluster.ui.typeName}}</div>\n                                </div>\n                                <div class=\"cluster-infos cluster-architecture\">\n                                    <i class=\"{{cluster.ui.icon}} icon\"></i>\n                                    <div class=\"title\">{{cluster.architecture.toLowerCase()}}</div>\n                                </div>\n                            </div>\n                            <div class=\"data\">\n                                <div class=\"details\">\n                                    <div class=\"details-key\">Used in projects</div>\n                                    <div class=\"details-value\">{{cluster.usedInProjects}}</div>\n                                </div>\n\n                                <div class=\"details\">\n                                    <div class=\"details-key\">Nodes</div>\n                                    <div class=\"details-value\">\n                                        <i ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='LOADING'\" class=\"icon-spin icon-spinner\"/>\n                                        <span ng-if=\"cluster.data.state==='LOADED'\">{{cluster.data.count.nodes}}</span>\n                                        <span ng-if=\"cluster.architecture!=='KUBERNETES'\">N/A</span>\n                                        <span ng-if=\"isK8sAndIsStopped(cluster)\">-</span>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='ERROR'\" title=\"Unable to load cluster info\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-dku-error icon\"></i>\n                                        </div>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='INSUFFICIENT_PERMISSION'\" title=\"Insufficient permissions\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-lock icon\"></i>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div class=\"details\">\n                                    <div class=\"details-key\">Pods</div>\n                                    <div class=\"details-value\">\n                                        <i ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='LOADING'\" class=\"icon-spin icon-spinner\"/>\n                                        <span ng-if=\"cluster.data.state==='LOADED'\">{{cluster.data.count.pods}}</span>\n                                        <span ng-if=\"cluster.architecture!=='KUBERNETES'\">N/A</span>\n                                        <span ng-if=\"isK8sAndIsStopped(cluster)\">-</span>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='ERROR'\" title=\"Unable to load cluster info\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-dku-error icon\"></i>\n                                        </div>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='INSUFFICIENT_PERMISSION'\" title=\"Insufficient permissions\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-lock icon\"></i>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div class=\"details\">\n                                    <div class=\"details-key\">Unschedulable pods</div>\n                                    <div class=\"details-value\">\n                                        <i ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='LOADING'\" class=\"icon-spin icon-spinner\"/>\n                                        <span ng-if=\"cluster.data.state==='LOADED'\">{{cluster.data.count.unschedulablePods}}</span>\n                                        <span ng-if=\"cluster.architecture!=='KUBERNETES'\">N/A</span>\n                                        <span ng-if=\"isK8sAndIsStopped(cluster)\">-</span>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='ERROR'\" title=\"Unable to load cluster info\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-dku-error icon\"></i>\n                                        </div>\n                                        <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.data.state==='INSUFFICIENT_PERMISSION'\" title=\"Insufficient permissions\" toggle=\"tooltip\" class=\"icon\">\n                                            <i class=\"icon-lock icon\"></i>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                            <div class=\"footer\">\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.metricsServer==='INSTALLED' && cluster.metrics.state==='LOADED' || !isK8sAndIsRunning(cluster)\" class=\"indicator cpu\">\n                                    <div class=\"key\">CPU</div>\n                                    <div ng-if=\"cluster.metricsServer==='INSTALLED'\" class=\"gauge\">{{cluster.metrics.cpuUsage}}%</div>\n                                    <div ng-if=\"cluster.architecture!='KUBERNETES'\" class=\"gauge\">N/A</div>\n                                    <div ng-if=\"cluster.architecture==='KUBERNETES' && cluster.metricsServer==='NOT_INSTALLED'\" class=\"gauge\">-</div>\n                                </div>\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.metricsServer==='INSTALLED' && cluster.metrics.state==='LOADED' || !isK8sAndIsRunning(cluster)\" class=\"indicator ram\">\n                                    <div class=\"key\">RAM</div>\n                                    <div ng-if=\"cluster.metricsServer==='INSTALLED'\" class=\"gauge\">{{cluster.metrics.memoryUsage}}%</div>\n                                    <div ng-if=\"cluster.architecture!=='KUBERNETES'\" class=\"gauge\">N/A</div>\n                                    <div ng-if=\"cluster.architecture==='KUBERNETES' && cluster.metricsServer==='NOT_INSTALLED'\" class=\"gauge\">-</div>\n                                </div>\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.metricsServer==='NOT_INSTALLED'\">\n                                    <div title=\"Metrics server not installed\" toggle=\"tooltip\" class=\"icon\">\n                                        <i class=\"icon-dku-error icon\"/>\n                                    </div>&nbsp;Metrics unavailable\n                                </div>\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && (cluster.metricsServer==='CHECKING' || cluster.metricsServer==='INSTALLED' && cluster.metrics.state=='LOADING')\">\n                                    <i class=\"icon-spin icon-spinner\"/>&nbsp;Loading monitoring\n                                </div>\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && (cluster.metrics.state==='ERROR' || cluster.metricsServer==='ERROR')\">\n                                    <i class=\"icon-dku-error icon\"/>&nbsp;Unable to retrieve metrics\n                                </div>\n                                <div ng-if=\"isK8sAndIsRunning(cluster) && cluster.metricsServer==='INSUFFICIENT_PERMISSION'\">\n                                    <div title=\"Insufficient permissions\" toggle=\"tooltip\" class=\"icon\">\n                                        <i class=\"icon-lock icon\"/>\n                                    </div>&nbsp;Monitoring not available\n                                </div>\n                            </div>\n                        </div>\n                        <div class=\"overlay-disabled-item\"\n                             ng-if=\"!cluster.canUpdateCluster\"\n                             toggle=\"tooltip\"\n                             container=\"body\"\n                             title=\"You can only use this cluster, not monitor nor modify it.\">\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"empty-list-cta flex\" ng-if=\"clusters.length === 0 && !refreshing\" style=\"margin-top: 50px\">\n                <h1 style=\"margin-bottom: 0\">No clusters attached or created</h1>\n\n                <div style=\"margin-top: 20px\">\n                    <p>Clusters are sets of nodes that run containerized<br />applications with their dependencies and services.</p>\n                </div>\n\n                <div>\n                    <p><span doclink-wrapper page=\"containers/index\">Read the documentation</span> to learn more.</p>\n                </div>\n\n                <div class=\"noflex\">\n                    <button class=\"btn btn--primary\"\n                            ng-click=\"mainCreateOption.action()\">\n                            {{mainCreateOption.title}}\n                    </button>\n                    <span class=\"dropdown grouped-dropdown-button\" ng-if=\"createClusterOptions\">\n                        <button class=\"btn btn--primary btn--icon dropdown-toggle manual-caret\"\n                                type=\"button\"\n                                data-toggle=\"dropdown\"\n                                ng-disabled=\"!createClusterOptions\">\n                            <i class=\"icon-caret-down\" />\n                        </button>\n                        <ul class=\"dropdown-menu\">\n                            <li ng-repeat=\"option in createClusterOptions\">\n                                <a  ng-click=\"option.action()\">{{option.title}}</a>\n                            </li>\n                        </ul>\n                    </span>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/clusters/delete-cluster-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"Delete cluster\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n            \n            <div ng-if=\"clusterStatus.error\" api-error-alert=\"clusterStatus.error\" />\n            \n            <div ng-if=\"clusterStatus && clusterStatus.usages.length == 0\">Delete cluster <b>{{clusterId}}</b> (not used)</div>\n            \n            <div ng-if=\"clusterStatus && clusterStatus.usages.length > 0\">\n                <div>\n                    Delete cluster <b>{{clusterId}}</b> used by :\n                </div>\n                <ul>\n                    <li ng-repeat=\"usage in clusterStatus.usages\">\n                        <div ng-if=\"usage.scenarioId\">\n                            Scenario {{usage.scenarioId}} (project {{usage.scenarioProjectKey}})\n                        </div>\n                        <div ng-if=\"!usage.scenarioId\">\n                            Project {{usage.projectKey}}\n                        </div>\n                    </li>\n                </ul>\n                <div>\n                    <span ng-if=\"clusterStatus.otherProjectUsagesCount > 0 || clusterStatus.otherScenarioUsagesCount > 0\"> + <strong>{{clusterStatus.otherProjectUsagesCount}}</strong> projects and <strong>{{clusterStatus.otherScenarioUsagesCount}}</strong> scenarios</span>\n                </div>\n\n            </div>\n\n            <div ng-if=\"doesntNeedStop()\">Not running/attached at the moment</div>\n            <div ng-if=\"mayNeedStop()\" class=\"alert alert-info\">\n                The cluster is currently running/attached.\n                <br />\n                <label>\n                    <input type=\"checkbox\" ng-model=\"uiState.stop\" />\n                    Stop/detach cluster\n                </label>\n            </div>\n            \n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"submit\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"delete()\">Delete</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/clusters/fragments/container-cluster-settings-block.html", "<form class=\"dkuform-horizontal\">\n    <div class=\"section\" ng-if=\"mask\">\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override global settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.enabled\">\n                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for everything related to containerized execution</span>\n                </label>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"section\" ng-if=\"(!mask || mask.enabled)\">\n        <h2 id=\"configs\">Containerized execution configs</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override execution configs</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.properties\">\n                    <span class=\"help-inline\">Override this to define additional properties and/or execution configurations</span>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"!mask || mask.properties\">\n            <div ng-if=\"mask.properties\" style=\"margin-bottom: 20px\">\n                <h3>Overrides to all configurations</h3>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Base image</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.baseImage\"/>\n                        <span class=\"help-inline\">\n                            Leave empty to use the default image (see doc. for more information about base images)\n                        </span>\n                    </div>\n                </div>\n                <div ng-show=\"isBaseImageNameSuspicious(settings.executionConfigsGenericOverrides.baseImage)\" class=\"alert alert-warning\">\n                    <strong><i class=\"icon-warning-sign\"></i> It looks like this base image contains a repository URL.</strong> <br />\n                        Make sure to input only the base image's name in this field. The URL goes into the next field (Image registry URL).\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Image registry URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.repositoryURL\"/>\n                        <span class=\"help-inline\">\n                            Base URL of the image registry, in the form host/root. See doc. for more information.\n                        </span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Image registry pull secret name</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.imagePullSecretName\"/>\n                        <span class=\"help-inline\">\n                            Optional: The secret name is used in the Kubernetes imagePullSecrets manifest section. This is required if your container registry is private and your cluster needs to authenticate to it for pulling images.\n                        </span>\n                    </div>\n                </div>\n\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Image pre-push hook</label>\n                    <div class=\"controls\">\n                        <select dku-bs-select ng-model=\"settings.executionConfigsGenericOverrides.prePushMode\" \n                        ng-options=\"x[0] as x[1] for x in [['NONE', 'None'], ['ECR', 'Enable push to ECR'], ['ACR', 'Enable push to ACR'], ['CUSTOM', 'Custom script']]\" />\n                        <span class=\"help-inline\">\n                            Action to run before pushing an image.\n                            This is usually only required for running on Amazon EKS or Azure AKS\n                        </span>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-if=\"settings.executionConfigsGenericOverrides.prePushMode == 'CUSTOM'\">\n                    <label class=\"control-label\">Script</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.prePushScript\"/>\n                        <span class=\"help-inline\">\n                            Absolute path to a shell script. Receives the repository url, image name &amp; tag as arguments.\n                            This script should support being called on an already-existing image/tag.\n                        </span>\n                    </div>\n                </div>\n\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Kubernetes Namespace</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.kubernetesNamespace\"/>\n                        <span class=\"help-inline\">Kubernetes namespace to use. Variable expansion is supported. Empty = use cluster default</span>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-if=\"settings.executionConfigsGenericOverrides.kubernetesNamespace.indexOf('${') >= 0\"> <!-- only useful when there are variables in the namespace name -->\n                    <label for=\"\" class=\"control-label\">Make K8S-compliant</label>\n                    <div class=\"controls\">\n                        <label>\n                        <input type=\"checkbox\" ng-model=\"settings.executionConfigsGenericOverrides.ensureNamespaceCompliance\" />\n                        <span class=\"help-inline\">\n                            Automatically adjust namespace name to ensure it is compatible with the RFC1123 sub-domain syntax enforced by Kubernetes\n                        </span>\n                        </label>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"\" class=\"control-label\">Auto-create namespace</label>\n                    <div class=\"controls\">\n                        <label>\n                        <input type=\"checkbox\" ng-model=\"settings.executionConfigsGenericOverrides.createNamespace\" />\n                        <span class=\"help-inline\">\n                            Automatically create the namespace if it doesn't already exist.\n                        </span>\n                        </label>\n                    </div>\n                </div>\n\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Kubectl Context</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.kubeCtlContext\"/>\n                        <span class=\"help-inline\">kubectl context to use (empty = use default)</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Kube config path</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.executionConfigsGenericOverrides.kubeConfigPath\"/>\n                        <span class=\"help-inline\">Path to the config file for Kubectl, if not default</span>\n                    </div>\n                </div>\n\n                 <div class=\"control-group\">\n                    <label class=\"control-label\">Custom properties</label>\n                    <div class=\"controls\">\n                        <ng2-key-values-list \n                            [(items)]=\"settings.executionConfigsGenericOverrides.properties\"\n                            key-placeholder=\"Property key\"\n                            value-placeholder=\"Property value\"\n                            add-label=\"Add Custom Property\">\n                        </ng2-key-values-list>\n                        <span class=\"help-inline\">Additional properties about this container config, for use by DSS. For specific use cases.</span>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-if=\"mask.properties\">\n                <h3>Per-configuration overrides</h3>\n            </div>\n\n            <div add-remove ng-model=\"settings.executionConfigs\">\n                <div ng-repeat=\"execConfig in settings.executionConfigs\" class=\"repeatable-config-block\">      \n                    <div class=\"pull-right btn-group\">\n                        <button class=\"btn btn--success\" ng-click=\"testConf(execConfig, clusterId)\" >\n                            Test\n                        </button>\n                        <button class=\"btn btn--success btn--icon\" data-toggle=\"dropdown\" ng-if=\"getExtraClusters().length > 0 && execConfig.type == 'KUBERNETES'\">\n                            <i class=\"icon-caret-down\" />\n                        </button>\n                        <ul class=\"dropdown-menu pull-right\" ng-if=\"getExtraClusters().length > 0 && execConfig.type == 'KUBERNETES'\">\n                            <li ng-repeat=\"k8sCluster in getExtraClusters()\">\n                                <a ng-click=\"testConf(execConfig, k8sCluster.id)\">\n                                    Test on {{k8sCluster.name}}\n                                </a>\n                            </li>\n                        </ul>\n                        <button type=\"button\" class=\"btn btn--danger\" ng-click=\"remove($index)\" style=\"margin-left: 16px\">\n                            Remove\n                        </button>\n                    </div>\n\n                    <div ng-if=\"getTestError(execConfig)\" api-error-alert=\"getTestError(execConfig)\" />\n\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Configuration name</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.name\"/>\n                            <span class=\"help-inline\">\n                                NB: renaming or removing configurations could cause trouble.\n                            </span>\n                        </div>\n                    </div>\n\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Container engine</label>\n                        <div class=\"controls\">\n                            <select dku-bs-select ng-model=\"execConfig.type\" ng-options=\"x[0] as x[1] for x in [['KUBERNETES', 'Kubernetes'], ['DOCKER', 'Docker']]\" />\n                        </div>\n                    </div>\n\n                    <h3>Settings</h3>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Image registry URL</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.repositoryURL\"/>\n                            <span class=\"help-inline\">\n                                Base URL of the image registry, in the form host/root. See doc. for more information.\n                                <span ng-if=\"execConfig.type == 'DOCKER'\">Generally not required when using Docker</span>\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Image registry pull secret name</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.imagePullSecretName\"/>\n                            <span class=\"help-inline\">\n                            Optional: The secret name is used in the Kubernetes imagePullSecrets manifest section. This is required if your container registry is private and your cluster needs to authenticate to it for pulling images.\n                        </span>\n                        </div>\n                    </div>\n\n                    <div class=\"control-group\" ng-if=\"execConfig.repositoryURL\">\n                        <label class=\"control-label\">Image pre-push hook</label>\n                        <div class=\"controls\">\n                            <select dku-bs-select ng-model=\"execConfig.prePushMode\" \n                            ng-options=\"x[0] as x[1] for x in [['NONE', 'None'], ['ECR', 'Enable push to ECR'], ['ACR', 'Enable push to ACR'], ['CUSTOM', 'Custom script']]\" />\n                            <span class=\"help-inline\">\n                                Action to run before pushing an image.\n                                This is usually only required for running on Amazon EKS or Azure AKS\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"execConfig.prePushMode == 'CUSTOM'\">\n                        <label class=\"control-label\">Script</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.prePushScript\"/>\n                            <span class=\"help-inline\">\n                                Absolute path to a shell script. Receives the repository url, image name &amp; tag as arguments.\n                                This script should support being called on an already-existing image/tag.\n                            </span>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"execConfig.type == 'DOCKER'\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Docker host</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.dockerHost\"/>\n                                <span class=\"help-inline\">\n                                    Leave empty to use the default docker host specified by your environment (generally the local Docker env)\n                                </span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Docker network</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.dockerNetwork\"/>\n                                <span class=\"help-inline\">E.g. 'host', 'bridge' (or empty), or user-defined network</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Docker runtime</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.dockerRuntime\"/>\n                                <span class=\"help-inline\">Leave empty to use the default runtime. Use 'nvidia' for GPU-enabled containers</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Docker GPUs</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.dockerGpus\"/>\n                                <span class=\"help-inline\">\n                                    GPUs to expose to the containers.\n                                    E.g. 'all' to expose all GPUs, '\"device=0,2\"' for GPUs 0 and 2, leave empty for no GPU\n                                </span>\n                            </div>\n                        </div>\n                        <h3>Authentication</h3>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Enable TLS</label>\n                            <div class=\"controls\">\n                                <input type=\"checkbox\" ng-model=\"execConfig.dockerTLSVerify\"/>\n                                <span class=\"help-inline\">Secure Docker communications using TLS certificates</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"execConfig.dockerTLSVerify\">\n                            <label class=\"control-label\">Certificates path</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.dockerCertPath\"/>\n                                <span class=\"help-inline\">Leave empty to use the default path.</span>\n                            </div>\n                        </div>\n                    </div>\n                    <div ng-if=\"execConfig.type == 'KUBERNETES'\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Kubernetes Namespace</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.kubernetesNamespace\"/>\n                                <span class=\"help-inline\">Kubernetes namespace to use. Variable expansion is supported. Empty = use cluster default</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"execConfig.kubernetesNamespace.indexOf('${') >= 0\"> <!-- only useful when there are variables in the namespace name -->\n                            <label for=\"\" class=\"control-label\">Make K8S-compliant</label>\n                            <div class=\"controls\">\n                                <label>\n                                <input type=\"checkbox\" ng-model=\"execConfig.ensureNamespaceCompliance\" />\n                                <span class=\"help-inline\">\n                                    Automatically adjust namespace name to ensure it is compatible with the RFC1123 sub-domain syntax enforced by Kubernetes\n                                </span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Auto-create namespace</label>\n                            <div class=\"controls\">\n                                <label>\n                                <input type=\"checkbox\" ng-model=\"execConfig.createNamespace\" />\n                                <span class=\"help-inline\">\n                                    Automatically create the namespace if it doesn't already exist.\n                                </span>\n                                </label>\n                            </div>\n                        </div>\n                    </div>\n                    <h3>Permissions</h3>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Usable by</label>\n                        <div class=\"controls\">\n                            <label>\n                                <input type=\"radio\" ng-model=\"execConfig.usableBy\" value=\"ALL\"/>\n                                Everyone\n                            </label>\n                            <label>\n                                <input type=\"radio\" ng-model=\"execConfig.usableBy\" value=\"ALLOWED\"/>\n                                Selected groups\n                            </label>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"execConfig.usableBy=='ALLOWED'\">\n                        <label class=\"control-label\">&#8627; usable by groups</label>\n                        <div class=\"controls\">\n                            <select dku-bs-select multiple=\"multiple\" ng-model=\"execConfig.allowedGroups\" ng-options=\"g for g in allGroups\" class=\"exclude-from-smart-change\"></select>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"appConfig.cdeEnabled\">\n                        <label class=\"control-label\">Workload type</label>\n                        <div class=\"controls\">\n                            <select dku-bs-select ng-model=\"execConfig.workloadType\" \n                            ng-options=\"x[0] as x[1] for x in [['ANY', 'Any type of workload'], ['USER_CODE', 'User code (Python, R, ...)'], ['VISUAL_RECIPES', 'Visual recipes']]\" />\n                        </div>\n                    </div>\n                    <div ng-if=\"execConfig.type == 'DOCKER' && !mask\">\n                        <h3>Resources for Docker containers</h3>\n                        <span class=\"help-inline\" style=\"padding: 0\">\n                            These settings control CPU and memory limits that are set on each container.\n                            It is recommended to be familiar with\n                            <a href=\"https://docs.docker.com/config/containers/resource_constraints/\"\n                               target=\"_blank\" rel=\"noopener noreferrer\">Docker resource constraints</a>\n                            and cgroups to use this.\n                        </span>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Limits</label>\n                            <div class=\"controls\">\n                                <ng2-key-values-list \n                                    [(items)]=\"execConfig.dockerResources\" \n                                    key-placeholder=\"Limit key\"\n                                    value-placeholder=\"Limit value\"\n                                    add-label=\"Add Limit\">\n                                </ng2-key-values-list>\n                                <span class=\"help-inline\">Custom Docker resource limits key-value. E.g. <code>memory</code> = <code>2000m</code> or <code>cpus</code> = <code>1.5</code>.</span>\n                            </div>\n                        </div>\n                    </div>\n                    <div ng-if=\"execConfig.type == 'KUBERNETES' && !mask\">\n                        <h3>Resources for Kubernetes containers</h3>\n                        <p>\n                            These settings control CPU and memory limits that are set on each container.<br />\n                            It is recommended to be familiar with\n                            <a href=\"https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/\"\n                               target=\"_blank\" rel=\"noopener noreferrer\">Kubernetes \"request\" and \"limit\" parameters</a> to use this.\n                        </p>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Memory request</label>\n                            <div class=\"controls\">\n                                <input type=\"number\" force-integer ng-model=\"execConfig.kubernetesResources.memRequestMB\"  />\n                                <span class=\"help-inline\">Memory request for containers in MB. -1 = default (inherit namespace settings)</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Memory limit</label>\n                            <div class=\"controls\">\n                                <input type=\"number\" force-integer ng-model=\"execConfig.kubernetesResources.memLimitMB\"  />\n                                <span class=\"help-inline\">Memory limit for containers in MB. -1 = default (inherit namespace settings)</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">CPU request</label>\n                            <div class=\"controls\">\n                                <input type=\"number\" ng-model=\"execConfig.kubernetesResources.cpuRequest\" />\n                                <span class=\"help-inline\">CPU request for containers (0.5 = 50% of a core, 2 = 2 cores).  -1 = default (inherit namespace settings)</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">CPU limit</label>\n                            <div class=\"controls\">\n                                <input type=\"number\" ng-model=\"execConfig.kubernetesResources.cpuLimit\" />\n                                <span class=\"help-inline\">CPU limit for containers (0.5 = 50% of a core, 2 = 2 cores). -1 = default (inherit namespace settings)</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Custom requests</label>\n                            <div class=\"controls\">\n                                <ng2-key-values-list \n                                    [(items)]=\"execConfig.kubernetesResources.customRequests\" \n                                    key-placeholder=\"Request key\"\n                                    value-placeholder=\"Request value\"\n                                    add-label=\"Add Custom Request\">\n                                </ng2-key-values-list>\n                                <span class=\"help-inline\">Custom Kubernetes requests key-value.</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Custom limits</label>\n                            <div class=\"controls\">\n                                <ng2-key-values-list \n                                    [(items)]=\"execConfig.kubernetesResources.customLimits\" \n                                    key-placeholder=\"Limit key\"\n                                    value-placeholder=\"Limit value\"\n                                    add-label=\"Add Custom Limit\">\n                                </ng2-key-values-list>\n                                <span class=\"help-inline\">Custom Kubernetes limits key-value. For example, on Google Kubernetes Engine, use <code>nvidia.com/gpu</code> = <code>1</code> to get a GPU node</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Node selector</label>\n                            <div class=\"controls\">\n                                <!-- <div class=\"codemirror\" style=\"height: 30px\"> -->\n                                    <textarea style=\"width: 700px\" ng-model=\"execConfig.nodeSelector\" zui-codemirror=\"codeMirrorSettingService.get('text/yaml')\" placeholder=\"Optional nodeSelector YAML specification. Must start with 'nodeSelector:' followed by 2-space indented Kubernetes NodeSelector specification\" />\n                                <!-- </div> -->\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Affinity</label>\n                            <div class=\"controls\">\n                                <!-- <div class=\"codemirror\" style=\"height: 30px\"> -->\n                                    <textarea style=\"width: 700px\" ng-model=\"execConfig.affinity\" zui-codemirror=\"codeMirrorSettingService.get('text/yaml')\" placeholder=\"Optional pod affinity YAML specification. Must start with 'affinity:' followed by 2-space indented Kubernetes pod affinity specification\" />\n                                <!-- </div> -->\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Tolerations</label>\n                            <div class=\"controls\">\n                                <!-- <div class=\"codemirror\" style=\"height: 30px\"> -->\n                                    <textarea style=\"width: 700px\" ng-model=\"execConfig.tolerations\" zui-codemirror=\"codeMirrorSettingService.get('text/yaml')\" placeholder=\"Optional pod tolerations YAML specification. Must start with 'tolerations:' followed by 2-space indented Kubernetes pod affinity specification\" />\n                                <!-- </div> -->\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Topology spread constraints</label>\n                            <div class=\"controls\">\n                                <!-- <div class=\"codemirror\" style=\"height: 30px\"> -->\n                                    <textarea style=\"width: 700px\" ng-model=\"execConfig.deploymentTopologySpreadConstraints\" zui-codemirror=\"codeMirrorSettingService.get('text/yaml')\" placeholder=\"Optional topology spread constraints YAML specification. Must start with 'topologySpreadConstraints:' followed by 2-space indented Kubernetes pod topology spread constraint specification\" />\n                                <!-- </div> -->\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">HostPath volumes</label>\n                            <div class=\"controls\">\n\n                                <ng2-key-values-list \n                                    [(items)]=\"execConfig.hostPathVolumes\" \n                                    key-placeholder=\"Host path\"\n                                    value-placeholder=\"Container path\"\n                                    add-label=\"Add HostPath volumes\">\n                                </ng2-key-values-list>\n                                <span class=\"help-inline\">Additional \"hostPath\" type volumes to mount in containers. This is usually only required for GPU support on Azure Kubernetes Service\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Increase shared memory size</label>\n                            <div class=\"controls\">\n                                <input type=\"checkbox\" ng-model=\"execConfig.enableCustomSHM\"/>\n                                <span class=\"help-inline\">Recommended for running torch workloads (e.g. LLM inference), otherwise defaults to 64MB</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"execConfig.enableCustomSHM\">\n                            <label class=\"control-label\">Shared memory size</label>\n                            <div class=\"controls\">\n                                <input type=\"number\" force-integer ng-model=\"execConfig.customSHMValueMB\"/>\n                                <span class=\"help-inline\">Shared memory limit of the container in MB. -1 = default (1/2 of node's memory)</span>\n                            </div>\n                        </div>\n\n                    </div>\n                    \n                    <h3>Advanced settings</h3>\n\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Base image for User Code</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.baseImage\"/>\n                            <span class=\"help-inline\">\n                                Used for User Code workload type. Leave empty to use the default image (see doc. for more information about base images)\n                            </span>\n                        </div>\n                    </div>\n                    <div ng-show=\"isBaseImageNameSuspicious(execConfig.baseImage)\" class=\"alert alert-warning\">\n                        <strong><i class=\"icon-warning-sign\"></i> It looks like this base image contains a repository URL.</strong> <br />\n                        Make sure to input only the base image's name in this field. The repository is specified above in the \"Image registry URL\" setting.\n                    </div>\n                    <div ng-if=\"execConfig.type == 'KUBERNETES'\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Kubectl Context</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.kubeCtlContext\"/>\n                                <span class=\"help-inline\">kubectl context to use (empty = use default). This will not be taken into account if using dynamic K8S clusters</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Kube config path</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"execConfig.kubeConfigPath\"/>\n                                <span class=\"help-inline\">Path to the config file for Kubectl (empty = use default). This will not be taken into account if using dynamic K8S clusters</span>\n                            </div>\n                        </div>\n                    </div>\n\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Custom properties</label>\n                        <div class=\"controls\">\n                            <ng2-key-values-list \n                                [(items)]=\"execConfig.properties\"\n                                key-placeholder=\"Property key\"\n                                value-placeholder=\"Property value\"\n                                add-label=\"Add Custom Property\">\n                            </ng2-key-values-list>\n                            <span class=\"help-inline\">Additional properties about this container config, for use by DSS. For specific use cases.</span>\n                        </div>\n                    </div>\n                 </div>\n\n                <button type=\"button\" class=\"btn btn--primary btn--text\" ng-click=\"add(getNewContainerConfig())\" style=\"margin-top: 10px;\">\n                    <i plus-icon />  Add another config\n                </button>\n            </div>\n\n        </div>\n    </div>\n    <div class=\"section\" ng-if=\"(!mask || mask.enabled)\">\n        <h2 id=\"default-exposition-for-kubenetes-webapps\">Default exposition for Kubernetes webapps</h2>\n\n        <div ng-class=\"{'alert': true, 'alert-info': settings.defaultWebappsK8SExposition.type == 'port_forward', 'alert-warning': settings.defaultWebappsK8SExposition.type != 'port_forward'}\">\n             Port-forwarding exposition provides the best setup and reliability for webapps. It allows secure webapps which are usually not possible with other modes.<br />\n             Dataiku does not recommend moving away from Port-forwarding\n        </div>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override expositions</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.defaultWebappsK8SExposition\">\n                    <span class=\"help-inline\">Override this to override the default exposition for webapps running on Kubernetes</span>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"!mask || mask.defaultWebappsK8SExposition\">\n            <div service-exposition=\"settings.defaultWebappsK8SExposition\" exposition-usage-context=\"'WEBAPP'\" container-type=\"'KUBERNETES'\" exposable-kind=\"'WEBAPP'\"></div>\n        </div>\n    </div>\n</form>\n");
$templateCache.put("/templates/admin/clusters/fragments/hadoop-cluster-settings-block.html", "\n\n<form class=\"dkuform-horizontal\">\n    \n    <div ng-if=\"!mask\" class=\"section\">\n\t\t<h2 id=\"security\">Hadoop security (Kerberos)</h2>\n\n    \t<div class=\"alert alert-warning\">A modification of these settings requires a DSS restart</div>\n\n        <div class=\"control-group\" ng-if=\"!mask\" ng-class=\"{'disabled-params' : mask && (!mask.kerberosAuth)}\">\n            <label class=\"control-label\">Enable</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.kerberosLoginEnabled\"/>\n                <span class=\"help-inline\">Should DSS log itself on Kerberos</span>\n            </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"!mask\" ng-class=\"{'disabled-params' : mask && (!mask.kerberosAuth)}\">\n            <label class=\"control-label\">Principal</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"settings.dssPrincipal\"/>\n                <span class=\"help-inline\">Principal for the DSS user</span>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"!mask\" ng-class=\"{'disabled-params' : mask && (!mask.kerberosAuth)}\">\n            <label class=\"control-label\">Keytab</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"settings.dssKeytabPath\"/>\n                <span class=\"help-inline\">Absolute path to the keytab to use for DSS</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"section\">\n        <h2 id=\"config-keys\">Hadoop config keys</h2>\n    \t<div class=\"control-group\" ng-if=\"mask\">\n\t        <label class=\"control-label\">Override global settings</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"mask.properties\">\n\t                <span class=\"help-inline\">If disabled, this cluster will use globally-defined Hadoop configuration keys. It is generally always required to override this\n\t            </label>\n\t        </div>\n\t    </div>\n\n\t    <div class=\"control-group\" ng-if=\"!mask || mask.properties\">\n\t\t\t<ng2-credentials-list \n\t\t\t\t[(items)]=\"settings.extraConf\"\n\t\t\t\tkey-placeholder=\"Configuration key\"\n\t\t\t\tvalue-placeholder=\"Configuration value\"\n\t\t\t\tadd-label=\"Add configuration\">\n\t\t\t</ng2-credentials-list>\n\t    </div>\n    </div>\n\n     <div class=\"section\">\n        <h2 id=\"validation-kernel\">Pig/Hive validation kernel</h2>\n\n\t    <div class=\"alert alert-info\">Extra environment variables passed to the process dedicated to validating Pig and Hive queries</div>\n    \n\t    <div class=\"control-group\" ng-if=\"mask\">\n\t        <label class=\"control-label\">Override</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"mask.validationKernelsExtraEnv\">\n\t                <span class=\"help-inline\">Advanced usage</span>\n\t            </label>\n\t        </div>\n\t    </div>\n\n\t    <div class=\"control-group\" ng-if=\"!mask || mask.validationKernelsExtraEnv\">\n\t\t\t<ng2-credentials-list \n\t\t\t\t[(items)]=\"settings.validationKernelsExtraEnv\"\n\t\t\t\tkey-placeholder=\"Variable key\"\n\t\t\t\tvalue-placeholder=\"Variable value\"\n\t\t\t\tadd-label=\"Add environment variable\">\n\t\t\t</ng2-credentials-list>\n\t    </div>\n\t</div>\n</form>\n\n");
$templateCache.put("/templates/admin/clusters/fragments/hive-cluster-settings-block.html", "<form class=\"dkuform-horizontal\">\n\t<div class=\"section\" ng-if=\"mask\">\n\t    <div class=\"control-group\" ng-if=\"mask\">\n\t        <label class=\"control-label\">Override global settings</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"mask.enabled\">\n\t                <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for everything related to Hive</span>\n\t            </label>\n\t        </div>\n\t    </div>\n    </div>\n\n\t<div class=\"section\" ng-if=\"!mask || mask.enabled\">\n\t\t<div class=\"control-group\" ng-if=\"!mask || mask.enabled\">\n\t\t    <label class=\"control-label\">Enable Hive</label>\n\t\t    <div class=\"controls\">\n\t\t        <label>\n\t\t            <input type=\"checkbox\" ng-model=\"settings.enabled\"/>\n\t                <span class=\"help-inline\">Enable support of Hive {{mask ? 'for this cluster' : ''}}</span>\n\t\t        </label>\n\t\t    </div>\n\t\t</div>\n\t</div>\n\n    <div ng-if=\"(!mask || mask.enabled) && settings.enabled\">\n    \t<div class=\"section\">\n        <h2 id=\"hiveserver2\">HiveServer2</h2>\n\n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override connection settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.jdbc\">\n                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined HiveServer2 connection settings</span>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"!mask || mask.jdbc\">\n\n            <div class=\"control-group\">\n                <label for=\"hiveUseURLcheckbox\" class=\"control-label\">Use advanced URL syntax</label>\n                <div class=\"controls\">\n                    <input id=\"hiveUseURLcheckbox\" type=\"checkbox\" ng-model=\"settings.useURL\"/>\n                </div>\n            </div>\n            <div ng-show=\"settings.useURL != true\">\n                <div class=\"control-group\">\n                    <label for=\"hiveserver2Host\" class=\"control-label\">Host</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" id=\"hiveserver2Host\" ng-model=\"settings.hiveServer2Host\"/>\n                        <span class=\"help-inline\">HiveServer2 host</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"hiveserver2Port\" class=\"control-label\">Port</label>\n                    <div class=\"controls\">\n                        <input type=\"number\" id=\"hiveserver2Port\" min=\"0\" max=\"65535\" step=\"1\" ng-model=\"settings.hiveServer2Port\"/>\n                        <span class=\"help-inline\">HiveServer2 port</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"hivePrincipal\" class=\"control-label\">Principal</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" id=\"hivePrincipal\" ng-model=\"settings.hiveServer2Principal\"/>\n                        <span class=\"help-inline\">Kerberos principal of the HiveServer2</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"extraUrl\" class=\"control-label\">Extra URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" id=\"extraUrl\" ng-model=\"settings.extraUrl\"/>\n                        <span class=\"help-inline\">Appended to the JDBC URL after the jdbc:hive2://host:port/db</span>\n                    </div>\n                </div>\n            </div>\n            <div ng-show=\"settings.useURL == true\">\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Driver class</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.driver\"/>\n                        <span class=\"help-inline\">Default: org.apache.hive.jdbc.HiveDriver</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Connection URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.url\" ng-if=\"!appConfig.hiveUrlContainsSecret\" />\n                        <input type=\"password\" ng-model=\"settings.url\" ng-if=\"appConfig.hiveUrlContainsSecret\" />\n                        <span class=\"help-inline\">Mandatory</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Displayed connection URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.displayedUrl\"/>\n                        <span class=\"help-inline\">Shown in logs instead of connection URL if present. Useful to hide passwords</span>\n                    </div>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label  class=\"control-label\">Connection properties</label>\n                <div class=\"controls\">\n                    <ng2-credentials-list \n                        [(items)]=\"settings.connectionProperties\"\n                        key-placeholder=\"Configuration key\"\n                        value-placeholder=\"Configuration value\"\n                        add-label=\"Add configuration\">\n                    </ng2-credentials-list>\n                </div>\n            </div>\n        </div>\n\n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override charts settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.canChart\">\n                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for charts on HiveServer2</span>\n                </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.canChart\">\n            <label class=\"control-label\">Use HiveServer2 for charts</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"settings.canChart\"/>\n                    <span class=\"help-inline\">Charts can be done using Hive if Impala is not available.</span>\n                </label>\n            </div>\n        </div>\n        </div>\n\n\n        <div class=\"section\">\n            <h2 id=\"recipes\">Hive recipes</h2>\n\n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override creation settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.engineCreationSettings\">\n                    <span class=\"help-inline\">\n                        If disabled, this cluster will use globally-defined settings for Hive recipe creation settings\n                    </span>\n                </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.engineCreationSettings\">\n            <label class=\"control-label\">Default execution engine</label>\n            <div class=\"controls\">\n                <select dku-bs-select ng-model=\"settings.engineCreationSettings.executionEngine\">\n                    <option value=\"HIVECLI_LOCAL\">(Deprecated) Hive CLI (Isolated metastore)</option>\n                    <option value=\"HIVECLI_GLOBAL\">(Deprecated) Hive CLI (Global metastore)</option>\n                    <option value=\"HIVESERVER2\">HiveServer2</option>\n                </select>\n                <span class=\"help-inline\">Default value for new Hive recipes</span>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"mask && impersonationEnabled\">\n            <label class=\"control-label\">Override 'Hive user'</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.additionalUserToGrantAccessToWhenImpersonating\">\n                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined setting for 'which user runs Hive'</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"impersonationEnabled && (!mask || mask.additionalUserToGrantAccessToWhenImpersonating)\">\n            <label class=\"control-label\">Hive user</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"settings.additionalUserToGrantAccessToWhenImpersonating\"/>\n                <span class=\"help-inline\">In impersonation mode, DSS needs to grant access to this user</span>\n            </div>\n        </div>\n    \n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override 'Force database'</label>\n             <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"mask.overrideDatabaseInLocalMetastore\">\n                    <span class=\"help-inline\">Advanced usage</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"!mask || mask.overrideDatabaseInLocalMetastore\">\n            <label class=\"control-label\">Force database</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.overrideDatabaseInLocalMetastore\"/>\n                <span class=\"help-inline\">Should DSS override the Hive database to 'dataiku' whenever using the isolated metastore mode and validating</span>\n            </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"mask && impersonationEnabled\">\n            <label class=\"control-label\">Override 'Write ACL'</label>\n             <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"mask.addWriteACLOnDataUsabilityACL\">\n                    <span class=\"help-inline\">Advanced usage</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"impersonationEnabled && (!mask || mask.addWriteACLOnDataUsabilityACL)\">\n            <label class=\"control-label\">Write ACL in datasets</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.addWriteACLOnDataUsabilityACL\"/>\n                <span class=\"help-inline\">Add write ACL to Hive on managed datasets? Required if Storage-based authorization is enabled in Hive metastore</span>\n            </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"mask && !impersonationEnabled\">\n            <label class=\"control-label\">Override 'pre-create managed'</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes\">\n                    <span class=\"help-inline\">Advanced usages</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"!impersonationEnabled && (!mask || mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes)\">\n            <label class=\"control-label\">Pre-create folder for HS2 recipes</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes\"/>\n                <span class=\"help-inline\">When running a recipe through a non-impersonating HiveServer2, should DSS create the folder before doing the synchronization? Must be disabled for \"inherit permissions mode\". See documentation for more info.</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"mask && impersonationEnabled\">\n            <label class=\"control-label\">Override 'pre-create managed'</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes\">\n                    <span class=\"help-inline\">Advanced usages</span>\n                </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"impersonationEnabled && (!mask || mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes)\">\n            <label class=\"control-label\">Pre-create folder for HS2 recipes</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes\"/>\n                <span class=\"help-inline\">When running a recipe through a impersonating HiveServer2, should DSS create the folder before doing the synchronization? See documentation for more info.</span>\n                </label>\n            </div>\n        </div>\n        </div>\n\n        <div class=\"section\">\n            <h2 id=\"query-alterations\">Query alterations</h2>\n\n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override global settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.queryAlterations\">\n                    <span class=\"help-inline\">\n                        Advanced usage\n                    </span>\n                </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.queryAlterations\">\n            <label class=\"control-label\">Add compression commands</label>\n            <div class=\"controls\">\n                <label>\n                <input type=\"checkbox\" ng-model=\"settings.addCompressionCommands\"/>\n                <span class=\"help-inline\">Should DSS add 'SET ...' commands to Hive jobs in order to set the output's compression? (Snappy, Deflate, ...)</span>\n            </label>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"$root.isDSSAdmin() && (!mask || mask.queryAlterations)\">\n            <label class=\"control-label\">Auxiliary jars and UDFs</label>\n            <div class=\"controls\">\n                <textarea ng-model=\"settings.auxJarsAndUdfs\"\n                        ui-codemirror=\"codeMirrorSettingService.get('text/x-sql')\">\n                </textarea>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"$root.isDSSAdmin() && (!mask || mask.queryAlterations)\">\n            <label class=\"control-label\">Run before table creation scripts</label>\n            <div class=\"controls\">\n                <span class=\"help-inline\">Commands to run before creating tables in DSS-produced Hive scripts</span>\n                <textarea ng-model=\"settings.initQueryPreStatements\"\n                        ui-codemirror=\"codeMirrorSettingService.get('text/x-sql')\">\n                </textarea>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"$root.isDSSAdmin() && (!mask || mask.queryAlterations)\">\n            <label class=\"control-label\">Run after table creation scripts</label>\n            <div class=\"controls\">\n                <span class=\"help-inline\">Commands to run after creating tables in DSS-produced Hive scripts</span>\n                <textarea ng-model=\"settings.initQueryPostStatements\"\n                        ui-codemirror=\"codeMirrorSettingService.get('text/x-sql')\">\n                </textarea>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"$root.isDSSAdmin() && (!mask || mask.queryAlterations)\">\n            <label class=\"control-label\">Aux. jars for validation</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"settings.hiveAdditionalJars\"/>\n                <span class=\"help-inline\">Additional jars to use when validating Hive recipes (colon-separated list)</span>\n            </div>\n        </div>\n\n        </div>\n\n        <div class=\"section\">\n            <h2 id=\"runtime-configurations\">Hive runtime configurations</h2>\n\n\t        <div ng-if=\"mask\" class=\"control-group\">\n\t            <label class=\"control-label\">Override</label>\n\t            <div class=\"controls\">\n\t                <label>\n\t                    <input type=\"checkbox\" ng-model=\"mask.properties\">\n\t                    <span/>\n\t                </label>\n\t            </div>\n\t        </div>\n\n        <div ng-if=\"!mask || mask.properties\">\n            <div ng-if=\"mask\" style=\"margin-bottom: 20px\">\n                <h3>Config keys added to all configurations <button type=\"button\" ng-if=\"hadoopSettings\" class=\"btn btn--secondary pull-right\" ng-click=\"copyHadoopSettings()\">Copy Hadoop settings</button></h3>\n                <ng2-credentials-list \n                    [(items)]=\"settings.executionConfigsGenericOverrides\"\n                    key-placeholder=\"Configuration key\"\n                    value-placeholder=\"Configuration value\"\n                    add-label=\"Add configuration\">\n                </ng2-credentials-list>\n            </div>\n            <div ng-if=\"mask\">\n                <h3>Per-configuration overrides</h3>\n            </div>\n            <div add-remove ng-model=\"settings.executionConfigs\" ng-init=\"preAddConfig = false\">\n\n                <div ng-repeat=\"execConfig in settings.executionConfigs\" class=\"repeatable-config-block\" >\n\n                    <button type=\"button\" class=\"pull-right btn btn--danger\" style=\"margin: 10px\" ng-click=\"remove($index)\">\n                        Remove\n                    </button>\n                    <h3>Basic</h3>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Config name</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.name\" />\n                            <div class=\"help-inline\">\n                                NB: Make sure a named configuration is not used before removing or renaming it.\n                            </div>\n                        </div>\n                    </div>\n                    <div ng-if=\"mask && execConfig.name && execConfig.name.length > 0 && appConfig.hiveExecutionConfigs.indexOf(execConfig.name) < 0\" class=\"alert alert-warning\">\n                        <p>No runtime configuration named <em>{{execConfig.name}}</em> exists at the instance level.</p>\n                        <p>Runtime configurations defined at the cluster level are only overrides of configurations defined in <a href=\"{{$state.href('admin.general')}}\">Administration</a></p>\n                    </div>\n                    <h3>Config keys</h3>\n                    <small>\n                        Define here Hive configuration keys.\n                    </small>\n                    <ng2-credentials-list \n                        [(items)]=\"execConfig.conf\"\n                        key-placeholder=\"Hive configuration key\"\n                        value-placeholder=\"Hive configuration value\"\n                        add-label=\"Add Hive configuration\">\n                    </ng2-credentials-list>\n                </div>\n\n                <button type=\"button\" class=\"btn btn--text btn--primary\" ng-click=\"preAddConfig = true; add({conf : []})\"><span plus-icon />&nbsp;Add another config</button>\n            </div>\n            </div>\n        </div>\n    </div>\n</form>");
$templateCache.put("/templates/admin/clusters/fragments/impala-cluster-settings-block.html", "<form class=\"dkuform-horizontal\">\n\n\t<div class=\"section\" ng-if=\"mask\">\n\t    <div class=\"control-group\" ng-if=\"mask\">\n\t        <label class=\"control-label\">Override global settings</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"mask.enabled\">\n\t                <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for everything related to Impala</span>\n\t            </label>\n\t        </div>\n\t    </div>\n    </div>\n\n    <div class=\"section\"  ng-if=\"!mask || mask.enabled\">\n\t    <div class=\"control-group\">\n\t        <label class=\"control-label\">Enable Impala</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"settings.enabled\" ng-disabled=\"!appConfig.hadoopEnabled\"/>\n\t                <span ng-show=\"!appConfig.hadoopEnabled\" class=\"text-error\">\n\t                    Hadoop support is not enabled\n\t                </span>\n\t                <span class=\"help-inline\">\n\t                    Enable support of Impala {{mask ? 'for this cluster' : '' }}\n\t                </span>\n\t            </label>\n\t        </div>\n\t    </div>\n\t</div>\n\n    <div ng-if=\"(!mask || mask.enabled) && settings.enabled\">\n    \t<div class=\"section\">\n            <h2 id=\"connection\">Impala connection</h2>\n\n        <div ng-if=\"mask\" class=\"control-group\">\n            <label class=\"control-label\">Override connection settings</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.jdbc\">\n                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined Impalad connection settings</span>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"!mask || mask.jdbc\">\n\n            <div class=\"control-group\">\n                <label for=\"impalaUseURLcheckbox\" class=\"control-label\">Use advanced URL syntax</label>\n                <div class=\"controls\">\n                    <input id=\"impalaUseURLcheckbox\" type=\"checkbox\" ng-model=\"settings.useURL\"/>\n                </div>\n            </div>\n            <div ng-show=\"settings.useURL != true\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Use Cloudera (Simba) driver</label>\n                    <div class=\"controls\">\n                        <input type=\"checkbox\" ng-model=\"settings.useSimbaDriver\"/>\n                        <span class=\"help-inline\">Required for impersonation</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Authentication</label>\n                    <div class=\"controls\">\n                        <select dku-bs-select ng-model=\"settings.authBehavior\">\n                            <option value=\"KERBEROS_FALLBACK_NOAUTH\">Kerberos if available</option>\n                            <option value=\"KERBEROS\">Kerberos</option>\n                            <option value=\"LDAP\">User/password (LDAP)</option>\n                            <option value=\"NOAUTH\">None</option>\n                        </select>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-hide=\"settings.authBehavior != 'LDAP'\">\n                    <label class=\"control-label\">Credentials mode</label>\n                    <div class=\"controls\">\n                        <select ng-model=\"settings.credentialsMode\">\n                            <option value=\"GLOBAL\">Global</option>\n                            <option value=\"PER_USER\">Per user</option>\n                        </select>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-hide=\"settings.authBehavior != 'LDAP' || settings.credentialsMode != 'GLOBAL'\">\n                    <label class=\"control-label\">User</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.user\"/>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-hide=\"settings.authBehavior != 'LDAP' || settings.credentialsMode != 'GLOBAL'\">\n                    <label class=\"control-label\">Password</label>\n                    <div class=\"controls\">\n                        <input type=\"password\" ng-model=\"settings.password\"/>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-hide=\"settings.authBehavior != 'KERBEROS_FALLBACK_NOAUTH' && settings.authBehavior != 'KERBEROS'\">\n                    <label for=\"impaladPrincipal\" class=\"control-label\">Principal</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" id=\"impaladPrincipal\" ng-model=\"settings.principal\"/>\n                        <span class=\"help-inline\">Kerberos principal of the impalad hosts</span>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"useSSLcheckbox\" class=\"control-label\">Use SSL</label>\n                    <div class=\"controls\">\n                        <input id=\"useSSLcheckbox\" type=\"checkbox\" ng-model=\"settings.useSsl\" />\n                    </div>\n                </div>\n                \n                <div ng-show=\"settings.useSsl == true\">\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Truststore path</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"settings.trustStorePath\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Truststore password</label>\n                        <div class=\"controls\">\n                            <input type=\"password\" ng-model=\"settings.trustStorePassword\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\">Self-signed</label>\n                        <div class=\"controls\">\n                            <input type=\"checkbox\" ng-model=\"settings.isSelfSigned\"/>\n                            <span class=\"help-inline\">The certificate can be self-signed</span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"settings.useURL || settings.useSimbaDriver\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <label class=\"control-label\">Driver class</label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"settings.driver\" placeholder=\"com.cloudera.impala.jdbc.Driver\"/>\n                    <span class=\"help-inline\" ng-show=\"!settings.useURL && settings.useSimbaDriver\">Defaults to the class of the JDBC41 Cloudera driver.</span>\n                </div>\n            </div>\n            <div ng-show=\"settings.useURL == true\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Connection URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.url\"/>\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label class=\"control-label\">Displayed connection URL</label>\n                    <div class=\"controls\">\n                        <input type=\"text\" ng-model=\"settings.displayedUrl\"/>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"control-group\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <label  class=\"control-label\">Advanced properties</label>\n                <div class=\"controls\">\n                    <ng2-credentials-list \n                        [(items)]=\"settings.connectionProperties\"\n                        key-placeholder=\"Property key\"\n                        value-placeholder=\"Property value\"\n                        add-label=\"Add property\">\n                    </ng2-credentials-list>\n                </div>\n            </div>\n            \n            <div class=\"control-group\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <label for=\"impaladPort\" class=\"control-label\">Default port</label>\n                <div class=\"controls\">\n                    <input type=\"number\" id=\"impaladPort\" min=\"0\" max=\"65535\" step=\"1\" ng-model=\"settings.port\"/>\n                    <span class=\"help-inline\">Port on which impalad daemons are listening</span>\n                </div>\n            </div>\n\n            <h3 id=\"hosts\">Impala hosts</h3>\n\n            <div add-remove ng-model=\"settings.datanodes\" ng-class=\"{'disabled-params' : mask && (!mask.enabled || !settings.enabled || !mask.jdbc)}\">\n                <div>\n            \t    <small>\n            \t        Leave 0 as port to use the default port\n            \t    </small>\n                </div>\n                <div ng-repeat=\"datanode in settings.datanodes\" >\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\"></label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"datanode.fqn\" />\n                            <input type=\"number\" ng-model=\"datanode.port\" />\n                            <a class=\"\" ng-click=\"remove($index)\">\n                                <i class=\"icon-trash\"></i>\n                            </a>\n                        </div>\n                    </div>\n                </div>\n                <button type=\"button\" class=\"btn btn--success\" ng-click=\"add({fqn : '', port : 0})\">Add another host</button>\n            </div>\n        </div>\n\n    \t</div>\n    \t<div class=\"section\">\n            <h2 id=\"recipes\">Impala recipes</h2>\n\n\t        <div class=\"control-group\" ng-if=\"mask && impersonationEnabled\">\n\t            <label class=\"control-label\">Override 'Impala user'</label>\n\t            <div class=\"controls\">\n\t                <label>\n\t                    <input type=\"checkbox\" ng-model=\"mask.additionalUserToGrantAccessToWhenImpersonating\">\n\t                    <span class=\"help-inline\">Advanced usage</span>\n\t                </label>\n\t            </div>\n\t        </div>\n\t        <div class=\"control-group\" ng-if=\"impersonationEnabled && (!mask || mask.additionalUserToGrantAccessToWhenImpersonating)\">\n\t            <label class=\"control-label\">Impala user</label>\n\t            <div class=\"controls\">\n\t                <input type=\"text\" ng-model=\"settings.additionalUserToGrantAccessToWhenImpersonating\"/>\n\t                <span class=\"help-inline\">In impersonation mode, DSS needs to grant access to this user</span>\n\t            </div>\n\t        </div>\n\t    \n\t        <div class=\"control-group\" ng-if=\"mask && !impersonationEnabled\">\n\t            <label class=\"control-label\">Override 'Pre-create managed'</label>\n\t             <div class=\"controls\">\n\t                <label>\n\t                    <input type=\"checkbox\" ng-model=\"mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes\">\n\t                    <span class=\"help-inline\">Advanced usage</span>\n\t                </label>\n\t            </div>\n\t        </div>\n\t        <div class=\"control-group\" ng-if=\"!impersonationEnabled && (!mask || mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes)\">\n\t            <label class=\"control-label\">Pre-create folder for write</label>\n\t            <div class=\"controls\">\n\t                <label>\n\t                <input type=\"checkbox\" ng-model=\"settings.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes\"/>\n\t                <span class=\"help-inline\">When running a \"write by Impala\" recipe, should DSS create the folder before doing the synchronization? Must be disabled for \"inherit permissions mode\". See documentation for more info.</span>\n\t                </label>\n\t            </div>\n\t        </div>\n\t    \n\t        <div class=\"control-group\" ng-if=\"mask\">\n\t            <label class=\"control-label\">Override creation settings</label>\n\t             <div class=\"controls\">\n\t                <label>\n\t                    <input type=\"checkbox\" ng-model=\"mask.engineCreationSettings\">\n\t                    <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for Impala recipe creation settings</span>\n\t                </label>\n\t            </div>\n\t        </div>\n\t        \n\t        <div class=\"control-group\" ng-if=\"!mask || mask.engineCreationSettings\">\n\t            <label class=\"control-label\">Stream mode</label>\n\t            <div class=\"controls\">\n\t                <input type=\"checkbox\" ng-model=\"settings.engineCreationSettings.streamMode\"/>\n\t                <span class=\"help-inline\">Applied to new Impala recipes. In stream mode, Impala does not write the output directly</span>\n\t            </div>\n\t        </div>\n    \t</div>\n    </div>\n</form>\n");
$templateCache.put("/templates/admin/clusters/fragments/security-permissions.html", "<div class=\"\">\n    <div block-api-error />\n    <div ng-if=\"appConfig.communityEdition\">\n        <div style=\"margin: 3em auto; width: 500px; text-align: center\">\n            <h4 class=\"ce-unavail\">\n                Collaborative features are not available in\n                <br />\n                Dataiku DSS Free Edition\n            </h4>\n        </div>\n    </div>\n    <div ng-if=\"!appConfig.communityEdition\" style=\"\" class=\"permissions-table-page\">\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\" ng-if=\"cluster.canUpdateCluster\">\n                <label class=\"control-label\">Owner</label>\n                <div class=\"controls\">\n                    <select\n                        dku-bs-select=\"{ liveSearch: true }\"\n                        ng-options=\"usr.login as usr.displayName for usr in allUsers\"\n                        ng-model=\"ui.ownerLogin\"\n                        options-descriptions=\"allUsersLogin\"\n                        layout=\"list\">\n                    </select>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"useByAllDisabled\" class=\"control-label\">Usable by all</label>\n                <div class=\"controls\">\n                    <input type=\"checkbox\" ng-hide=\"cluster.canManageUsersCluster || (!cluster.canManageUsersCluster && !cluster.usableByAll)\" checked disabled />\n                    <input type=\"checkbox\" ng-hide=\"cluster.canManageUsersCluster || (!cluster.canManageUsersCluster && cluster.usableByAll)\" disabled />\n                    <input type=\"checkbox\" ng-show=\"cluster.canManageUsersCluster\" ng-model=\"cluster.usableByAll\" id=\"useByAllDisabled\"/>\n                </div>\n            </div>\n        </form>\n        <form class=\"inline-form\">\n\n            <table sort-table class=\"table table-striped table-hover permissions\" >\n                <thead>\n                    <tr>\n                        <th colspan=\"2\">Group name</th>\n                        <th>Use</th>\n                        <th ng-if=\"cluster.canUpdateCluster\">Change settings &amp; Operate</th>\n                        <th ng-if=\"cluster.canManageUsersCluster\">Admin</th>\n                        \n                        <th>&nbsp;</th>\n                    </tr>\n                </thead>\n                <tbody add-remove ng-model=\"cluster.permissions\">\n                    <tr ng-hide=\"cluster.permissions.length\">\n                        <td colspan=\"13\" style=\"text-align: center; font-size: 16px; line-height: 40px; color: #666\">\n                            No group is granted access to this cluster\n                        </td>\n                    </tr>\n                    <tr ng-repeat=\"perm in cluster.permissions\">\n                        <td colspan=\"2\">{{perm.group}}</td>\n                        <td>\n                            <label class=\"checkbox\" for=\"useDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$useDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$useDisabled\" ng-model=\"perm.use\" id=\"useDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td ng-if=\"cluster.canUpdateCluster\">\n                            <label class=\"checkbox\" for=\"updateDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$updateDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$updateDisabled\" ng-model=\"perm.update\" id=\"updateDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td ng-if=\"cluster.canManageUsersCluster\">\n                            <label class=\"checkbox\" for=\"manageUsersDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$manageUsersDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$manageUsersDisabled\" ng-model=\"perm.manageUsers\" id=\"manageUsersDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                       \n                        <td>\n                            <a  class=\"link-danger\" ng-click=\"remove($index)\"> <i class=\"icon-trash\" /></a>\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n\n            <div ng-show=\"unassignedGroups.length\" style=\"margin-bottom: 20px;\">\n                <select style=\"display: inline-block;\" ng-model=\"newPerm.group\" dku-bs-select=\"{liveSearch:true,width:250}\" ng-options=\"g for g in unassignedGroups\" data-none-selected-text=\"Select a group\" ></select>\n                <button style=\"display: inline-block;\" ng-disabled=\"!newPerm.group\" ng-click=\"addPermission()\" class=\"btn btn--secondary\">\n                    <span plus-icon />\n                    &nbsp;Grant access to group\n                </button>\n            </div>\n\n            <div class=\"alert alert-info\"> \n                <i class=\"icon-info-sign\" /> \n                &nbsp;To manage groups go to <a class=\"tab\" ng-class=\"{'enabled': $state.includes('admin.groups')}\" href=\"/admin/security/groups/\">DSS global administration</a>.\n            </div>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/clusters/fragments/spark-cluster-settings-block.html", "<form class=\"dkuform-horizontal\" ng-if=\"addLicInfo.sparkLicensed\">\n\t<div class=\"section\" ng-if=\"mask\">\n\t    <div class=\"control-group\" ng-if=\"mask\">\n\t        <label class=\"control-label\">Override global settings</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"mask.enabled\" />\n\t                <span class=\"help-inline\">If disabled, this cluster will use globally-defined settings for everything related to Spark</span>\n\t            </label>\n\t        </div>\n\t    </div>\n\t</div>\n\n    <div class=\"section\"  ng-if=\"!mask || mask.enabled\">\n\t    <div class=\"control-group\">\n\t        <label class=\"control-label\">Enable Spark</label>\n\t        <div class=\"controls\">\n\t            <label>\n\t                <input type=\"checkbox\" ng-model=\"settings.sparkEnabled\"/>\n\t                <span class=\"help-inline\">Enable support of Spark {{mask ? 'for this cluster': ''}}</span>\n\t            </label>\n\t        </div>\n\t    </div>\n\t</div>\n\n    <div class=\"section\" ng-if=\"mask.enabled && settings.sparkEnabled\">\n        <div ng-if=\"mask.enabled\" class=\"control-group\">\n            <label class=\"control-label\">Spark HOME</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"text\" ng-model=\"settings.sparkHome\"/>\n                    <span class=\"help-inline\">Overrides the Spark HOME from the install-spark-integration command. Leave empty to use the globally-defined Spark HOME</span>\n                </label>\n            </div>\n        </div>\n    </div>\n\n\n    <div class=\"section\" ng-if=\"(!mask || mask.enabled) && settings.sparkEnabled\">\n\n        <h2 id=\"runtime-config\">Runtime configurations</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override runtime configs</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.properties\">\n                    <span class=\"help-inline\">Override this to define additional properties and/or runtime configurations</span>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"!mask || mask.properties\">\n            <div ng-if=\"mask.properties\" style=\"margin-bottom: 20px\">\n                <h3>Config keys added to all configurations <button type=\"button\" ng-if=\"hadoopSettings\" class=\"btn btn--secondary pull-right\" ng-click=\"copyHadoopSettings()\">Copy Hadoop settings</button></h3>\n                <ng2-credentials-list \n                    [(items)]=\"settings.executionConfigsGenericOverrides\"\n                    key-placeholder=\"Configuration key\"\n                    value-placeholder=\"Configuration value\"\n                    add-label=\"Add configuration\"\n                    warn-if-trimmable=\"true\">\n                </ng2-credentials-list>\n            </div>\n            <div ng-if=\"mask.properties\">\n                <h3>Per-configuration overrides</h3>\n            </div>\n\n            <div add-remove ng-model=\"settings.executionConfigs\">\n\n                <div ng-repeat=\"execConfig in settings.executionConfigs\" class=\"repeatable-config-block spark-execution-config\" >\n            \n                    <a class=\"pull-right text-danger\" style=\"margin: 10px\" ng-click=\"remove($index)\">\n                        <i class=\"icon-trash\" />\n                    </a>\n\n                    <h3>Basic</h3>\n\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Config name</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"execConfig.name\" />\n                            <div class=\"help-inline\">\n                                NB: renaming or removing configurations could cause trouble.\n                            </div>\n                        </div>\n                    </div>\n                    <div ng-if=\"mask && execConfig.name && execConfig.name.length > 0 && appConfig.sparkExecutionConfigs.indexOf(execConfig.name) < 0\" class=\"alert alert-warning\">\n                        <p>No runtime configuration named <em>{{execConfig.name}}</em> exists at the instance level.</p>\n                        <p>Runtime configurations defined at the cluster level are only overrides of configurations defined in <a href=\"{{$state.href('admin.general')}}\">Administration</a></p>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Description</label>\n                        <div class=\"controls\">\n                            <textarea ng-model=\"execConfig.description\" style=\"height: 130px; width: 480px\" />\n                        </div>\n                    </div>\n                    <h3>Config keys</h3>\n                    <small>\n                        Define here Spark configuration keys.\n                        Keys not listed here are inherited from your system-wide Spark configuration.\n                    </small>\n                    <ng2-credentials-list \n                        [(items)]=\"execConfig.conf\"\n                        key-placeholder=\"Configuration key\"\n                        value-placeholder=\"Configuration value\"\n                        add-label=\"Add Spark configuration\"\n                        warn-if-trimmable=\"true\">\n                    </ng2-credentials-list>\n\n                    <div>\n                        <div class=\"control-group\" style=\"margin-top: 20px; margin-bottom:: 20px;\">\n                            <label for=\"\" class=\"control-label\"><h3 style=\"margin: -3px 0 0 0\">Managed Spark-on-K8S</h3></label>\n                            <div class=\"controls\">\n                                <label>\n                                <input type=\"checkbox\" ng-model=\"execConfig.kubernetesSettings.managedKubernetes\" />\n                                <span class=\"help-inline\">\n                                    Automatically manage setting up Spark for Kubernetes. If you're not using dynamic K8S clusters, you'll still need to setup the <em>spark.master</em> config key.\n                                </span>\n                                 </label>\n                            </div>\n                        </div>\n\n                        <div ng-if=\"execConfig.kubernetesSettings.managedKubernetes\">\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Image registry URL</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.repositoryURL\"/>\n                                    <span class=\"help-inline\">\n                                        Base URL of the image registry, in the form host/root. See doc. for more information.\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.kubernetesSettings.repositoryURL\">\n                                <label class=\"control-label\">Image pre-push hook</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"execConfig.kubernetesSettings.prePushMode\" \n                                    ng-options=\"x[0] as x[1] for x in [['NONE', 'None'], ['ECR', 'Enable push to ECR'], ['ACR', 'Enable push to ACR'], ['CUSTOM', 'Custom script']]\" />\n                                    <span class=\"help-inline\">\n                                        Action to run before pushing an image.\n                                        This is usually only required for running on Amazon EKS or Azure AKS\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.kubernetesSettings.prePushMode == 'CUSTOM'\">\n                                <label class=\"control-label\">Script</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.prePushScript\"/>\n                                    <span class=\"help-inline\">\n                                        Absolute path to a shell script. Receives the repository url, image name &amp; tag as arguments.\n                                        This script should support being called on an already-existing image/tag.\n                                    </span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Kubernetes namespace</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.managedNamespace\" />\n                                    <span class=\"help-inline\">\n                                        Kubernetes Namespace to use. Variable expansion is supported\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.kubernetesSettings.managedNamespace.indexOf('${') >= 0\"> <!-- only useful when there are variables in the namespace name -->\n                                <label for=\"\" class=\"control-label\">Make K8S-compliant</label>\n                                <div class=\"controls\">\n                                    <label>\n                                    <input type=\"checkbox\" ng-model=\"execConfig.kubernetesSettings.ensureNamespaceCompliance\" />\n                                    <span class=\"help-inline\">\n                                        Automatically adjust namespace name to ensure it is compatible with the RFC1123 sub-domain syntax enforced by Kubernetes\n                                    </span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Auto-create namespace</label>\n                                <div class=\"controls\">\n                                    <label>\n                                    <input type=\"checkbox\" ng-model=\"execConfig.kubernetesSettings.createNamespace\" />\n                                    <span class=\"help-inline\">\n                                        Automatically create the namespace if it doesn't already exist.\n                                    </span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Authentication mode</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"execConfig.kubernetesSettings.authenticationMode\" ng-options=\"x[0] as x[1] for x in [['BUILTIN', 'Use builtin configuration'], ['DYNAMIC_SERVICE_ACCOUNT', 'Create service accounts dynamically']]\" options-descriptions=\"['For UIF, each impersonated user needs credentials', '']\" layout=\"list\" />\n                                    <span class=\"help-inline\">\n                                        Spark-on-K8S jobs need end-users to authenticate to K8S. Select how to authenticate and authorize user jobs.\n                                    </span>\n                                </div>\n                            </div>\n\n                            <h4>Advanced settings</h4>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Kubectl context</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.kubeCtlContext\"/>\n                                    <span class=\"help-inline\">kubectl context to use (empty = use default). This will not be taken into account if using dynamic K8S clusters</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Kubectl config path</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.kubeConfigPath\"/>\n                                    <span class=\"help-inline\">Path to the kubectl config file (empty = use default).  This will not be taken into account if using dynamic K8S clusters</span>\n                                </div>\n                            </div>\n                            <!-- the other fields of the ContainerBuildConfig don't apply here, we don't want to know about building images for K8S via a remote docker -->\n                            \n                            <h3>Advanced settings</h3>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Base image</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.baseImage\"/>\n                                    <span class=\"help-inline\">\n                                        Leave empty to use the default image (see doc. for more information about base images)\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"appConfig.sparkVersion.startsWith('3.')\">\n                                <label class=\"control-label\">Executor pod YAML</label>\n                                <div class=\"controls\">\n                                    <!-- <div class=\"codemirror\" style=\"height: 30px\"> -->\n                                        <textarea style=\"width: 700px\" ng-model=\"execConfig.kubernetesSettings.executorPodTemplate\" zui-codemirror=\"codeMirrorSettingService.get('text/yaml')\" placeholder=\"Optional pod template specified as YAML\" />\n                                    <!-- </div> -->\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"appConfig.sparkVersion.startsWith('3.') && execConfig.kubernetesSettings.executorPodTemplate\">\n                                <label class=\"control-label\">Executor container name</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"execConfig.kubernetesSettings.executorPodTemplateContainerName\"/>\n                                    <span class=\"help-inline\">\n                                        Name of the container for the Spark executor in the pod YAML (default is spark-executor)\n                                    </span>\n                                </div>\n                            </div>\n                            \n                        </div>\n                    </div>\n\n\n                    <div>\n                        <div class=\"control-group\" style=\"margin-top: 20px; margin-bottom:: 20px;\">\n                            <label for=\"\" class=\"control-label\"><h3 style=\"margin: -3px 0 0 0\">Managed cloud credentials</h3></label>\n                            <div class=\"controls\">\n                                <label>\n                                <input type=\"checkbox\" ng-model=\"execConfig.cloudCredentialsSettings.enabled\" />\n                                <span class=\"help-inline\">\n                                    Automatically manage Cloud (AWS, Azure, GCP) credentials for SparkSQL notebooks. Use this preferably in \"standalone\" kind of deployments like Spark-on-Kubernetes\n                                </span>\n                                 </label>\n                            </div>\n                        </div>\n\n                        <div ng-if=\"execConfig.cloudCredentialsSettings.enabled\">\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Provide AWS credential</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-options=\"x[0] as x[1] for x in [['NONE', 'No'], ['ANY_MATCH', 'From any AWS connection'], ['FIRST_MATCH', 'From a connection']]\" ng-model=\"execConfig.cloudCredentialsSettings.aws.mode\" />\n                                    <span class=\"help-inline\">Only connections for which the user has 'read connection details' rights will be considered</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.cloudCredentialsSettings.aws.mode == 'FIRST_MATCH'\">\n                                <label class=\"control-label\">AWS connections to consider</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" comma-separated-view ng-model=\"execConfig.cloudCredentialsSettings.aws.connections\"/>\n                                    <span class=\"help-inline\">\n                                        Comma-separated list of AWS connections names. The first connection on which the user has 'read connection details' will be used\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"appConfig.synchronizeToMetastoreCatalogFlavor == 'AWS_GLUE'\">\n                                <label class=\"control-label\">Also manage Glue credential</label>\n                                <div class=\"controls\">\n                                    <input type=\"checkbox\" ng-model=\"execConfig.cloudCredentialsSettings.aws.provideGlueClientCredential\"/>\n                                    <span class=\"help-inline\">\n                                        Use the credential from the specified connection to access the Glue catalog client in the notebook\n                                    </span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Provide Azure credential</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-options=\"x[0] as x[1] for x in [['NONE', 'No'], ['ANY_MATCH', 'From any Azure connection'], ['FIRST_MATCH', 'From a connection']]\" ng-model=\"execConfig.cloudCredentialsSettings.azure.mode\" />\n                                    <span class=\"help-inline\">Only connections for which the user has 'read connection details' rights will be considered</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.cloudCredentialsSettings.azure.mode == 'FIRST_MATCH'\">\n                                <label class=\"control-label\">Azure connections to consider</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" comma-separated-view ng-model=\"execConfig.cloudCredentialsSettings.azure.connections\"/>\n                                    <span class=\"help-inline\">\n                                        Comma-separated list of Azure connections names. The first connection on which the user has 'read connection details' will be used\n                                    </span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Provide GCP credential</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-options=\"x[0] as x[1] for x in [['NONE', 'No'], ['ANY_MATCH', 'From any GCP connection'], ['FIRST_MATCH', 'From a connection']]\" ng-model=\"execConfig.cloudCredentialsSettings.gcp.mode\" />\n                                    <span class=\"help-inline\">Only connections for which the user has 'read connection details' rights will be considered</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"execConfig.cloudCredentialsSettings.gcp.mode == 'FIRST_MATCH'\">\n                                <label class=\"control-label\">GCP connections to consider</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" comma-separated-view ng-model=\"execConfig.cloudCredentialsSettings.gcp.connections\"/>\n                                    <span class=\"help-inline\">\n                                        Comma-separated list of GCP connections names. The first connection on which the user has 'read connection details' will be used\n                                    </span>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n\n                <button type=\"button\" \n                    class=\"btn btn--text btn--primary\" \n                    ng-click=\"add({conf : []})\">\n                    <span plus-icon></span>&nbsp;Add another config\n                </button>\n            </div>\n        </div>\n\n    </div>\n\n\t<div class=\"section\" ng-if=\"(!mask || mask.enabled) && settings.sparkEnabled && appConfig.featureFlags.includes('sparkClusterMode')\">\n        <h2 id=\"yarn\">Cluster mode (Unsupported)</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\" >\n            <label class=\"control-label\">Override</label>\n            <label class=\"dku-toggle\" style=\"display: inline-block;\">\n                <input type=\"checkbox\" ng-model=\"mask.yarnCluster\">\n                <span/>\n            </label>\n        </div>\n        \n        <div ng-if=\"!mask || mask.yarnCluster\">\n            <div class=\"control-group\">\n                <div class=\"controls\">\n                    <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"preloadYarnClusterFiles(settings.yarnClusterSettings)\">Preload</button>\n                    <span class=\"help-inline\">Upload DSS-related files to the cluster to speed up application launching in yarn-cluster mode</span>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"yarnClusterConnection\" class=\"control-label\">Connection</label>\n                <div class=\"controls\">\n                    <input type=\"text\" id=\"yarnClusterConnection\" ng-model=\"settings.yarnClusterSettings.connectionName\"/>\n                    <span class=\"help-inline\">Name of DSS connection to use to push files on cluster</span>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"yarnClusterLocation\" class=\"control-label\">Location</label>\n                <div class=\"controls\">\n                    <input type=\"text\" id=\"yarnClusterLocation\" ng-model=\"settings.yarnClusterSettings.location\"/>\n                    <span class=\"help-inline\">Location inside the connection to push files on cluster</span>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"yarnClusterTunnelConnection\" class=\"control-label\">Tunnel connection</label>\n                <div class=\"controls\">\n                    <input type=\"text\" id=\"yarnClusterTunnelConnection\" ng-model=\"settings.yarnClusterSettings.tunnelConnectionName\"/>\n                    <span class=\"help-inline\">Name of a SSH (DSS) connection to use to tunnel to the cluster. Use when DSS is behind a NAT from the cluster p.o.v.</span>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"yarnClusterTunnelHost\" class=\"control-label\">Tunnel remote host</label>\n                <div class=\"controls\">\n                    <input type=\"text\" id=\"yarnClusterTunnelHost\" ng-model=\"settings.yarnClusterSettings.tunnelRemoteHost\"/>\n                    <span class=\"help-inline\">Hostname of the tunnel remote host (overrides the output of the 'hostname' command)</span>\n                </div>\n            </div>\n        </div>\n    </div>\n\n\n\t<div class=\"section\" ng-if=\"(!mask || mask.enabled) && settings.sparkEnabled\">\n\t\t<h2 id=\"interactive-sparks\">Interactive SparkSQL (notebooks &amp; charts)</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.interactiveExecutionEngine\" />\n                    <span/>\n                </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.interactiveExecutionEngine\">\n            <label class=\"control-label\">Interactive SparkSQL</label>\n            <div class=\"controls\">\n                <select dku-bs-select ng-model=\"settings.interactiveExecutionEngine\">\n                    <option ng-repeat=\"o in executionEngines\" value=\"{{o.value}}\" ng-disabled=\"o.disabled\">{{o.label}}</option>\n                </select>\n            </div>\n        </div>\n\t</div>\n\n\n    <div class=\"section\">\n\n        <h2 id=\"default-config\">Default configuration (recipes &amp; ML)</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.engineCreationSettings\">\n                    <span/>\n                </label>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.engineCreationSettings\">\n            <label class=\"control-label\">Default runtime config</label>\n            <div class=\"controls\">\n                <select dku-bs-select ng-model=\"settings.engineCreationSettings.executionConfig\" ng-options=\"x for x in appConfig.sparkExecutionConfigs\" />\n                <span class=\"help-inline\">Applies only to new recipes and machine learning tasks. Will use \"default\" if empty</span>\n            </div>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"!mask || mask.engineCreationSettings\">\n            <label class=\"control-label\">Default global metastore</label>\n            <div class=\"controls\">\n                <input type=\"checkbox\" ng-model=\"settings.engineCreationSettings.useGlobalMetastore\" />\n                <span class=\"help-inline\">Should the recipes and machine learning be created in \"Global metastore\" mode? Applies only to new recipes and machine learning tasks</span>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"section\" ng-if=\"(!mask || mask.enabled) && settings.sparkEnabled\">\n    \t<h2 id=\"advanced-settings\">Advanced settings</h2>\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Additional jars</label>\n            <div class=\"controls\" style=\"max-width: 400px;\">\n                <div>\n\t                <span class=\"help-inline\">Will be added to calls to spark-submit</span>\n                </div>\n                <ng2-values-list [(items)]=\"settings.additionalSparkSubmitJars\" add-label=\"Add a jar\" value-placeholder=\"E.g. jar-file-name.jar\"></ng2-values-list>\n            </div>\n        </div>\n    </div>\n\n\n    <div class=\"section\" ng-if=\"mask\">\n\n        <h2 id=\"environment-variables\">Environment variables</h2>\n\n        <div class=\"control-group\" ng-if=\"mask\">\n            <label class=\"control-label\">Override</label>\n            <div class=\"controls\">\n                <label>\n                    <input type=\"checkbox\" ng-model=\"mask.environmentVariables\">\n                    <span/>\n                </label>\n            </div>\n        </div>\n\n        <div ng-if=\"mask.environmentVariables\">\n            <div class=\"spark-execution-config\">\n                <ng2-key-values-list \n                    [(items)]=\"settings.environmentVariables\" \n                    add-label=\"Add Environment Variable\" \n                    key-placeholder=\"Variable key\" \n                    value-placeholder=\"Variable value\">\n                </ng2-key-values-list>\n            </div>\n        </div>\n    </div>\n</form>\n");
$templateCache.put("/templates/admin/clusters/k8s-object-describe-modal.html", "<div class=\"modal modal3 wide-modal runnable-modal k8s-describe-modal\" ng-controller=\"K8SObjectDescribeController\" auto-size=\"false\">\n    <div dku-modal-header-with-totem modal-title=\"{{ objectType }} {{ objectName }}\"\n         modal-totem=\"icon-info-sign\"/>\n    <div class=\"modal-body\" ng-if=\"uiState.mode == 'describe'\">\n        <div class=\"flex oa\" ng-if=\"loading\">\n            <div class=\"alert alert-info\"><i class=\"icon-spinner icon-spin\"></i>&nbsp;Loading...</div>\n        </div>\n        <div class=\"flex oa kubectl-output\" ng-if=\"describeResult && !deleteResult\">\n            <pre class=\"smart-log-tail-content\">{{ describeResult }}<span copy-clipboard-button=\"describeResult\" /></pre>\n        </div>\n        <div class=\"flex oa kubectl-output\" ng-if=\"deleteResult\">\n            <pre class=\"smart-log-tail-content\">{{ deleteResult }}<span copy-clipboard-button=\"deleteResult\" /></pre>\n        </div>\n        <div ng-if=\"err\">\n            <label for=\"err\" class=\"control-label\">Error output</label>\n            <div class=\"flex oa kubectl-output error\" ng-if=\"err\">\n                <pre id=\"err\" class=\"smart-log-tail-content\">{{ err }}<span copy-clipboard-button=\"err\" /></pre>\n            </div>\n        </div>\n    </div>\n     <div class=\"modal-body\" ng-if=\"uiState.mode == 'logs'\">\n        <pre smart-log-tail=\"podLogTail\" />\n    </div>\n    <div class=\"modal-footer\">\n        <div class=\"modal-footer-left-content\">\n            <button ng-if=\"uiState.mode == 'describe' && !deleting && !deleteResult && objectType === 'Pod'\" type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"switchToLogs()\">Switch to logs</button>\n            <button ng-if=\"uiState.mode == 'logs' && !deleting && !deleteResult && objectType === 'Pod'\" type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"switchToDescribe()\">Switch to describe</button>\n        </div>\n        <div class=\"modal-footer-std-buttons\">\n            <button ng-if=\"uiState.mode == 'logs' && !deleting && !deleteResult && objectType === 'Pod'\" type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"downloadPodLog()\"><i class=\"icon-download\"></i>Download log</button>\n            <button ng-if=\"!deleteResult && canDeleteObject()\" type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"deleteObject()\" ng-disabled=\"deleting\"><i class=\"icon-spinner icon-spin\" ng-if=\"deleting\"></i>&nbsp;{{ deleting ? \"Deleting\" : \"Delete\" }} {{ objectType }}</button>\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Close</button>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/clusters/new-cluster-modal.html", "<div class=\"modal modal3 dku-modal\">\n\t<div dku-modal-header modal-title=\"{{ title }}\" />\n\n\t<form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newClusterForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n            <div class=\"control-group\" ng-if=\"!typeAlreadyKnown\">\n                <label for=\"\" class=\"control-label\">Type</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"newCluster.type\" ng-options=\"c.id as c.label group by c.architecture for c in clusterTypes | orderBy:'architecture + label'\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"!typeAlreadyKnown && newCluster.type === 'manual'\">\n                <label for=\"\" class=\"control-label\">Architecture</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"newCluster.architecture\" ng-options=\"c.id as c.label for c in clusterArchitectures\"/>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"newCluster.name\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\" ng-if=\"newCluster.architecture != 'KUBERNETES'\"/>\n                    <input type=\"text\" ng-model=\"newCluster.name\" required ng-pattern=\"/^[A-Za-z0-9-]+$/\" ng-if=\"newCluster.architecture == 'KUBERNETES'\"/>\n                </div>\n            </div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newClusterForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/clusters/run-k8s-action-modal.html", "<div class=\"modal modal3 wide-modal runnable-modal k8s-action-modal\" auto-size=\"false\">\n    <div dku-modal-header-with-totem modal-title=\"{{ label }}\"\n         modal-totem=\"{{ icon | toModernIcon:24 }}\" />\n    <div class=\"modal-body\">\n        <div class=\"w800 mbot20\" ng-if=\"longDescription\">\n            <div class=\"larger-grey-text\">{{ longDescription }}</div>\n        </div>\n\n        <div ng-show=\"fatalAPIError\" block-api-error></div>\n\n        <div class=\"recipe-settings-section1 w800 mtop20\" ng-if=\"customCommand\">\n            <form class=\"dkuform-modal-horizontal\">\n                <div class=\"control-group\">\n                    <label for=\"commandArgs\" class=\"control-label\">Arguments</label>\n                    <div class=\"controls\">\n                        <input id=\"commandArgs\" type=\"text\" ng-model=\"$parent.commandArgs\" required  ng-change=\"updateCommand()\" dku-enter=\"run()\" />\n                        <span class=\"help-inline\">Kubectl command, like 'get pods'</span>\n                    </div>\n                </div>\n            </form>\n        </div>\n\n        <div class=\"recipe-settings-section1 w800\" id=\"kubectl-command\">\n            <div class=\"control-group\">\n                <label for=\"command\" class=\"control-label\">Command</label>\n                <div class=\"controls kubectl-output\">\n                    <pre id=\"command\">{{fullCommand}}<span copy-clipboard-button=\"fullCommand\" /></pre>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"recipe-settings-section1 w800 mtop20\" ng-show=\"(hasFilters || hasCommandDryRunFlag())  && !updateCommand()\">\n            <form class=\"dkuform-modal-horizontal\">\n                <div class=\"control-group\" ng-show=\"hasFilters\">\n                    <label for=\"namespaceFilter\" class=\"control-label\">Namespace filter</label>\n                    <div class=\"controls\">\n                        <input id=\"namespaceFilter\" type=\"text\" ng-model=\"namespaceFilter\" ng-change=\"updateCommand()\" />\n                        <span class=\"help-inline\">Set the namespace you would like to run the command on</span>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-show=\"hasFilters\">\n                    <label for=\"labelFilter\" class=\"control-label\">Label selector</label>\n                    <div class=\"controls\">\n                        <input id=\"labelFilter\" type=\"text\" ng-model=\"labelFilter\" ng-change=\"updateCommand()\" />\n                        <span class=\"help-inline\">Set your label selector (check <a href=\"https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#list-and-watch-filtering\" target=\"_blank\">here</a> for the syntax)</span>\n                    </div>\n                </div>\n                <div ng-if=\"hasAdditionalOptions\" class=\"control-group mtop20\" ng-show=\"!$parent.updateCommand()\">\n                    <label class=\"control-label\" for=\"deleteFailed\">Also delete failed jobs</label>\n                    <div class=\"controls\">\n                        <label class=\"dku-toggle\" style=\"display: inline-block\">\n                            <input id=\"deleteFailed\" type=\"checkbox\" ng-model=\"$parent.deleteFailed\" ng-change=\"$parent.updateCommand()\"/>\n                            <span />\n                        </label>\n                    </div>\n                </div>\n                <div class=\"control-group\" ng-show=\"hasCommandDryRunFlag()  && !updateCommand()\">\n                    <label class=\"control-label\" for=\"dryRun\">Dry run</label>\n                    <div class=\"controls\">\n                        <label class=\"dku-toggle\" style=\"display: inline-block\">\n                            <input id=\"dryRun\" type=\"checkbox\" ng-model=\"dryRun\" ng-change=\"updateCommand()\"/>\n                            <span />\n                        </label>\n                    </div>\n                </div>\n            </form>\n        </div>\n\n        <div ng-if=\"output\" class=\"recipe-settings-section1 w800\" id=\"kubectl-output\">\n            <div class=\"control-group\">\n                <label for=\"output\" class=\"control-label\">Standard output</label>\n                <div class=\"controls kubectl-output\">\n                    <pre id=\"output\">{{output}}<span copy-clipboard-button=\"output\" /></pre>\n                </div>\n            </div>\n        </div>\n\n        <div ng-if=\"err\" class=\"recipe-settings-section1 w800\" id=\"kubectl-err\">\n            <div class=\"control-group error\">\n                <label for=\"err\" class=\"control-label\">Error output</label>\n                <div class=\"controls kubectl-output\">\n                    <pre id=\"err\">{{err}}<span copy-clipboard-button=\"err\" /></pre>\n                </div>\n            </div>\n        </div>\n\n        <div ng-if=\"output && hasCommandDryRunFlag() && dryRun==true\" class=\"recipe-settings-section1 w800 dry-run-warning\">\n            Disable dry run to actually execute the command\n        </div>\n\n        <div ng-if=\"code===0 && !output && !err && !running\" class=\"recipe-settings-section1 w800 no-output-warning\">\n            Command executed successfully with no output\n        </div>\n    </div>\n    <div class=\"modal-footer\">\n        <div class=\"modal-footer-left-content\">\n            <button type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"resetSettings()\" ng-if=\"!running\">Reset to default</button>\n        </div>\n        <div class=\"modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Close</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"run()\" ng-disabled=\"running\"><i class=\"icon-spinner icon-spin\" ng-if=\"running\"></i>&nbsp;Run</button>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/R-edit.html", "<div class=\"fh code-env\" global-keydown=\"{'ctrl-s meta-s':'saveAndMaybePerformChanges(false)'}\">\n    <div class=\"h100 row-fluid\">\n        <div class=\"span2 offset0 nav-list-sidebar sidebar-admin\" style=\"padding-top: 0;\">\n            <div class=\"horizontal-flex\" style=\"height: auto;\">\n                <div class=\"flex mx-textellipsis\">\n                    <h4 class=\"mx-textellipsis\" title=\"{{codeEnv.envName}}\">{{codeEnv.envName}}</h4>\n                </div>\n                <div class=\"noflex center-children\" style=\"font-size: 14px; opacity: 0.8;\" ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <div custom-element-popup cep-position=\"align-right-bottom\" close-on-click=\"true\">\n                        <i class=\"icon-cog mainzone cursor-pointer\" ng-click=\"togglePopover()\"></i>\n                        <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                            <li ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\"><i class=\"icon-trash\"></i>&nbsp;Delete</a>\n                            </li>\n                            <li>\n                                <a ng-click=\"getEnvDiagnostic(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Get diagnostic</a>\n                            </li>\n                        </ul>\n                    </div>\n                </div>\n            </div>\n            <ul>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'info'}\" full-click>\n                    <a ng-click=\"uiState.active = 'info'\" main-click>General</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'permissions'}\" full-click ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                    <a ng-click=\"uiState.active = 'permissions'\" main-click>Permissions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'packages'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_NON_MANAGED_PATH' || codeEnv.deploymentMode == 'PLUGIN_NON_MANAGED' || codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                    <a ng-click=\"uiState.active = 'packages'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'versions'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_VERSIONED'\">\n                    <a ng-click=\"uiState.active = 'versions'\" main-click>Versions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'managed'}\" full-click ng-if=\"codeEnv.deploymentMode == 'PLUGIN_MANAGED' || codeEnv.deploymentMode == 'DSS_INTERNAL'\">\n                    <a ng-click=\"uiState.active = 'managed'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'single'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                    <a ng-click=\"uiState.active = 'single'\" main-click>Current version</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'containers'}\" full-click ng-if=\"['AUTOMATION_VERSIONED', 'AUTOMATION_SINGLE', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'containers'\" main-click>Containerized execution</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'logs'}\" full-click>\n                    <a ng-click=\"uiState.active = 'logs'\" main-click>Logs</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'usages'}\" full-click ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <a ng-click=\"uiState.active = 'usages'\" main-click>Usages</a>\n                </li>\n            </ul>\n            <div ng-include=\"'/templates/admin/code-envs/common/save-update-buttons.html'\" />\n        </div>\n        <div class=\"span10 h100 offset0 boxed-next-to-sidebar no-padding\" ng-switch=\"uiState.active\">\n            <div ng-switch-when=\"info\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env</h1>\n                <div block-api-error />\n                <form class=\"dkuform-horizontal\">\n                    <div class=\"section\">\n                    <h2>General env info</h2>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Mode</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.deploymentMode}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Owner</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.owner}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['AUTOMATION_NON_MANAGED_PATH', 'PLUGIN_NON_MANAGED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                        <label for=\"\" class=\"control-label\">Location of the environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.noVersion.path}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                        <label for=\"\" class=\"control-label\">Conda environment</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.noVersion.desc.externalCondaEnvName\" />\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2  ng-if=\"appConfig.sparkEnabled\">Spark</h2>\n                    <div class=\"control-group\" ng-if=\"appConfig.sparkEnabled && ['AUTOMATION_NON_MANAGED_PATH', 'PLUGIN_NON_MANAGED', 'EXTERNAL_CONDA_NAMED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                        <label for=\"\" class=\"control-label\">Yarn R executable</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.noVersion.desc.yarnRBin\" />\n                            <span class=\"help-inline\">R binary on the Yarn nodes for SparkR</span>\n                        </div>\n                    </div>\n                    </div>\n\n\n                    <div class=\"section\">\n                    <h2>Extra options</h2>\n\n                    <div ng-if=\"codeEnv\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Override imported settings</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.envSettings.overrideImportedEnvSettings\" />\n                                </label>\n                             </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings && codeEnv.desc.conda\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings && codeEnv.desc.conda\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings\">\n                            <label for=\"\" class=\"control-label\">CRAN mirror URL</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"codeEnv.envSettings.cranMirrorURL\"/>\n                            </div>\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2>Jupyter</h2>\n                    <div class=\"control-group\" ng-if=\"codeEnv.noVersion != null && !codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.noVersion.kernelSpecName || 'not installed'}}</div>\n                        </div>\n                    </div>\n                     <div class=\"control-group\" ng-if=\"codeEnv.currentVersion != null && !codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.currentVersion.kernelSpecName || 'not installed'}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>Unable to check status</div>\n                             <div ng-if=\"codeEnv.kernelSpecsListingError\" api-error-alert=\"codeEnv.kernelSpecsListingError\" />\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"!!codeEnv.noVersion\">\n                        <div class=\"controls\">\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs IRkernel)</span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"!!codeEnv.currentVersion\">\n                        <div class=\"controls\">\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs IRkernel)</span>\n                        </div>\n                    </div>\n                    </div>\n                </form>\n\n                <!-- <pre class=\"debug\">{{codeEnv|json}}</pre> -->\n            </div>\n\n            <div ng-switch-when=\"usages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env usages</h1>\n                <div class=\"section\">\n                    <code-env-usage env-lang=\"{{envLang}}\" env-name=\"{{codeEnv.envName}}\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"permissions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Permissions</h1>\n                <div class=\"section\">\n                    <div code-env-security-permissions code-env=\"codeEnv\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"managed\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div r-version=\"codeEnv.noVersion\" update-version=\"updateEnvVersion\" editable=\"false\"></div>\n                </div>\n            </div>\n            <div ng-switch-when=\"single\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Version</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div r-version=\"codeEnv.currentVersion\" update-version=\"updateEnvVersion\" editable=\"true\"></div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"versions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Versions</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div>\n                        <button class=\"btn btn--secondary\" ng-click=\"openImportEnvVersionModal()\">Import new version</button>\n                    </div>\n                    <div ng-repeat=\"version in codeEnv.versions | orderBy: '-versionId'\" ng-class=\"{'version-separator' : $index > 0}\">\n                        <div r-version=\"version\"\n                            version-spec-is-dirty=\"versionSpecIsDirty\"\n                            save-version=\"saveVersionAndMaybePerformChanges\"\n                            update-version=\"updateEnvVersion\"\n                            install-jupyter-support=\"installJupyterSupport\"\n                            remove-jupyter-support=\"removeJupyterSupport\"\n                            editable=\"true\"\n                            with-save-update=\"true\"\n                            can-version-be-updated=\"canVersionBeUpdated\"\n                        ></div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"packages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <button class=\"btn btn--secondary\" ng-click=\"fetchNonManagedEnvDetails()\">Fetch packages list</button>\n\n                <div class=\"row-fluid\" ng-if=\"nonManagedEnvDetails\">\n                    <div class=\"span6\" ng-if=\"nonManagedEnvDetails.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Conda)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.condaEnvSpec}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (R)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.nocondaEnvSpec}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"logs\" class=\"h100 vertical-flex paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env logs</h1>\n                <div class=\"flex\">\n                    <div class=\"section fh\">\n                        <div simple-logs logs=\"logs\" obj-id=\"[envLang, envName]\" get-log=\"getLog\" download-url=\"downloadURL\"/>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"containers\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Containerized execution</h1>\n                <div class=\"section\">\n                <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_VERSIONED'\">\n                    <div ng-repeat=\"version in codeEnv.versions | orderBy: '-versionId'\" ng-class=\"{'version-separator' : $index > 0}\">\n                        <div container-version=\"version\"\n                            set-for-all-versions=\"setContainerConfForAllVersions\"\n                            version-spec-is-dirty=\"versionSpecIsDirty\"\n                            save-version=\"saveVersionAndMaybePerformChanges\"\n                            update-version=\"updateEnvVersion\"\n                            can-version-be-updated=\"canVersionBeUpdated\"\n                            with-save-update=\"true\"\n                            deployment-mode=\"codeEnv.deploymentMode\"\n                        ></div>\n                    </div>\n                </div>\n                <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                    <div code-env-containers code-env=\"codeEnv.currentVersion\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                </div>\n                <div ng-if=\"['PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <div code-env-containers code-env=\"codeEnv.noVersion\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/R-version.html", "<div>\n    <div class=\"horizontal-flex\" style=\"margin-bottom: 10px;\">\n        <h4 class=\"flex mx-textellipsis\">\n            <span>Version {{version.versionId}}</span>\n        </h4>\n        <div ng-if=\"withSaveUpdate\" class=\"noflex\">\n            <div ng-if=\"specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary\" style=\"width: 100%\" ng-click=\"saveVersionEnv(false)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save\n                </button>\n            </div>\n            <div ng-if=\"!specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary\" ng-disabled=\"true\" style=\"width: 100%\" >\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Saved!\n                </button>\n            </div>\n            <div style=\"display: inline-block; width: 10px;\"></div> <!-- separation -->\n            <div ng-if=\"canBeUpdated() && specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--primary\" ng-click=\"saveVersionEnv(true)\" style=\"width: 100%;\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save and update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated() && !specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success\" ng-click=\"updateVersionEnv()\" style=\"width: 100%;\">\n                    Update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated()\" style=\"display: inline-block; width: 20px; margin-top: 5px;\">\n                <span custom-element-popup cep-position=\"align-right-bottom\">\n                    <a class=\"mainzone dropdown-toggle\" ng-click=\"togglePopover()\">\n                        <i class=\"icon-cog\" style=\"color:#999;margin-left: 4px;position: relative;top: 1px;\"/>\n                    </a>\n                    <div class=\"popover custom-element-popup-popover dropdown-menu pull-right simple dkuform-horizontal\" style=\"padding: 10px 20px; z-index: 10;\">\n                        <label class=\"checkbox\">\n                            <input id=\"allCheckbox\" type=\"checkbox\" ng-model=\"uiState.upgradeAllPackages\"></input>\n                            Update all packages\n                        </label>\n                        <span class=\"help-inline\" style=\"color: #999\">\n                            Updates packages in the virtual environment so that the installed packages match the list and versions of the packages specified by the user.\n                        </span>\n                        <label class=\"checkbox\">\n                            <input id=\"rebuildCheckbox\" type=\"checkbox\" ng-model=\"uiState.forceRebuildEnv\"></input>\n                            Rebuild env\n                        </label>\n                        <span class=\"help-inline\" style=\"color: #999\">\n                            Clears the code environment and rebuilds it from scratch\n                        </span>\n                    </div>\n                </span>\n\n            </div>\n        </div>\n    </div>\n\n    <form class=\"dkuform-horizontal\">\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Path</label>\n            <div class=\"controls\">\n                <div>{{version.path}}</div>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"appConfig.sparkEnabled\">\n            <label for=\"\" class=\"control-label\">Yarn R executable</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"version.desc.yarnRBin\" />\n                <span class=\"help-inline\">R binary on the Yarn nodes for SparkR</span>\n            </div>\n        </div>\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Ready</label>\n            <div class=\"controls\">\n                <div>{{version.ready}}</div>\n            </div>\n        </div>\n        <div ng-if=\"version.desc.envSettings\">\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Inherit global settings</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"version.desc.envSettings.inheritGlobalSettings\" />\n                    </label>\n                 </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings && version.desc.conda\">\n                <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings && version.desc.conda\">\n                <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings\">\n                <label for=\"\" class=\"control-label\">CRAN mirror URL</label>\n                <div class=\"controls\">\n                     <input type=\"text\" ng-model=\"version.desc.envSettings.cranMirrorURL\" />\n                </div>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"version.versionId\"> <!-- only for versioned envs -->\n            <label for=\"\" class=\"control-label\">Usages by bundles</label>\n            <div class=\"controls\">\n                <ul>\n                    <li ng-repeat=\"link in version.links\">\n                        <span>{{link}}</span>\n                        <span ng-if=\"version.kernelSpecNames[link]\"> with kernel : {{version.kernelSpecNames[link]}}</span>\n                    </li>\n                </ul>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"version.versionId\"> <!-- only for versioned envs -->\n            <div class=\"controls\">\n                <button class=\"btn btn--secondary\" ng-click=\"installJupyterSupportVersion()\" >(Re)install Jupyter support</button>\n                <button class=\"btn btn--secondary\" ng-click=\"removeJupyterSupportVersion()\" >Remove Jupyter support</button>\n                <span class=\"help-inline\">(needs ipykernel)</span>\n            </div>\n        </div>\n    </form>\n    <div class=\"row-fluid\">\n        <div class=\"span6\" ng-if=\"version.desc.conda\">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Base packages (Conda)</legend>\n            <pre class=\"package-list\"># These packages cannot be removed nor reversioned\n            {{version.mandatoryCondaEnvironment}}</pre>\n            <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (Conda)</legend>\n            <pre class=\"package-list\" ng-if=\"!editable\">{{version.specCondaEnvironment}}</pre>\n            <p class=\"small\" style=\"color:#666\">\n                These are the packages that you actually want to install  <span style=\"margin-left: 10px;\" data-placement=\"bottom\" dku-md-popover='Specify the packages you want:\n\n* one row per package\n* each row is a Conda package match specification ( [link](https://conda.io/docs/user-guide/tasks/build-packages/package-spec.html#package-match-specifications) )\n\nExamples of package specifications:\n\n* r-irkernel>=0.7\n* r-base' dku-md-title=\"Package list\" class=\"step-help-popover\" popover-clazz=\"step-help-popover\" >\n                    <i class=\"icon-question-sign\"></i>\n                </span>\n            </p>\n            <div class=\"codemirror\" ng-if=\"editable\">\n                <textarea ng-model=\"version.specCondaEnvironment\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n            </div>\n        </div>\n        <div class=\"span6 \">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Base packages (R)</legend>\n            <pre class=\"package-list\"># These packages cannot be removed nor reversioned\n            {{version.mandatoryPackageList}}</pre>\n            <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (R)</legend>\n            <p class=\"small\" style=\"color:#666\">\n                These are the packages that you actually want to install <span style=\"margin-left: 10px;\" data-placement=\"bottom\" dku-md-popover='Specify the packages you want:\n\n* one row per package\n* each row is a pair of package name and package version (optional)\n\nExamples of package specifications:\n\n* \"RJSONIO\",\"0.13\"\n* \"dplyr\",' dku-md-title=\"Package list\" class=\"step-help-popover\" popover-clazz=\"step-help-popover\" >\n                    <i class=\"icon-question-sign\"></i>\n                </span>\n            </p>\n            <pre class=\"package-list\" ng-if=\"!editable\">{{version.specPackageList}}</pre>\n            <div class=\"codemirror\" ng-if=\"editable\">\n                <textarea ng-model=\"version.specPackageList\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n            </div>\n        </div>\n    </div>\n    <div class=\"row-fluid\">\n        <div class=\"span6\" ng-if=\"version.desc.conda\">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Actual packages (Conda)</legend>\n            <pre class=\"package-list\">{{version.actualCondaEnvironment}}</pre>\n        </div>\n        <div class=\"span6 \">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Actual packages (Pip)</legend>\n            <pre class=\"package-list\">{{version.actualPackageList}}</pre>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/container-version.html", "<div>\n    <div class=\"horizontal-flex\" style=\"margin-bottom: 10px;\">\n        <h4 class=\"flex mx-textellipsis\">\n            <span>Version {{version.versionId}}</span>\n        </h4>\n        <div ng-if=\"withSaveUpdate\" class=\"noflex\">\n            <div ng-if=\"specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary w100\" ng-click=\"saveVersionEnv(false)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save\n                </button>\n            </div>\n            <div ng-if=\"!specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary w100\" ng-disabled=\"true\" >\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Saved!\n                </button>\n            </div>\n            <div style=\"display: inline-block; width: 10px;\"></div> <!-- separation -->\n            <div ng-if=\"canBeUpdated() && specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success w100\" ng-click=\"saveVersionEnv(true)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save and update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated() && !specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success w100\" ng-click=\"updateVersionEnv()\">\n                    Update\n                </button>\n            </div>\n        </div>\n        <div ng-if=\"canBeUpdated()\" style=\"display: inline-block; width: 20px; margin-top: 5px;\">\n            <span custom-element-popup cep-position=\"align-right-bottom\">\n                <a class=\"mainzone dropdown-toggle\" ng-click=\"togglePopover()\">\n                    <i class=\"icon-cog\" style=\"color:#999;margin-left: 4px;position: relative;top: 1px;\"/>\n                </a>\n                <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                <li>\n                    <a ng-click=\"setThisForAllVersions()\"><i class=\"icon-copy\"></i>&nbsp;Set for all versions</a>\n                </li>\n            </ul>\n            </span>\n        </div>\n    </div>\n    <div code-env-containers code-env=\"version\" env-lang=\"envLang\" deployment-mode=\"deploymentMode\"></div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/import-env-modal.html", "<div class=\"modal modal3 new-env-modal dku-modal\" auto-size=\"false\" ng-controller=\"AdminCodeEnvsAutomationImportController\">\n    <div dku-modal-header modal-title=\"Import code env\" />\n\n    <form class=\"dkuform-modal-horizontal\" name=\"importEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <div class=\"control-group\" >\n                <label for=\"newEnvFile\" class=\"control-label\">Code env file</label>\n                <div class=\"controls\">\n                    <input id=\"newEnvFile\" type=\"file\" style=\"line-height: 10px; width: 250px;\" required valid-file ng-model=\"newEnv.file\" accept=\"application/zip\" />\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"import()\" ng-disabled=\"importEnvForm.$invalid\">Import</button>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/import-env-version-modal.html", "<div class=\"modal modal3 new-env-modal dku-modal\" auto-size=\"false\" ng-controller=\"AdminCodeEnvsAutomationImportController\">\n    <div dku-modal-header modal-title=\"Import code env version\" />\n\n    <form class=\"dkuform-modal-horizontal\" name=\"importEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <div class=\"control-group\" >\n                <label for=\"newEnvFile\" class=\"control-label\">Code env file</label>\n                <div class=\"controls\">\n                    <input id=\"newEnvFile\" type=\"file\" style=\"line-height: 10px; width: 250px;\" required valid-file ng-model=\"newEnv.file\" accept=\"application/zip\" />\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"import()\" ng-disabled=\"importEnvForm.$invalid\">Import</button>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/index.html", "<div class=\"dss-page\">\n    <div class=\"vertical-flex h100\">\n        <div class=\"top-level-tabs\"\n            ng-if=\"mayCreateCodeEnvs() && !$state.includes('admin.codeenvs-automation.python-edit') && !$state.includes('admin.codeenvs-automation.r-edit')\">\n            <div class=\"horizontal-flex object-nav code-envs__nav-bar\">\n\n                <div class=\"noflex title\">\n                    <h2 class=\"page-subtitle\">Code envs</h2>\n                </div>\n\n                <div class=\"noflex tabs\">\n                    <a class=\"tab\" fw500-width\n                        ng-class=\"{'enabled': $state.includes('admin.codeenvs-automation.list')}\"\n                        ui-sref=\"admin.codeenvs-automation.list\">\n                        Management\n                    </a>\n                    <a class=\"tab\" fw500-width\n                        ng-show=\"mayCreateCodeEnvs()\"\n                        ng-class=\"{'enabled': $state.includes('admin.codeenvs-automation.internal')}\"\n                        ui-sref=\"admin.codeenvs-automation.internal\">\n                        Internal envs setup\n                    </a>\n                </div>\n            </div>\n        </div>\n        <div ng-if=\"!mayCreateCodeEnvs()\" ui-sref=\"admin.codeenvs-automation.list\"></div>\n        <div ui-view class=\"code-envs__tab-content\"></div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/list.html", "<div class=\"fh vertical-flex\">\n    <div class=\"noflex std-list-header\">\n        <div class=\"dropdown pull-right\" ng-if=\"!canCreateCodeEnv()\">\n            <button class=\"btn btn--primary\" ng-disabled=\"true\" title=\"You don't have the right to create code envs\">New Python env</button>\n            <button class=\"btn btn--primary\" ng-if=\"!$scope.isDeployer()\" ng-disabled=\"true\" title=\"You don't have the right to create code envs\">New R env</button>\n            <button class=\"btn btn--primary\" ng-disabled=\"true\" title=\"You don't have the right to create code envs\">Import env</button>\n        </div>\n        <div class=\"dropdown pull-right\" ng-if=\"canCreateCodeEnv()\">\n            <button class=\"btn btn--primary\" ng-click=\"openNewPythonEnvModal()\">New Python env</button>\n            <button class=\"btn btn--primary\" ng-if=\"!isDeployer()\" ng-click=\"openNewREnvModal()\">New R env</button>\n            <button class=\"btn btn--primary\" ng-click=\"openImportEnvModal()\">Import env</button>\n        </div>\n        <div class=\"std-list-search-box\">\n            <span class=\"add-on\"> <i class=\"icon-dku-search\"></i>\n            </span>\n            <input type=\"search\" ng-model=\"query\" style=\"width: 190px;\" placeholder=\"Filter...\"/>\n        </div>\n    </div>\n\n    <div class=\"flex\">\n        <div class=\"fh\">\n            <div block-api-error></div>\n            <div class=\"h100 oa\">\n                <table sort-table class=\"table table-striped table-hover\" style=\"width:100%\">\n                    <thead>\n                        <tr>\n                            <th sort-col=\"envName\">Name</th>\n                            <th sort-col=\"envLang\">Language</th>\n                            <th sort-col=\"owner\">Owner</th>\n                            <th sort-col=\"kernelSpecName\">Jupyter kernel</th>\n                            <th sort-col=\"deploymentMode\">Deployment mode</th>\n                            <th>&nbsp;</th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                        <tr ng-repeat=\"codeEnv in codeEnvs | toArray| filter:query | orderBy:sortColumn:sortDescending\">\n                            <td full-click>\n                                <a ng-if=\"codeEnv.envLang == 'PYTHON'\" ui-sref=\"admin.codeenvs-automation.python-edit({envName:codeEnv.envName})\">{{codeEnv.envName}}</a>\n                                <a ng-if=\"codeEnv.envLang == 'R'\" ui-sref=\"admin.codeenvs-automation.r-edit({envName:codeEnv.envName})\">{{codeEnv.envName}}</a>\n                            </td>\n                            <td>\n                                <span ng-class=\"{'text-warning': isPythonDeprecated(codeEnv.pythonInterpreter)}\">{{codeEnv.languageDisplayName}} </span>\n                                <span class=\"text-warning\" ng-if=\"isPythonDeprecated(codeEnv.pythonInterpreter)\" toggle=\"tooltip\" title=\"{{codeEnv.pythonInterpreter}} is deprecated and will be removed soon\">\n                                    <i class=\"icon-dku-warning\"></i>\n                                </span>\n                            </td>\n                            <td>{{ codeEnv.owner }}</td>\n                            <td title=\"{{codeEnv.kernelSpecName}}\">{{ codeEnv.kernelSpecName }}</td>\n                            <td>{{ codeEnv.deploymentMode }}</td>\n                            <td>\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\" style=\"text-decoration:none\" ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                    <i class=\"icon-trash\" />\n                                </a>\n                            </td>\n                        </tr>\n                    </tbody>\n                </table>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/new-R-env-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"New R env\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\" name=\"newCodeEnvForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Deployment type</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<select dku-bs-select ng-model=\"newEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" ng-model=\"newEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">External Conda env name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" required ng-model=\"newEnv.externalCondaEnvName\" />\n\t\t\t\t</div>\n\t\t\t</div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Conda</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.conda\" />\n                        <span class=\"help-inline\">Use Conda</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Mandatory packages</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.installCorePackages\" />\n                        <span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Jupyter</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.installJupyterSupport\" />\n                        <span class=\"help-inline\">Install support for Jupyter notebooks</span>\n                    </label>\n                </div>\n            </div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/new-python-env-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"New Python env\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\" name=\"newCodeEnvForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Deployment type</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<select dku-bs-select ng-model=\"newEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" ng-model=\"newEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">External Conda env name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" required ng-model=\"newEnv.externalCondaEnvName\" />\n\t\t\t\t</div>\n\t\t\t</div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Python</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"newEnv.pythonInterpreter\" ng-options=\"x[0] as x[1] for x in pythonInterpreters\" />\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE' && newEnv.pythonInterpreter == 'CUSTOM'\">\n                <label for=\"\" class=\"control-label\">Python executable</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"newEnv.customInterpreter\"  />\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Conda</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.conda\" />\n                        <span class=\"help-inline\">Use conda</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                <label for=\"\" class=\"control-label\">Mandatory packages</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.installCorePackages\"/>\n                        <span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'AUTOMATION_SINGLE' && !isDeployer()\">\n                <label for=\"\" class=\"control-label\">Jupyter</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"newEnv.installJupyterSupport\"/>\n                        <span class=\"help-inline\">Install support for Jupyter notebooks</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"isPythonDeprecated()\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> The selected Python interpreter is deprecated and will be removed soon.\n                </div>\n            </div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/python-edit.html", "<div class=\"fh code-env\" global-keydown=\"{'ctrl-s meta-s':'saveAndMaybePerformChanges(false)'}\">\n    <div class=\"h100 row-fluid\">\n        <div class=\"span2 offset0 nav-list-sidebar sidebar-admin\" style=\"padding-top: 0;\">\n            <div class=\"horizontal-flex\" style=\"height: auto;\">\n                <div class=\"flex mx-textellipsis\">\n                    <h4 class=\"mx-textellipsis\" title=\"{{codeEnv.envName}}\">{{codeEnv.envName}}</h4>\n                </div>\n                <div class=\"noflex center-children\" style=\"font-size: 14px; opacity: 0.8;\" ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <div custom-element-popup cep-position=\"align-right-bottom\" close-on-click=\"true\">\n                        <i class=\"icon-cog mainzone cursor-pointer\" ng-click=\"togglePopover()\"></i>\n                        <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                            <li ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\"><i class=\"icon-trash\"></i>&nbsp;Delete</a>\n                            </li>\n                            <li>\n                                <a ng-click=\"getEnvDiagnostic(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Get diagnostic</a>\n                            </li>\n                        </ul>\n                    </div>\n                </div>\n            </div>\n            <ul>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'info'}\" full-click>\n                    <a ng-click=\"uiState.active = 'info'\" main-click>General</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'permissions'}\" full-click ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                    <a ng-click=\"uiState.active = 'permissions'\" main-click>Permissions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'packages'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_NON_MANAGED_PATH' || codeEnv.deploymentMode == 'PLUGIN_NON_MANAGED' || codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                    <a ng-click=\"uiState.active = 'packages'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'versions'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_VERSIONED'\">\n                    <a ng-click=\"uiState.active = 'versions'\" main-click>Versions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'managed'}\" full-click ng-if=\"codeEnv.deploymentMode == 'PLUGIN_MANAGED' || codeEnv.deploymentMode == 'DSS_INTERNAL'\">\n                    <a ng-click=\"uiState.active = 'managed'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'single'}\" full-click ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                    <a ng-click=\"uiState.active = 'single'\" main-click>Current version</a>\n                </li>\n                <li ng-if=\"!['EXTERNAL_CONDA_NAMED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\" ng-class=\"{'l1': true, 'active': uiState.active == 'resources'}\" full-click>\n                    <a ng-click=\"uiState.active = 'resources'\" main-click>Resources</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'logs'}\" full-click>\n                    <a ng-click=\"uiState.active = 'logs'\" main-click>Logs</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'usages'}\" full-click ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <a ng-click=\"uiState.active = 'usages'\" main-click>Usages</a>\n                </li>\n                <li ng-if=\"!isDeployer()\" ng-class=\"{'l1': true, 'active': uiState.active == 'containers'}\" full-click ng-if=\"['AUTOMATION_VERSIONED', 'AUTOMATION_SINGLE', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'containers'\" main-click>Containerized execution</a>\n                </li>\n            </ul>\n            <div ng-include=\"'/templates/admin/code-envs/common/save-update-buttons.html'\"></div>\n        </div>\n        <div class=\"span10 h100 offset0 boxed-next-to-sidebar no-padding\" ng-switch=\"uiState.active\">\n            <div ng-switch-when=\"info\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env</h1>\n                <div block-api-error />\n                <form class=\"dkuform-horizontal\">\n                    <div class=\"section\">\n                    <h2>General env info</h2>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Mode</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.deploymentMode}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Owner</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.owner}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['AUTOMATION_NON_MANAGED_PATH', 'PLUGIN_NON_MANAGED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                        <label for=\"\" class=\"control-label\">Location of the environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.noVersion.path}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                        <label for=\"\" class=\"control-label\">Conda environment</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.noVersion.desc.externalCondaEnvName\" />\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\" ng-if=\"appConfig.sparkEnabled && ['AUTOMATION_NON_MANAGED_PATH', 'PLUGIN_NON_MANAGED', 'EXTERNAL_CONDA_NAMED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                    <h2>Spark</h2>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Yarn Python executable</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.noVersion.desc.yarnPythonBin\" />\n                            <span class=\"help-inline\">Python binary on the Yarn nodes for Pyspark (save, remove then re-install jupyter support to update in notebooks)</span>\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2>Extra options</h2>\n\n                    <div ng-if=\"codeEnv\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Override imported settings</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.envSettings.overrideImportedEnvSettings\" />\n                                </label>\n                             </div>\n                        </div>\n\n                         <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings && codeEnv.desc.conda\">\n                             <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                             <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                             </div>\n                         </div>\n                         <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings && codeEnv.desc.conda\">\n                             <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                             <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                             </div>\n                         </div>\n                        <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'pip install'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.pipInstallExtraOptions\" add-label=\"Add option for 'pip install'\" value-placeholder=\"E.g. -i, --trusted-host...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"codeEnv.envSettings.overrideImportedEnvSettings\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'virtualenv'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.envSettings.virtualenvCreateExtraOptions\" add-label=\"Add option for 'virtualenv'\" value-placeholder=\"E.g. -p, --system-site-packages...\"/>\n                            </div>\n                        </div>\n                    </div>\n                    </div>\n\n\n                    <div class=\"section\" ng-if=\"!isDeployer()\">\n                    <h2>Jupyter</h2>\n                    <div class=\"control-group\" ng-if=\"codeEnv.noVersion != null && !codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.noVersion.kernelSpecName || 'not installed'}}</div>\n                        </div>\n                    </div>\n                     <div class=\"control-group\" ng-if=\"codeEnv.currentVersion != null && !codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.currentVersion.kernelSpecName || 'not installed'}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>Unable to check status</div>\n                             <div ng-if=\"codeEnv.kernelSpecsListingError\" api-error-alert=\"codeEnv.kernelSpecsListingError\" />\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"!!codeEnv.noVersion\">\n                        <div class=\"controls\">\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs ipykernel)</span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"!!codeEnv.currentVersion\">\n                        <div class=\"controls\">\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs ipykernel)</span>\n                        </div>\n                    </div>\n                    </div>\n                </form>\n\n                <!-- <pre class=\"debug\">{{codeEnv|json}}</pre> -->\n            </div>\n\n            <div ng-switch-when=\"usages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env usages</h1>\n                <div class=\"section\">\n                    <code-env-usage env-lang=\"{{envLang}}\" env-name=\"{{codeEnv.envName}}\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"permissions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Permissions</h1>\n                <div class=\"section\">\n                    <div code-env-security-permissions code-env=\"codeEnv\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"managed\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div python-version=\"codeEnv.noVersion\" update-version=\"updateEnvVersion\" editable=\"false\"></div>\n                </div>\n            </div>\n            <div ng-switch-when=\"single\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Version</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div python-version=\"codeEnv.currentVersion\" update-version=\"updateEnvVersion\" editable=\"true\"></div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"versions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Versions</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                    <div>\n                        <button class=\"btn btn--secondary\" ng-click=\"openImportEnvVersionModal()\">Import new version</button>\n                    </div>\n                    <div ng-repeat=\"version in codeEnv.versions | orderBy: '-versionId' \" ng-class=\"{'version-separator' : $index > 0}\">\n                        <div python-version=\"version\"\n                            version-spec-is-dirty=\"versionSpecIsDirty\"\n                            save-version=\"saveVersionAndMaybePerformChanges\"\n                            update-version=\"updateEnvVersion\"\n                            install-jupyter-support=\"installJupyterSupport\"\n                            remove-jupyter-support=\"removeJupyterSupport\"\n                            editable=\"true\"\n                            with-save-update=\"true\"\n                            can-version-be-updated=\"canVersionBeUpdated\"\n                        ></div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"packages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <button class=\"btn btn--secondary\" ng-click=\"fetchNonManagedEnvDetails()\">Fetch packages list</button>\n\n                <div class=\"row-fluid\" ng-if=\"nonManagedEnvDetails\">\n                    <div class=\"span6\" ng-if=\"nonManagedEnvDetails.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Conda)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.condaEnvSpec}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Pip)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.nocondaEnvSpec}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"logs\" class=\"h100 vertical-flex paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env logs</h1>\n                <div class=\"flex\">\n                    <div class=\"section fh\">\n                        <div simple-logs logs=\"logs\" obj-id=\"[envLang, envName]\" get-log=\"getLog\" download-url=\"downloadURL\"/>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"containers\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Containerized execution</h1>\n                <div class=\"section\">\n                    <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_VERSIONED'\">\n                        <div ng-repeat=\"version in codeEnv.versions | orderBy: '-versionId'\" ng-class=\"{'version-separator' : $index > 0}\">\n                            <div container-version=\"version\"\n                                set-for-all-versions=\"setContainerConfForAllVersions\"\n                                version-spec-is-dirty=\"versionSpecIsDirty\"\n                                save-version=\"saveVersionAndMaybePerformChanges\"\n                                update-version=\"updateEnvVersion\"\n                                can-version-be-updated=\"canVersionBeUpdated\"\n                                with-save-update=\"true\"\n                                env-lang=\"envLang\"\n                                deployment-mode=\"codeEnv.deploymentMode\"\n                            ></div>\n                        </div>\n                    </div>\n                    <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                        <div code-env-containers code-env=\"codeEnv.currentVersion\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                    </div>\n                    <div ng-if=\"['PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                        <div code-env-containers code-env=\"codeEnv.noVersion\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-if=\"codeEnv.deploymentMode !== 'EXTERNAL_CONDA_NAMED'\" ng-switch-when=\"resources\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Resources</h1>\n                <div class=\"section\">\n                    <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_VERSIONED'\">\n                        <div ng-repeat=\"version in codeEnv.versions | orderBy: '-versionId'\" ng-class=\"{'version-separator' : $index > 0}\">\n                            <div resources-version=\"version\"\n                                env-name=\"codeEnv.envName\"\n                                set-for-all-versions=\"setResourcesConfForAllVersions\"\n                                version-spec-is-dirty=\"versionSpecIsDirty\"\n                                save-version=\"saveVersionAndMaybePerformChanges\"\n                                update-version=\"updateEnvVersion\"\n                                can-version-be-updated=\"canVersionBeUpdated\"\n                                with-save-update=\"true\"\n                                editor-options=\"codeEnvResourcesEditorOptions\"\n                            ></div>\n                        </div>\n                    </div>\n                    <div ng-if=\"codeEnv.deploymentMode == 'AUTOMATION_SINGLE'\">\n                        <div code-env-resources code-env=\"codeEnv.currentVersion\" env-name=\"codeEnv.envName\" editor-options=\"codeEnvResourcesEditorOptions\" node-type=\"AUTOMATION\" can-update-code-env=\"codeEnv.canUpdateCodeEnv\" deployment-mode=\"'AUTOMATION_SINGLE'\"></div>\n                    </div>\n                    <div ng-if=\"codeEnv.deploymentMode == 'PLUGIN_MANAGED'\">\n                        <div code-env-resources code-env=\"codeEnv.noVersion\" env-name=\"codeEnv.envName\" editor-options=\"codeEnvResourcesEditorOptions\" node-type=\"AUTOMATION\" can-update-code-env=\"codeEnv.canUpdateCodeEnv\" deployment-mode=\"'PLUGIN_MANAGED'\"></div>\n                    </div>\n                </div>\n            </div>\n\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/automation/python-version.html", "<div>\n    <div class=\"horizontal-flex\" style=\"margin-bottom: 10px;\">\n        <h4 class=\"flex mx-textellipsis\">\n            <span>Version {{version.versionId}}</span>\n        </h4>\n        <div ng-if=\"withSaveUpdate\" class=\"noflex\">\n            <div ng-if=\"specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary\" style=\"width: 100%\" ng-click=\"saveVersionEnv(false)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save\n                </button>\n            </div>\n            <div ng-if=\"!specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary\" ng-disabled=\"true\" style=\"width: 100%\" >\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Saved!\n                </button>\n            </div>\n            <div style=\"display: inline-block; width: 10px;\"></div> <!-- separation -->\n            <div ng-if=\"canBeUpdated() && specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success\" ng-click=\"saveVersionEnv(true)\" style=\"width: 100%;\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save and update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated() && !specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success\" ng-click=\"updateVersionEnv()\" style=\"width: 100%;\">\n                    Update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated()\" style=\"display: inline-block; width: 20px; margin-top: 5px;\">\n                <span custom-element-popup cep-position=\"align-right-bottom\">\n                    <a class=\"mainzone dropdown-toggle\" ng-click=\"togglePopover()\">\n                        <i class=\"icon-cog\" style=\"color:#999;margin-left: 4px;position: relative;top: 1px;\"/>\n                    </a>\n                    <div class=\"popover custom-element-popup-popover dropdown-menu pull-right simple dkuform-horizontal\" style=\"padding: 10px 20px; z-index: 10;\">\n                        <label class=\"checkbox\">\n                            <input id=\"allCheckbox\" type=\"checkbox\" ng-model=\"uiState.upgradeAllPackages\"></input>\n                            Update all packages\n                        </label>\n                        <span class=\"help-inline\" style=\"color: #999\">\n                            Updates packages in the virtual environment so that the installed packages match the list and versions of the packages specified by the user.\n                        </span>\n                        <label class=\"checkbox\">\n                            <input id=\"rebuildCheckbox\" type=\"checkbox\" ng-model=\"uiState.forceRebuildEnv\"></input>\n                            Rebuild env\n                        </label>\n                        <span class=\"help-inline\" style=\"color: #999\">\n                            Clears the code environment and rebuilds it from scratch\n                        </span>\n                    </div>\n                </span>\n\n            </div>\n        </div>\n    </div>\n\n    <form class=\"dkuform-horizontal\">\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Path</label>\n            <div class=\"controls\">\n                <div>{{version.path}}</div>\n            </div>\n        </div>\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Python interpreter</label>\n            <div class=\"controls\">\n                <div>\n                    <span ng-class=\"{'text-warning': isPythonDeprecated(version.desc.pythonInterpreter)}\">{{version.desc.pythonInterpreter == 'CUSTOM' ? version.desc.customInterpreter : version.desc.pythonInterpreter}} </span>\n                    <span class=\"text-warning\" ng-if=\"isPythonDeprecated(version.desc.pythonInterpreter)\" toggle=\"tooltip\" title=\"{{version.desc.pythonInterpreter}} is deprecated and will be removed soon\">\n                        <i class=\"icon-dku-warning\"></i>\n                    </span>\n                </div>\n            </div>\n        </div>\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Core packages versions</label>\n            <div class=\"controls\">\n                <select dku-bs-select ng-options=\"x[0] as x[1] for x in [['LEGACY_PANDAS023', 'Pandas 0.23 (legacy)'],['PANDAS10', 'Pandas 1.0 (Python 3.6 and above)'],['PANDAS11', 'Pandas 1.1 (Python 3.6 and above)'],['PANDAS12', 'Pandas 1.2 (Python 3.7 and above)'],['PANDAS13', 'Pandas 1.3 (Python 3.7 and above)'],['PANDAS14', 'Pandas 1.4 (Python 3.8 and above)'],['PANDAS15', 'Pandas 1.5 (Python 3.8 and above)'],['PANDAS20', 'Pandas 2.0 (Python 3.8 and above)'],['PANDAS21', 'Pandas 2.1 (Python 3.9 and above)'],['PANDAS22', 'Pandas 2.2 (Python 3.9 and above)'],['PANDAS23', 'Pandas 2.3 (Python 3.9 and above)']]\" ng-model=\"version.desc.corePackagesSet\" ng-change=\"refreshMandatoryPackageList()\"/>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"appConfig.sparkEnabled\">\n            <label for=\"\" class=\"control-label\">Yarn Python executable</label>\n            <div class=\"controls\">\n                <input type=\"text\" ng-model=\"version.desc.yarnPythonBin\" />\n                <span class=\"help-inline\">Python binary on the Yarn nodes for Pyspark (save, remove then re-install jupyter support to update in notebooks)</span>\n            </div>\n        </div>\n        <div class=\"control-group\">\n            <label for=\"\" class=\"control-label\">Ready</label>\n            <div class=\"controls\">\n                <div>{{version.ready}}</div>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"version.versionId\"> <!-- only for versioned envs -->\n            <label for=\"\" class=\"control-label\">Usages by bundles</label>\n            <div class=\"controls\">\n                <ul>\n                    <li ng-repeat=\"link in version.links\">\n                        <span>{{link}}</span>\n                        <span ng-if=\"version.kernelSpecNames[link]\"> with kernel : {{version.kernelSpecNames[link]}}</span>\n                    </li>\n                </ul>\n            </div>\n        </div>\n        <div ng-if=\"version.desc.envSettings\">\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Inherit global settings</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"version.desc.envSettings.inheritGlobalSettings\" />\n                    </label>\n                </div>\n            </div>\n\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings && version.desc.conda\">\n                <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings && version.desc.conda\">\n                <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings\">\n                <label for=\"\" class=\"control-label\">Extra options for 'pip install'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.pipInstallExtraOptions\" add-label=\"Add option for 'pip install'\" value-placeholder=\"E.g. -i, --trusted-host...\"/>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"!version.desc.envSettings.inheritGlobalSettings\">\n                <label for=\"\" class=\"control-label\">Extra options for 'virtualenv'</label>\n                <div class=\"controls\">\n                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                    <ng2-values-list [(items)]=\"version.desc.envSettings.virtualenvCreateExtraOptions\" add-label=\"Add option for 'virtualenv'\" value-placeholder=\"E.g. -p, --system-site-packages...\"/>\n                </div>\n            </div>\n        </div>\n        <div class=\"control-group\" ng-if=\"version.versionId\"> <!-- only for versioned envs -->\n            <div class=\"controls\">\n                <button class=\"btn btn--secondary\" ng-click=\"installJupyterSupportVersion()\" >(Re)install Jupyter support</button>\n                <button class=\"btn btn--secondary\" ng-click=\"removeJupyterSupportVersion()\" >Remove Jupyter support</button>\n                <span class=\"help-inline\">(needs ipykernel)</span>\n            </div>\n        </div>\n    </form>\n    <div class=\"row-fluid\">\n        <div class=\"span6\" ng-if=\"version.desc.conda\">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Base packages (Conda)</legend>\n            <pre class=\"package-list\"># These packages cannot be removed nor reversioned\n            {{version.mandatoryCondaEnvironment}}</pre>\n            <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (Conda)</legend>\n            <p class=\"small\" style=\"color:#666\">\n                These are the packages that you actually want to install <span style=\"margin-left: 10px;\" data-placement=\"bottom\" dku-md-popover='Specify the packages you want:\n\n* one row per package\n* each row is a Conda package match specification ( [link](https://conda.io/docs/user-guide/tasks/build-packages/package-spec.html#package-match-specifications) )\n\nExamples of package specifications:\n\n* pandas=0.20.3\n* numpy>=0.19' dku-md-title=\"Package list\" class=\"step-help-popover\" popover-clazz=\"step-help-popover\" >\n                    <i class=\"icon-question-sign\"></i>\n                </span>\n            </p>\n            <pre class=\"package-list\" ng-if=\"!editable\">{{version.specCondaEnvironment}}</pre>\n            <div class=\"codemirror\" ng-if=\"editable\">\n                <textarea ng-model=\"version.specCondaEnvironment\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n            </div>\n        </div>\n        <div class=\"span6 \">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Base packages (Pip)</legend>\n            <pre class=\"package-list\"># These packages cannot be removed nor reversioned\n            {{version.mandatoryPackageList}}</pre>\n            <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (Pip)</legend>\n            <pre class=\"package-list\" ng-if=\"!editable\">{{version.specPackageList}}</pre>\n            <p class=\"small\" style=\"color:#666\">\n                These are the packages that you actually want to install <span style=\"margin-left: 10px;\" data-placement=\"bottom\" dku-md-popover='Specify the packages you want:\n\n* one row per package\n* each row is a PIP package specification ( [link](https://setuptools.readthedocs.io/en/latest/pkg_resources.html#requirement-objects) )\n\nExamples of package specifications:\n\n* pandas==0.20.3\n* numpy>=0.19' dku-md-title=\"Package list\" class=\"step-help-popover\" popover-clazz=\"step-help-popover\" >\n                    <i class=\"icon-question-sign\"></i>\n                </span>\n            </p>\n\n            <div ng-if=\"version.desc.conda\" class=\"alert alert-warning\">\n                    <i class=\"icon-warning-sign\"></i>&nbsp;\n                    Do not put packages here that are installed as conda packages or available as conda packages (including on conda-forge). Doing so is very likely to cause issues with those packages.\n            </div>\n\n            <div class=\"codemirror\" ng-if=\"editable\">\n                <textarea ng-model=\"version.specPackageList\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n            </div>\n        </div>\n    </div>\n    <div class=\"row-fluid\">\n        <div class=\"span6\" ng-if=\"version.desc.conda\">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Actual packages (Conda)</legend>\n            <pre class=\"package-list\">{{version.actualCondaEnvironment}}</pre>\n        </div>\n        <div class=\"span6 \">\n            <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Actual packages (Pip)</legend>\n            <pre class=\"package-list\">{{version.actualPackageList}}</pre>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-envs/automation/resources-version.html", "<div>\n    <div class=\"horizontal-flex\" style=\"margin-bottom: 10px;\">\n        <h4 class=\"flex mx-textellipsis\">\n            <span>Version {{version.versionId}}</span>\n        </h4>\n        <div ng-if=\"withSaveUpdate\" class=\"noflex\">\n            <div ng-if=\"specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary w100\" ng-click=\"saveVersionEnv(false)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save\n                </button>\n            </div>\n            <div ng-if=\"!specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 100px; margin-top: 5px;\">\n                <button class=\"btn btn--primary w100\" ng-disabled=\"true\" >\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Saved!\n                </button>\n            </div>\n            <div style=\"display: inline-block; width: 10px;\"></div> <!-- separation -->\n            <div ng-if=\"canBeUpdated() && specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success w100\" ng-click=\"saveVersionEnv(true)\">\n                    <i class=\"icon-save\"></i>\n                    &nbsp;Save and update\n                </button>\n            </div>\n            <div ng-if=\"canBeUpdated() && !specIsDirty()\" class=\"btn-group code-env__buttons\" style=\"display: inline-block; width: 150px; margin-top: 5px;\">\n                <button class=\"btn btn--success w100\" ng-click=\"updateVersionEnv()\">\n                    Update\n                </button>\n            </div>\n        </div>\n        <div ng-if=\"canBeUpdated()\" style=\"display: inline-block; width: 20px; margin-top: 5px;\">\n            <span custom-element-popup cep-position=\"align-right-bottom\">\n                <a class=\"mainzone dropdown-toggle\" ng-click=\"togglePopover()\">\n                    <i class=\"icon-cog\" style=\"color:#999;margin-left: 4px;position: relative;top: 1px;\"></i>\n                </a>\n                <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                <li>\n                    <a ng-click=\"setThisForAllVersions()\"><i class=\"icon-copy\"></i>&nbsp;Set for all versions</a>\n                </li>\n            </ul>\n            </span>\n        </div>\n    </div>\n    <div code-env-resources code-env=\"version\" env-name=\"envName\" editor-options=\"codeEnvResourcesEditorOptions\" node-type=\"AUTOMATION\" can-update-code-env=\"canBeUpdated()\" deployment-mode=\"'AUTOMATION_VERSIONED'\">\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/code-env-containers.html", "<div class=\"h100 vertical-flex\">\n    <div block-api-error/>\n    <div ng-if=\"!addLicInfo.containersLicensed\" class=\"alert alert-error\">\n        <i class=\"icon-warning-sign\"/>&nbsp;Your license does not cover usage of containers\n    </div>\n\n    <div class=\"locked-feature\" ng-if=\"appConfig.communityEdition\">\n        <div class=\"banner\">\n            Containers are not available with your\n            <span class=\"edition\">Free Edition</span> license\n        </div>\n        <div include-no-scope=\"/templates/profile/community-vs-enterprise-try.html\"></div>\n    </div>\n\n    <div class=\"noflex\" ng-if=\"addLicInfo.containersLicensed\">\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\">\n                <label class=\"control-label\">Build for</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" ng-model=\"containerSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"NONE\" class=\"exclude-from-smart-change\"/>\n                        None\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"containerSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALL\" class=\"exclude-from-smart-change\"/>\n                        All container configurations\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"containerSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALLOWED\" class=\"exclude-from-smart-change\"/>\n                        Selected container configurations\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"containerSelection() === 'ALLOWED'\">\n                <div class=\"controls\">\n                    <select dku-bs-select multiple=\"multiple\" ng-model=\"codeEnv.containerConfs\"\n                            ng-options=\"c for c in containerNames\"></select>\n                </div>\n            </div>\n        </form>\n        <div class=\"alert alert-info\" ng-show=\"containerSelection() === 'ALL' || (containerSelection() === 'ALLOWED' && codeEnv.containerConfs.length > 0)\">\n            <span ng-show=\"codeEnv.allContainerConfs\">Code environment images will be built for <strong>all current containers configurations</strong>.<br /></span>\n            You will have to update this code environment again when you edit these container configurations.\n        </div>\n        <div class=\"alert alert-error\" ng-show=\"outdatedContainerConfs.length > 0 && containerSelection() !== 'ALL' \">\n            <h5>\n                <i class=\"icon-dku-error\"></i>\n                Some of the container configurations you have chosen for this code environment do not exist anymore:\n            </h5>\n            <ul class=\"item-list\">\n                <li ng-repeat=\"containerConf in outdatedContainerConfs\">{{ containerConf }}</li>\n            </ul>\n            <button class=\"btn btn--secondary\" ng-click=\"removeOutdatedContainerConfs()\">Remove from selected containers</button>\n        </div>\n\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\">\n                <label class=\"control-label\">Build for</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" ng-model=\"sparkKubernetesSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"NONE\" class=\"exclude-from-smart-change\"/>\n                        None\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"sparkKubernetesSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALL\" class=\"exclude-from-smart-change\"/>\n                        All Spark-on-K8S configurations\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"sparkKubernetesSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALLOWED\" class=\"exclude-from-smart-change\"/>\n                        Selected Spark-on-K8S configurations\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-show=\"sparkKubernetesSelection() === 'ALLOWED'\">\n                <div class=\"controls\">\n                    <select dku-bs-select multiple=\"multiple\" ng-model=\"codeEnv.sparkKubernetesConfs\"\n                            ng-options=\"c for c in sparkKubernetesNames\"></select>\n                </div>\n            </div>\n        </form>\n        <div class=\"alert alert-info\" ng-show=\"sparkKubernetesSelection() === 'ALL' || (sparkKubernetesSelection() === 'ALLOWED' && codeEnv.sparkKubernetesConfs.length > 0)\">\n            <span ng-show=\"codeEnv.allSparkKubernetesConfs\">Code environment images will be built for <strong>all current Spark-on-K8S configurations</strong>.<br /></span>\n            You will have to update this code environment again when you edit these Spark-on-K8S configurations.\n        </div>\n        <div class=\"alert alert-error\" ng-show=\"outdatedSparkKubernetesConfs.length > 0 && sparkKubernetesSelection() !== 'ALL' \">\n            <h5>\n                <i class=\"icon-dku-error\"></i>\n                Some of the Spark-on-K8S configurations you have chosen for this code environment do not exist anymore:\n            </h5>\n            <ul class=\"item-list\">\n                <li ng-repeat=\"sparkKubernetesConf in outdatedSparkKubernetesConfs\">{{ sparkKubernetesConf }}</li>\n            </ul>\n            <button class=\"btn btn--secondary\" ng-click=\"removeOutdatedSparkKubernetesConfs()\">Remove from selected Spark-on-K8S</button>\n        </div>\n\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\">\n                <label class=\"control-label\">Rebuild Code Studio templates</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeStudioRebuildTemplateSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"NONE\" class=\"exclude-from-smart-change\"/>\n                        None\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeStudioRebuildTemplateSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALL\" class=\"exclude-from-smart-change\"/>\n                        All templates using this Code Env\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeStudioRebuildTemplateSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ASK\" class=\"exclude-from-smart-change\"/>\n                        Ask on Code Env update\n                    </label>\n                </div>\n            </div>\n        </form>\n\n        <form ng-if=\"envLang === 'PYTHON' && deploymentMode !== 'EXTERNAL_CONDA_NAMED'\" class=\"dkuform-horizontal\">\n            <div ng-if=\"enableCodeEnvResources\" class=\"control-group\">\n                <label class=\"control-label\">Resources initialization</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeEnv.desc.dockerImageResources\" ng-model-options=\"{ getterSetter: true }\" value=\"NONE\" class=\"exclude-from-smart-change\"/>\n                        None\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeEnv.desc.dockerImageResources\" ng-model-options=\"{ getterSetter: true }\" value=\"INIT\" class=\"exclude-from-smart-change\"/>\n                        Run resources initialization script\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"codeEnv.desc.dockerImageResources\" ng-model-options=\"{ getterSetter: true }\" value=\"COPY\" class=\"exclude-from-smart-change\"/>\n                        Copy resources from local code environment\n                    </label>\n                </div>\n            </div>\n            <div ng-if=\"!enableCodeEnvResources\" class=\"alert alert-warning\">\n                    Running the code environment resources initialization script has been forbidden by your administrator.\n            </div>\n        </form>\n\n        <div ng-if=\"envLang === 'PYTHON' && deploymentMode !== 'EXTERNAL_CONDA_NAMED' && deploymentMode !== 'DSS_INTERNAL'\" class=\"dkuform-horizontal mbot8\">\n            <h2 class=\"settings-section-title\">Container runtime additions</h2>\n\n            <div add-remove ng-model=\"codeEnv.desc.predefinedContainerHooks\">\n                <div ng-repeat=\"predef in codeEnv.desc.predefinedContainerHooks\" class=\"repeatable-config-block\">\n                    <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                        <i class=\"dku-icon-trash-16\"></i>\n                    </button>\n                    <div class=\"control-group\">\n                        <label for=\"runtimeAdditionType\" class=\"control-label\">Type</label>\n                        <div class=\"controls\">\n                            <select id=\"runtimeAdditionType\" dku-bs-select ng-model=\"predef.type\" \n                                ng-options=\"x[0] as x[1] for x in runtimeAdditionTypes\"\n                                options-descriptions=\"runtimeAdditionTypesDescriptions\"\n                                layout=\"list\"\n                            />\n                        </div>\n                    </div>\n                </div>\n                <button type=\"button\" class=\"btn btn--primary btn--text btn--dku-icon\" ng-click=\"add({})\">\n                    <i class=\"dku-icon-plus-16\" />  Add\n                </button>\n                <div ng-if=\"containsMismatchedPythonHooks()\" class=\"alert alert-warning mtop8\">\n                    <i class=\"icon-warning-sign\"/>&nbsp;Your container runtime additions contain one or more Python installations that are not required for your current interpreter version.\n                </div>\n            </div>\n        </div>\n\n        <div ng-if=\"deploymentMode !== 'EXTERNAL_CONDA_NAMED'\" class=\"dkuform-horizontal\">\n            <h2 class=\"settings-section-title\">Advanced container settings</h2>\n            <form class=\"dkuform-horizontal\">\n                <div class=\"control-group\">\n                    <label for=\"atStart\" class=\"control-label\">At-start Dockerfile</label>\n                    <div class=\"controls\">\n                        <textarea id=\"atStart\" class=\"textarea--bounded-dimensions\" ng-model=\"codeEnv.desc.dockerfileAtStart\" />\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"before\" class=\"control-label\">Before-packages Dockerfile</label>\n                    <div class=\"controls\">\n                        <textarea id=\"before\" class=\"textarea--bounded-dimensions\" ng-model=\"codeEnv.desc.dockerfileBeforePackages\" />\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"after\" class=\"control-label\">After-packages Dockerfile</label>\n                    <div class=\"controls\">\n                        <textarea id=\"after\" class=\"textarea--bounded-dimensions\" ng-model=\"codeEnv.desc.dockerfileAfterPackages\" />\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"atEnd\" class=\"control-label\">At-end Dockerfile</label>\n                    <div class=\"controls\">\n                        <textarea id=\"atEnd\" class=\"textarea--bounded-dimensions\" ng-model=\"codeEnv.desc.dockerfileAtEnd\" />\n                    </div>\n                </div>\n                <div class=\"control-group\">\n                    <label for=\"cacheControl\" class=\"control-label\">Cache control statement location</label>\n                    <div class=\"controls\">\n                        <select id=\"cacheControl\" dku-bs-select ng-model=\"codeEnv.desc.containerCacheBustingLocation\" ng-options=\"x[0] as x[1] for x in cacheLocations\" />\n                    </div>\n                </div>\n            </form>\n       </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/code-env-resources.html", "<div class=\"h100 vertical-flex code-env-resources__container\">\n    <div block-api-error></div>\n    <div class=\"alert alert-warning\" ng-if=\"!enableCodeEnvResources\">\n        Running the code environment resources initialization script has been forbidden by your administrator.\n    </div>\n\n    <div class=\"row-fluid\" disabled-if=\"!enableCodeEnvResources\">\n        <div class=\"span8\">\n            <h2>Initialization script</h2>\n            <code-snippet-editor\n                class=\"code-env-resources__init-script\"\n                code=\"codeEnv.resourcesInitScript\"\n                sample-type=\"'python'\"\n                categories=\"['py-code-env-resources', 'user-py-code-env-resources']\"\n                save-category=\"'user-py-code-env-resources'\"\n                editor-options=\"editorOptions\"></code-snippet-editor>\n\n            <h2>Environment variables</h2>\n            <table class=\"table table-striped table-hover\">\n                <thead>\n                    <tr>\n                      <th>Name</th>\n                      <th>Value</th>\n                      <th>Type</th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr ng-repeat=\"(name, envVar) in resourcesEnvironmentVariables\">\n                      <td>{{name}}</td>\n                      <td>{{envVar.value}}</td>\n                      <td>{{envVar.type | niceConst}}</td>\n                    </tr>\n                </tbody>\n            </table>\n        </div>\n\n        <div class=\"span4\">\n            <h2>API node behavior</h2>\n            <div class=\"control-group\">\n                <div class=\"controls\">\n                    <input ng-if=\"enableCodeEnvResources\" type=\"checkbox\" ng-model=\"codeEnv.desc.updateResourcesApiNode\"></input>\n                    <input ng-if=\"!enableCodeEnvResources\" type=\"checkbox\" disabled></input>\n                    <span class=\"help-inline\">Run resources initialization script on API node.</span>\n                </div>\n            </div>\n\n            <div class=\"code-env-resources-explorer__title-wrapper\">\n                <h2 class=\"code-env-resources-explorer__title\">Files{{showResourcesSize || computingSize ? \":\" : \"\" }}\n                    {{!computingSize && showResourcesSize ? (resourcesSize | fileSizeOrNA) : \"\" }}\n                    <i class=\"dku-loader icon-spin dku-loader--inlined h20 w20\" ng-if=\"computingSize\"></i>\n                </h2>\n                <span ng-if=\"!showResourcesSize\" class=\"code-env-resources-explorer__info dku-tiny-text-sb\">Refresh to compute size</span>\n                <a class=\"refresh-button link-std code-env-resources-explorer__compute-button\" ng-click=\"computeSize()\">\n                    <i class=\"icon-refresh\"></i>\n                </a>\n                <button\n                    class=\"btn btn--outline btn--primary code-env-resources-explorer__upload-button\"\n                    ng-disabled=\"!canBeUpdated()\"\n                    ng-click=\"openUploadResourcesModal()\">Upload</button>\n                <button\n                    class=\"btn btn--outline btn--danger code-env-resources-explorer__clear-button\"\n                    ng-disabled=\"!canBeUpdated()\"\n                    ng-click=\"clearResources()\">\n                    Clear\n                </button>\n            </div>\n            <div class=\"code-env-resources-explorer__browser\">\n                <browse-path class=\"flex vertical-flex\"\n                    title=\"Resources directory\"\n                    path=\"resourcesBrowserPath\"\n                    browse-fn=\"resourcesBrowseFn\"\n                    can-select-fn=\"resourcesCanSelectFn\"\n                    items-are-projects=\"false\"\n                    searchable=\"false\"\n                    register-execute-browse-fn=\"registerExecuteResourcesBrowseFn\"\n                    show-size=\"showResourcesSize\">\n                </browse-path>\n            </div>\n        </div>\n    </div>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/code-env-usage.html", "<div ng-class=\"{'code-env-usages__div__loaded':$ctrl.accessibleUsages}\">\n    <div block-api-error />\n    <form class=\"dkuform-horizontal\">\n        <div class=\"control-group\" ng-if=\"!$ctrl.accessibleUsages\">\n            <p>Searching for all uses of a code env may take a long time on large instances.</p>\n            <button class=\"btn btn--primary\" ng-click=\"$ctrl.getUsage()\">Compute Usage</button>\n        </div>\n        <div ng-if=\"$ctrl.accessibleUsages\">\n            <div ng-if=\"$ctrl.inaccessibleObjectsCount > 0\" class=\"control-group\">\n                <div><strong>{{$ctrl.inaccessibleObjectsCount}}</strong> {{'object' | plurify:$ctrl.inaccessibleObjectsCount}} <ng-pluralize count=\"objectsNotAccessible\" when=\"{'one': 'is', 'other': 'are'}\"></ng-pluralize> not accessible according to your current permissions.</div>\n            </div>\n            <div>\n                <div class=\"flex std-list-search-box\">\n                    <span class=\"add-on\"><i class=\"icon-dku-search\"></i></span>\n                    <input type=\"search\" \n                           ng-model=\"$ctrl.uiState.filters.query\"\n                           ng-change=\"$ctrl.filterUsages()\"\n                           placeholder=\"Filter...\"\n                           auto-focus=\"true\"\n                           style=\"width:170px;\"/>\n\n                    <span class=\"mleft8\">\n                        <select class=\"placeholder-as-default-value\"\n                                dku-bs-select=\"{noneSelectedText:'All types'}\" \n                                multiple=\"multiple\"\n                                ng-model=\"$ctrl.uiState.filters.types\"\n                                ng-change=\"$ctrl.filterUsages()\"\n                                ng-options=\"o.id as o.label for o in $ctrl.uiState.options.types\"/>\n                    </span>\n\n                    <span class=\"mleft8\">\n                        <select class=\"placeholder-as-default-value\"\n                                dku-bs-select=\"{noneSelectedText: 'All projects'}\"\n                                multiple=\"multiple\"\n                                ng-model=\"$ctrl.uiState.filters.projects\"\n                                ng-change=\"$ctrl.filterUsages()\"\n                                ng-options=\"o.id as o.label for o in $ctrl.uiState.options.projects\"/>\n                    </span>\n\n                    <button class=\"btn-link btn--like-text mleft8\"\n                            ng-show=\"$ctrl.uiState.filters.resetable\"\n                            ng-click=\"$ctrl.resetFilters()\">reset filters</button>\n                </div>\n                <div class=\"counter mbot8\">\n                    {{$ctrl.uiState.filteredUsages.length}} <span ng-if=\"$ctrl.uiState.filteredUsages.length < $ctrl.accessibleUsages.length\">/ {{$ctrl.accessibleUsages.length}}</span> {{'usage' | plurify:$ctrl.uiState.filteredUsages.length}}\n                    in {{$ctrl.uiState.filteredProjectsCount}} {{'project' | plurify:$ctrl.uiState.filteredProjectsCount}}\n                </div>\n                <table ng-if=\"$ctrl.uiState.filteredUsages.length > 0\"\n                       sort-table \n                       class=\"table table-striped table-hover w100\">\n                    <tr>\n                        <th sort-col=\"envUsage\">Type</th>\n                        <th sort-col=\"projectKey\">Project Key</th>\n                        <th sort-col=\"objectId\">Item</th>\n                    </tr>\n                    <tr ng-repeat=\"usage in $ctrl.uiState.filteredUsages | orderBy:sortColumn:sortDescending\">\n                        <td>{{usage.envUsage |  typeToName}}</td>\n                        <td>{{usage.projectLabel}}</td>\n                        <td>\n                            <a ng-if=\"usage.href\" href=\"{{usage.href}}\" title=\"{{usage.linkLabel}}\">{{usage.objectId || usage.linkLabel}}</a>\n                            <span ng-if=\"!usage.href\">{{usage.objectId || usage.linkLabel}}</span>\n                        </td>\n                    </tr>\n                </table>\n            </div>\n            <div ng-if=\"$ctrl.uiState.filteredUsages.length===0\" class=\"text-center\">\n                No usage {{$ctrl.uiState.filteredUsages.length < $ctrl.accessibleUsages.length ? \"match\" : \"found\"}}\n            </div>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/common/delete-env-modal.html", "<div class=\"modal modal3 modal-wide\">\n\t<div dku-modal-header modal-title=\"Delete {{codeEnv.envName}} env\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n\t\t<div class=\"modal-body\">\n\t\t\t<code-env-usage env-lang=\"{{codeEnv.envLang}}\" env-name=\"{{codeEnv.envName}}\" ng-if=\"codeEnv.canManageUsersCodeEnv\"/>\n        </div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"submit\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"delete()\">Delete</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/code-envs/common/dss-internal-code-env.html", "<div>\n    <h2 class=\"code-envs__section-title\">{{ $ctrl.codeEnvDescription | capitalize }} code environment</h2>\n    <div ng-if=\"!$ctrl.codeEnvExists\">\n        <div class=\"alert alert-info\">\n            The code environment for {{ $ctrl.codeEnvDescription }} is not installed. <span ng-if=\"$ctrl.mayCreateCodeEnvs()\">Select a python interpreter to create it.</span>\n        </div>\n\n        <div class=\"control-group\" ng-if=\"$ctrl.mayCreateCodeEnvs()\">\n            <label class=\"control-label\">Python Interpreter</label>\n            <div class=\"controls\">\n                <select\n                    dku-bs-select\n                    ng-model=\"$ctrl.codeEnvConfig.pythonInterpreter\"\n                    ng-options=\"x[0] as x[1] for x in $ctrl.supportedPythonInterpreters\"\n                ></select>\n                <button class=\"btn btn--contained btn--primary\" ng-click=\"$ctrl.createCodeEnv()\" ng-disabled=\"!$ctrl.codeEnvConfig.pythonInterpreter\">Create code environment</button>\n            </div>\n        </div>\n    </div>\n\n    <div ng-if=\"$ctrl.codeEnvExists\">\n        <div class=\"alert alert-info\">\n            The code environment for {{ $ctrl.codeEnvDescription }} has already been created. Open <a href=\"{{$ctrl.codeEnvHref}}\"><strong>{{$ctrl.codeEnv.envName}}</strong></a> in the code environments\n            tab to manage containerized execution.\n        </div>\n\n        <ng-container ng-if=\"$ctrl.outdated\">\n            <div class=\"alert alert-warning\" ng-if=\"$ctrl.showOutdatedRequirementsWarning\">\n                The code environment for {{ $ctrl.codeEnvDescription }} has outdated packages and needs to be updated.\n            </div>\n            <div class=\"alert alert-warning\" ng-if=\"$ctrl.showOutdatedContainerImagesWarning\">\n                The code environment for {{ $ctrl.codeEnvDescription }} needs to be updated for at least one containerized execution configuration.\n            </div>\n            <div class=\"control-group\" ng-if=\"$ctrl.mayCreateCodeEnvs()\">\n                <button class=\"btn btn--contained btn--primary\" ng-click=\"$ctrl.updateCodeEnv()\">Update code environment</button>\n            </div>\n        </ng-container>\n    </div>\n    <div ng-if=\"$ctrl.mayCreateCodeEnvs()\">\n        <div class=\"alert alert-warning\" ng-if=\"$ctrl.showPiiDetectionCodeEnvWarning\">\n            The code environment for {{ $ctrl.codeEnvDescription }} has been created but it is not yet used for {{ $ctrl.codeEnvDescription }}.\n            <span ng-if=\"$ctrl.appConfig.admin\">Change the code env selection in <a ui-sref=\"admin.general.genai\">Administration > Settings > LLM Mesh</a>.</span>\n            <span ng-if=\"!$ctrl.appConfig.admin\">Ask your administrator to change the setting in Administration > Settings > LLM Mesh.</span>\n        </div>\n        <div class=\"alert alert-warning\" ng-if=\"$ctrl.showRagCodeEnvWarning\">\n            The code environment for {{ $ctrl.codeEnvDescription }} has been created but it is not yet used as default for {{ $ctrl.codeEnvDescription }}.\n            <span ng-if=\"$ctrl.appConfig.admin\">Change the code env selection in <a ui-sref=\"admin.general.genai\">Administration > Settings > LLM Mesh</a>.</span>\n            <span ng-if=\"!$ctrl.appConfig.admin\">Ask your administrator to change the setting in Administration > Settings > LLM Mesh.</span>\n        </div>\n        <div class=\"alert alert-warning\" ng-if=\"$ctrl.hfLocalConnectionsWithWrongCodeEnv && $ctrl.hfLocalConnectionsWithWrongCodeEnv.length > 0\">\n            The code environment for {{ $ctrl.codeEnvDescription }} has been created but another code env is set for use in some of the local Hugging Face connections.\n            <span ng-if=\"$ctrl.appConfig.admin\">Change the code env selection in the connection settings for:</span>\n            <span ng-if=\"!$ctrl.appConfig.admin\">Ask your administrator to change the code env selection in the connection settings for:</span>\n            <ul style=\"margin-bottom: 0\">\n                <li ng-repeat=\"connectionInfo in $ctrl.hfLocalConnectionsWithWrongCodeEnv\">\n                    <a ng-if=\"$ctrl.appConfig.admin\" href=\"{{connectionInfo.href}}\">{{connectionInfo.name}}</a>\n                    <span ng-if=\"!$ctrl.appConfig.admin\">{{connectionInfo.name}}</span>\n                </li>\n            </ul>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/internal-code-envs.html", "<div class=\"code-envs__boxed-pane fh oa\">\n    <form class=\"dkuform-horizontal\">\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"object detection\"\n                internal-code-env-type=\"DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"image classification\"\n                internal-code-env-type=\"DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"External/Proxy Models\"\n                internal-code-env-type=\"PROXY_MODELS_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"Databricks utils\"\n                internal-code-env-type=\"DATABRICKS_UTILS_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"PII detection\"\n                internal-code-env-type=\"PII_DETECTION_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"local Hugging Face models\"\n                internal-code-env-type=\"HUGGINGFACE_LOCAL_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                code-env-description=\"retrieval augmented generation\"\n                internal-code-env-type=\"RAG_CODE_ENV\"/>\n        </div>\n        <div class=\"section\">\n            <dss-internal-code-env\n                    code-env-description=\"document extraction\"\n                    internal-code-env-type=\"DOCUMENT_EXTRACTION_CODE_ENV\"/>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/common/save-update-buttons.html", "<div>\n    <div class=\"horizontal-flex\" style=\"height: auto;\"> <!-- no h100 as horizontal-flex does -->\n        <div ng-if=\"specIsDirty()\" class=\"btn-group code-env__buttons flex\" style=\"flex-basis: 50px;\">\n            <button class=\"btn btn--outline btn--primary\" style=\"width: 100%\" ng-click=\"saveAndMaybePerformChanges(false)\">\n                <i class=\"icon-save\"></i>\n                &nbsp;<span translate=\"GLOBAL.BUTTONS.SAVE\">Save</span>\n            </button>\n        </div>\n        <div ng-if=\"!specIsDirty()\" class=\"btn-group code-env__buttons flex\" style=\"flex-basis: 50px;\">\n            <button class=\"btn btn--outline btn--success\" ng-disabled=\"true\" style=\"width: 100%\" >\n                <i class=\"icon-save\"></i>\n                &nbsp;<span translate=\"GLOBAL.BUTTONS.SAVED\">Saved!</span>\n            </button>\n        </div>\n        <div class=\"flex\" style=\"flex-basis: 10px;\"></div> <!-- separation -->\n        <div ng-if=\"canBeUpdated() && specIsDirty()\" class=\"btn-group code-env__buttons code-env__button-container flex\">\n            <button class=\"btn btn--outline btn--success code-env__button-save-and-update\" show-tooltip-on-content-overflow\n                title=\"{{ translate('GLOBAL.BUTTONS.SAVE_AND_UPDATE', 'Save and update') }}\" toggle=\"tooltip-top\" container=\"body\"\n                ng-click=\"saveAndMaybePerformChanges(true)\">\n                <i class=\"icon-save\"></i>\n                &nbsp;<span translate=\"GLOBAL.BUTTONS.SAVE_AND_UPDATE\">Save and update</span>\n            </button>\n        </div>\n        <div ng-if=\"canBeUpdated() && !specIsDirty()\" class=\"btn-group code-env__buttons flex\" style=\"flex-basis: 150px;\">\n            <button class=\"btn btn--outline btn--success\" ng-click=\"updateEnv()\" style=\"width: 100%;\">\n                &nbsp;<span translate=\"GLOBAL.BUTTONS.UPDATE\">Update</span>\n            </button>\n        </div>\n        <div ng-if=\"!canBeUpdated()\" class=\"flex\" style=\"flex-basis: 150px;\"></div>\n    </div>\n    <div class=\"alert alert-warning dib mtop16 mbot0\" ng-if=\"hasOptedOutOfReferenceSpec()\">\n        <div>DSS supervision over this code env has been manually disabled.</div>\n        <div>Upgrades provided by DSS will no longer be applied when this code env is updated.</div>\n    </div>\n    <div class=\"alert alert-info dib mtop16 mbot0\" ng-if=\"useReferenceSpec()\">\n        <div>Some settings of this internal code env are managed by DSS, and will automatically be upgraded when this code env is updated.</div>\n    </div>\n    <div ng-if=\"canBeUpdated()\">\n        <div ng-if=\"!useReferenceSpec()\">\n            <label class=\"checkbox\" style=\"margin: 5px 0;\">\n                <input id=\"allCheckbox\" type=\"checkbox\" ng-model=\"uiState.upgradeAllPackages\"></input>\n                Update all packages\n            </label>\n            <div>\n                <span class=\"help-inline\" style=\"color: #999\">\n                    Updates packages in the virtual environment so that the installed packages match the list and versions of the packages specified by the user.\n                </span>\n            </div>\n            <label ng-if=\"codeEnv.deploymentMode !== 'EXTERNAL_CONDA_NAMED'\" class=\"checkbox\" style=\"margin: 5px 0;\">\n                <input ng-if=\"enableCodeEnvResources\" type=\"checkbox\" ng-model=\"uiState.updateResources\"></input>\n                <input ng-if=\"!enableCodeEnvResources\" type=\"checkbox\" disabled></input>\n                Run resources init script\n            </label>\n        </div>\n        <label class=\"checkbox\" style=\"margin: 5px 0;\">\n            <input type=\"checkbox\" ng-model=\"uiState.forceRebuildEnv\"></input>\n            Rebuild env\n        </label>\n        <div>\n            <span class=\"help-inline\" style=\"color: #999\">\n                Clears the code environment and rebuilds it from scratch\n            </span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/security-permissions.html", "<div class=\"\">\n    <div block-api-error />\n    <div class=\"locked-feature\" ng-if=\"!appConfig.licensedFeatures.userSecurityAllowed\">\n        <div class=\"banner\">\n            Your DSS <span ng-bind=\"appConfig.licensedFeatures.limitedEditionString\" /> does\n            not allow you to manage project permissions.\n        </div>\n        <div include-no-scope=\"/templates/profile/community-vs-enterprise-try.html\"></div>\n    </div>\n    <div ng-if=\"appConfig.licensedFeatures.userSecurityAllowed\" style=\"\" class=\"permissions-table-page\">\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\" ng-if=\"codeEnv.canUpdateCodeEnv\">\n                <label class=\"control-label\">Owner</label>\n                <div class=\"controls\">\n                    <select\n                        dku-bs-select=\"{ liveSearch: true }\"\n                        ng-options=\"usr.login as usr.displayName for usr in allUsers\"\n                        ng-model=\"ui.ownerLogin\"\n                        options-descriptions=\"allUsersLogin\"\n                        layout=\"list\">\n                    </select>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"useByAllDisabled\" class=\"control-label\">Usable by all</label>\n                <div class=\"controls\">\n                    <input type=\"checkbox\" ng-hide=\"codeEnv.canUpdateCodeEnv || (!codeEnv.canUpdateCodeEnv && !codeEnv.usableByAll)\" checked disabled />\n                    <input type=\"checkbox\" ng-hide=\"codeEnv.canUpdateCodeEnv || (!codeEnv.canUpdateCodeEnv && codeEnv.usableByAll)\" disabled />\n                    <input type=\"checkbox\" ng-show=\"codeEnv.canUpdateCodeEnv\" ng-model=\"codeEnv.usableByAll\" id=\"useByAllDisabled\"/>\n                </div>\n            </div>\n        </form>\n        <form class=\"inline-form\">\n\n            <table sort-table class=\"table table-striped table-hover permissions\" >\n                <thead>\n                    <tr>\n                        <th colspan=\"2\">Group name</th>\n                        <th>Use</th>\n                        <th ng-if=\"codeEnv.canUpdateCodeEnv\">Update settings &amp; packages</th>\n                        <th ng-if=\"codeEnv.canUpdateCodeEnv\">Admin</th>\n                        <th>&nbsp;</th>\n                    </tr>\n                </thead>\n                <tbody add-remove ng-model=\"codeEnv.permissions\">\n                    <tr ng-hide=\"codeEnv.permissions.length\">\n                        <td colspan=\"13\" style=\"text-align: center; font-size: 16px; line-height: 40px; color: #666\">\n                            No group is granted access to this code env\n                        </td>\n                    </tr>\n                    <tr ng-repeat=\"perm in codeEnv.permissions\">\n\n                        <td colspan=\"2\">{{perm.group}}</td>\n                        <td>\n                            <label class=\"checkbox\" for=\"useDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$useDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$useDisabled\" ng-model=\"perm.use\" id=\"useDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td ng-if=\"codeEnv.canUpdateCodeEnv\">\n                            <label class=\"checkbox\" for=\"updateDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$updateDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$updateDisabled\" ng-model=\"perm.update\" id=\"updateDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td ng-if=\"codeEnv.canUpdateCodeEnv\">\n                            <label class=\"checkbox\" for=\"manageUsersDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$manageUsersDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$manageUsersDisabled\" ng-model=\"perm.manageUsers\" id=\"manageUsersDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td>\n                            <a  class=\"link-danger\" ng-click=\"remove($index)\"> <i class=\"icon-trash\" /></a>\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n\n            <div ng-show=\"unassignedGroups.length\" style=\"margin-bottom: 20px;\">\n                <select style=\"display: inline-block;\" ng-model=\"newPerm.group\" dku-bs-select=\"{liveSearch:true,width:250}\" ng-options=\"g for g in unassignedGroups\" data-none-selected-text=\"Select a group\" ></select>\n                <button style=\"display: inline-block;\" ng-disabled=\"!newPerm.group\" ng-click=\"addPermission()\" class=\"btn btn--secondary\">\n                    <span plus-icon />\n                    &nbsp;Grant access to group\n                </button>\n            </div>\n\n            <div class=\"alert alert-info\" style=\"border-radius: 0px\"> <i class=\"icon-info-sign\" />To manage groups go to\n                <a class=\"tab\" ng-class=\"{'enabled': $state.includes('admin.groups')}\" href=\"/admin/security/groups/\">DSS global administration</a>\n                .\n            </div>\n        </form>\n    </div>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/common/upload-resources-modal.html", "<div class=\"modal modal3 new-env-modal dku-modal\" auto-size=\"false\"\n    ng-controller=\"AdminCodeEnvsUploadResourcesController\">\n    <div dku-modal-header modal-title=\"Upload and extract a zip to the resources directory\"></div>\n\n    <form class=\"dkuform-modal-horizontal\" name=\"uploadResourceForm\">\n        <div class=\"modal-body\">\n            <div block-api-error></div>\n            <div class=\"control-group\">\n                <label for=\"resourcesToUpload\" class=\"control-label\">Resource zip file to upload</label>\n                <div class=\"controls\">\n                    <input\n                        id=\"resourcesToUpload\"\n                        type=\"file\"\n                        class=\"code-env-resources-upload__input-file\"\n                        required valid-file\n                        ng-model=\"resourcesToUpload\"\n                        accept=\"application/zip\"/>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Overwrite if existing</label>\n                <div class=\"controls\">\n                    <input type=\"checkbox\" ng-model=\"overwrite\"/>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"upload()\"\n                ng-disabled=\"uploadResourceForm.$invalid\">Upload</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/R-edit.html", "<div class=\"fh code-env\" global-keydown=\"{'ctrl-s meta-s':'saveAndMaybePerformChanges(false)'}\">\n    <div class=\"h100 row-fluid\">\n        <div class=\"span2 offset0 nav-list-sidebar sidebar-admin\" style=\"padding-top: 0;\">\n            <div class=\"horizontal-flex\" style=\"height: auto;\">\n                <div class=\"flex mx-textellipsis\">\n                    <h4 class=\"mx-textellipsis\" title=\"{{codeEnv.envName}}\">{{codeEnv.envName}}</h4>\n                </div>\n                <div class=\"noflex center-children\" style=\"font-size: 14px; opacity: 0.8;\" ng-if=\"codeEnv.canUpdateCodeEnv || isExportable(codeEnv)\">\n                    <div custom-element-popup cep-position=\"align-right-bottom\" close-on-click=\"true\">\n                        <i class=\"icon-cog mainzone cursor-pointer\" ng-click=\"togglePopover()\"></i>\n                        <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                            <li ng-if=\"isExportable(codeEnv)\">\n                                <a ng-click=\"exportEnv(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Export</a>\n                            </li>\n                            <li ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\"><i class=\"icon-trash\"></i>&nbsp;Delete</a>\n                            </li>\n                            <li>\n                                <a ng-click=\"getEnvDiagnostic(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Get diagnostic</a>\n                            </li>\n                        </ul>\n                    </div>\n                </div>\n            </div>\n            <ul>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'info'}\" full-click>\n                    <a ng-click=\"uiState.active = 'info'\" main-click>General</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'required'}\" full-click ng-if=\"codeEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                    <a ng-click=\"uiState.active = 'required'\" main-click>Packages to install</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'actual'}\" full-click ng-if=\"['DESIGN_MANAGED', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'actual'\" main-click>Currently installed packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'packages'}\" full-click ng-if=\"codeEnv.deploymentMode == 'DESIGN_NON_MANAGED' || codeEnv.deploymentMode == 'PLUGIN_NON_MANAGED' || codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                    <a ng-click=\"uiState.active = 'packages'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'permissions'}\" full-click ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                    <a ng-click=\"uiState.active = 'permissions'\" main-click>Permissions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'containers'}\" full-click ng-if=\"['DESIGN_MANAGED', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'containers'\" main-click>Containerized execution</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'logs'}\" full-click>\n                    <a ng-click=\"uiState.active = 'logs'\" main-click>Logs</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'usages'}\" full-click ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <a ng-click=\"uiState.active = 'usages'\" main-click>Usages</a>\n                </li>\n            </ul>\n            <div ng-include=\"'/templates/admin/code-envs/common/save-update-buttons.html'\" />\n        </div>\n        <div class=\"span10 h100 offset0 boxed-next-to-sidebar no-padding\" ng-switch=\"uiState.active\">\n            <div ng-switch-when=\"info\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <div block-api-error />\n                <h1>Code env</h1>\n                <form class=\"dkuform-horizontal\">\n                    <div class=\"section\">\n                    <h2>General env info</h2>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Mode</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.deploymentMode}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Owner</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.owner}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['DESIGN_MANAGED', 'DESIGN_NON_MANAGED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                        <label for=\"\" class=\"control-label\">Location of the environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.path}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                        <label for=\"\" class=\"control-label\">Conda environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.desc.externalCondaEnvName}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                        <label for=\"\" class=\"control-label\">Uses conda</label>\n                        <div class=\"controls\">\n                            {{codeEnv.desc.conda ? \"Yes\" : \"No\"}}\n                            <span class=\"help-inline\">Whether to use Conda to create and manage the packages. If not, use simply R.</span>\n                        </div>\n                    </div>\n                    </div>\n\n\n                    <div class=\"section\">\n                    <h2 ng-if=\"appConfig.sparkEnabled\">Spark</h2>\n                    <div class=\"control-group\" ng-if=\"appConfig.sparkEnabled\">\n                        <label for=\"\" class=\"control-label\">Yarn R executable</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.desc.yarnRBin\" />\n                            <span class=\"help-inline\">R binary on the Yarn nodes for SparkR</span>\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2>Extra options</h2>\n\n                    <div ng-if=\"codeEnv.desc.envSettings\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Inherit global settings</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.desc.envSettings.inheritGlobalSettings\" />\n                                </label>\n                             </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings && codeEnv.desc.conda\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings && codeEnv.desc.conda\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings\">\n                            <label for=\"\" class=\"control-label\">CRAN mirror URL</label>\n                            <div class=\"controls\">\n                                 <input type=\"text\" ng-model=\"codeEnv.desc.envSettings.cranMirrorURL\" />\n                            </div>\n                        </div>\n                    </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2>Jupyter</h2>\n                    <div class=\"control-group\" ng-if=\"!codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <span style=\"margin-right: 50px\">{{codeEnv.kernelSpecName || 'not installed'}}</span>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs IRkernel)</span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>Unable to check status</div>\n                             <div ng-if=\"codeEnv.kernelSpecsListingError\" api-error-alert=\"codeEnv.kernelSpecsListingError\" />\n                        </div>\n                    </div>\n                    </div>\n                </form>\n            </div>\n\n            <div ng-switch-when=\"usages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env usages</h1>\n                <div class=\"section\">\n                    <code-env-usage env-lang=\"{{envLang}}\" env-name=\"{{codeEnv.envName}}\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"permissions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Permissions</h1>\n                <div class=\"section\">\n                    <div code-env-security-permissions code-env=\"codeEnv\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"required\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages to install</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <div class=\"row-fluid\">\n                    <form class=\"dkuform-horizontal\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Install core packages</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.desc.installCorePackages\" ng-change=\"refreshMandatoryPackageList()\"/>\n                                    <span class=\"help-inline\">\n                                        Install mandatory set of packages (you won't be able to use Dataiku APIs without this)\n                                    </span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Install Jupyter support</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.desc.installJupyterSupport\" ng-change=\"refreshMandatoryPackageList()\" />\n                                    <span class=\"help-inline\">\n                                        Install support for Jupyter notebooks\n                                    </span>\n                                </label>\n                            </div>\n                        </div>\n                    </form>\n                </div>\n                <hr />\n\n                <div ng-if=\"getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore().length > 0\" class=\"alert alert-warning\">\n                    The following packages were previously \"Requested\" and are currently installed, but have been removed from the\n                    requested list. These packages may become unavailable. Check whether this is desired.<br />\n                    <strong>{{getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore()}}</strong>\n                </div>\n                <div class=\"row-fluid\">\n                    <div class=\"span6\" ng-if=\"codeEnv.desc.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (Conda)</legend>\n                        <p>\n                            Add here the packages that you want to be available in the environment. <strong>Do not remove packages once they are installed.</strong> Only packages mentioned here are guaranteed to be installed.<br />\n                        </p>\n                        <div class=\"codemirror\">\n                            <textarea ng-model=\"codeEnv.specCondaEnvironment\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n                        </div>\n                        <div>\n                            <a ng-click=\"openRCondaSpecEditHelp()\">Syntax help</a>\n                        </div>\n\n                        <legend class=\"settings-section-title mtop20 text-weak\">For information: base packages (Conda)</legend>\n                        <p>These packages cannot be removed nor reversioned</p>\n                        <pre class=\"package-list\">{{codeEnv.mandatoryCondaEnvironment}}</pre>\n                    </div>\n\n                    <div class=\"span6 \">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (CRAN)</legend>\n                        <p>\n                            Add here the packages that you want to be available in the environment. <strong>Do not remove packages once they are installed.</strong> Only packages mentioned here are guaranteed to be installed.<br />\n                        </p>\n                        <div ng-if=\"codeEnv.desc.conda\" class=\"alert alert-warning\">\n                            <i class=\"icon-warning-sign\"></i>&nbsp;\n                            It is highly recommend to only install Conda packages in Conda code envs. Installing packages from\n                            CRAN in Conda code envs is likely to cause issues.\n                        </div>\n                        <div class=\"codemirror\">\n                            <textarea ng-model=\"codeEnv.specPackageList\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n                        </div>\n                        <div>\n                            <a ng-click=\"openCRANEditHelp()\">Syntax help</a>\n                        </div>\n\n                         <legend class=\"settings-section-title mtop20 text-weak\">For information: base packages (CRAN)</legend>\n                         <p>These packages cannot be removed nor reversioned</p>\n                        <pre class=\"package-list\">{{codeEnv.mandatoryPackageList}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"actual\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Currently installed packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <div class=\"row-fluid\">\n                    <div class=\"span6\" ng-if=\"codeEnv.desc.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Installed packages (Conda)</legend>\n                        <div class=\"alert alert-info\">\n                            These are the packages that are <strong>currently</strong> installed in the code env. Note that only the list in \"Packages to install\" is authoritative as to which packages will be installed.<br />\n                            Packages that are not in \"Packages to install\" may not be installed when rebuilding this env or in containers.<br />\n                            This list only reflects the \"local\" code env, not what is available in containers.\n                        </div>\n                        <pre class=\"package-list\">{{codeEnv.actualCondaEnvironment}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Installed packages (R)</legend>\n                        <div class=\"alert alert-info\">\n                            These are the packages that are <strong>currently</strong> installed in the code env. Note that only the list in \"Packages to install\" is authoritative as to which packages will be installed.<br />\n                            Packages that are not in \"Packages to install\" may not be installed when rebuilding this env or in containers.<br />\n                            This list only reflects the \"local\" code env, not what is available in containers.\n                        </div>\n                        <pre class=\"package-list\">{{codeEnv.actualPackageList}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"packages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Currently installed packages</h1>\n                <div block-api-error />\n\n                <div class=\"section\">\n                <button class=\"btn btn--secondary\" ng-click=\"fetchNonManagedEnvDetails()\">Fetch packages list</button>\n                <div class=\"row-fluid\" ng-if=\"nonManagedEnvDetails\">\n                    <div class=\"span6\" ng-if=\"nonManagedEnvDetails.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Conda)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.condaEnvSpec}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (R)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.nocondaEnvSpec}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"logs\" class=\"h100 vertical-flex paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env logs</h1>\n                <div class=\"flex\">\n                    <div class=\"section fh\">\n                        <div simple-logs logs=\"logs\" obj-id=\"[envLang, envName]\" get-log=\"getLog\" download-url=\"downloadURL\"/>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"containers\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Containerized execution</h1>\n                <div class=\"section\">\n                    <div code-env-containers code-env=\"codeEnv\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                </div>\n            </div>\n\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/add-additional-packages-modal.html", "<div class=\"modal modal3 dku-modal additional-package-modal\">\n    <form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n        <div dku-modal-header modal-title=\"Add additional packages\"/>\n        <div class=\"modal-body modal-no-sizing\">\n\n            <div class=\"modal-info-container\">\n                <div class=\"modal-info\">\n                    <p>\n                        Some actions in DSS require to use a code-env with certain packages that are not shipped in DSS built-in code-env.\n                    </p>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label class=\"control-label\">Required packages for</label>\n                <div class=\"controls\">\n                    <select dku-bs-select=\"{ width: 250, wideDropdownOptions: true }\" ng-model=\"selectedPackages\" ng-options=\"p[0] as p[1] for p in packageListTypes\"></select>\n                </div>\n            </div>\n            <p style=\"font-size: 14px; margin-top: 15px;\">\n                The following packages will be added to the requested packages. \n            </p>\n            <div class=\"additional-package-list-container\">\n                <textarea ng-model=\"packageListValues[selectedPackages]\"\n                          ui-codemirror=\"insertReadOnlyOptions\"></textarea>\n            </div>\n        </div>\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <div class=\"pull-right\" ng-if=\"!positive\">\n                <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n                <button type=\"button\" class=\"btn btn--text btn--primary\" ng-click=\"insertPackages()\" ng-disabled=\"!selectedPackages\">Add</button>\n            </div>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/design/change-python-modal-successful.html", "<div class=\"modal modal3 dku-modal\">\n    <div dku-modal-header modal-title=\"Install packages\" />\n\n    <form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"codeEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <ul>\n                <li>Code env \"{{env.envName}}\"  \n                    <span ng-if=\"inplace\">python interpreter has been updated</span> \n                    <span ng-if=\"!inplace\">has been created</span> with {{env.pythonInterpreterFriendlyName}} interpreter\n                </li>\n                <li>\n                    Click \"Install packages now\" to update env according to the new package list, \"Close\" to install packages later.\n                </li>\n            </ul>\n\n            <div class=\"alert alert-warning mtop8\" ng-if=\"previousCorePackagesSet\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> {{previousCorePackagesSet}} is not compatible with {{env.pythonInterpreterFriendlyName}}. It has been overriden to {{env.desc.corePackagesSet}}\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Close</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-if=\"!inplace\" ng-click=\"goToEnv(env.envName)\">Go to {{env.envName}}</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"dismiss();installPackages(env.envName)\">Install packages now</button>\n        </div>\n    </form> \n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/change-python-modal.html", "<div class=\"modal modal3 dku-modal change-python-modal\">\n    <div dku-modal-header modal-title=\"Change Python interpreter\" />\n\n    <form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newCodeEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <div class=\"alert alert-warning\">\n                <i class=\"icon-dku-warning\"></i> Changing the Python interpreter for this code env can cause compatibility issues. You may need to manually update the package list or core package versions, and pickled objects created with a different Python version might not load correctly.\n            </div>\n            <div class=\"control-group\">\n                <label class=\"control-label\">Method</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" ng-model=\"inplace\" ng-value=\"true\"/>\n                        Modify this code environment\n                        <div class=\"help-inline\">Python code and models currently using this code env will be impacted</div>\n                    </label>\n                    <label>\n                        <input type=\"radio\" ng-model=\"inplace\" ng-value=\"false\"/>\n                        Create a new code environment\n                        <div class=\"help-inline\">Python code and models currently using this code env won't be impacted. \n                            You will need to select the new code env for every usage</div>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Python interpreter</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"newEnv.pythonInterpreter\" ng-options=\"x[0] as x[1] for x in pythonInterpreters\" />\n                </div>\n            </div>\n\n            <div class=\"control-group\" ng-if=\"newEnv.pythonInterpreter == 'CUSTOM'\">\n                <label for=\"\" class=\"control-label\">Python executable</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"newEnv.customInterpreter\"  />\n                </div>\n            </div>\n            <div class=\"control-group package-update-list-container\">\n                <div class=\"row-fluid\">\n                    <div class=\"span6\">\n                        <label for=\"\">Package list (Before)</label>\n                    </div>\n                    <div class=\"span6\">\n                        <label for=\"\">Package list (After)</label>\n                    </div>\n                </div>\n                <div class=\"row-fluid\">\n                    <div class=\"span6\">\n                        <textarea ng-model=\"oldEnv.specPackageList\" ui-codemirror=\"insertReadOnlyOptions\"></textarea>\n                    </div>\n                    <div class=\"span6\">\n                        <textarea ng-model=\"newEnv.specPackageList\" ui-codemirror=\"insertReadWriteOptions\"></textarea>\n                    </div>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"!inplace\">\n                <label for=\"\" class=\"control-label\">Name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"newEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"previousPython === newEnv.pythonInterpreter && newEnv.customInterpreter === oldEnv.desc.customInterpreter\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> Please select another interpreter than the current one\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"oldEnvContainsDeprecatedPythonCRA(newEnv.pythonInterpreter) && !supportedDeprecatedPythons.includes(newEnv.pythonInterpreter)\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> Detected inclusion of one or more container runtime additions for deprecated Python versions.\n                    <div>\n                        <input type=\"checkbox\" ng-model=\"newEnv.removeContainerRuntimeAdditions\"/> Remove non required Python container runtime additions\n                    </div>\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"oldEnvContainsDeprecatedPythonCRA(newEnv.pythonInterpreter) && previousPython !== newEnv.pythonInterpreter && supportedDeprecatedPythons.includes(newEnv.pythonInterpreter)\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> Detected a container runtime addition for the deprecated Python version {{ oldEnv.pythonInterpreterFriendlyName }}.\n                    <div>\n                        <input type=\"checkbox\" ng-model=\"newEnv.updateContainerRuntimeAdditions\"/> Update to the container runtime addition for {{ newEnv.pythonInterpreterFriendlyName }}\n                    </div>\n                </div>\n            </div><div class=\"alert alert-warning mtop8\"\n                ng-if=\"newEnvRequiresDeprecatedPythonCRA(newEnv.pythonInterpreter) && previousPython !== newEnv.pythonInterpreter && supportedDeprecatedPythons.includes(newEnv.pythonInterpreter)\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> Switching to the deprecated {{ newEnv.pythonInterpreterFriendlyName }} requires a container runtime addition.\n                    <div>\n                        <input type=\"checkbox\" ng-model=\"newEnv.updateContainerRuntimeAdditions\" /> Include container runtime addition for {{ newEnv.pythonInterpreterFriendlyName }}\n                    </div>\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"previousPython !== newEnv.pythonInterpreter && inplace\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> Updating this code env in-place might break usages. Browse <a class=\"small-link-button\" ng-click=\"dismiss();uiState.active = 'usages'\">usages\n                </a> before proceeding.\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-if=\"!inplace\" ng-click=\"create()\" ng-disabled=\"newCodeEnvForm.$invalid\"> Create\n            </button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-if=\"inplace\" ng-click=\"update()\" ng-disabled=\"newCodeEnvForm.$invalid\"> Update\n            </button>\n        </div>\n    </form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/code-studio-rebuild-modal.html", "<div class=\"modal modal3\">\n    <form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n        <div dku-modal-header modal-title=\"Rebuild Code Studio Templates\"/>\n        <div class=\"modal-body modal-no-sizing\">\n            <p>This Code Env is used by the following Code Studio {{ 'template' | plurify : templatesToRebuild.length }}:</p>\n            <div>\n                <ul>\n                    <li ng-repeat=\"templateId in templatesToRebuild\">\n                        {{templateId}}\n                    </li>\n                </ul>\n            </div>\n            <p>Do you want to rebuild <ng-pluralize count=\"templatesToRebuild.length\" when=\"{'one': 'this', 'other': 'these'}\"/> {{ 'template' | plurify : templatesToRebuild.length }}, so <ng-pluralize count=\"templatesToRebuild.length\" when=\"{'one': 'it', 'other': 'they'}\"/> use the updated version of this Code Env ?</p>\n            <span class=\"help-inline\">(this might take some time)</span>\n        </div>\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <div class=\"pull-right\" ng-if=\"!positive\">\n                <button class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n                <button class=\"btn btn--text btn--secondary\" ng-click=\"rebuildNone()\">Only build Code Env</button>\n                <button class=\"btn btn--text btn--primary\" ng-click=\"rebuildAll()\">Rebuild all templates</button>\n            </div>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/design/import-env-modal.html", "<div class=\"modal modal3 new-env-modal dku-modal\" auto-size=\"false\" ng-controller=\"AdminCodeEnvsDesignImportController\">\n    <div dku-modal-header modal-title=\"Import code env\" />\n\n    <form class=\"dkuform-modal-horizontal\" name=\"importEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <div class=\"control-group\" >\n                <label for=\"newEnvFile\" class=\"control-label\">Code env file</label>\n                <div class=\"controls\">\n                    <input id=\"newEnvFile\" type=\"file\" style=\"line-height: 10px; width: 250px;\" required valid-file ng-model=\"newEnv.file\" accept=\"application/zip\" />\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"import()\" ng-disabled=\"importEnvForm.$invalid\">Import</button>\n        </div>\n    </form>\n</div>");
$templateCache.put("/templates/admin/code-envs/design/index.html", "<div class=\"dss-page\">\n    <div class=\"vertical-flex h100\">\n        <div class=\"top-level-tabs\"\n            ng-if=\"mayCreateCodeEnvs() && !$state.includes('admin.codeenvs-design.python-edit') && !$state.includes('admin.codeenvs-design.r-edit')\">\n            <div class=\"horizontal-flex object-nav code-envs__nav-bar\">\n                \n                <div class=\"noflex title\">\n                    <h2 class=\"page-subtitle\">Code envs</h2>\n                </div>\n\n                <div class=\"noflex tabs\">\n                    <a class=\"tab\" fw500-width\n                        ng-class=\"{'enabled': $state.includes('admin.codeenvs-design.list')}\"\n                        ui-sref=\"admin.codeenvs-design.list\">\n                        Management\n                    </a>\n                    <a class=\"tab\" fw500-width\n                        ng-show=\"mayCreateCodeEnvs()\"\n                        ng-class=\"{'enabled': $state.includes('admin.codeenvs-design.internal')}\"\n                        ui-sref=\"admin.codeenvs-design.internal\">\n                        Internal envs setup\n                    </a>\n                </div>\n            </div>\n        </div>\n        <div ng-if=\"!mayCreateCodeEnvs()\" ui-sref=\"admin.codeenvs-design.list\"></div>\n        <div ui-view class=\"code-envs__tab-content\"></div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-envs/design/list.html", "<div class=\"fh vertical-flex\">\n    <div class=\"noflex std-list-header\">\n        <div class=\"dropdown pull-right\" ng-if=\"!canCreateCodeEnv() && !canRequestCodeEnvInstall\">\n            <button class=\"btn btn--primary\" ng-disabled=\"true\" title=\"You don't have the right to create code envs\">New Python env</button>\n            <button class=\"btn btn--primary\" ng-disabled=\"true\" title=\"You don't have the right to create code envs\">New R env</button>\n        </div>\n\n        <div class=\"dropdown pull-right\" ng-if=\"!canCreateCodeEnv() && canRequestCodeEnvInstall\">\n            <button class=\"btn btn--primary\" ng-click=\"openNewEnvRequestModal('PYTHON')\">Request Python env</button>\n            <button class=\"btn btn--primary\" ng-click=\"openNewEnvRequestModal('R')\">Request R env</button>\n        </div>\n\n        <div class=\"dropdown pull-right\" ng-if=\"canCreateCodeEnv()\">\n            <button class=\"btn btn--primary\" ng-click=\"openNewPythonEnvModal()\">New Python env</button>\n            <button class=\"btn btn--primary\" ng-click=\"openNewREnvModal()\">New R env</button>\n            <button class=\"btn btn--primary\" ng-click=\"openImportEnvModal()\">Import env</button>\n        </div>\n        <div class=\"std-list-search-box\">\n            <span class=\"add-on\"> <i class=\"icon-dku-search\"></i>\n            </span>\n            <input type=\"search\" ng-model=\"query\" style=\"width: 190px;\" placeholder=\"Filter...\"/>\n        </div>\n    </div>\n\n    <div class=\"flex\">\n        <div class=\"fh\">\n            <div block-api-error></div>\n            <div class=\"h100 oa\">\n                <table sort-table class=\"table table-striped table-hover\" style=\"width:100%\">\n                    <thead>\n                        <tr>\n                            <th sort-col=\"envName\">Name</th>\n                            <th sort-col=\"languageDisplayName\">Language</th>\n                            <th sort-col=\"owner\">Owner</th>\n                            <th sort-col=\"kernelSpecName\">Jupyter kernel</th>\n                            <th sort-col=\"deploymentMode\">Deployment</th>\n                            <th>&nbsp;</th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                        <tr ng-repeat=\"codeEnv in codeEnvs | toArray| filter:query | orderBy:sortColumn:sortDescending\">\n                            <td full-click>\n                                <span ng-if=\"codeEnv.envLang == 'PYTHON'\" class=\"faic\">\n                                    <a ui-sref=\"admin.codeenvs-design.python-edit({envName:codeEnv.envName})\">{{codeEnv.envName}}</a>\n                                    <i ng-if=\"codeEnv.upstreamPreset\" class=\"dku-icon-info-circle-fill-16 mleft4 text-weak\"\n                                        toggle=\"tooltip\" data-html=\"true\" title=\"Generated automatically with installed package set <strong>{{ codeEnv.upstreamPreset.description }} (v{{ codeEnv.upstreamPreset.major + '.' + codeEnv.upstreamPreset.minor }})</strong>\">\n                                    </i>\n                                </span>\n                                <a ng-if=\"codeEnv.envLang == 'R'\" ui-sref=\"admin.codeenvs-design.r-edit({envName:codeEnv.envName})\">{{codeEnv.envName}}</a>\n                            </td>\n                            <td>\n                                <span ng-class=\"{'text-warning': isPythonDeprecated(codeEnv.pythonInterpreter)}\">{{codeEnv.languageDisplayName}} </span>\n                                <span class=\"text-warning\" ng-if=\"isPythonDeprecated(codeEnv.pythonInterpreter)\" toggle=\"tooltip\" title=\"{{codeEnv.pythonInterpreter}} is deprecated and will be removed soon\">\n                                    <i class=\"icon-dku-warning\"></i>\n                                </span>\n                            </td>\n                            <td>{{ codeEnv.owner }}</td>\n                            <td>{{ codeEnv.kernelSpecName }}</td>\n                            <td>{{ codeEnv.deploymentMode }}</td>\n                            <td>\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\" style=\"text-decoration:none; margin-right: 10px;\" ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                    <i class=\"icon-trash\" />\n                                </a>\n                                <a ng-click=\"exportEnv(codeEnv.envLang, codeEnv.envName)\" style=\"text-decoration:none; margin-right: 10px;\" ng-if=\"isExportable(codeEnv)\">\n                                    <i class=\"icon-download\"></i>\n                                </a>\n                            </td>\n                        </tr>\n                    </tbody>\n                </table>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-R-env-from-draft-modal.html", "<div class=\"modal modal3\">\n    <div dku-modal-header modal-title=\"New R env\" />\n\n    <form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\" name=\"newCodeEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Deployment type</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"requestedEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"requestedEnv.envName\" ng-pattern=\"/^[_A-Za-z0-9-]+$/\" disabled/>\n                </div>\n            </div>\n\n\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                <label for=\"\" class=\"control-label\">External Conda env name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"requestedEnv.externalCondaEnvName\"  />\n                </div>\n            </div>\n\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                <label for=\"\" class=\"control-label\">Mandatory packages</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"requestedEnv.installCorePackages\" />\n                        <span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                <label for=\"\" class=\"control-label\">Jupyter</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"requestedEnv.installJupyterSupport\" />\n                        <span class=\"help-inline\">Install support for Jupyter notebooks</span>\n                    </label>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"createEnvFromDraft()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n        </div>\n    </form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-R-env-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"New R env\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\" name=\"newCodeEnvForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Deployment type</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<select dku-bs-select ng-model=\"newEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" ng-model=\"newEnv.envName\" ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">External Conda env name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" required ng-model=\"newEnv.externalCondaEnvName\"  />\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Conda</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.conda\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Use Conda</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Mandatory packages</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.installCorePackages\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Jupyter</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.installJupyterSupport\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Install support for Jupyter notebooks</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-R-env-request-modal.html", "<div class=\"modal modal3 dku-modal request-code-env-modal\">\n\t<dku-modal-header-with-totem modal-totem=\"icon-lock\">\n\t\t<dku-modal-title>\n\t\t\tRequest new R env\n\t\t</dku-modal-title>\n\t\t<dku-modal-tabs>\n\t\t\t<li class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'GENERAL'}\"><a ng-click=\"codeEnvModal.$modalTab = 'GENERAL'\">General</a></li>\n\t\t\t<li ng-if=\"requestedEnv.envName && isCodeEnvNameUnique(requestedEnv.envName)\" class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'PACKAGES'}\"><a ng-click=\"codeEnvModal.$modalTab = 'PACKAGES'\">Packages to install</a></li>\n\t\t\t<li ng-if=\"!requestedEnv.envName || !isCodeEnvNameUnique(requestedEnv.envName)\" class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'PACKAGES'}\" ><a style=\"cursor: not-allowed;\">Packages to install</a></li>\n\t\t</dku-modal-tabs>\n\t</dku-modal-header-with-totem>\n\n\t<div class=\"modal-body\" style=\"max-height: 400px !important;\">\n\t\t<div class=\"row-fluid\">\n\t\t\t<form class=\"dkuform-horizontal\">\n\t\t\t\t<div ng-if=\"codeEnvModal.$modalTab === 'GENERAL'\">\n\t\t\t\t\t<h5 class=\"font-weight-semi-bold\">You don't have the authorization to create a code env.</h5>\n\t\t\t\t\t<p>Contact the project administrators. <a href=\"{{$root.versionDocRoot}}collaboration/requests.html\" target=\"_blank\">Learn more</a></p>\n\t\t\t\t\t<textarea ng-model=\"codeEnvModal.message\" class=\"request-code-env-modal__message-input\" placeholder=\"Optional message\" maxlength=\"1000\" ng-trim=\"false\"/>\n\t\t\t\t\t<span class=\"request-plugin-modal__message-input-counter\" ng-style=\"codeEnvModal.message.length === 1000 && {'color': 'red'}\" >\n            \t\t\t{{codeEnvModal.message.length || 0}}/1000\n        \t\t\t</span>\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Name</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<input type=\"text\" ng-model=\"requestedEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\" custom-validation=\"isCodeEnvNameUnique\"/>\n\t\t\t\t\t\t\t<div class=\"alert alert-error request-code-env-modal__name-input-error\" ng-show=\"!isCodeEnvNameUnique(requestedEnv.envName)\">\n\t\t\t\t\t\t\t\tCode env \"{{requestedEnv.envName}}\" already exists.\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t</div>\n\n\n\t\t\t\t<div ng-if=\"codeEnvModal.$modalTab === 'PACKAGES'\">\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Install core packages</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"requestedEnv.installCorePackages\" />\n\t\t\t\t\t\t\t\t<span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Install Jupyter support</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"requestedEnv.installJupyterSupport\"/>\n\t\t\t\t\t\t\t\t<span class=\"help-inline\">Install support for Jupyter notebooks</span>\n\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\" ng-if=\"useConda\">\n\t\t\t\t\t\t<legend class=\"settings-section-title mtop0\">Requested packages (Conda)</legend>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<p>\n\t\t\t\t\t\t\t\tAdd here the packages that you want to be available in the environment.\n\t\t\t\t\t\t\t</p>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"codemirror\">\n\t\t\t\t\t\t\t<textarea rows=\"5\" ng-model=\"requestedEnv.specCondaEnvironment\" ui-codemirror=\"codeEnvResourcesEditorOptions\"></textarea>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<a ng-click=\"openRCondaSpecEditHelp()\">Syntax help</a>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div ng-if=\"requestedEnv.installCorePackages\">\n\t\t\t\t\t\t\t<legend ng-if=\"useConda\" class=\"settings-section-title mtop20 text-weak\">For information: base packages (Conda)</legend>\n\t\t\t\t\t\t\t<p>These are the packages required for the selected core features. These packages cannot be removed nor reversioned</p>\n\t\t\t\t\t\t\t<pre class=\"package-list\">{{requestedEnv.mandatoryPackageList}}</pre>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<legend class=\"settings-section-title mtop0\">Requested packages (CRAN)</legend>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<p>\n\t\t\t\t\t\t\t\tAdd here the packages that you want to be available in the environment.\n\t\t\t\t\t\t\t</p>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div ng-if=\"useConda\" class=\"alert alert-warning\">\n\t\t\t\t\t\t\t<i class=\"icon-warning-sign\"></i>&nbsp;\n\t\t\t\t\t\t\tIt is highly recommend to only install Conda packages in Conda code envs. Installing packages from CRAN in Conda code envs is likely to cause issues.\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"codemirror\">\n\t\t\t\t\t\t\t<textarea rows=\"5\" ng-model=\"requestedEnv.specPackageList\" ui-codemirror=\"codeEnvResourcesEditorOptions\"></textarea>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<a ng-click=\"openCRANEditHelp()\">Syntax help</a>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div ng-if=\"requestedEnv.installCorePackages && !useConda\">\n\t\t\t\t\t\t\t<legend ng-if=\"!useConda\" class=\"settings-section-title mtop20 text-weak\">For information: base packages (CRAN)</legend>\n\t\t\t\t\t\t\t<p>These are the packages required for the selected core features. These packages cannot be removed nor reversioned</p>\n\t\t\t\t\t\t\t<pre class=\"package-list\">{{requestedEnv.mandatoryPackageList}}</pre>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</form>\n\t\t</div>\n\t</div>\n\n\t<div class=\"modal-footer modal-footer-std-buttons\">\n\t\t<button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"cancelRequest()\">Cancel</button>\n\t\t<button ng-if=\"requestedEnv.envName && codeEnvModal.$modalTab === 'GENERAL' && isCodeEnvNameUnique(requestedEnv.envName)\" type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"nextTab()\">Next</button>\n\t\t<button ng-if =\"!requestedEnv.envName && codeEnvModal.$modalTab === 'GENERAL'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Cannot create env with an empty name\">Next</button>\n\t\t<button ng-if =\"requestedEnv.envName && !isCodeEnvNameUnique(requestedEnv.envName) && codeEnvModal.$modalTab === 'GENERAL'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Env already exists\">Next</button>\n\t\t<button ng-if=\"requestedEnv.envName && codeEnvModal.$modalTab === 'PACKAGES' && isCodeEnvNameUnique(requestedEnv.envName)\" type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"sendRequest()\">Request install</button>\n\t\t<button ng-if =\"!requestedEnv.envName && codeEnvModal.$modalTab === 'PACKAGES'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Cannot create env with an empty name\">Request install</button>\n\t\t<button ng-if =\"requestedEnv.envName && !isCodeEnvNameUnique(requestedEnv.envName) && codeEnvModal.$modalTab === 'PACKAGES'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Env already exists\">Request install</button>\n\t</div>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-python-env-from-draft-modal.html", "<div class=\"modal modal3 dku-modal\">\n    <div dku-modal-header modal-title=\"New Python env\" />\n\n    <form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newCodeEnvForm\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Deployment type</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"requestedEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n                </div>\n            </div>\n\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label\">Name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"requestedEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\" disabled/>\n                </div>\n            </div>\n\n\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                <label for=\"\" class=\"control-label\">External Conda env name</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"requestedEnv.externalCondaEnvName\"  />\n                </div>\n            </div>\n\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                <label for=\"\" class=\"control-label\">Python</label>\n                <div class=\"controls\">\n                    <select dku-bs-select ng-model=\"requestedEnv.pythonInterpreter\" ng-options=\"x[0] as x[1] for x in draftPythonInterpreters\" />\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED' && requestedEnv.pythonInterpreter == 'CUSTOM'\">\n                <label for=\"\" class=\"control-label\">Python executable</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"requestedEnv.customInterpreter\"  />\n                </div>\n            </div>\n\n\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                <label for=\"\" class=\"control-label\">Mandatory packages</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"requestedEnv.installCorePackages\" />\n                        <span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                <label for=\"\" class=\"control-label\">Jupyter</label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"checkbox\" ng-model=\"requestedEnv.installJupyterSupport\" />\n                        <span class=\"help-inline\">Install support for Jupyter notebooks</span>\n                    </label>\n                </div>\n            </div>\n            <div class=\"alert alert-warning mtop8\" ng-if=\"isPythonDeprecated()\">\n                <div>\n                    <i class=\"icon-dku-warning\"></i> The selected Python interpreter is deprecated and will soon be removed.\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"createEnvFromDraft()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n        </div>\n    </form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-python-env-modal.html", "<div class=\"modal modal3 dku-modal\">\n\t<div dku-modal-header modal-title=\"New Python env\" />\n\n\t<form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newCodeEnvForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Deployment type</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<select dku-bs-select ng-model=\"newEnv.deploymentMode\" ng-options=\"x[0] as x[1] for x in deploymentModes\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" ng-model=\"newEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">External Conda env name</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<input type=\"text\" required ng-model=\"newEnv.externalCondaEnvName\"  />\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Python</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<select dku-bs-select ng-model=\"newEnv.pythonInterpreter\" ng-options=\"x[0] as x[1] for x in pythonInterpreters\" />\n\t\t\t\t</div>\n\t\t\t</div>\n            <div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED' && newEnv.pythonInterpreter == 'CUSTOM'\">\n                <label for=\"\" class=\"control-label\">Python executable</label>\n                <div class=\"controls\">\n                    <input type=\"text\" required ng-model=\"newEnv.customInterpreter\"  />\n                </div>\n            </div>\n\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Conda</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.conda\" />\n                        <span class=\"help-inline\">Use conda</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Mandatory packages</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.installCorePackages\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div> \n\t\t\t<div class=\"control-group\" ng-if=\"newEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t<label for=\"\" class=\"control-label\">Jupyter</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label>\n\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"newEnv.installJupyterSupport\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Install support for Jupyter notebooks</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"alert alert-warning mtop8\" ng-if=\"isPythonDeprecated()\">\n\t\t\t\t<div>\n\t\t\t\t\t<i class=\"icon-dku-warning\"></i> The selected Python interpreter is deprecated and will soon be removed.\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newCodeEnvForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/new-python-env-request-modal.html", "<div class=\"modal modal3 dku-modal request-code-env-modal\">\n\t<dku-modal-header-with-totem modal-totem=\"icon-lock\">\n\t\t<dku-modal-title>\n\t\t\tRequest new python env\n\t\t</dku-modal-title>\n\t\t<dku-modal-tabs>\n\t\t\t<li class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'GENERAL'}\"><a ng-click=\"codeEnvModal.$modalTab = 'GENERAL'\">General</a></li>\n\t\t\t<li ng-if=\"requestedEnv.envName && isCodeEnvNameUnique(requestedEnv.envName)\" class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'PACKAGES'}\"><a ng-click=\"codeEnvModal.$modalTab = 'PACKAGES'\">Packages to install</a></li>\n\t\t\t<li ng-if=\"!requestedEnv.envName || !isCodeEnvNameUnique(requestedEnv.envName)\" class=\"tab\" ng-class=\"{'active': codeEnvModal.$modalTab == 'PACKAGES'}\" ><a style=\"cursor: not-allowed;\">Packages to install</a></li>\n\t\t</dku-modal-tabs>\n\t</dku-modal-header-with-totem>\n\n\t<div class=\"modal-body\" style=\"max-height: 400px !important;\">\n\t\t<div class=\"row-fluid\">\n\t\t\t<form class=\"dkuform-horizontal\" name=\"newCodeEnvRequestForm\">\n\t\t\t\t<div ng-if=\"codeEnvModal.$modalTab === 'GENERAL'\">\n\t\t\t\t\t<h5 class=\"font-weight-semi-bold\">You don't have the authorization to create a code env.</h5>\n\t\t\t\t\t<p>Contact the project administrators. <a href=\"{{$root.versionDocRoot}}collaboration/requests.html\" target=\"_blank\">Learn more</a></p>\n\t\t\t\t\t<textarea ng-model=\"codeEnvModal.message\" class=\"request-code-env-modal__message-input\" placeholder=\"Optional message\" maxlength=\"1000\" ng-trim=\"false\"/>\n\t\t\t\t\t<span class=\"request-plugin-modal__message-input-counter\" ng-style=\"codeEnvModal.message.length === 1000 && {'color': 'red'}\" >\n            \t\t\t{{codeEnvModal.message.length || 0}}/1000\n        \t\t\t</span>\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Name</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<input ng-required=\"true\" type=\"text\" ng-model=\"requestedEnv.envName\" required ng-pattern=\"/^[_A-Za-z0-9-]+$/\" custom-validation=\"isCodeEnvNameUnique\"/>\n\t\t\t\t\t\t\t<div class=\"request-code-env-modal__name-input-error alert alert-error\" ng-show=\"!isCodeEnvNameUnique(requestedEnv.envName)\">\n\t\t\t\t\t\t\t\tCode env \"{{requestedEnv.envName}}\" already exists.\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\" ng-if=\"requestedEnv.deploymentMode == 'DESIGN_MANAGED'\">\n\t\t\t\t\t\t<label class=\"control-label\" >Python</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<select dku-bs-select ng-model=\"requestedEnv.pythonInterpreter\" ng-change=\"updateDefaultCorePackageSet()\" ng-options=\"x[0] as x[1] for x in requestPythonInterpreters\"/>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\n\n\t\t\t\t<div ng-if=\"codeEnvModal.$modalTab === 'PACKAGES'\">\n\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Install core packages</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"requestedEnv.installCorePackages\" />\n\t\t\t\t\t\t\t\t<span class=\"help-inline\">Install mandatory set of packages (you won't be able to use Dataiku APIs without this)</span>\n\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<label class=\"control-label\">Install Jupyter support</label>\n\t\t\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t<input type=\"checkbox\" ng-model=\"requestedEnv.installJupyterSupport\" />\n\t\t\t\t\t\t\t\t<span class=\"help-inline\">Install support for Jupyter notebooks</span>\n\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\" ng-if=\"useConda\">\n\t\t\t\t\t\t<legend class=\"settings-section-title mtop0\">Requested packages (Conda)</legend>\n\t\t\t\t\t\t<div class=\"pull-right\" style=\"line-height: 30px; margin-left: 10px;\">\n\t\t\t\t\t\t\t<button class=\"btn btn--secondary\" ng-click=\"insertAdditionalPackages('conda')\">Add sets of packages</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<p>\n\t\t\t\t\t\t\t\tAdd here the packages that you want to be available in the environment.\n\t\t\t\t\t\t\t</p>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"codemirror\">\n\t\t\t\t\t\t\t<textarea rows=\"5\" ng-model=\"requestedEnv.specCondaEnvironment\" ui-codemirror=\"specPackageListEditorOptionsConda\"></textarea>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<a ng-click=\"openPyCondaSpecEditHelp()\">Syntax help</a>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t<legend class=\"settings-section-title mtop0\">Requested packages (Pip)</legend>\n\t\t\t\t\t\t<div ng-if=\"!useConda\" class=\"pull-right\" style=\"line-height: 30px; margin-left: 10px;\">\n\t\t\t\t\t\t\t<button class=\"btn btn--secondary\" ng-click=\"insertAdditionalPackages('pip')\">Add a set of packages</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<p>\n\t\t\t\t\t\t\t\tAdd here the packages that you want to be available in the environment.\n\t\t\t\t\t\t\t</p>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div ng-if=\"useConda\" class=\"alert alert-warning\">\n\t\t\t\t\t\t\t<i class=\"icon-warning-sign\"></i>&nbsp;\n\t\t\t\t\t\t\tDo not put packages here that are installed as conda packages or available as conda packages (including on conda-forge). Doing so is very likely to cause issues with those packages.\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"codemirror\">\n\t\t\t\t\t\t\t<textarea rows=\"5\" ng-model=\"requestedEnv.specPackageList\" ui-codemirror=\"specPackageListEditorOptionsPip\"></textarea>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<a ng-click=\"openPipRequirementsEditHelp()\">Syntax help</a>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\n\t\t\t\t</div>\n\t\t\t</form>\n\t\t</div>\n\t</div>\n\n\t<div class=\"modal-footer modal-footer-std-buttons\">\n\t\t<button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"cancelRequest()\">Cancel</button>\n\t\t<button ng-if=\"requestedEnv.envName && codeEnvModal.$modalTab === 'GENERAL' && isCodeEnvNameUnique(requestedEnv.envName)\" type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"nextTab()\">Next</button>\n\t\t<button ng-if =\"!requestedEnv.envName && codeEnvModal.$modalTab === 'GENERAL'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Cannot create env with an empty name\">Next</button>\n\t\t<button ng-if =\"requestedEnv.envName && !isCodeEnvNameUnique(requestedEnv.envName) && codeEnvModal.$modalTab === 'GENERAL'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Env already exists\">Next</button>\n\t\t<button ng-if=\"requestedEnv.envName && codeEnvModal.$modalTab === 'PACKAGES' && isCodeEnvNameUnique(requestedEnv.envName)\" type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"sendRequest()\">Request install</button>\n\t\t<button ng-if =\"!requestedEnv.envName && codeEnvModal.$modalTab === 'PACKAGES'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Cannot create env with an empty name\">Request install</button>\n\t\t<button ng-if =\"requestedEnv.envName && !isCodeEnvNameUnique(requestedEnv.envName) && codeEnvModal.$modalTab === 'PACKAGES'\" class=\"btn btn--text btn--primary\" ng-disabled=\"true\" toggle=\"tooltip\" title=\"Env already exists\">Request install</button>\n\t</div>\n</div>\n");
$templateCache.put("/templates/admin/code-envs/design/python-edit.html", "<div class=\"fh code-env\" global-keydown=\"{'ctrl-s meta-s':'saveAndMaybePerformChanges(false)'}\">\n    <div class=\"h100 row-fluid\">\n        <div class=\"span2 offset0 nav-list-sidebar sidebar-admin\" style=\"padding-top: 0;\">\n            <div class=\"horizontal-flex\" style=\"height: auto;\">\n                <div class=\"flex mx-textellipsis\">\n                    <h4 class=\"mx-textellipsis\" title=\"{{codeEnv.envName}}\">{{codeEnv.envName}}</h4>\n                </div>\n                <div class=\"noflex center-children\" style=\"font-size: 14px; opacity: 0.8;\" ng-if=\"codeEnv.canUpdateCodeEnv || isExportable(codeEnv)\">\n                    <div custom-element-popup cep-position=\"align-right-bottom\" close-on-click=\"true\">\n                        <i class=\"icon-cog mainzone cursor-pointer\" ng-click=\"togglePopover()\"></i>\n                        <ul class=\"popover custom-element-popup-popover dropdown-menu\">\n                            <li ng-if=\"isExportable(codeEnv)\">\n                                <a ng-click=\"exportEnv(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Export</a>\n                            </li>\n                            <li ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                                <a ng-click=\"openDeleteEnvModal(codeEnv)\"><i class=\"icon-trash\"></i>&nbsp;Delete</a>\n                            </li>\n                            <li>\n                                <a ng-click=\"getEnvDiagnostic(envLang, codeEnv.envName)\"><i class=\"icon-download\"></i>&nbsp;Get diagnostic</a>\n                            </li>\n                        </ul>\n                    </div>\n                </div>\n            </div>\n            <ul>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'info'}\" full-click>\n                    <a ng-click=\"uiState.active = 'info'\" main-click>General</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'required'}\" full-click ng-if=\"codeEnv.deploymentMode == 'DESIGN_MANAGED'\">\n                    <a ng-click=\"uiState.active = 'required'\" main-click>Packages to install</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'actual'}\" full-click ng-if=\"['DESIGN_MANAGED', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'actual'\" main-click>Currently installed packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'packages'}\" full-click ng-if=\"codeEnv.deploymentMode == 'DESIGN_NON_MANAGED' || codeEnv.deploymentMode == 'PLUGIN_NON_MANAGED' || codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                    <a ng-click=\"uiState.active = 'packages'\" main-click>Packages</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'permissions'}\" full-click ng-if=\"codeEnv.canManageUsersCodeEnv\">\n                    <a ng-click=\"uiState.active = 'permissions'\" main-click>Permissions</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'containers'}\" full-click ng-if=\"['DESIGN_MANAGED', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                    <a ng-click=\"uiState.active = 'containers'\" main-click>Containerized execution</a>\n                </li>\n                <li ng-if=\"!['EXTERNAL_CONDA_NAMED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\" ng-class=\"{'l1': true, 'active': uiState.active == 'resources'}\" full-click>\n                    <a ng-click=\"uiState.active = 'resources'\" main-click>Resources</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'logs'}\" full-click>\n                    <a ng-click=\"uiState.active = 'logs'\" main-click>Logs</a>\n                </li>\n                <li ng-class=\"{'l1': true, 'active': uiState.active == 'usages'}\" full-click ng-if=\"codeEnv.canUpdateCodeEnv\">\n                    <a ng-click=\"uiState.active = 'usages'\" main-click>Usages</a>\n                </li>\n            </ul>\n            <div ng-include=\"'/templates/admin/code-envs/common/save-update-buttons.html'\"></div>\n        </div>\n        <div class=\"span10 h100 offset0 boxed-next-to-sidebar no-padding\" ng-switch=\"uiState.active\">\n            <div ng-switch-when=\"info\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code environment</h2>\n                <div block-api-error />\n                <form class=\"dkuform-horizontal\">\n                    <div class=\"section\">\n                        <h2>General info</h2>\n\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Mode</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.deploymentMode}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"\" class=\"control-label\">Owner</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.owner}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['DESIGN_MANAGED', 'DESIGN_NON_MANAGED', 'PLUGIN_NON_MANAGED'].indexOf(codeEnv.deploymentMode) >= 0\">\n                        <label for=\"\" class=\"control-label\">Location of the environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.path}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group horizontal-flex\" ng-if=\"codeEnv.deploymentMode == 'DESIGN_MANAGED' && codeEnv.desc.pythonInterpreter\" >\n                        <label for=\"\" class=\"control-label\">Python interpreter</label>\n                        <div class=\"mleft8\" style=\"display:flex; align-items:center\">\n                            <span ng-class=\"{'text-warning': isPythonDeprecated(codeEnv.desc.pythonInterpreter)}\">{{codeEnv.pythonInterpreterFriendlyName }} </span>\n                            <span class=\"text-warning\" ng-if=\"isPythonDeprecated(codeEnv.desc.pythonInterpreter)\" toggle=\"tooltip\" title=\"{{codeEnv.desc.pythonInterpreter}} is deprecated and will be removed soon\">\n                                <i class=\"icon-dku-warning\"></i>\n                            </span>\n                        </div>\n                        <button class=\"btn btn--primary mleft16\" ng-click=\"openChangePythonInterpreterModal(codeEnv)\" ng-disabled=\"specIsDirty()\">Change Python interpreter</button>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'EXTERNAL_CONDA_NAMED'\">\n                        <label for=\"\" class=\"control-label\">Conda environment</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.desc.externalCondaEnvName}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.deploymentMode == 'DESIGN_MANAGED' || codeEnv.deploymentMode == 'PLUGIN_MANAGED'\">\n                        <label for=\"\" class=\"control-label\">Uses conda</label>\n                        <div class=\"controls\">\n                            {{codeEnv.desc.conda ? \"Yes\" : \"No\"}}\n                            <span class=\"help-inline\">Whether to use Conda to create and manage the packages. If not, use simply virtualenv and pip.</span>\n                        </div>\n                    </div>\n                    </div>\n                    <div class=\"section\">\n                    <h2 ng-if=\"appConfig.sparkEnabled\">Spark</h2>\n                    <div class=\"control-group\" ng-if=\"appConfig.sparkEnabled\">\n                        <label for=\"\" class=\"control-label\">Yarn Python executable</label>\n                        <div class=\"controls\">\n                            <input type=\"text\" ng-model=\"codeEnv.desc.yarnPythonBin\" />\n                            <span class=\"help-inline\">Python binary on the Yarn nodes for Pyspark (save, remove then re-install jupyter support to update in notebooks)</span>\n                        </div>\n                    </div>\n                    </div>\n\n\n                    <div class=\"section\">\n                    <h2 >Extra options</h2>\n\n                    <div ng-if=\"codeEnv.desc.envSettings\">\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Inherit global settings</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.desc.envSettings.inheritGlobalSettings\" />\n                                </label>\n                             </div>\n                        </div>\n\n                         <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings && codeEnv.desc.conda\">\n                             <label for=\"\" class=\"control-label\">Extra options for 'conda create'</label>\n                             <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.condaCreateExtraOptions\" add-label=\"Add option for 'conda create'\" value-placeholder=\"E.g. --clone, --dev...\"/>\n                             </div>\n                         </div>\n                         <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings && codeEnv.desc.conda\">\n                             <label for=\"\" class=\"control-label\">Extra options for 'conda install'</label>\n                             <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.condaInstallExtraOptions\" add-label=\"Add option for 'conda install'\" value-placeholder=\"E.g. -n, -p...\"/>\n                             </div>\n                         </div>\n                        <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'pip install'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.pipInstallExtraOptions\" add-label=\"Add option for 'pip install'\" value-placeholder=\"E.g. -i, --trusted-host...\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"!codeEnv.desc.envSettings.inheritGlobalSettings\">\n                            <label for=\"\" class=\"control-label\">Extra options for 'virtualenv'</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                <ng2-values-list [(items)]=\"codeEnv.desc.envSettings.virtualenvCreateExtraOptions\" add-label=\"Add option for 'virtualenv'\" value-placeholder=\"E.g. -p, --system-site-packages...\"/>\n                            </div>\n                        </div>\n                        </div>\n                    </div>\n\n                    <div class=\"section\">\n                    <h2>Jupyter</h2>\n                    <div class=\"control-group\" ng-if=\"['DESIGN_MANAGED', 'PLUGIN_MANAGED', 'DSS_INTERNAL'].includes(codeEnv.deploymentMode)\">\n                        <label for=\"\" class=\"control-label\">Python interpreter</label>\n                        <div class=\"controls\">\n                            <div>{{codeEnv.desc.pythonInterpreter == 'CUSTOM' ? codeEnv.desc.customInterpreter : codeEnv.desc.pythonInterpreter}}</div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"!codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <span style=\"margin-right: 50px\">{{codeEnv.kernelSpecName || 'not installed'}}</span>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"installJupyterSupport()\">(Re)install Jupyter support</button>\n                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"removeJupyterSupport()\">Remove Jupyter support</button>\n                            <span class=\"help-inline\">(needs ipykernel package to be in the env)</span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"codeEnv.unknownKernelSpecStatus\">\n                        <label for=\"\" class=\"control-label\">Jupyter kernel</label>\n                        <div class=\"controls\">\n                            <div>Unable to check status</div>\n                             <div ng-if=\"codeEnv.kernelSpecsListingError\" api-error-alert=\"codeEnv.kernelSpecsListingError\" />\n                        </div>\n                    </div>\n                    </div>\n                </form>\n            </div>\n\n            <div ng-switch-when=\"usages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env usages</h1>\n                <div class=\"section\">\n                    <code-env-usage env-lang=\"{{envLang}}\" env-name=\"{{codeEnv.envName}}\"/>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"permissions\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Permissions</h1>\n                <div class=\"section\">\n                    <div code-env-security-permissions code-env=\"codeEnv\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"required\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages to install</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <div>\n                    <form class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Install core packages</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"codeEnv.desc.installCorePackages\" ng-change=\"refreshMandatoryPackageList()\"/>\n                                            <span class=\"help-inline\">\n                                                Install mandatory set of packages (you won't be able to use Dataiku APIs without this)\n                                            </span>\n                                        </label>\n                                    </div>\n                                </div>\n                            </div>\n                            <div class=\"span6\">\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Core packages versions</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select ng-options=\"x[0] as x[1] for x in [['LEGACY_PANDAS023', 'Pandas 0.23 (legacy)'],['PANDAS10', 'Pandas 1.0 (Python 3.6 and above)'],['PANDAS11', 'Pandas 1.1 (Python 3.6 and above)'],['PANDAS12', 'Pandas 1.2 (Python 3.7 and above)'],['PANDAS13', 'Pandas 1.3 (Python 3.7 and above)'],['PANDAS14', 'Pandas 1.4 (Python 3.8 and above)'],['PANDAS15', 'Pandas 1.5 (Python 3.8 and above)'],['PANDAS20', 'Pandas 2.0 (Python 3.8 and above)'],['PANDAS21', 'Pandas 2.1 (Python 3.9 and above)'],['PANDAS22', 'Pandas 2.2 (Python 3.9 and above)'],['PANDAS23', 'Pandas 2.3 (Python 3.9 and above)']]\" ng-model=\"codeEnv.desc.corePackagesSet\" ng-change=\"refreshMandatoryPackageList()\"/>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Install Jupyter support</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"codeEnv.desc.installJupyterSupport\" ng-change=\"refreshMandatoryPackageList()\" />\n                                    <span class=\"help-inline\">\n                                        Install support for Jupyter notebooks\n                                    </span>\n                                </label>\n                            </div>\n                        </div>\n                    </form>\n                </div>\n                <hr />\n\n                <div class=\"row-fluid\">\n                    <div class=\"span6\" ng-if=\"codeEnv.desc.conda\">\n                        <div ng-if=\"getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore('conda').length > 0\" class=\"alert alert-warning\">\n                            The following packages were previously \"Requested\" and are currently installed, but have been removed from the\n                            requested list. These packages may become unavailable. Check whether this is desired.<br />\n                            <strong>{{getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore('conda').join(', ')}}</strong>\n                        </div>\n\n                        <div ng-if=\"isPackageRequired('conda', 'pyspark') || isPackageInstalled('conda', 'pyspark')\" class=\"alert alert-warning\">\n                            <b>pyspark</b> is {{ isPackageInstalled('conda', 'pyspark') ? 'installed in' : 'in the requested packages of' }} your code env.\n                            It is not recommended to install pyspark manually. Please refer to\n                            <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/latest/spark/usage.html\">the documentation</a>\n                            to find out how to interact with Spark in the recommended way.\n                        </div>\n\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Requested packages (Conda)</legend>\n                        <div>\n                            <div class=\"pull-right\" style=\"line-height: 30px; margin-left: 10px;\">\n                                <button class=\"btn btn--secondary\" ng-click=\"insertAdditionalPackages('conda')\">Add sets of packages</button>\n                            </div>\n                            <p>\n                                Add here the packages that you want to be available in the environment. <strong>Do not remove packages once they are installed.</strong> Only packages mentioned here are guaranteed to be installed.<br />\n                            </p>\n                        </div>\n                        <div class=\"codemirror\">\n                            <textarea ng-model=\"codeEnv.specCondaEnvironment\" ui-codemirror=\"specPackageListEditorOptionsConda\"></textarea>\n                        </div>\n                        <div>\n                            <a ng-click=\"openPyCondaSpecEditHelp()\">Syntax help</a>\n                        </div>\n                        <legend class=\"settings-section-title mtop20 text-weak\">For information: base packages (Conda)</legend>\n                        <p>These are the packages required for the selected core features. These packages cannot be removed nor reversioned</p>\n                        <pre class=\"package-list\">{{codeEnv.mandatoryCondaEnvironment}}</pre>\n                    </div>\n                    <div class=\"span6 \">\n                        <div ng-if=\"getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore('pip').length > 0\" class=\"alert alert-warning\">\n                            The following packages were previously \"Requested\" and are currently installed, but have been removed from the\n                            requested list. These packages may become unavailable. Check whether this is desired.<br />\n                            <strong>{{getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore('pip').join(', ')}}</strong>\n                        </div>\n\n                        <div ng-if=\"isPackageRequired('pip', 'pyspark') || isPackageInstalled('pip', 'pyspark')\" class=\"alert alert-warning\">\n                            <b>pyspark</b> is {{ isPackageInstalled('pip', 'pyspark') ? 'installed in' : 'in the requested packages of' }} your code env.\n                            It is not recommended to install pyspark manually. Please refer to\n                            <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/latest/spark/usage.html\">the documentation</a>\n                            to find out how to interact with Spark in the recommended way.\n                        </div>\n\n                        <legend class=\"settings-section-title mtop0\">Requested packages (Pip)</legend>\n                        <div>\n                            <div class=\"pull-right\" style=\"line-height: 30px; margin-left: 10px;\">\n                                <button class=\"btn btn--secondary\" ng-if=\"!codeEnv.desc.conda\" ng-click=\"insertAdditionalPackages('pip')\">Add sets of packages</button>\n                            </div>\n                            <p>\n                                Add here the packages that you want to be available in the environment. <strong>Do not remove packages once they are installed.</strong> Only packages mentioned here are guaranteed to be installed.<br />\n                            </p>\n                        </div>\n                        <div ng-if=\"codeEnv.desc.conda\" class=\"alert alert-warning\">\n                                <i class=\"icon-warning-sign\"></i>&nbsp;\n                                Do not put packages here that are installed as conda packages or available as conda packages (including on conda-forge). Doing so is very likely to cause issues with those packages.\n                        </div>\n                        <div class=\"codemirror\">\n                            <textarea rows=\"5\" ng-model=\"codeEnv.specPackageList\" ui-codemirror=\"specPackageListEditorOptionsPip\"></textarea>\n                        </div>\n                        <div>\n                            <a ng-click=\"openPipRequirementsEditHelp()\">Syntax help</a>\n                        </div>\n                        <legend class=\"settings-section-title mtop20 text-weak\">For information: base packages (Pip)</legend>\n                        <p>These are the packages required for the selected core features. These packages cannot be removed nor reversioned</p>\n                        <pre class=\"package-list\">{{codeEnv.mandatoryPackageList}}</pre>\n                    </div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"actual\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Currently installed packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <div class=\"row-fluid\">\n                    <div class=\"span6\" ng-if=\"codeEnv.desc.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Installed packages (Conda)</legend>\n                        <div class=\"alert alert-info\">\n                            These are the packages that are <strong>currently</strong> installed in the code env. Note that only the list in \"Packages to install\" is authoritative as to which packages will be installed.<br />\n                            Packages that are not in \"Packages to install\" may not be installed when rebuilding this env or in containers.<br />\n                            This list only reflects the \"local\" code env, not what is available in containers.\n\n                        </div>\n                        <pre class=\"package-list\">{{codeEnv.actualCondaEnvironment}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 0;\">Installed packages (Pip)</legend>\n                        <div class=\"alert alert-info\">\n                            These are the packages that are <strong>currently</strong> installed in the code env. Note that only the list in \"Packages to install\" is authoritative as to which packages will be installed.<br />\n                            Packages that are not in \"Packages to install\" may not be installed when rebuilding this env or in containers.<br />\n                            This list only reflects the \"local\" code env, not what is available in containers.\n                        </div>\n                        <pre class=\"package-list\">{{codeEnv.actualPackageList}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"packages\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Packages</h1>\n                <div block-api-error />\n                <div class=\"section\">\n                <button class=\"btn btn--secondary\" ng-click=\"fetchNonManagedEnvDetails()\">Fetch packages list</button>\n\n                <div class=\"row-fluid\" ng-if=\"nonManagedEnvDetails\">\n                    <div class=\"span6\" ng-if=\"nonManagedEnvDetails.conda\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Conda)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.condaEnvSpec}}</pre>\n                    </div>\n                    <div class=\"span6\">\n                        <legend class=\"settings-section-title\" style=\"margin-top: 10px;\">Packages (Pip)</legend>\n                        <pre class=\"package-list\">{{nonManagedEnvDetails.nocondaEnvSpec}}</pre>\n                    </div>\n                </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"logs\" class=\"h100 vertical-flex paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Code env logs</h1>\n                <div class=\"flex\">\n                    <div class=\"section fh\">\n                        <div simple-logs logs=\"logs\" obj-id=\"[envLang, envName]\" get-log=\"getLog\" download-url=\"downloadURL\"/>\n                    </div>\n                </div>\n\n            </div>\n\n            <div ng-switch-when=\"containers\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Containerized execution</h1>\n                <div class=\"section\">\n                    <div code-env-containers code-env=\"codeEnv\" env-lang=\"envLang\" deployment-mode=\"codeEnv.deploymentMode\"></div>\n                </div>\n            </div>\n\n            <div ng-if=\"codeEnv.deploymentMode !== 'EXTERNAL_CONDA_NAMED'\" ng-switch-when=\"resources\" class=\"h100 oa paned-settings-page-pane\" style=\"position: relative;\">\n                <h1>Resources</h1>\n                <div class=\"section\">\n                    <div\n                        ng-if=\"!!codeEnv.desc.installCorePackages\"\n                        code-env-resources\n                        code-env=\"codeEnv\"\n                        env-name=\"codeEnv.envName\"\n                        node-type=\"DESIGN\"\n                        can-update-code-env=\"codeEnv.canUpdateCodeEnv\"\n                        deployment-mode=\"codeEnv.deploymentMode\"\n                        editor-options=\"codeEnvResourcesEditorOptions\"></div>\n                    <div ng-if=\"!codeEnv.desc.installCorePackages\" class=\"alert alert-warning\">\n                        Cannot use code-environment resources without the core packages.\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-studios/add-block-modal.html", "<div class=\"modal modal3 dku-modal\">\n\t<div dku-modal-header modal-title=\"Select a block type\" />\n\n\t<form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\"\n          name=\"addCodeStudioTemplateBlockForm\">\n\t\t<div class=\"modal-body\">\n            <div class=\"code-studio-template__block-search\">\n                <div class=\"std-list-search-box\">\n                    <span class=\"add-on\"><i class=\"icon-dku-search\"></i></span>\n                    <input type=\"text\" ng-model=\"uiState.blocQuery\" placeholder=\"Filter...\"/>\n                </div>\n                <div ng-show=\"filteredBlocks.length < blocksCount\" class=\"pull-right\">\n                    <strong>{{filteredBlocks.length}}</strong> of <strong>{{blocksCount}}</strong>\n                </div>\n            </div>\n            <ul class=\"code-studio-template--selectable-items-list selectable\">\n                <li ng-repeat=\"blockType in filteredBlocks\"\n                    class=\"code-studio-template--selectable-item hoverable\"\n                    ng-class=\"{'disabled':!blockTypeCanBeAdded(blockType), 'selectable':blockTypeCanBeAdded(blockType)}\"\n                    ng-if=\"!blockType.isLocked\"\n                    ng-click=\"blockTypeCanBeAdded(blockType) && selectBlock(blockType)\">\n                    <div class=\"code-studio-template--block-type-icon\">\n                        <i ng-if=\"blockType.icon\" ng-class=\"blockType.icon\" class=\"mright8\"/>\n                    </div>\n                    <div class=\"code-studio-template--block-type-name\">{{blockType.label}}<span ng-if=\"blockType.isAdvanced\" class=\"code-studio-template--block-type-advanced\"> [Advanced]</span></div>\n                    <div class=\"code-studio-template--block-type-desc\">{{blockType.description}}<span ng-if=\"blockType.isUnique\"> (unique)</span></div>\n                </li>\n            </ul>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/code-studios/add-code-env-block.html", "                        \n<div class=\"control-group\">\n    <label for=\"codeEnv\" class=\"control-label\">Code Environment</label>\n    <div class=\"controls\">\n        <select id=\"codeEnv\"\n                ng-model=\"ui.codeEnv\"\n                dku-bs-select=\"{liveSearch:true,size:'auto'}\"\n                ng-options=\"c as c.envName group by c.envLang for c in availableCodeEnvs | orderBy:codeEnvComparator(codeEnv.source) track by c.envName\">\n        </select>\n    </div>\n</div>\n<div class=\"control-group\" ng-if=\"ui.versionIds.length > 0\">\n    <label for=\"codeEnvVersion\" class=\"control-label\">Version</label>\n    <div class=\"controls\">\n        <select id=\"codeEnvVersion\"\n                dku-bs-select=\"{liveSearch:true,size:'auto'}\"\n                ng-options=\"v for v in ui.versionIds\"\n                ng-model=\"block.params.versionId\">\n        </select>\n    </div>\n</div>\n<div class=\"control-group\">\n    <label for=\"codeEnvDir\" class=\"control-label\">Sub-Directory</label>\n    <div class=\"controls\">\n        <input id=\"codeEnvDir\" type=\"text\" ng-model=\"block.params.envDir\" ng-pattern=\"/^(.(?!\\.\\.\\/))+$/\"/> <!-- only forbid \"../\". backend will catch the rest -->\n        <span class=\"help-inline\">Leave empty for default.</span>\n    </div>\n</div>\n<div class=\"control-group\">\n    <div class=\"controls\">\n        <div class=\"help-inline\">Environment will be available under {{getFullEnvDir()}}</div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-studios/block_based-code-studio-template-params.html", "<form class=\"dkuform-horizontal\">\n\n    <div ui-sortable=\"{axis:'y', cursor: 'move', handle: '.handle', items: 'div.sortable'}\"\n         ng-model=\"codeStudioTemplate.params.blocks\">\n\n        <div ng-repeat=\"block in codeStudioTemplate.params.blocks\"\n             class=\"repeatable-config-block\"\n             style=\"padding: 8px 8px 8px 0\"\n             ng-class=\"{'sortable': !isLockedBlock(block)}\">\n            <div class=\"horizontal-flex\">\n\n                <div ng-if=\"isLockedBlock(block)\" class=\"noflex handle code-studio-template__handle locked\">\n                    <i class=\"icon-lock\" toggle=\"tooltip\" container=\"body\" title=\"Mandatory block: it can't be re/moved\"/>\n                </div>\n                <div ng-if=\"!isLockedBlock(block)\" class=\"noflex handle code-studio-template__handle\">\n                    <i class=\"icon-dku-handle\"/>\n                </div>\n\n                <div class=\"flex\">\n\n                    <div class=\"code-studio-template__block-header\">\n                        <div ng-click=\"foldBlock(block, $event.ctrlKey)\"\n                             class=\"code-studio-template__block-header__foldable\">\n                            <div>\n                                <h3 class=\"dib code-studio-template__block-title\">\n                                    {{ niceBlockTypeLabel(block) }}\n                                    <span ng-if=\"block.params.actionName || block.params.label\">: {{ block.params.actionName || block.params.label }}</span>\n                                    <span ng-if=\"block.params.envLang && block.params.envName\">: {{ block.params.envLang | capitalizeWord }} {{ block.params.envName }}</span>\n                                </h3>\n                                <i ng-class=\"{'icon-chevron-up':block.$show, 'icon-chevron-down':!block.$show}\" class=\"mleft8\" ></i>\n                            </div>\n                            <div class=\"code-studio-template__block-subtitle\">{{ niceBlockTypeDesc(block) }}</div>\n                        </div>\n                        <a ng-if=\"!isLockedBlock(block)\"\n                           ng-click=\"removeBlock($index)\"\n                           toggle=\"tooltip\"\n                           container=\"body\"\n                           title=\"Delete block\"\n                           data-qa-code-studio-template-delete-block>\n                            <i class=\"icon-trash error-text-color\"></i>\n                        </a>\n                    </div>\n\n                    <div ng-if=\"block.type == 'dss_base_image'\"\n                         ng-show=\"block.$show\"\n                         class=\"code-studio-template__block-body\">\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Synchronized files</label>\n                            <span class=\"help-inline\">Map folders from the DSS server to folders inside the codeStudio. Optionally restrict to a subfolder of a folder of the DSS folder. Optionally make one-way (click on arrow)</span>\n                            <div class=\"controls\">\n                                <editable-list full-width-list=\"true\" ng-model=\"block.params.syncedZones\" add-label=\"Add mapped folder\" template=\"buildNewSyncZone\" transcope=\"{params:block.params}\">\n                                    <div>\n                                        <select dku-bs-select ng-model=\"it.zone\">\n                                            <option value=\"code_studio_versioned\">Code Studio versioned files</option>\n                                            <option value=\"code_studio_resources\">Code Studio resources</option>\n                                            <option value=\"project_lib_versioned\">Project libraries</option>\n                                            <option value=\"project_lib_resources\">Project resources</option>\n                                            <option value=\"recipes\">Project recipes</option>\n                                            <option value=\"notebooks\">Project notebooks</option>\n                                            <option value=\"user_versioned\">User config</option>\n                                            <option value=\"user_resources\">User resources</option>\n                                        </select>\n                                    </div>\n                                    &nbsp;/&nbsp;\n                                    <input style=\"min-width: 206px\" type=\"text\" ng-disabled=\"true\" ng-if=\"it.zone == 'recipes'\"></input>\n                                    <editable-list-input style=\"min-width: 206px\" type=\"text\" ng-model=\"it.pathInZone\" ng-if=\"it.zone != 'recipes'\"/>\n                                    <button type=\"button\" class=\"btn btn--text btn--secondary btn--icon btn--dku-icon mleftright4\" ng-click=\"it.oneWay=!it.oneWay;\">\n                                        <i class=\"editable-list__arrow-icon\" ng-class=\"{'dku-icon-arrow-right-long-16':it.oneWay, 'dku-icon-arrow-input-output-16':!it.oneWay}\"></i>\n                                    </button>\n                                    <editable-list-input full-width-input=\"true\" type=\"text\" ng-model=\"it.pathInContainer\"/>\n                                </editable-list>\n                            </div>\n                        </div>\n\n                        <div class=\"alert alert--warning\" ng-repeat=\"conflict in listSyncedZoneConflicts(block.params.syncedZones)\">\n                            The path <em>{{conflict.pathInContainer}}</em> is used in zones {{conflict.zones}}\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Excluded files</label>\n                            <div class=\"controls\">\n                                <ng2-values-list full-width-list=\"true\" [(items)]=\"block.params.excludedFromSync\" add-label=\"Add an excluded pattern\" value-placeholder=\"E.g. *.ipynb\"></ng2-values-list>\n                                <span class=\"help-inline\">Patterns for excluding files/folders created in Code Studios from synchronization</span>\n                            </div>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"block.type == 'simple_deployment'\"\n                         ng-show=\"block.$show\"\n                         class=\"code-studio-template__block-body\">\n                        <div class=\"code-studio-template__section mleft0\">\n                            <div class=\"control-group\">\n                                <label for=\"useTcpReadiness{{$index}}\" class=\"control-label\">Use TCP probing</label>\n                                <div class=\"controls\">\n                                    <label style=\"font-size: inherit\">\n                                        <input id=\"useTcpReadiness{{$index}}\" type=\"checkbox\" ng-model=\"block.params.useTcpReadiness\"/>\n                                        <span class=\"help-inline\">Kubernetes will check readiness by probing the first exposed port directly with TCP</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Readiness probe</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"block.params.readinessProbeUrl\"/>\n                                    <span class=\"help-inline\">HTTP URL to use to probe whether the service in the Code Studio is up and running: [http(s)://host[:port]/]path/to/probe</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"block.params.readinessProbeUrl && block.params.readinessProbeUrl.length > 0\">\n                                <label class=\"control-label\">Readiness probe headers</label>\n                                <div class=\"controls\">\n                                    <ng2-key-values-list [(items)]=\"block.params.readinessProbeHeaders\"\n                                                         value-placeholder=\"Header value\"\n                                                         key-placeholder=\"Header name\"\n                                                         add-label=\"Add HTTP header\">\n                                    </ng2-key-values-list>\n                                    <span class=\"help-inline\">HTTP headers to use for the readiness probe</span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Initial synchronization timeout</label>\n                                <div class=\"controls\">\n                                    <input type=\"number\" min=\"1\" max=\"99\" ng-model=\"block.params.initialSyncTimeoutInMinutes\"/>\n                                    <span class=\"help-inline\">Maximum time for the synchronization of all zones at startup in minutes</span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Extra labels</label>\n                                <div class=\"controls\">\n                                    <ng2-key-values-list\n                                        [(items)]=\"block.params.labels\"\n                                        key-placeholder=\"Key\"\n                                        value-placeholder=\"Value\"\n                                        add-label=\"Add label\">\n                                    </ng2-key-values-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Extra annotations</label>\n                                <div class=\"controls\">\n                                    <ng2-key-values-list\n                                        [(items)]=\"block.params.annotations\"\n                                        key-placeholder=\"Key\"\n                                        value-placeholder=\"Value\"\n                                        add-label=\"Add annotation\">\n                                    </ng2-key-values-list>\n                                </div>\n                            </div>\n\n\n                        </div>\n                        <div ng-repeat=\"exposedPort in block.params.exposedPorts\"\n                             class=\"code-studio-template__section mleft0\">\n                            <a ng-click=\"removeSimpleDeploymentExposedPort(block, $index)\"\n                               toggle=\"tooltip\" container=\"body\" title=\"Remove this exposed port\"\n                               class=\"pull-right\">\n                                <i class=\"icon-trash error-text-color\"></i>\n                            </a>\n                            <div class=\"control-group\">\n                                <label for=\"portLabel{{$index}}\" class=\"control-label\">Exposed port label</label>\n                                <div class=\"controls\">\n                                    <input id=\"portLabel{{$index}}\" type=\"text\" ng-model=\"exposedPort.label\" ng-required=\"true\"/>\n                                    <span class=\"help-inline\">Tab's name in the Code Studio view</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"portShow{{$index}}\" class=\"control-label\">Expose HTML service</label>\n                                <div class=\"controls\">\n                                    <label style=\"font-size: inherit\">\n                                        <input id=\"portShow{{$index}}\" type=\"checkbox\" ng-model=\"exposedPort.exposeHtml\"/>\n                                        <span class=\"help-inline\">This allows you to consult it from DSS</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"portExposed{{$index}}\" class=\"control-label\">Exposed port</label>\n                                <div class=\"controls\">\n                                    <input id=\"portExposed{{$index}}\" type=\"number\" force-integer ng-model=\"exposedPort.port\" min=\"1\" max=\"65535\" ng-required=\"true\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"portSubpath{{$index}}\" class=\"control-label\">Proxied subpath</label>\n                                <div class=\"controls\">\n                                    <input id=\"portSubpath{{$index}}\" type=\"text\" ng-model=\"exposedPort.proxiedUrlSuffix\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Header for proxy prefix</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"exposedPort.proxyPrefixHeaderName\"/>\n                                    <span class=\"help-inline\">Optional header name to pass the prefix behind which the port is exposed by DSS to the server inside the pod</span>\n                                </div>\n                            </div>\n                        </div>\n                        <button class=\"btn btn--text btn--secondary mtop8\"\n                                ng-click=\"addSimpleDeploymentExposedPort(block)\"><i class=\"icon-plus\"/> Add an exposed port</button>\n                    </div>\n\n                    <div ng-if=\"block.type == 'append_dockerfile'\"\n                         ng-show=\"block.$show\"\n                         class=\"code-studio-template__block-body\">\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Label</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"block.params.label\"/>\n                                <span class=\"help-inline\">Internal label of this append</span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Dockerfile</label>\n                            <div class=\"controls\">\n                                <div style=\"display: grid\">\n                                    <textarea ng-model=\"block.params.dockerfile\"\n                                              ui-refresh=\"block.$show\"\n                                              ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"></textarea>\n                                </div>\n                                <span class=\"help-inline\">\n                                    you can use <span class=\"code-studio-template__variable\">__TEMPLATE_RESOURCES__</span> as prefix path for your template resource files (see the \"Resources\" tab).\n                                </span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label for=\"runAsRoot{{$index}}\" class=\"control-label\">Run as root</label>\n                            <div class=\"controls\">\n                                <label style=\"font-size: inherit\">\n                                    <input id=\"runAsRoot{{$index}}\" type=\"checkbox\" ng-model=\"block.params.runAsRoot\" />\n                                    <span class=\"help-inline\">Run this Dockerfile chunk as root in /opt/dataiku. Otherwise as dataiku in /home/dataiku</span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">External resources</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Transferred in the docker build directory. You'll need to add a COPY statement to bake them in your image. Destination paths must be relative.</span>\n                                <ng2-key-values-list [(items)]=\"block.params.resources\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder\"\n                                                     add-label=\"Add copied file or folder\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"block.type == 'entrypoint'\" ng-show=\"block.$show\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Label</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"block.params.label\"/>\n                                <span class=\"help-inline\">Internal label of this entrypoint</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Entrypoint</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">If the path of this command is not absolute, the command should be on the user root $PATH.</span>\n                                <input type=\"text\" style=\"width: 100%\" ng-model=\"block.params.entrypoint\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Scripts</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Directly copied to the image in the specified path (if not absolute, then relative to /home/dataiku/). You can use variables in your source paths, like <span class=\"code-studio-template__variable\">${template.resources}</span> as path to your resource files.</span>\n                                <ng2-key-values-list [(items)]=\"block.params.scripts\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder on Code Studio\"\n                                                     add-label=\"Add script to Code Studio\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"is_launch_for_webapps{{$index}}\" class=\"control-label\">Launch for Webapps</label>\n                            <div class=\"controls\">\n                                <label style=\"font-size: inherit\">\n                                    <input id=\"is_launch_for_webapps{{$index}}\" type=\"checkbox\" ng-model=\"block.params.useInWebapps\"/>\n                                    <span class=\"help-inline\">Should this entrypoint be launched when starting this template as a Code Studio Webapp.</span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-init=\"$showExposedPort = (block.params.exposedPort != null)\">\n                            <label for=\"is_expose_entrypoint_port{{$index}}\" class=\"control-label\">Expose port</label>\n                            <div class=\"controls\">\n                                <label style=\"font-size: inherit\">\n                                    <input type=\"checkbox\"\n                                           id=\"is_expose_entrypoint_port{{$index}}\"\n                                           ng-checked=\"$showExposedPort\"\n                                           ng-click=\"$showExposedPort = ! $showExposedPort; updateEntrypointExposedPort($showExposedPort, block)\"/>\n                                    <span class=\"help-inline\">Expose to DSS the service launched by this Entrypoint</span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"$showExposedPort\">\n                            <div class=\"control-group\">\n                                <label for=\"entrypoint-label{{$index}}\" class=\"control-label\">Exposed port label</label>\n                                <div class=\"controls\">\n                                    <input id=\"entrypoint-label{{$index}}\" type=\"text\" ng-model=\"block.params.exposedPort.label\"/>\n                                    <span class=\"help-inline\">Tab's name in the Code Studio view</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"entrypoint-expose-html{{$index}}\" class=\"control-label\">Expose HTML service</label>\n                                <div class=\"controls\">\n                                    <label style=\"font-size: inherit\">\n                                        <input id=\"entrypoint-expose-html{{$index}}\" type=\"checkbox\" ng-model=\"block.params.exposedPort.exposeHtml\"/>\n                                        <span class=\"help-inline\">This allows you to consult it from DSS</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"entrypoint-port{{$index}}\" class=\"control-label\">Exposed port</label>\n                                <div class=\"controls\">\n                                    <input id=\"entrypoint-port{{$index}}\" type=\"number\" force-integer ng-model=\"block.params.exposedPort.port\" min=\"1\" max=\"65535\" ng-required=\"true\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"entrypoint-proxiedUrlSuffix{{$index}}\" class=\"control-label\">Proxied subpath</label>\n                                <div class=\"controls\">\n                                    <input id=\"entrypoint-proxiedUrlSuffix{{$index}}\" type=\"text\" ng-model=\"block.params.exposedPort.proxiedUrlSuffix\"/>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"block.type == 'add_codeenv'\" ng-show=\"block.$show\">\n                        <div code-studio-template-add-code-env-block block=\"block\" available-code-envs=\"availableCodeEnvs\"></div>\n                    </div>\n\n                    <div ng-if=\"block.type.startsWith('pycdstdioblk_')\" ng-show=\"block.$show\">\n                        <div ng-controller=\"PluginCodeStudioBlockController\">\n                            <div class=\"alert alert--warning\" ng-if=\"!loadedDesc || !loadedDesc.desc\">The plugin component defining this block type {{block.type}} is missing</div>\n                            <div custom-params-form ng-if=\"loadedDesc && pluginDesc\"\n                                 desc=\"loadedDesc.desc\"\n                                 plugin-desc=\"pluginDesc\"\n                                 component-id=\"loadedDesc.id\"\n                                 config=\"block.params.config\" >\n                            </div>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"block.type == 'custom_action'\" ng-show=\"block.$show\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Name</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"block.params.actionName\" ng-required=\"true\"/>\n                                <span class=\"help-inline\">Internal name of the action. Used as label if label isn't defined</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Label</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"block.params.actionLabel\" placeholder=\"{{block.params.actionName}}\"/>\n                                <span class=\"help-inline\">Label of the action in the UI</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Icon</label>\n                            <div class=\"controls block-template__icon-input\">\n                                <input type=\"text\" ng-model=\"block.params.actionIcon\" placeholder=\"fa fa-...\"/><i class=\"\" ng-class=\"block.params.actionIcon\"></i>\n                                <span class=\"help-inline\">Icon from <a href=\"https://fontawesome.com/v5/docs\" target=\"_blank\">Font Awesome v5 <i class=\"icon-external-link\"/></a></span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Description</label>\n                            <div class=\"controls\">\n                                <textarea ng-model=\"block.params.actionDescription\" ng-required=\"true\" class=\"w100\" rows=\"3\"/>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Behavior</label>\n                            <div class=\"controls\">\n                                <select dku-bs-select ng-model=\"block.params.actionBehavior\" ng-options=\"x[0] as x[1] for x in [['FIRE_AND_FORGET', 'Run and don\\'t wait'], ['WAIT_FOR_RETURN_VALUE', 'Open modal to wait for command completion'], ['WAIT_FOR_RETURN_VALUE_AND_REFRESH_VIEW', 'Open modal to wait for command and refresh views on completion']]\" />\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Command line to execute</label>\n                            <div class=\"controls\">\n                                <textarea ng-model=\"block.params.actionCommand\" ng-required=\"true\" class=\"w100\" rows=\"5\"/>\n                            </div>\n                        </div>\n                    </div>\n\n                    <div ng-if=\"block.type == 'starter_files'\" ng-show=\"block.$show\">\n\n                        <div class=\"code-studio-template__block-subtitle\">\n                            You can use variables in your source paths, like <span class=\"code-studio-template__variable\">${template.resources}</span> as path to your resource files, or <span class=\"code-studio-template__variable\">${dip.home}</span> as path to your data directory.\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Code Studio versioned files</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Put in the Code Studio versioned files</span>\n                                <ng2-key-values-list [(items)]=\"block.params.codeStudioVersionedFiles\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder\"\n                                                     add-label=\"Add copied file or folder\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Code Studio resource files</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Put in the Code Studio resource files</span>\n                                <ng2-key-values-list [(items)]=\"block.params.codeStudioResourcesFiles\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder\"\n                                                     add-label=\"Add copied file or folder\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">User config files</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Put in the user config files (location shared between all Code Studios of all projects)</span>\n                                <ng2-key-values-list [(items)]=\"block.params.userVersionedFiles\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder\"\n                                                     add-label=\"Add copied file or folder\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">User resource files</label>\n                            <div class=\"controls\">\n                                <span class=\"help-inline\">Put in the user resource files (location shared between all Code Studios of all projects)</span>\n                                <ng2-key-values-list [(items)]=\"block.params.userResourcesFiles\"\n                                                     key-placeholder=\"Source file or folder\"\n                                                     value-placeholder=\"Target file of folder\"\n                                                     add-label=\"Add copied file or folder\">\n                                </ng2-key-values-list>\n                            </div>\n                        </div>\n                    </div>\n\n                </div>\n            </div>\n        </div>\n\n        <div>\n            <button class=\"btn btn--text btn--primary\"\n                    ng-click=\"addBlock()\"\n                    data-qa-code-studio-templates-add-block-button>\n                <span><i class=\"icon-plus\"></i>Add a block</span>\n            </button>\n        </div>\n    </div>\n</form>\n");
$templateCache.put("/templates/admin/code-studios/code-studio-template-container-conf-settings.html", " <!-- form chunk shared between the template edition and the mass-set-container-conf modal -->\n \n                        <div class=\"control-group\" >\n                            <label for=\"\" class=\"control-label\">Run on</label>\n                            <div class=\"controls\">\n                                <select dku-bs-select ng-model=\"codeStudioTemplate.defaultContainerConf\" ng-options=\"c as (c || 'None') for c in containerNamesForRun\"></select>\n                                <span class=\"help-inline\">Default container configuration for Code Studios that use this template</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"codeStudioTemplate.defaultContainerConf\">\n                            <label for=\"allowContainerConfOverride\" class=\"control-label\">Allow project override</label>\n                            <div class=\"controls\">\n                                <label style=\"font-size: inherit\">\n                                    <input id=\"allowContainerConfOverride\" type=\"checkbox\" ng-model=\"codeStudioTemplate.allowContainerConfOverride\" />\n                                    <span class=\"help-inline\">Let projects override the configuration to run on</span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Build for</label>\n                            <div class=\"controls\">\n                                <div class=\"dib\">\n                                    <label>\n                                        <input type=\"radio\" ng-model=\"containerSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALL\" class=\"exclude-from-smart-change\"/>\n                                        All container configurations\n                                    </label>\n                                    <label>\n                                        <input type=\"radio\" ng-model=\"containerSelection\" ng-model-options=\"{ getterSetter: true }\" value=\"ALLOWED\" class=\"exclude-from-smart-change\"/>\n                                        Selected container configurations\n                                    </label>\n                                </div>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-show=\"containerSelection() === 'ALLOWED'\">\n                            <div class=\"controls\">\n                                <select dku-bs-select multiple=\"multiple\" ng-model=\"codeStudioTemplate.containerConfs\"\n                                        ng-options=\"c for c in containerNames\"></select>\n                            </div>\n                        </div>\n");
$templateCache.put("/templates/admin/code-studios/code-studio-template.html", "<div class=\"code-studio-template dss-page\"  global-keydown=\"{'ctrl-s meta-s':'save()'}\">\n\n    <div class=\"vertical-flex h100\">\n\n        <!-- HORIZONTAL TOP BAR -->\n\n        <div class=\"top-level-tabs\">\n            <div class=\"horizontal-flex object-nav\">\n                <!-- BREADCRUMB -->\n                <div class=\"object-breadcrumb object-breadcrumb--tooltip-on-overflow-no-expand\">\n                    <div class=\"item\">\n                        <div class=\"title\">\n                            <a class=\"object-breadcrumb__link\"\n                               ui-sref=\"admin.code-studios.list\"\n                               title=\"Go back to Code Studios list\">\n                                Code Studio Templates\n                            </a>\n                            <i class=\"object-breadcrumb__divider\">/</i>\n                            <div class=\"object-breadcrumb__item ng-isolate-scope ellipsed\"\n                                 show-tooltip-on-text-overflow=\"\"\n                                 text-tooltip=\"codeStudioTemplate.label\"\n                                 tooltip-direction=\"'tooltip-bottom'\">\n                                <div class=\"ellipsed\"\n                                     ng-show=\"textTooltip\"\n                                     ng-bind-html=\"getHtmlContent()\"\n                                     title=\"\"\n                                     toggle=\"tooltip-bottom\"\n                                     container=\"body\"\n                                     data-original-title=\"{{codeStudioTemplate.label}}\">\n                                    {{ codeStudioTemplate.label }}\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n                <!-- TAB TITLES / SUBMENU -->\n                <div class=\"menu mleft16 code-studio__menu-flex\">\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'info'}\"\n                       ng-click=\"uiState.active = 'info'\"\n                       data-qa-code-studio-template-tab-general>General</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'definition'}\"\n                       ng-if=\"uiState.canUpdate\"\n                       ng-click=\"uiState.active = 'definition'\"\n                       data-qa-code-studio-template-tab-definition>Definition</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'resources'}\"\n                       ng-if=\"uiState.canUpdate\"\n                       ng-click=\"uiState.active = 'resources'\"\n                       data-qa-code-studio-template-tab-resources>Resources</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'permissions'}\"\n                       ng-if=\"uiState.canUpdate\"\n                       ng-click=\"uiState.active = 'permissions'\"\n                       data-qa-code-studio-template-tab-permissions>Permissions</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'logs'}\"\n                       ng-if=\"uiState.canUpdate\"\n                       ng-click=\"uiState.active = 'logs'\"\n                       data-qa-code-studio-template-tab-build-history>Build History</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'usage'}\"\n                       ng-click=\"uiState.active = 'usage'\"\n                       data-qa-code-studio-template-tab-usage>Usage</a>\n                    <a class=\"tab\"\n                       fw500-width\n                       ng-class=\"{'enabled': uiState.active == 'history'}\"\n                       ng-click=\"uiState.active = 'history'\"\n                       data-qa-code-studio-template-tab-history>History</a>\n                </div>\n                <!-- TOPBAR ACTIONS BUTTONS -->\n                <div class=\"otherLinks code-studio__otherlinks-flex\">\n                    <span ng-if=\"uiState.canUpdate && codeStudioTemplate.type == 'block_based'\">\n                        <button class=\"btn btn--outline btn--secondary\" ng-click=\"exportTemplate()\" data-qa-code-studio-template-export>\n                            <i class=\"icon-download\"/> Export\n                        </button>\n                    </span>\n                    <button class=\"btn btn--outline btn--secondary\"\n                            ng-if=\"uiState.canUpdate && codeStudioTemplate.type != 'block_based' && !codeStudioTemplate.type.startsWith('pykbkle_')\"\n                            ng-click=\"exportTemplate()\">\n                        <i class=\"icon-download\"/> Export\n                    </button>\n                    <span ng-if=\"uiState.canUpdate\">\n                        <button class=\"btn btn--outline btn--primary\"\n                                ng-click=\"checkSaveAndBuild(false)\"\n                                data-qa-code-studio-template-build>\n                            <i class=\"icon-wrench\"/> Build\n                        </button>\n                        <span class=\"dropdown code-studio__grouped-dropdown-button\">\n                            <button class=\"btn btn--outline btn--primary btn--icon dropdown-toggle manual-caret\"\n                                    type=\"button\"\n                                    data-toggle=\"dropdown\"\n                                    ng-disabled=\"!appConfig.globalPermissions.mayCreateCodeStudioTemplates\">\n                                <i class=\"icon-caret-down\" />\n                            </button>\n                            <ul class=\"dropdown-menu\">\n                                <li ng-click=\"checkSaveAndBuild(true)\">\n                                    <i class=\"icon-wrench\"/>&nbsp;Build with no cache\n                                </li>\n                            </ul>\n                        </span>\n                    </span>\n                    <button type=\"submit\" class=\"btn btn--primary\"\n                            ng-if=\"uiState.canUpdate\"\n                            ng-click=\"save()\"\n                            ng-disabled=\"!codeStudioTemplateIsDirty()\"\n                            data-qa-code-studio-template-save>\n                        <i class=\"icon-save\"></i> Save\n                    </button>\n                    <button type=\"submit\"\n                            class=\"btn btn--outline btn--primary\"\n                            ng-if=\"!uiState.canUpdate\"\n                            ng-disabled=\"true\"\n                            toggle=\"tooltip\" title=\"You are not allowed to edit the template\">\n                        <i class=\"icon-save\"></i> Save\n                    </button>\n                    <!--\n                    <button class=\"btn btn--secondary dropdown-toggle\" data-toggle=\"dropdown\" href>\n                        Actions <span class=\"caret\"></span>\n                    </button>\n                    <ul class=\"dropdown-menu pull-right text-left\">\n                        <li>\n                            <a ng-click=\"deleteCodeStudioTemplate()\">\n                                <span class=\"text-error\">\n                                    <i class=\"icon-trash\" />&nbsp;Delete this CodeStudio\n                                </span>\n                            </a>\n                        </li>\n                    </ul>\n                    -->\n                </div>\n            </div>\n        </div>\n\n        <div block-api-error />\n\n        <!-- TABS PANELS -->\n\n        <div class=\"tab-content code-studio-template__tab-content h100\">\n\n            <!-- GENERAL TAB -->\n\n            <div ng-class=\"{active: uiState.active==='info'}\" class=\"tab-pane h100\">\n                <div class=\"code-studio-template__boxed-pane fh oa\">\n                    <form class=\"dkuform-horizontal\">\n\n                        <div class=\"code-studio-template__section\">\n                            <h2 class=\"code-studio-template__title\">Code Studio configuration</h2>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Template label</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"codeStudioTemplate.label\" required></input>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Short description</label>\n                                <div class=\"controls\">\n                                    <div class=\"code-studio-template__shortDesc code-studio-template__editable\" ng-show=\"!uiState.$editingShortDesc\">\n                                        <div from-markdown=\"codeStudioTemplate.shortDesc || 'Short description...'\"/>\n                                        <span class=\"code-studio-template__field-edit\"><i class=\"icon-pencil\" ng-click=\"startEditShortDesc(codeStudioTemplate)\"></i></span>\n                                    </div>\n                                    <div class=\"code-studio-template__shortDesc--editing\" ng-show=\"uiState.$editingShortDesc\">\n                                        <textarea type=\"text\" ng-model=\"uiState.edited\"/>\n                                        <div>\n                                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"cancelEditShortDesc(codeStudioTemplate)\">Cancel</button>\n                                            <button type=\"submit\" class=\"btn btn--success\" ng-click=\"stopEditShortDesc(codeStudioTemplate)\">OK</button>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Description</label>\n                                <div class=\"controls\">\n                                    <div class=\"code-studio-template__description code-studio-template__editable\" ng-show=\"!uiState.$editingDescription\">\n                                        <div from-markdown=\"codeStudioTemplate.description || 'Description...'\"/>\n                                        <span class=\"code-studio-template__field-edit\"><i class=\"icon-pencil\" ng-click=\"startEditDescription(codeStudioTemplate)\"></i></span>\n                                    </div>\n                                    <div class=\"code-studio-template__description--editing\" ng-show=\"uiState.$editingDescription\">\n                                        <textarea type=\"text\" ng-model=\"uiState.edited\"/>\n                                        <div>\n                                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"cancelEditDescription(codeStudioTemplate)\">Cancel</button>\n                                            <button type=\"submit\" class=\"btn btn--success\" ng-click=\"stopEditDescription(codeStudioTemplate)\">OK</button>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Icon</label>\n                                <div class=\"controls block-template__icon-input\">\n                                    <input type=\"text\" ng-model=\"codeStudioTemplate.icon\" placeholder=\"fa fa-...\"/><i class=\"\" ng-class=\"codeStudioTemplate.icon\"></i>\n                                    <span class=\"help-inline\">Icon from <a href=\"https://fontawesome.com/v5/docs\" target=\"_blank\">Font Awesome v5 <i class=\"icon-external-link\"/></a></span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"isEditor\" class=\"control-label\">Code editor template</label>\n                                <div class=\"controls\">\n                                    <label style=\"font-size: inherit\">\n                                        <input id=\"isEditor\" type=\"checkbox\" ng-model=\"codeStudioTemplate.isEditor\"/>\n                                        <span class=\"help-inline\">A code editor template helps DSS propose specific actions and indicates if the template is providing a code editing environment.</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                        </div>\n\n                        <div class=\"code-studio-template__section\">\n                            <h2 class=\"code-studio-template__title\">Build</h2>\n\n                            <div ng-include=\"'/templates/admin/code-studios/code-studio-template-container-conf-settings.html'\"></div>\n\n                            <div class=\"alert alert-info\" ng-show=\"containerSelection() === 'ALL' || (containerSelection() === 'ALLOWED' && codeStudioTemplate.containerConfs.length > 0)\">\n                                <span ng-show=\"codeStudioTemplate.allContainerConfs\">Code Studio template images will be built for <strong>all current containers configurations</strong>.<br /></span>\n                                You will have to build this template again when you edit these container configurations.\n                            </div>\n                            <div class=\"alert alert-error\" ng-show=\"outdatedContainerConfs.length > 0 && containerSelection() !== 'ALL' \">\n                                <h5>\n                                    <i class=\"icon-dku-error\"></i>\n                                    Some of the container configurations you have chosen for this Code Studio template do not exist anymore:\n                                </h5>\n                                <ul class=\"item-list\">\n                                    <li ng-repeat=\"containerConf in outdatedContainerConfs\">{{ containerConf }}</li>\n                                </ul>\n                                <button class=\"btn btn--secondary\" ng-click=\"removeOutdatedContainerConfs()\">Remove from selected containers</button>\n                            </div>\n\n                            <h2 class=\"code-studio-template__title\">Extra code env options</h2>\n\n                            <div class=\"control-group\">\n                                <label for=\"inheritGlobalCodeEnvsExtraSettings\" class=\"control-label\">Inherit global settings</label>\n                                <div class=\"controls\">\n                                    <label style=\"font-size: inherit\">\n                                        <input id=\"inheritGlobalCodeEnvsExtraSettings\" type=\"checkbox\" ng-model=\"codeStudioTemplate.inheritGlobalCodeEnvsExtraSettings\"/>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-show=\"!codeStudioTemplate.inheritGlobalCodeEnvsExtraSettings\">\n                                <label for=\"\" class=\"control-label\">Extra options for 'pip install'</label>\n                                <div class=\"controls\">\n                                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                    <ng2-values-list [(items)]=\"codeStudioTemplate.codeEnvsExtraSettings.pipInstallExtraOptions\" add-label=\"Add option for 'pip install'\" value-placeholder=\"E.g. -i, --trusted-host...\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-show=\"!codeStudioTemplate.inheritGlobalCodeEnvsExtraSettings\">\n                                <label for=\"\" class=\"control-label\">Extra options for 'virtualenv'</label>\n                                <div class=\"controls\">\n                                    <span class=\"help-inline\">One item per option (so \"-i /stuff\" must be two items)</span>\n                                    <ng2-values-list [(items)]=\"codeStudioTemplate.codeEnvsExtraSettings.virtualenvCreateExtraOptions\" add-label=\"Add option for 'virtualenv'\" value-placeholder=\"E.g. -p, --system-site-packages...\"/>\n                                </div>\n                            </div>\n                        </div>\n\n                    </form>\n                </div>\n            </div>\n\n            <!-- DEFINITION TAB -->\n\n            <div ng-class=\"{active: uiState.active==='definition'}\" class=\"tab-pane h100\">\n\n                <div class=\"paned-settings-page-pane code-studio-template__boxed-pane padbot0 vertical-flex h100\">\n\n                    <h1 class=\"noflex\">\n                        Definition\n                    </h1>\n\n                    <div class=\"flex\">\n\n                        <div class=\"fh oa\">\n\n                            <div class=\"code-studio-template__section\">\n\n                                <div ng-if=\"codeStudioTemplate.type.indexOf('pykbkle_') === 0\">\n                                    <div ng-controller=\"PluginCodeStudioController\">\n                                        <div class=\"alert alert--warning\" ng-if=\"!loadedDesc || !loadedDesc.desc\">The plugin component defining this template type {{codeStudioTemplate.type}} is missing</div>\n                                        <div custom-params-form\n                                             ng-if=\"loadedDesc && pluginDesc\"\n                                             desc=\"loadedDesc.desc\"\n                                             plugin-desc=\"pluginDesc\"\n                                             component-id=\"loadedDesc.id\"\n                                             config=\"codeStudioTemplate.params.config\" >\n                                        </div>\n                                        <div ng-if=\"loadedDesc && loadedDesc.desc && !loadedDesc.desc.paramsTemplate && loadedDesc.desc.params.length === 0\" class=\"center-children\">\n                                            <span>No parameters</span>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div ng-if=\"codeStudioTemplate.type.indexOf('pykbkle_') < 0\">\n                                    <ng-include ng-if=\"codeStudioTemplate.type\" src=\"'/templates/admin/code-studios/' + codeStudioTemplate.type + '-code-studio-template-params.html'\"></ng-include>\n                                </div>\n\n                            </div>\n\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- RESOURCES TAB -->\n\n            <div ng-class=\"{active: uiState.active==='resources'}\" class=\"tab-pane h100\">\n                <div class=\"code-studio-template__boxed-pane fh oa plugin-dev-commons\">\n\n                    <div class=\"h100 plugin-content\">\n                        <div code-studio-template-resources-callbacks\n                             root-description=\"template resources files\"\n                             class=\"h100\" >\n                            <div folder-content-editor\n                                 empty-cta=\"codeStudioTemplateResourcesEmptyCta\"\n                                 class=\"h100\"\n                                 data-qa-code-studio-template-resources></div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- PERMISSIONS TAB -->\n\n            <div ng-class=\"{active: uiState.active==='permissions'}\" class=\"tab-pane h100\">\n                <div class=\"code-studio-template__boxed-pane fh oa\">\n                    <form class=\"dkuform-horizontal\">\n                        <div class=\"code-studio-template__section\" ng-if=\"codeStudioTemplate\">\n                            <h2 class=\"code-studio-template__title\">Permissions</h2>\n                            <div code-studio-template-security-permissions code-studio-template=\"codeStudioTemplate\"></div>\n                        </div>\n                    </form>\n                </div>\n            </div>\n\n            <!-- LOGS TAB -->\n\n            <div ng-class=\"{active: uiState.active==='logs'}\" class=\"tab-pane h100\">\n\n                <div class=\"paned-settings-page-pane code-studio-template__boxed-pane padbot0 vertical-flex h100\">\n\n                    <h1 class=\"noflex\">\n                        <span>Build History</span>\n                        <div class=\"pull-right\">\n                            <button class=\"btn btn--outline\" ng-click=\"refreshLogs()\"><i class=\"icon-refresh\"></i>&nbsp;Refresh</button>\n                        </div>\n                    </h1>\n\n                    <form class=\"dkuform-horizontal noflex container-fluid code-studio-template__section no-border\">\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Show build...</label>\n                            <div class=\"controls\">\n                                <select dku-bs-select ng-model=\"uiState.selectedLog\" ng-options=\"l as l.buildId for l in uiState.logs\"></select>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"uiState.currentLog.buildId\">\n                            <label class=\"control-label\">Diagnosis</label>\n                            <div class=\"controls\">\n                                <a class=\"nowrap\" ng-click=\"downloadBuildDiagnosis(uiState.currentLog)\" data-qa-code-studio-template-download-diagnosis><i class=\"icon-download\"></i> Download</a>\n                                <span class=\"help-inline\">Get a zip to attach to your support request</span>\n                            </div>\n                        </div>\n                    </form>\n\n\n                    <!-- LOG TABS TITLES -->\n                    <div class=\"noflex code-studio-template__section no-border\">\n                        <div class=\"column-header-tabs dib\" ng-init=\"uiState.activeLogTab = 'log'\">\n                            <div class=\"tab\" ng-class=\"{'active' : uiState.activeLogTab === 'log'}\" ng-click=\"uiState.activeLogTab = 'log'\">\n                                <div class=\"title mright8\">Log</div>\n                            </div>\n                            <div class=\"tab\" ng-class=\"{'active' : uiState.activeLogTab === 'dockerfile'}\" ng-click=\"uiState.activeLogTab = 'dockerfile'\">\n                                <div class=\"title mleft8 mright8\">Dockerfile</div>\n                            </div>\n                            <div class=\"tab\" ng-class=\"{'active' : uiState.activeLogTab === 'contents'}\" ng-click=\"uiState.activeLogTab = 'contents'\">\n                                <div class=\"title mleft8\">Build data</div>\n                            </div>\n                        </div>\n                    </div>\n\n                    <!-- LOGS TABS PANELS -->\n                    <div class=\"flex code-studio-template__section\" ng-switch=\"uiState.activeLogTab\">\n                        <div ng-switch-when=\"log\" class=\"h100 vertical-flex\">\n                            <div class=\"noflex m8\">\n                                <a class=\"nowrap\" ng-href=\"{{getBuildLogURL(uiState.currentLog)}}\" target=\"_blank\">View build log</a><br />\n                            </div>\n                            <div class=\"flex h100\">\n                                <pre smart-log-tail=\"uiState.currentLog.logTail\" class=\"fh oa\" style=\"max-width: initial; max-height: initial;\"></pre>\n                            </div>\n                        </div>\n\n                        <div ng-switch-when=\"dockerfile\" class=\"fh\">\n                            <pre class=\"debug w100 h100 oa\" style=\"max-width: initial; max-height: initial;\">{{ uiState.currentLog.dockerfile }}</pre>\n                        </div>\n\n                        <div ng-switch-when=\"contents\" class=\"fh\">\n                            <div class=\"h100 fattable-default-style\" fat-repeat=\"uiState.currentLog.contents\" as=\"item\" row-height=\"24\">\n                                <div>\n                                    <div style=\"width: 10px\">\n                                        <span><i ng-class=\"{'icon-folder-close': item.isDirectory, 'icon-file': !item.isDirectory}\"></i></span>\n                                    </div>\n                                    <div style=\"width: 200px\" class=\"mx-textellipsis\">\n                                        <span>{{ item.path }}</span>\n                                    </div>\n                                    <div style=\"width: 50px\" class=\"mx-textellipsis\">\n                                        <span ng-if=\"!item.isDirectory\">{{ item.size | fileSizeOrNA }}</span>\n                                    </div>\n                                    <div style=\"width: 50px\" class=\"mx-textellipsis\">\n                                        <span>{{ item.lastModified | friendlyDate }}</span>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- USAGE TAB -->\n\n            <div ng-class=\"{active: uiState.active==='usage'}\" class=\"tab-pane h100\">\n\n                <div class=\"paned-settings-page-pane code-studio-template__boxed-pane padbot0 vertical-flex h100\">\n\n                    <h1 class=\"noflex\">\n                        <span>Usage of this template</span>\n                        <div class=\"pull-right\">\n                            <button type=\"button\" class=\"btn btn--text\"\n                                    ng-if=\"uiState.usage\"\n                                    ng-click=\"refreshUsages()\">\n                                <i class=\"icon-refresh\"></i> Refresh\n                            </button>\n                        </div>\n                    </h1>\n\n                    <div class=\"empty-list-cta\" ng-if=\"uiState.usage == null\">\n                        <p>Searching for all uses of a Code Studio template may take a long time on large instances.</p>\n                        <button type=\"button\" class=\"btn btn--text\" ng-click=\"refreshUsages()\"><i class=\"icon-refresh\"></i>&nbsp;Refresh</button>\n                    </div>\n\n                    <div class=\"noflex code-studio-template__section\" ng-if=\"uiState.usage.notAccessibleCount > 0\">\n                        <p>{{uiState.usage.notAccessibleCount}} Code Studio(s) ({{uiState.usage.notAccessibleRunningCount}} running) in {{uiState.usage.notAccessibleProjectCount}} project(s) without read access</p>\n                    </div>\n\n                    <div class=\"flex\" ng-if=\"uiState.usage != null\">\n                        <div class=\"fh oa\">\n                            <div class=\"code-studio-template__section\" ng-if=\"uiState.usage.projects.length > 0\">\n                                <table class=\"table table-hover w100\">\n                                    <thead>\n                                        <tr>\n                                            <th style=\"width: 20px;\"></th>\n                                            <th style=\"width: 10%;\">Project</th>\n                                            <th style=\"width: calc(20% - 20px);\">Code Studio Name</th>\n                                            <th style=\"width: 8%;\">Owner</th>\n                                            <th style=\"width: 8%;\">Created on</th>\n                                            <th style=\"width: 8%;\">Created by</th>\n                                            <th style=\"width: 8%;\">State</th>\n                                            <th style=\"width: 15%;\">Webapps</th>\n                                            <th style=\"width: 15%;\">Users</th>\n                                            <th style=\"width: 8%;\">Last image</th>\n                                        </tr>\n                                    </thead>\n                                    <tbody>\n                                        <tr ng-repeat=\"item in flatUsageList\">\n                                            <td>\n                                                <i ng-if=\"item.$idx===0 && item.$count>1\"\n                                                   ng-class=\"{'icon-chevron-up':item.$expanded, 'icon-chevron-down':!item.$expanded}\"\n                                                   ng-click=\"toggleUsage(item.projectKey)\"/>\n                                            </td>\n                                            <td><span ng-if=\"item.$idx===0\">{{ item.projectKey }}</span></td>\n                                            <td>\n                                                <span ng-if=\"item.$expanded\">\n                                                    <a ui-sref=\"projects.project.code-studios.code-studio.view({projectKey: item.projectKey, codeStudioObjectId: item.id, codeStudioName: (item.name | slugify)})\">\n                                                        {{ item.name || '(' + item.id + ')' }}\n                                                    </a>\n                                                </span>\n                                                <span ng-if=\"!item.$expanded\">{{ item.$count + ' use' | plurify: item.$count }}</span>\n                                            </td>\n                                            <td><span ng-if=\"item.$expanded\">{{item.owner}}</span></td>\n                                            <td><span ng-if=\"item.$expanded && item.createdOn > 0\">{{ item.createdOn | friendlyDate }}</span></td>\n                                            <td><span ng-if=\"item.$expanded\">{{ item.createdBy }}</span></td>\n                                            <td>\n                                                <span ng-if=\"item.$expanded && item.running\" class=\"started\">\n                                                    <i class=\"icon-play\"/> started\n                                                </span>\n                                                <span ng-if=\"item.$expanded && !item.running\" class=\"stopped\">\n                                                    <i class=\"icon-stop\"/> stopped\n                                                </span>\n                                            </td>\n                                            <td>\n                                                <span ng-if=\"item.currentUses.webapps.length===0\">\n                                                    no webapps\n                                                </span>\n                                                <span ng-if=\"!item.$expanded && item.currentUses.webapps.length>0\">\n                                                    {{ item.currentUses.webapps.length }} {{'webapp' | plurify:item.currentUses.webapps.length }}\n                                                </span>\n                                                <span ng-if=\"item.$expanded && item.currentUses.webapps.length>0\">\n                                                    {{ getFirstItems(item.currentUses.webapps, 'name', 5) }}\n                                                </span>\n                                            </td>\n                                            <td>\n                                                <span ng-if=\"item.currentUses.users.length===0\">\n                                                    no users\n                                                </span>\n                                                <span ng-if=\"!item.$expanded && item.currentUses.users.length>0\">\n                                                    {{ item.currentUses.users.length }} {{'user' | plurify:item.currentUses.users.length }}\n                                                </span>\n                                                <span ng-if=\"item.$expanded && item.currentUses.users.length>0\">\n                                                    {{ getFirstItems(item.currentUses.users, 'login', 5) }}\n                                                </span>\n                                            </td>\n                                            <td class=\"code-studio-template--last-image\">\n                                                <span ng-if=\"item.$expanded && item.running\"\n                                                      ng-class=\"{'outdated':isOutdated(item)}\">\n                                                    {{ isOutdated(item) ? 'no' : 'yes' }}\n                                                </span>\n                                            </td>\n                                        </tr>\n                                    </tbody>\n                                </table>\n                            </div>\n                            <div class=\"empty-list-cta\" ng-if=\"uiState.usage.projects.length === 0\">\n                                <p>This template is not used yet.</p>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- HISTORY TAB -->\n\n            <div ng-class=\"{active: uiState.active==='history'}\" class=\"tab-pane h100\">\n\n                <div class=\"paned-settings-page-pane code-studio-template__boxed-pane padbot0 vertical-flex h100\">\n\n                    <h1 class=\"noflex\">\n                        <span>History</span>\n                    </h1>\n\n                    <div ng-if=\"codeStudioTemplate && codeStudioTemplate.id && uiState.active==='history'\"\n                         object-git-history\n                         object-type=\"CODE_STUDIO_TEMPLATE\"\n                         object-id=\"codeStudioTemplate.id\"\n                         project-key=\"\"\n                         object-revertable=\"true\"\n                         class=\"flex\"/>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/code-studios/code-studio-templates.html", "<div class=\"code-studio-template dss-page\" filtered-multi-select-rows ng-model=\"codeStudioTemplates\">\n\n    <div class=\"vertical-flex h100\">\n\n        <!-- HORIZONTAL TOP BAR -->\n\n        <div class=\"horizontal-flex object-nav code-studio-template__nav-bar\">\n            <div class=\"noflex\">\n                <h2 class=\"page-subtitle\">Code Studio Templates</h2>\n            </div>\n            <div class=\"flex std-list-search-box\">\n                <span class=\"add-on\"><i class=\"icon-dku-search\"></i></span>\n                <input type=\"search\" ng-model=\"selection.filterQuery.userQuery\" style=\"width: 190px;\" placeholder=\"Filter...\"/>\n            </div>\n            <div class=\"noflex font0\">\n                <button class=\"btn btn--primary\"\n                        ng-click=\"createCodeStudioTemplate($event)\"\n                        ng-disabled=\"!appConfig.globalPermissions.mayCreateCodeStudioTemplates\">\n                    <i class=\"icon-plus\"/>&nbsp;Create Code Studio template\n                </button>\n                <span class=\"dropdown code-studio__grouped-dropdown-button\">\n                    <button class=\"btn btn--primary btn--icon dropdown-toggle manual-caret\"\n                            type=\"button\"\n                            data-toggle=\"dropdown\"\n                            ng-disabled=\"!appConfig.globalPermissions.mayCreateCodeStudioTemplates\">\n                        <i class=\"icon-caret-down\" />\n                    </button>\n                    <ul class=\"dropdown-menu\">\n                        <li ng-click=\"uploadCodeStudioTemplate()\">\n                            <i class=\"icon-upload\"/>&nbsp;Upload a Code Studio template\n                        </li>\n                    </ul>\n                </span>\n            </div>\n        </div>\n\n        <div block-api-error></div>\n\n        <!-- EMPTY STATE -->\n        <div ng-show=\"fetchedList && !selection.allObjects.length\" class=\"empty-list-cta\">\n            <div data-block=\"empty\" class=\"code-studio-list__empty-section\">\n                <h1>No Code Studio templates defined</h1>\n                <p>\n                    Code Studios are containers for third party tools such as IDE (JupyterLab, VScode or RStudio) or Web application stacks (such as Streamlit).\n                </p>\n                <p class=\"small\"><span doclink-wrapper page=\"code-studios/index\">\n                    Read the documentation</span> to learn more\n                </p>\n                <div ng-if=\"appConfig.globalPermissions.mayCreateCodeStudioTemplates\">\n                    <button class=\"btn btn--primary btn--large\" ng-click=\"createCodeStudioTemplate($event)\"><i class=\"icon-plus\"/>&nbsp;Create your first Code Studio template</button>\n                </div>\n            </div>\n        </div>\n\n        <div ng-show=\"fetchedList && selection.allObjects.length\" class=\"flex h100 m8\">\n            <div class=\"fh oa\">\n                <table sort-table-dyn\n                       sort-column=\"selection.orderQuery\"\n                       sort-descending=\"selection.orderReversed\"\n                       class=\"table table-striped table-hover table-fixed w100\"\n                       data-qa-code-studio-templates-table>\n                    <thead>\n                        <tr>\n                            <th style=\"width: 80px;\">\n                                <div custom-element-popup\n                                     class=\"mass-action-btn\"\n                                     cep-position=\"align-left-bottom\"\n                                     cep-offset-left=\"-26\"\n                                     close-on-click=\"true\">\n                                    <input type=\"checkbox\"\n                                           class=\"select-cb\"\n                                           ng-model=\"selection.all\"\n                                           dku-indeterminate=\"selection.some\"\n                                           ng-change=\"updateMassSelectionCheckbox();\">\n                                    <a ng-class=\"{disabled:selection.none}\" ng-click=\"togglePopover()\" class=\"mainzone dropdown-toggle\">\n                                        <span ng-hide='selection.none'>{{selection.selectedObjects.length + \" / \" + selection.allObjects.length}}</span>\n                                        <b class=\"caret\"></b>\n                                    </a>\n                                    <ul class=\"popover custom-element-popup-popover dropdown-menu column-header-menu\">\n                                        <li>\n                                            <a ng-click=\"deleteSelectedTemplates()\"><i class=\"icon-trash error-text-color\"></i>&nbsp;Delete</a>\n                                        </li>\n                                        <li>\n                                            <a ng-click=\"buildSelectedTemplates()\"><i class=\"icon-wrench\"></i>&nbsp;Build</a>\n                                        </li>\n                                        <li>\n                                            <a ng-click=\"massSetContainerConfs()\"><i class=\"icon-refresh\"></i>&nbsp;Change container confs</a>\n                                        </li>\n                                    </ul>\n                                </div>\n                            </th>\n                            <th style=\"width: 20%;\" sort-col-dyn=\"label\">Label</th>\n                            <th style=\"width: 10%;\" sort-col-dyn=\"id\">Id</th>\n                            <th style=\"width: 10%;\" sort-col-dyn=\"type\">Type</th>\n                            <th style=\"width: 10%;\" sort-col-dyn=\"owner\">Owner</th>\n                            <th style=\"width: 10%;\">Usage</th>\n                            <th style=\"width: 10%;\">Build for</th>\n                            <th style=\"width: 15%;\" sort-col-dyn=\"lastBuilt\">Built</th>\n                            <th style=\"width: 20px;\">&nbsp;</th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                        <tr ng-repeat=\"codeStudioTemplate in selection.filteredObjects\">\n                            <td disable-main-click style=\"padding: 6px\" class=\"checkbox-label-width\">\n                                <label disable-main-click>\n                                    <input type=\"checkbox\"\n                                           ng-model=\"codeStudioTemplate.$selected\"\n                                           ng-click=\"checkBoxChanged(codeStudioTemplate, $event)\"\n                                           style=\"margin:5px\"/>\n                                </label>\n                            </td>\n                            <td full-click class=\"ellipsed\">\n                                <a ui-sref=\"admin.code-studios.code-studio({codeStudioTemplateId:codeStudioTemplate.id})\" main-click>\n                                    <i ng-if=\"!codeStudioTemplate.icon\" class=\"{{'code_studio' |typeToIcon}}\"/>\n                                    <i ng-if=\"codeStudioTemplate.icon\" ng-class=\"codeStudioTemplate.icon\"/>\n                                    &nbsp;{{codeStudioTemplate.label}}\n                                </a>\n                            </td>\n                            <td class=\"ellipsed\" >{{codeStudioTemplate.id}}</td>\n                            <td>{{codeStudioTemplate.type}}</td>\n                            <td>{{codeStudioTemplate.owner}}</td>\n                            <td ng-if=\"codeStudioTemplate.$usages == null\" style=\"padding: 4px;\"> <!-- special case, because it's a button -->\n                                <button type=\"button\" class=\"btn btn--text btn--secondary btn--icon\"\n                                        ng-if=\"$index == 0\"\n                                        ng-click=\"getUsages()\"\n                                        ng-disabled=\"uiState.fetchingUsages\">\n                                    <i class=\"icon-refresh\" ng-class=\"{'icon-spin':uiState.fetchingUsages}\"></i>\n                                </button>\n                                <span ng-if=\"$index > 0\" style=\"margin-left: 8px;\">&#8212;</span>\n                            </td>\n                            <td ng-if=\"codeStudioTemplate.$usages != null\">\n                                <div ng-if=\"codeStudioTemplate.$usages.cannotCheckUsages\">N/A</div>\n                                <div ng-if=\"!codeStudioTemplate.$usages.cannotCheckUsages\">{{codeStudioTemplate.$usages.totalCount}} ({{codeStudioTemplate.$usages.totalRunningCount}} running)</div>\n                            </td>\n                            <td>\n                                <div class=\"dib\" ng-repeat=\"conf in codeStudioTemplate.$buildConfForDisplay\">\n                                    <span ng-if=\"!$first\">,</span>\n                                    <span ng-if=\"conf.notBuilt\"><em>{{conf.name}}</em></span>\n                                    <span ng-if=\"!conf.notBuilt && conf.isDefault\" toggle=\"tooltip\" title=\"default run configuration\"><strong>{{conf.name}}</strong></span>\n                                    <span ng-if=\"!conf.notBuilt && !conf.isDefault\">{{conf.name}}</span>\n                                </div>\n                            </td>\n                            <td>\n                                <span ng-if=\"codeStudioTemplate.lastBuilt == 0\">-</span>\n                                <span ng-if=\"codeStudioTemplate.lastBuilt != 0\">{{ codeStudioTemplate.lastBuilt | friendlyDate }}</span>\n                            </td>\n                            <td>\n                                <a ng-click=\"deleteCodeStudioTemplate(codeStudioTemplate)\" data-qa-code-studio-templates-delete-template>\n                                    <i class=\"icon-trash error-text-color\" />\n                                </a>\n                            </td>\n                        </tr>\n                    </tbody>\n                </table>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/code-studios/delete-code-studio-template-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"Delete Code Studio template\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n\t\t\t<div>Delete Code Studio template <b>{{codeStudioTemplateId}}</b></div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"deleteRuntimes\" class=\"control-label\">Delete created Code Studios</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label style=\"font-size: inherit\">\n\t\t\t\t\t\t<input id=\"deleteRuntimes\" type=\"checkbox\" ng-model=\"deleteRuntimes\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Stop and delete Code Studios and Webapps created using this template. See usages below.</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"deleteImages\" class=\"control-label\">Purge Docker Images and builds</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label style=\"font-size: inherit\">\n\t\t\t\t\t\t<input id=\"deleteImages\" type=\"checkbox\" ng-model=\"deleteImages\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Purge Docker images and empty build directory</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"control-group\" ng-if=\"!uiState.usages\">\n\t\t\t\t<p>Searching for all uses of a Code Studio may take a long time on large instances.</p>\n\t\t\t\t<button class=\"btn btn--primary\" ng-click=\"refreshUsages()\" data-qa-code-studio-template-compute-usage-before-delete>Compute Usage</button>\n\t\t\t</div>\n\t\t\t<div ng-if=\"uiState.usages\">\n\t\t\t\t<div>Used by <strong>{{uiState.usages.totalCount}}</strong> {{ 'Code Studio' | plurify : uiState.usages.totalCount }} (<strong>{{uiState.usages.totalRunningCount}}</strong> running) in <strong>{{uiState.usages.projects | objectSize}}</strong> {{ 'project' | plurify : (uiState.usages.projects | objectSize) }}</div>\n\t\t\t\t<div ng-if=\"uiState.usages.notAccessibleCount > 0\" class=\"control-group\">\n\t\t\t\t\t<div><strong>{{uiState.usages.notAccessibleCount}}</strong> {{ 'object' | plurify : uiState.usages.notAccessibleCount }} <ng-pluralize count=\"uiState.usages.notAccessibleCount\" when=\"{   'one': 'is',  'other': 'are'}\"></ng-pluralize> not accessible according to your current permissions.</div>\n\t\t\t\t</div>\n\t\t\t\t<ul>\n\t\t\t\t\t<li ng-repeat=\"project in uiState.usages.projects\">\n\t\t\t\t\t\t<div><strong>{{project.count}}</strong> {{ 'Code Studio' | plurify : project.count }} (<strong>{{project.runningCount}}</strong> running) in {{ project.projectKey }}</div>\n\t\t\t\t\t</li>\n\t\t\t\t</ul>\n\t\t\t</div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"submit\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"delete()\" data-qa-code-studio-template-confirm-delete>Delete</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/code-studios/export-code-studio-template-to-plugin-modal.html", "<div class=\"modal modal3\">\n    <div dku-modal-header modal-title=\"Export to plugin template\" />\n\n    <form name=\"conversionForm\" class=\"dkuform-modal-horizontal dkuform-modal-wrapper \">\n\n        <div class=\"modal-body\">\n            <div block-api-error />\n            <div class=\"control-group\">\n                <label class=\"control-label\">\n                    Target plugin\n                </label>\n                <div class=\"controls\">\n                    <label>\n                        <input type=\"radio\" name=\"mode\" value=\"NEW\" ng-model=\"convert.mode\">\n                        New plugin\n                    </label>\n                    <label>\n                        <input type=\"radio\" name=\"mode\" value=\"EXISTING\" ng-model=\"convert.mode\">\n                        Existing dev plugin\n                    </label>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label class=\"control-label\">\n                    Plugin id\n                </label>\n                <div class=\"controls\" ng-if=\"convert.mode == 'EXISTING' && (!devPlugins || devPlugins.length)\">\n                    <select dku-bs-select=\"{liveSearch: true}\"\n                        ng-model=\"convert.targetPluginId\"\n                        ng-options=\"devPlugin.desc.id as (devPlugin.desc.meta.label || devPlugin.desc.id) for devPlugin in devPlugins\"\n                        required\n                        />\n                </div>\n                <div class=\"help-inline\" ng-if=\"convert.mode == 'EXISTING' && devPlugins.length === 0\">\n                    No dev plugin installed.\n                </div>\n                <div class=\"controls\" ng-if=\"convert.mode == 'NEW'\">\n                    <input type=\"text\" ng-model=\"convert.newPluginId\" ng-pattern=\"/^[a-z][a-z0-9-]*$/\" required />\n                    <span class=\"help-inline\" style=\"width:250px; padding-left: 0;\">\n                        Lowercase letters, numbers and \"-\"\n                    </span>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"targetFolder\" class=\"control-label\">\n                    Plugin component name\n                </label>\n                <div class=\"controls\">\n                    <input type=\"text\" ng-model=\"convert.targetFolder\" id=\"targetFolder\" ng-pattern=\"/^[a-z][a-z0-9-]*$/\" required/>\n                    <span class=\"help-inline\" style=\"width:250px; padding-left: 0;\">\n                        Lowercase letters, numbers and \"-\"\n                    </span>\n                </div>\n            </div>\n            <div class=\"control-group\" ng-if=\"convert.mode == 'EXISTING'\">\n                <label for=\"portShow\" class=\"control-label\">Overwrite</label>\n                <div class=\"controls\">\n                    <label style=\"font-size: inherit\">\n                        <input id=\"portShow\" type=\"checkbox\" ng-model=\"convert.overwrite\"/>\n                        <span class=\"help-inline\">If the plugin component exists, update it</span>\n                    </label>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"doExport()\" ng-disabled=\"!isIdValid() || conversionForm.$invalid\">Export</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("/templates/admin/code-studios/manual-code-studio-template-params.html", "<form class=\"dkuform-horizontal\">\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Dockerfile</label>\n        <div class=\"controls\">\n            <div class=\"padbot8\">\n                <textarea ng-model=\"codeStudioTemplate.params.dockerfile\"\n                          ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"\n                          ui-refresh=\"uiState.active\"></textarea>\n            </div>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Entrypoint</label>\n        <div class=\"controls\">\n            <input type=\"text\" ng-model=\"codeStudioTemplate.params.entrypoint\"/>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Resources</label>\n        <div class=\"controls\">\n            <ng2-key-values-list \n                [(items)]=\"codeStudioTemplate.params.resources\"\n                key-placeholder=\"Source file or folder\"\n                value-placeholder=\"Target file of folder\"\n                add-label=\"Add copied file or folder\">\n            </ng2-key-values-list>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">K8S deployment Yaml</label>\n        <div class=\"controls\">\n            <div class=\"padbot8\">\n                <textarea ng-model=\"codeStudioTemplate.params.yaml\"\n                          ui-codemirror=\"codeMirrorSettingService.get('text/x-yaml')\"\n                          ui-refresh=\"uiState.active\"></textarea>\n            </div>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Object name</label>\n        <div class=\"controls\">\n            <input type=\"text\" ng-model=\"codeStudioTemplate.params.headObjectName\"/>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Selector</label>\n        <div class=\"controls\">\n            <div ng-model=\"codeStudioTemplate.params.selector\" type=\"text\" multiselect-field allow-free allow-dubs=\"true\" placeholder=\"Type a pod selector\" ></div>\n        </div>\n    </div>\n    \n        <div class=\"control-group\">\n        <label class=\"control-label\">Synchronized files</label>\n        \n        <div class=\"controls\">\n            <span class=\"help-inline\">Map folders from the DSS server to folders inside the codeStudio. Optionally restrict to a subfolder of a folder of the DSS folder. Optionally make one-way (click on arrow)</span>\n            <editable-list full-width-list=\"true\" ng-model=\"codeStudioTemplate.params.syncedZones\" add-label=\"Add mapped folder\" template=\"buildNewSyncZone\" transcope=\"{params:codeStudioTemplate.params}\">\n                <div>\n                    <select dku-bs-select ng-model=\"it.zone\">\n                        <option value=\"code_studio_versioned\">Code Studio versioned files</option>\n                        <option value=\"code_studio_resources\">Code Studio resources</option>\n                        <option value=\"project_lib_versioned\">Project libraries</option>\n                        <option value=\"project_lib_resources\">Project resources</option>\n                        <option value=\"recipes\">Project recipes</option>\n                        <option value=\"notebooks\">Project notebooks</option>\n                        <option value=\"user_versioned\">User config</option>\n                        <option value=\"user_resources\">User resources</option>\n                    </select>\n                </div>\n                &nbsp;/&nbsp;\n                <input style=\"min-width: 206px\"  type=\"text\" ng-disabled=\"true\" ng-if=\"it.zone == 'recipes'\"></input>\n                <editable-list-input style=\"min-width: 206px\" type=\"text\" ng-model=\"it.pathInZone\" ng-if=\"it.zone != 'recipes'\"/>\n                <button type=\"button\" class=\"btn btn--text btn--secondary btn--icon btn--dku-icon mleftright4\" ng-click=\"it.oneWay=!it.oneWay;\">\n                    <i class=\"editable-list__arrow-icon\" ng-class=\"{'dku-icon-arrow-right-long-16':it.oneWay, 'dku-icon-arrow-input-output-16':!it.oneWay}\"></i>\n                </button>\n                <editable-list-input full-width-input=\"true\" type=\"text\" ng-model=\"it.pathInContainer\"/>\n            </editable-list>\n        </div>\n    </div>\n     \n    <div class=\"alert alert--warning\" ng-repeat=\"conflict in listSyncedZoneConflicts(codeStudioTemplate.params.syncedZones)\">\n        The path <em>{{conflict.pathInContainer}}</em> is used in zones {{conflict.zones}}\n    </div>\n    \n    \n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Excluded files</label>\n        <div class=\"controls\">\n            <ng2-values-list full-width-list=\"true\" [(items)]=\"codeStudioTemplate.params.excludedFromSync\" add-label=\"Add an excluded pattern\" value-placeholder=\"E.g. *.ipynb\"></ng2-values-list>\n            <span class=\"help-inline\">Patterns for files/folders excluded from synchronization</span>\n        </div>\n    </div>\n\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Exposed port</label>\n        <div class=\"controls\">\n            <input type=\"number\" force-integer ng-model=\"codeStudioTemplate.params.exposedPort\"/>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Proxied subpath</label>\n        <div class=\"controls\">\n            <input type=\"text\" ng-model=\"codeStudioTemplate.params.proxiedUrlSuffix\"/>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Header for proxy prefix</label>\n        <div class=\"controls\">\n            <input type=\"text\" ng-model=\"codeStudioTemplate.params.proxyPrefixHeaderName\"/>\n            <span class=\"help-inline\">Optional header name to pass the prefix behind which the port is exposed by DSS to the server inside the pod</span>\n        </div>\n    </div>\n    <div class=\"control-group\">\n        <label for=\"\" class=\"control-label\">Readiness probe</label>\n        <div class=\"controls\">\n            <input type=\"text\" ng-model=\"codeStudioTemplate.params.readinessProbeUrl\"/>\n            <span class=\"help-inline\">HTTP URL to use to probe whether the service in the Code Studio is up and running: [http(s)://host[:port]/]path/to/probe</span>\n        </div>\n    </div>\n    <div class=\"control-group\" ng-if=\"codeStudioTemplate.params.readinessProbeUrl && codeStudioTemplate.params.readinessProbeUrl.length > 0\">\n        <label class=\"control-label\">Readiness probe headers</label>\n        <div class=\"controls\">\n            <ng2-key-values-list \n                [(items)]=\"codeStudioTemplate.params.readinessProbeHeaders\"\n                key-placeholder=\"Header name\"\n                value-placeholder=\"Header value\"\n                add-label=\"Add HTTP header\">\n            </ng2-key-values-list>\n            <span class=\"help-inline\">HTTP headers to use for the readiness probe</span>\n        </div>\n    </div>\n</form>\n");
$templateCache.put("/templates/admin/code-studios/mass-delete-code-studio-template-modal.html", "<div class=\"modal modal3\">\n\t<div dku-modal-header modal-title=\"Delete {{codeStudioTemplateIds.length}} Code Studio templates\" />\n\n\t<form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n            \n            <div>Delete Code Studio templates <div class=\"dib\" ng-repeat=\"codeStudioTemplateId in codeStudioTemplateIds\"><span ng-if=\"!$first\">,</span> <b>{{codeStudioTemplateId}}</b></div></div>\n\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"deleteRuntimes\" class=\"control-label\">Delete created Code Studios</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label style=\"font-size: inherit\">\n\t\t\t\t\t\t<input id=\"deleteRuntimes\" type=\"checkbox\" ng-model=\"deleteRuntimes\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Stop and delete Code Studios and Webapps created using these templates. See usages below.</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"control-group\">\n\t\t\t\t<label for=\"deleteImages\" class=\"control-label\">Purge Docker Images and builds</label>\n\t\t\t\t<div class=\"controls\">\n\t\t\t\t\t<label style=\"font-size: inherit\">\n\t\t\t\t\t\t<input id=\"deleteImages\" type=\"checkbox\" ng-model=\"deleteImages\" />\n\t\t\t\t\t\t<span class=\"help-inline\">Purge Docker images and empty build directory</span>\n\t\t\t\t\t</label>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"control-group\" ng-if=\"!uiState.usages\">\n\t\t\t\t<p>Searching for all uses of Code Studios may take a long time on large instances.</p>\n\t\t\t\t<button class=\"btn btn--primary\" ng-click=\"refreshUsages()\">Compute Usages</button>\n\t\t\t</div>\n\t\t\t<div ng-if=\"uiState.usages\" class=\"mtop16\">\n\t\t\t\t<div>Used by <strong>{{uiState.usages.totalCount}}</strong> {{ 'Code Studio' | plurify : uiState.usages.totalCount }} (<strong>{{uiState.usages.totalRunningCount}}</strong> running) in <strong>{{uiState.usages.projects | objectSize}}</strong> {{ 'project' | plurify : (uiState.usages.projects | objectSize) }}</div>\n\t\t\t\t<div ng-if=\"uiState.usages.notAccessibleCount > 0\" class=\"control-group\">\n\t\t\t\t\t<div><strong>{{uiState.usages.notAccessibleCount}}</strong> {{ 'object' | plurify : uiState.usages.notAccessibleCount }} <ng-pluralize count=\"uiState.usages.notAccessibleCount\" when=\"{   'one': 'is',  'other': 'are'}\"></ng-pluralize> not accessible according to your current permissions.</div>\n\t\t\t\t</div>\n\t\t\t\t<ul>\n\t\t\t\t\t<li ng-repeat=\"project in uiState.usages.projects\">\n\t\t\t\t\t\t<div><strong>{{project.count}}</strong> {{ 'Code Studio' | plurify : project.count }} (<strong>{{project.runningCount}}</strong> running) in {{ project.projectKey }}</div>\n\t\t\t\t\t</li>\n\t\t\t\t</ul>\n\t\t\t</div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"submit\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--danger\" ng-click=\"delete()\">Delete</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/code-studios/mass-set-code-studio-template-container-config-modal.html", "<div class=\"modal modal3\">\n    <div dku-modal-header modal-title=\"Set container config on {{codeStudioTemplateIds.length}} Code Studio templates\" />\n\n    <form class=\"dkuform-modal-wrapper dkuform-modal-horizontal\">\n        <div class=\"modal-body\">\n            <div block-api-error />\n            \n            <div ng-include=\"'/templates/admin/code-studios/code-studio-template-container-conf-settings.html'\"></div>\n            \n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"submit\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--primary\" ng-click=\"setConfigs()\">OK</button>\n        </div>\n    </form>\n\n</div>");
$templateCache.put("/templates/admin/code-studios/new-code-studio-template-modal.html", "<div class=\"modal modal3 dku-modal\">\n\t<div dku-modal-header modal-title=\"New Code Studio template\" />\n\n\t<form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newCodeStudioTemplateForm\">\n\t\t<div class=\"modal-body\">\n            <div block-api-error />\n\n            <div class=\"control-group\"\n                 ng-if=\"templateTypes && templateTypes.length>1\">\n                <label for=\"\" class=\"control-label control-label-compact\">Type</label>\n                <div class=\"controls controls-compact\">\n                    <select dku-bs-select required class=\"w100\"\n                            ng-model=\"newCodeStudioTemplate.type\"\n                            ng-options=\"t.type as t.label for t in templateTypes\"\n                            options-descriptions=\"templateTypeDescriptions\"/>\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label control-label-compact\">Label</label>\n                <div class=\"controls controls-compact\">\n                    <input type=\"text\" required class=\"w100\"\n                           ng-model=\"newCodeStudioTemplate.label\"\n                           ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n                    <span class=\"help-inline\" style=\"width: 100%\">Only letters, numbers, - (minus) and _ (underscore) are accepted.</span>\n                </div>\n            </div>\n\t\t</div>\n\n\t\t<div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"create()\" ng-disabled=\"newCodeStudioTemplateForm.$invalid\">Create</button>\n\t\t</div>\n\t</form>\n\n</div>");
$templateCache.put("/templates/admin/code-studios/security-permissions.html", "<div class=\"\" security-permissions-base permissions-bearer=\"codeStudioTemplate\">\n    <div block-api-error />\n    <div ng-if=\"appConfig.communityEdition\">\n        <div style=\"margin: 3em auto; width: 500px; text-align: center\">\n            <h4 class=\"ce-unavail\">\n                Collaborative features are not available in\n                <br />\n                {{wl.productLongName}} Free Edition\n            </h4>\n        </div>\n    </div>\n    <div ng-if=\"!appConfig.communityEdition\" style=\"padding-left:0;padding-right:0\" class=\"permissions-table-page\">\n        <form class=\"dkuform-horizontal\">\n            <div class=\"control-group\">\n                <label class=\"control-label\">Owner</label>\n                <div class=\"controls\">\n                    <select\n                        dku-bs-select=\"{ liveSearch: true }\"\n                        ng-options=\"usr.login as usr.displayName for usr in allUsers\"\n                        ng-model=\"ui.ownerLogin\"\n                        options-descriptions=\"allUsersLogin\"\n                        layout=\"list\">\n                    </select>\n                </div>\n            </div>\n        </form>\n        <form class=\"inline-form\">\n\n            <table sort-table class=\"table table-striped table-hover permissions\" >\n                <thead>\n                    <tr>\n                        <th width=\"30%\">Group name</th>\n                        <th width=\"15%\">Can use</th>\n                        <th width=\"15%\">Can update</th>\n                        <th width=\"40%\">&nbsp;</th>\n                    </tr>\n                </thead>\n                <tbody add-remove ng-model=\"codeStudioTemplate.permissions\">\n                    <tr>\n                        <td width=\"30%\"><em>Everybody</em></td>\n                        <td width=\"15%\">\n                            <label class=\"checkbox\" for=\"useDisabled_default\" >\n                                <input type=\"checkbox\" ng-show=\"codeStudioTemplate.defaultPermission.$useDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"codeStudioTemplate.defaultPermission.$useDisabled\" ng-model=\"codeStudioTemplate.defaultPermission.use\" id=\"useDisabled_default\"/>\n                            </label>\n                        </td>\n                        <td width=\"15%\">\n                            <label class=\"checkbox\" for=\"updateDisabled_default\" >\n                                <input type=\"checkbox\" ng-show=\"codeStudioTemplate.defaultPermission.$updateDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"codeStudioTemplate.defaultPermission.$updateDisabled\" ng-model=\"codeStudioTemplate.defaultPermission.update\" id=\"updateDisabled_default\"/>\n                            </label>\n                        </td>\n                        <td width=\"40%\">\n                        </td>\n                    </tr>\n                    <tr ng-repeat=\"perm in codeStudioTemplate.permissions\">\n\n                        <td width=\"30%\">{{perm.group}}</td>\n                        <td width=\"15%\">\n                            <label class=\"checkbox\" for=\"useDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$useDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$useDisabled\" ng-model=\"perm.use\" id=\"useDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td width=\"15%\">\n                            <label class=\"checkbox\" for=\"updateDisabled_{{$index}}\" >\n                                <input type=\"checkbox\" ng-show=\"perm.$updateDisabled\" checked disabled />\n                                <input type=\"checkbox\" ng-hide=\"perm.$updateDisabled\" ng-model=\"perm.update\" id=\"updateDisabled_{{$index}}\"/>\n                            </label>\n                        </td>\n                        <td width=\"40%\">\n                            <a class=\"link-danger\" ng-click=\"remove($index)\"><i class=\"icon-trash error-text-color\"/></a>\n                        </td>\n                    </tr>\n                </tbody>\n            </table>\n\n            <div ng-show=\"unassignedGroups.length\" style=\"margin-bottom: 20px;\">\n                <select style=\"display: inline-block;\" ng-model=\"newPerm.group\" dku-bs-select=\"{liveSearch:true,width:250}\" ng-options=\"g for g in unassignedGroups\" data-none-selected-text=\"Select a group\" ></select>\n                <button style=\"display: inline-block;\" ng-disabled=\"!newPerm.group\" ng-click=\"addPermission()\" class=\"btn btn--secondary\">\n                    <span plus-icon />\n                    &nbsp;Grant access to group\n                </button>\n            </div>\n\n            <div class=\"alert alert-info\">\n                <i class=\"icon-info-sign\" />\n                &nbsp;To manage groups go to <a class=\"tab\" ng-class=\"{'enabled': $state.includes('admin.groups')}\" href=\"/admin/security/groups/\">DSS global administration</a>.\n            </div>\n        </form>\n    </div>\n\n</div>\n");
$templateCache.put("/templates/admin/code-studios/upload-code-studio-template-modal.html", "<div class=\"modal modal3 dku-modal\">\n    <div dku-modal-header modal-title=\"Upload Code Studio template\" />\n    <form class=\"dkuform-modal-horizontal dkuform-modal-wrapper\" name=\"newCodeStudioTemplateForm\">\n        <div class=\"modal-body code-studio-template__import-modal\">\n            <div block-api-error />\n            <div class=\"control-group\">\n                <label for=\"newCodeStudioTemplateFile\" class=\"control-label control-label-compact\">Template file</label>\n                <div class=\"controls controls-compact\">\n                    <input id=\"newCodeStudioTemplateFile\" type=\"file\" required valid-file ng-model=\"newCodeStudioTemplate.file\" accept=\"application/zip\" />\n                </div>\n            </div>\n            <div class=\"control-group\">\n                <label for=\"\" class=\"control-label control-label-compact\">Label</label>\n                <div class=\"controls controls-compact\">\n                    <input type=\"text\" ng-model=\"newCodeStudioTemplate.label\" ng-pattern=\"/^[_A-Za-z0-9-]+$/\"/>\n                </div>\n            </div>\n            <div ng-show=\"usedCodeEnvs\">\n                <h5>Code env remapping</h5>\n                <p style=\"color: gray\">\n                    Use this if you get code environment-related errors, to remap code environments declared in the import archive to code environments existing in your DSS instance.\n                </p>\n\n                <div style=\"display: inline-block; width: 100%;\" add-remove ng-model=\"importSpec.codeEnvs\">\n                    <ul class=\"raw-unstyled-ul\" >\n                        <li ng-repeat=\"codeEnv in importSpec.codeEnvs\">\n                            <div class=\"remapping\" style=\"margin: 5px 0\" import-project-remapping-form>\n                                <input type=\"text\" ng-model=\"codeEnv.source\" bs-typeahead=\"usedCodeEnvs\" ng-focus=\"inputFocus($event)\" data-min-length=\"0\" />\n\n                                <i class=\"icon-long-arrow-right\" style=\"font-size: 17px; margin: 0 10px; color: grey;\"></i>\n\n                                <select ng-model=\"target\"\n                                        dku-bs-select=\"{liveSearch:true,size:'auto'}\"\n                                        ng-options=\"c as c.envName group by c.envLang for c in availableCodeEnvs | orderBy:codeEnvComparator(codeEnv.source) track by c.envName\"\n                                        ng-change=\"codeEnv.target = target.builtin ? '' : target.envName\"\n                                        ng-init=\"target = findCodeEnv(availableCodeEnvs, codeEnv.source)\">\n                                </select>\n\n                                <span ng-if=\"codeEnv.source && codeEnv.target && findCodeEnv(codeEnvs, codeEnv.source).envLang && findCodeEnv(codeEnvs, codeEnv.source).envLang != target.envLang\">\n                                    <i class=\"icon-warning-sign\" toggle=\"tooltip\" title=\"Type mismatch, expecting {{findCodeEnv(codeEnvs, codeEnv.source).envLang}}\" placement=\"right\" container=\"body\"></i>\n                                </span>\n\n                                <a ng-click=\"remove($index)\" class=\"pull-right\" style=\"color: grey\"><i class=\"icon-trash \"/></a>\n                            </div>\n\n                        </li>\n                    </ul>\n\n                    <div  class=\"add-value\">\n                        <span class=\"pull-right\" ng-click=\"refreshCodeEnvs()\" toggle=\"tooltip\" title=\"Refresh code envs list\" placement=\"left\" container=\"body\" style=\"text-align: right\">\n                            <i class=\"icon-refresh\" />\n                        </span>\n                        <span ng-click=\"add({})\">\n                            <i class=\"icon-plus-sign\" /> ADD REMAPPING\n                        </span>\n                    </div>\n\n                </div>\n            </div>\n            <ul class=\"raw-unstyled-ul alert alert-error\" ng-show=\"messages.length >0\" style=\"margin-top: 20px;\">\n                <h4>Issues were encountered</h4>\n                <li ng-repeat=\"message in messages\" class=\"row-fluid\">\n                    <div class=\"span2\" style=\"padding-top: 14px;\">\n                        <span class=\"{{DKUConstants.design.alertClasses[message.severity]}} severity\">{{message.severity}}</span>\n                    </div>\n                    <div class=\"span10\">\n                        <h5>{{message.title}}</h5>\n                        {{message.message}}\n                    </div>\n                </li>\n            </ul>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-click=\"import()\" ng-disabled=\"newCodeStudioTemplateForm.$invalid\">Import</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("/templates/admin/connection-anthropic.html", "<div ng-controller=\"AnthropicConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"api-key-input\" class=\"control-label\">Anthropic API key</label>\n                                    <div class=\"controls\">\n                                        <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\" />\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">Usable models</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV4Sonnet\" class=\"control-label\">Claude 4 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV4Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV4Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV4Opus\" class=\"control-label\">Claude 4 Opus</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV4Opus\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV4Opus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.015/1k tokens - Completion cost: $0.075/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV37Sonnet\" class=\"control-label\">Claude 3.7 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV37Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV37Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV35SonnetV2\" class=\"control-label\">Claude 3.5 Sonnet V2 (Oct. 24)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV35SonnetV2\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV35SonnetV2\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens\n                                                <br> Deprecated / scheduled for retirement on Oct. 22nd, 2025\n                                            </span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV35Sonnet\" class=\"control-label\">Claude 3.5 Sonnet V1 (Jun. 24)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV35Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV35Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens\n                                                <br> Deprecated / scheduled for retirement on Oct. 22nd, 2025\n                                            </span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV35Haiku\" class=\"control-label\">Claude 3.5 Haiku</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV35Haiku\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV35Haiku\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0008/1k tokens - Completion cost: $0.004/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV3Opus\" class=\"control-label\">Claude 3 Opus</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV3Opus\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV3Opus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.015/1k tokens - Completion cost: $0.075/1k tokens\n                                                <br> Deprecated / scheduled for retirement on Jan. 5th, 2026\n                                            </span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaudeV3Haiku\" class=\"control-label\">Claude 3 Haiku</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaudeV3Haiku\" type=\"checkbox\" ng-model=\"connection.params.allowClaudeV3Haiku\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00025/1k tokens - Completion cost: $0.00125/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Custom models</h2>\n\n                                <div add-remove ng-model=\"connection.params.customModels\">\n                                    <div ng-repeat=\"customModel in connection.params.customModels\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelId-' + $index}}\" class=\"control-label\">Model id</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelId-' + $index}}\" type=\"text\" required ng-model=\"customModel.id\"/>\n                                                <div class=\"help-inline\">\n                                                   Required. A model ID supported by Anthropic.\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelName-' + $index}}\" class=\"control-label\">Model display name</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelName-' + $index}}\" type=\"text\" ng-model=\"customModel.displayName\"/>\n                                                <div class=\"help-inline\">\n                                                    Used to identify this model in DSS. If empty defaults to the model id.\n                                                </div>\n                                            </div>\n                                        </div>\n                \n                                        <div class=\"control-group\">\n                                            <label for=\"{{'promptCost-' + $index}}\" class=\"control-label\">Prompt cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'promptCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.promptCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'completionCost-' + $index}}\" class=\"control-label\">Completion cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'completionCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.completionCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\"\n                                            ng-click=\"add({modelType: 'COMPLETION_CHAT'})\">\n                                        <i plus-icon/> Add custom model\n                                    </button>\n                                </div>\n\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n\n                </div>\n\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-athena.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span7\">\n                                <h2 class=\"settings-section-title\">Basic params</h2>\n                                \n                                <fieldset ng-if=\"connection.params.useURL != true\">\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">AWS region</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.region\" />\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Query data location</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.queryOutputLocation\" />\n                                            <span class=\"help-inline\">S3 location to put query results (optional)</span>\n                                        </div>\n                                    </div>\n                                </fieldset>\n                                <fieldset ng-if=\"connection.params.useURL == true\">\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Connection URL</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                            ng-required=\"true\"\n                                            placeHolder=\"jdbc:oracle:thin:@HOST:PORT:DB\" />\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Displayed URL</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                            ng-required=\"false\"\n                                            placeHolder=\"jdbc:oracle:thin:@HOST:PORT:DB\" />\n                                            <span class=\"help-inline\">Visible URL for the logs</span>\n                                        </div>\n                                    </div>\n                                </fieldset>\n\n                                <fieldset>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Credentials mode</label>\n                                        <div class=\"controls\">\n                                            <select dku-bs-select ng-model=\"connection.params.credentialsMode\" ng-options=\"x[0] as x[1] for x in [['USER_PASSWORD', 'AWS Keypair'], ['FROM_AWS_CONNECTION', 'From S3 connection']]\"></select>\n                                        </div>\n                                    </div>\n                                </fieldset>\n\n                                <fieldset ng-if=\"connection.params.credentialsMode == 'FROM_AWS_CONNECTION'\">\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">S3 connection name</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.associatedAWSConnection\" required/>\n                                        </div>\n                                    </div>\n                                </fieldset>\n\n                                <fieldset ng-if=\"connection.credentialsMode == 'GLOBAL' && connection.params.credentialsMode == 'USER_PASSWORD'\">\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Access key</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.user\" ng-required=\"connection.params.useURL != true\"/>\n                                            <div class=\"help-inline\" ng-show=\"connection.params.useURL != true\">\n                                                Mandatory.\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Secret key</label>\n                                        <div class=\"controls\">\n                                            <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                        </div>\n                                    </div>\n                                </fieldset>\n\n                                <div class=\"control-group\">\n                                    <label  class=\"control-label\">Advanced JDBC properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                            <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">Advanced params</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Driver version</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select ng-model=\"connection.params.version\">\n                                            <option value=\"2.X\">2.X</option>\n                                            <option value=\"3.X\">3.X</option>\n                                        </select>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. You must fill this value to avoid conflicts between the driver\\'s jars and other DSS jars.',size:'xxlarge'}\" />\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Fetch size</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                            </div>\n\n                            <div class=\"span5\">\n                                <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n\n</div>");
$templateCache.put("/templates/admin/connection-azure-ai-search.html", "<div ng-controller=\"AzureAISearchConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-azure-ai-services-auth-part.html\"/>\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\"/>\n                                <div ng-if=\"connection.params.authType === 'OAUTH2_APP'\" class=\"control-group\">\n                                    <label class=\"control-label\" for=\"credentials-mode\">Credentials mode</label>\n                                    <div class=\"controls\">\n                                        <select id=\"credentials-mode\" ng-model=\"connection.credentialsMode\" dku-bs-select>\n                                            <option value=\"GLOBAL\">Global</option>\n                                            <option value=\"PER_USER\">Per user</option>\n                                        </select>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"></div>\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection</div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.ok\" class=\"alert alert-error\">\n                <i class=\"icon-dku-error\" /> Connection to Azure AI Search failed: {{testResult.message}}\n            </div>\n            <div ng-show=\"testResult.ok\" class=\"alert alert-success\">\n              <i class=\"icon-success\" /> Connection to Azure AI Search OK\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-azure-llm.html", "<div ng-controller=\"AzureLLMConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\"/>\n                    <div block-api-error/>\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Endpoints</h2>\n\n                                <div class=\"alert alert-info\">\n                                    <i class=\"icon-info-sign\" /> Endpoints should support v1 of OpenAI API\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"{{'customModelKey-' + $index}}\" class=\"control-label\">Default key (optional)</label>\n                                    <div class=\"controls\">\n                                        <input id=\"{{'customModelKey-' + $index}}\" type=\"password\" ng-model=\"connection.params.defaultKey\"/>\n                                        <div class=\"help-inline\">\n                                            API key to use by default\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div add-remove ng-model=\"connection.params.customModels\" >\n                                    <div ng-repeat=\"customModel in connection.params.customModels\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'customModelId-' + $index}}\" class=\"control-label\">Id</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelId-' + $index}}\" type=\"text\" required ng-model=\"customModel.id\"/>\n                                                <div class=\"help-inline\">\n                                                    Required\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'customModelName-' + $index}}\" class=\"control-label\">Display name</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelName-' + $index}}\" type=\"text\" required ng-model=\"customModel.displayName\"/>\n                                                <div class=\"help-inline\">\n                                                    Required\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'customModelURI-' + $index}}\" class=\"control-label\">Target URI</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelURI-' + $index}}\" type=\"text\" required placeholder=\"https://endpoint-name.region.inference.ai.azure.com\" ng-model=\"customModel.targetURI\"/>\n                                                <div class=\"help-inline\">\n                                                    Required\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'customModelKey-' + $index}}\" class=\"control-label\">Endpoint Key</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelKey-' + $index}}\" type=\"password\" ng-model=\"customModel.key\"/>\n                                                <div class=\"help-inline\">\n                                                    Replaces default key if specified\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'customModelKey-' + $index}}\" class=\"control-label\">Model type</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'customModelKey-' + $index}}\" required\n                                                    ng-model=\"customModel.modelType\" bind-label=\"displayName\" bind-value=\"rawValue\"\n                                                    items=\"modelTypes\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"usePromptAndCompletionCosts(customModel)\">\n                                            <label for=\"{{'customModelPromptCost-' + $index}}\" class=\"control-label\">Prompt cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelPromptCost-' + $index}}\" type=\"number\" min=\"0\" \n                                                        ng-model=\"customModel.promptCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"usePromptAndCompletionCosts(customModel)\">\n                                            <label for=\"{{'customModelCompletionCost-' + $index}}\" class=\"control-label\">Completion cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelCompletionCost-' + $index}}\" type=\"number\" min=\"0\"\n                                                        ng-model=\"customModel.completionCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"useEmbeddingCosts(customModel)\">\n                                            <label for=\"{{'customModelEmbeddingCost-' + $index}}\" class=\"control-label\">Embedding cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'customModelEmbeddingCost-' + $index}}\" type=\"number\" min=\"0\"\n                                                        ng-model=\"customModel.embeddingCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label class=\"control-label\">Custom headers</label>\n                                            <div class=\"controls\">\n                                                <ng2-connection-properties-list\n                                                        [(items)]=\"customModel.customHeaders\"\n                                                        add-label=\"Add header\">\n                                                </ng2-connection-properties-list>\n                                                <span class=\"help-inline\">(Optional) Static headers sent with every request. Variable expansion is supported.</span>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\" ng-click=\"add({id: null, displayName: null, modelType: 'COMPLETION_CHAT', targetURI: null, key: null, promptCost: null, completionCost: null, embeddingCost: null})\">\n                                        <i plus-icon/> Add endpoint\n                                    </button>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\"/>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\"/>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\"/>\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\"/>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-azure-openai.html", "<div ng-controller=\"AzureOpenAiConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\"/>\n                    <div block-api-error/>\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-azure-ai-services-auth-part.html\"/>\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Custom headers</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list\n                                                [(items)]=\"connection.params.customHeaders\"\n                                                add-label=\"Add header\">\n                                        </ng2-connection-properties-list>\n                                        <span class=\"help-inline\">(Optional) Static headers sent with every request. Variable expansion is supported.</span>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Deployments</h2>\n                                <div add-remove ng-model=\"connection.params.availableDeployments\">\n                                    <div ng-repeat=\"deployment in connection.params.availableDeployments\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'deploymentName-' + $index}}\" class=\"control-label\">Deployment name</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'deploymentName-' + $index}}\" type=\"text\" required ng-model=\"deployment.name\"/>\n                                                <div class=\"help-inline\">\n                                                    Required\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'deploymentType-' + $index}}\" class=\"control-label\">Deployment type</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'deploymentType-' + $index}}\" required ng-change=\"onDeploymentTypeChange(deployment)\"\n                                                              ng-model=\"deployment.deploymentType\" bind-label=\"displayName\" bind-value=\"rawValue\"\n                                                              items=\"deploymentTypes\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"'IMAGE_GENERATION' === deployment.deploymentType\">\n                                            <label for=\"{{'imageHandlingMode-' + $index}}\" class=\"control-label\">Model handling mode</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'imageHandlingMode-' + $index}}\" required ng-model=\"deployment.imageHandlingMode\" bind-label=\"displayName\" bind-value=\"rawValue\" items=\"imageHandlingModes\" />\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"['COMPLETION_CHAT', 'COMPLETION_CHAT_MULTIMODAL', 'COMPLETION_CHAT_NO_SYSTEM_PROMPT'].includes(deployment.deploymentType)\">\n                                            <label for=\"{{'modelAPIMode-' + $index}}\" class=\"control-label\">API Mode</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'modelAPIMode-' + $index}}\" required ng-model=\"deployment.api\"\n                                                              bind-label=\"displayName\" bind-value=\"rawValue\" items=\"modelAPIModes\"/>\n                                                <div class=\"help-inline\">\n                                                    Choose whether the model will use Chat Completions API or Responses API.\n                                                </div>\n                                            </div>\n                                        </div>\n                                        \n                                        <div class=\"control-group\" ng-if=\"usePromptAndCompletionCosts(deployment)\">\n                                            <label class=\"control-label\">Max tokens API mode</label>\n                                            <div class=\"controls\">\n                                                <basic-select required\n                                                              ng-model=\"deployment.maxTokensAPIMode\"\n                                                              bind-label=\"displayName\"\n                                                              bind-value=\"rawValue\"\n                                                              items=\"maxTokensAPIModes\"\n                                                              bind-tooltip=\"description\" />\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"'IMAGE_GENERATION' !== deployment.deploymentType\">\n                                            <label for=\"{{'underlyingName-' + $index}}\" class=\"control-label\">Model pricing</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'underlyingName-' + $index}}\" ng-change=\"onModelPricingChange(deployment)\"\n                                                              ng-model=\"deployment.underlyingModelName\" bind-label=\"displayName\" bind-value=\"rawValue\"\n                                                              items=\"getOpenAIModels(deployment.deploymentType)\"/>\n                                                <span class=\"help-block\">\n                                                    Use the pricing from a given OpenAI model, or enter a custom pricing\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"usePromptAndCompletionCosts(deployment)\">\n                                            <label for=\"{{'promptCost-' + $index}}\" class=\"control-label\">Prompt cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'promptCost-' + $index}}\" type=\"number\" min=\"0\" ng-disabled=\"deployment.underlyingModelName !== ''\"\n                                                       ng-model=\"deployment.promptCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"usePromptAndCompletionCosts(deployment)\">\n                                            <label for=\"{{'completionCost-' + $index}}\" class=\"control-label\">Completion cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'completionCost-' + $index}}\" type=\"number\" min=\"0\" ng-disabled=\"deployment.underlyingModelName !== ''\"\n                                                       ng-model=\"deployment.completionCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"useEmbeddingCosts(deployment)\">\n                                            <label for=\"{{'embeddingCost-' + $index}}\" class=\"control-label\">Embedding cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'embeddingCost-' + $index}}\" type=\"number\" min=\"0\" ng-disabled=\"deployment.underlyingModelName !== ''\"\n                                                       ng-model=\"deployment.embeddingCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\" ng-click=\"add({name: '', underlyingModelName: '', deploymentType: 'COMPLETION_CHAT', api : 'CHAT_COMPLETIONS', maxTokensAPIMode: 'MODERN'})\">\n                                        <i plus-icon/> Add deployment\n                                    </button>\n                                </div>\n\n                                <h2 class=\"settings-section-title\" ng-if=\"showFineTuningSettings()\">Fine-tuning</h2>\n                                <div class=\"control-group\" ng-if=\"showFineTuningSettings()\">\n                                    <label for=\"allowFinetuning\" class=\"control-label\">Allow fine-tuning</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowFinetuning\" type=\"checkbox\" ng-model=\"connection.params.allowFinetuning\"/>\n                                        <span class=\"help-inline\">\n                                            Enable to allow models from this connection in the fine-tuning recipe.\n                                        </span>\n                                    </div>\n                                </div>\n                                <div ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning)\">\n                                    <div class=\"control-group\">\n                                        <label for=\"resource-name-input\" class=\"control-label\">Resource group</label>\n                                        <div class=\"controls\">\n                                            <input id=\"resource-group\" type=\"text\" ng-model=\"connection.params.resourceGroup\"/>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"resource-name-input\" class=\"control-label\">Subscription Id</label>\n                                        <div class=\"controls\">\n                                            <input id=\"subscription\" type=\"text\" ng-model=\"connection.params.subscriptionId\"/>\n                                        </div>\n                                    </div>\n                                    <div ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, true)\" class=\"control-group\">\n                                        <label class=\"control-label\">AzureML connection</label>\n                                        <div class=\"controls\">\n                                            <basic-select items=\"azureMLConnections\" placeholder=\"Select a connection\"\n                                                          ng-model=\"connection.params.azureMLConnection\">\n                                            </basic-select>\n                                            <span class=\"help-inline\">\n                                            Its credentials are used to deploy fine-tuned models with Azure Management API\n                                        </span>\n                                        </div>\n                                    </div>\n                                    <div class=\"alert info df aic mtop8\" ng-if=\"!!!connection.params.subscriptionId || !!!connection.params.resourceGroup\">\n                                        You need to input a resource group and a subscription id if you want to be able to deploy your Azure Open AI models.\n                                    </div>\n\n                                </div>\n                                <div ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, true)\">\n                                    <h2 class=\"settings-section-title\">Fine-tunable models</h2>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowGPT35Turbo0125Finetuning\" class=\"control-label\">GPT 3.5 Chat turbo (0125)</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input id=\"allowGPT35Turbo0125Finetuning\" type=\"checkbox\" disabled-if=\"!!!connection.params.allowFinetuning\" ng-model=\"connection.params.allowGPT35Turbo0125Finetuning\" />\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowGPT35Turbo0613Finetuning\" class=\"control-label\">GPT 3.5 Chat turbo (0613)</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input id=\"allowGPT35Turbo0613Finetuning\" type=\"checkbox\" disabled-if=\"!!!connection.params.allowFinetuning\" ng-model=\"connection.params.allowGPT35Turbo0613Finetuning\" />\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowGPT35Turbo1106Finetuning\" class=\"control-label\">GPT 3.5 Chat turbo (1106)</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input id=\"allowGPT35Turbo1106Finetuning\" type=\"checkbox\" disabled-if=\"!!!connection.params.allowFinetuning\" ng-model=\"connection.params.allowGPT35Turbo1106Finetuning\" />\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowBabbageFinetuning\" class=\"control-label\">Babbage 002</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input id=\"allowBabbageFinetuning\" type=\"checkbox\" disabled-if=\"!!!connection.params.allowFinetuning\" ng-model=\"connection.params.allowBabbageFinetuning\" />\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowDavinciFinetuning\" class=\"control-label\">Davinci 002</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input id=\"allowDavinciFinetuning\" type=\"checkbox\" disabled-if=\"!!!connection.params.allowFinetuning\" ng-model=\"connection.params.allowDavinciFinetuning\" />\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div add-remove ng-model=\"connection.params.customModels\" disabled-if=\"!!!connection.params.allowFinetuning\" >\n                                        <div ng-repeat=\"customModel in connection.params.customModels\" class=\"repeatable-config-block\">\n                                            <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                                <i class=\"dku-icon-trash-16\"></i>\n                                            </button>\n                                            <div class=\"control-group\">\n                                                <label for=\"{{'customModelId-' + $index}}\" class=\"control-label\">Custom Model Id</label>\n                                                <div class=\"controls\">\n                                                    <input id=\"{{'customModelId-' + $index}}\" type=\"text\" required ng-model=\"customModel.id\"/>\n                                                    <div class=\"help-inline\">\n                                                        Required\n                                                    </div>\n                                                </div>\n                                            </div>\n                                            <div class=\"control-group\">\n                                                <label for=\"{{'customModelName-' + $index}}\" class=\"control-label\">Custom model display name</label>\n                                                <div class=\"controls\">\n                                                    <input id=\"{{'customModelName-' + $index}}\" type=\"text\" required ng-model=\"customModel.displayName\"/>\n                                                    <div class=\"help-inline\">\n                                                        Required\n                                                    </div>\n                                                </div>\n                                            </div>\n                                            <div class=\"control-group\">\n                                                <label for=\"useChatAPI\" class=\"control-label\">Use chat API</label>\n                                                <div class=\"controls\">\n                                                    <label>\n                                                        <input id=\"useChatAPI\" type=\"checkbox\" ng-model=\"customModel.useChatAPI\" />\n                                                    </label>\n                                                </div>\n                                            </div>\n                                            <div class=\"control-group\">\n                                                <label for=\"canBeFineTuned\" class=\"control-label\">Can be fine-tuned</label>\n                                                <div class=\"controls\">\n                                                    <label>\n                                                        <input ng-disabled=\"true\" id=\"canBeFineTuned\" type=\"checkbox\" ng-model=\"customModel.canBeFineTuned\" ng-init=\"customModel.canBeFineTuned=true\" />\n                                                    </label>\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <button type=\"button\" class=\"btn btn--primary btn--text mtop8\" ng-click=\"add({displayName: '', id: '', useChatAPI: true})\">\n                                            <i plus-icon/> Add custom model\n                                        </button>\n                                    </div>\n                                </div>\n\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\"/>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\"/>\n                                <div ng-if=\"connection.params.authType === 'OAUTH2_APP'\" class=\"control-group\">\n                                    <label class=\"control-label\" for=\"credentials-mode\">Credentials mode</label>\n                                    <div class=\"controls\">\n                                        <select id=\"credentials-mode\" ng-model=\"connection.credentialsMode\" dku-bs-select>\n                                            <option value=\"GLOBAL\">Global</option>\n                                            <option value=\"PER_USER\">Per user</option>\n                                        </select>\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\"/>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-image-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\"/>\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-azure.html", "<div ng-controller=\"AzureConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div block-api-error />\n\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'storageAccount',type:'string', mandatory:true, label:'Azure Storage account'}\" />\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Auth type</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.authType\" dku-bs-select>\n                                    <option value=\"SHARED_KEY\">Shared key</option>\n                                    <option value=\"OAUTH2_APP\">OAuth2 from App</option>\n                                </select>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'SHARED_KEY'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'accessKey',type:'password', mandatory:true, label:'Access Key'}\" />\n\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'tenantId',type:'string', mandatory:true, label:'Tenant id'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'appId',type:'string', mandatory:true, label:'App id'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'appSecret',type:'password', mandatory:false, label:'App secret', tooltip:'Optional. Not needed if the app was registered as a public client '}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP' && connection.credentialsMode == 'PER_USER'\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'authorizationEndpoint',type:'string', false, label:'OAuth2 authorization endpoint', description:'If not default',  tooltip:'Optional. Will default to https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/authorize'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'tokenEndpoint',type:'string', false, label:'OAuth2 token endpoint', description:'If not default', tooltip:'Optional. Will default to https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/token'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType === 'OAUTH2_APP' && connection.credentialsMode === 'PER_USER'\">\n                            <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                    <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                </label>\n                            </div>\n                        </div>\n\n                        <h2 class=\"settings-section-title\">Fast loading/unloading</h2>\n\n                        <p>\n                            <small class=\"help-inline\" style=\"padding: 0\">\n                                These optional settings are used for direct data loading from/unloading to Snowflake and/or Databricks.\n                            </small>\n                        </p>\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'sasToken',type:'password', label:'SAS Token', tooltip:'Used for the direct data transfer to/from Snowflake and/or Databricks. For Snowflake, not needed if using an external stage'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStageName',type:'string', mandatory:false, label:'Snowflake external stage name', tooltip:'If necessary, add double quotes for case sensitivity, and qualify the stage name with the database and schema'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStagePath',type:'string', mandatory:false, label:'Snowflake external stage path', tooltip: 'Enter the path starting from and including the container. This should match the path used when creating the stage.'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeStorageIntegration',type:'string', mandatory:false, label:'Snowflake storage integration', tooltip: 'Not needed if using an external stage'}\" />\n\n                        <h2 class=\"settings-section-title\">Path restrictions</h2>\n\n                        <div class=\"control-group\" form-template-element\n                 model=\"connection.params\"\n                 field=\"{name:'chcontainer', type:'string', label:'Container', tooltip:'Optional. Limit accesses on this connection to the contents of this container. If empty, users will be able to select container (among container allowed by this access key)'}\" />\n                        <div class=\"control-group\" form-template-element\n                 model=\"connection.params\"\n                 field=\"{name:'chroot', type:'string', label:'Path from', tooltip:'Optional. Limit accesses on this connection to the contents of this folder. If empty, users will be able to use the whole container (or containers)'}\" />\n\n                        <fieldset ng-disabled=\"!connection.allowManagedDatasets && !connection.allowManagedFolders\">\n                            <h2 class=\"settings-section-title\">Managed datasets &amp; folders</h2>\n\n                            <div class=\"control-group\" ng-if=\"!connection.params.chcontainer\"\n                    form-template-element\n                    model=\"connection.params\"\n                    field=\"{name:'defaultManagedContainer',type:'string',\n                            label:'Default container',\n                            tooltip:'Managed datasets will be created by default in this container. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"!connection.params.chcontainer\"\n                    form-template-element\n                    model=\"connection.params\"\n                    field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Default path',\n                            tooltip:'Managed datasets will be created by default in this path. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.params.chcontainer\"\n                    form-template-element\n                    model=\"connection.params\"\n                    field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Managed data subpath',\n                            tooltip:'Managed datasets and folders will be created by default in this subpath of the root path in container. May contain variables.'}\" />\n                        </fieldset>\n\n                        <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n\n                        <h2 class=\"settings-section-title\">Advanced</h2>\n                        <div class=\"control-group\">\n\n                            <label class=\"control-label\">HDFS interface</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.hdfsInterface\" dku-bs-select>\n                                    <option value=\"WASB\">WASB</option>\n                                    <option value=\"ABFS\">ABFS</option>\n                                    <option value=\"NONE\">None</option>\n                                </select>\n                                <span class=\"help-inline\">Protocol to use for direct access to Azure datasets from Spark.</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"useSSL\" class=\"control-label\">Use SSL</label>\n                            <div class=\"controls\">\n                                <input id=\"useSSL\" type=\"checkbox\" ng-model=\"connection.params.useSSL\" />\n                                <span class=\"help-inline\">will use wasbs:// or abfss:// instead of wasb:// or abfs://</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Metastore synchronization</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.metastoreSynchronizationMode\" dku-bs-select>\n                                    <option value=\"KEEP_IN_SYNC\">Keep datasets synced</option>\n                                    <option value=\"NO_SYNC\">No sync</option>\n                                </select>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Fallback metastore DB</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.defaultMetastoreDatabase\" name=\"defaultMetastoreDatabase\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n                                <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.defaultMetastoreDatabase.$invalid\">\n                                    Metastore database names can only contains letters, numbers and underscores.\n                                </div>\n                                <div class=\"help-inline\">\n                                    This database is used as default for datasets that do not declare one\n                                </div>\n                            </div>\n                        </div>\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n\n                        <div ng-if=\"connection.params.authType === 'OAUTH2_APP'\" class=\"control-group\">\n                            <label class=\"control-label\">Credentials mode</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.credentialsMode\" dku-bs-select>\n                                    <option value=\"GLOBAL\">Global</option>\n                                    <option value=\"PER_USER\">Per user</option>\n                                </select>\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <!-- style=\"border-top: 1px #ccc solid\"-->\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />&nbsp;Please wait, testing connection\n        </div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.connectionOK\" class=\"alert alert-error\"> \n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK - {{testResult.connectionErrorMsg}}\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-azureml.html", "<div ng-controller=\"AzureMLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div block-api-error />\n\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Auth type</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.authType\" dku-bs-select>\n                                    <option value=\"OAUTH2_APP\">OAuth2 from App</option>\n                                    <option value=\"ENVIRONMENT\">Environment</option>\n                                </select>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'tenantId',type:'string', mandatory:true, label:'Tenant id'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'appId',type:'string', mandatory:true, label:'App id'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'appSecret',type:'password', mandatory:true, label:'App secret'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP' && connection.credentialsMode == 'PER_USER'\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'authorizationEndpoint',type:'string', false, label:'OAuth2 authorization endpoint', description:'If not default',  tooltip:'Optional. Will default to https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/authorize'}\" />\n                        <div class=\"control-group\" ng-if=\"connection.params.authType == 'OAUTH2_APP'\"\n                form-template-element\n                model=\"connection.params\"\n                field=\"{name:'tokenEndpoint',type:'string', false, label:'OAuth2 token endpoint', description:'If not default', tooltip:'Optional. Will default to https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/token'}\" />\n\n                            <div class=\"control-group\" ng-if=\"connection.params.authType === 'OAUTH2_APP' && connection.credentialsMode === 'PER_USER'\">\n                            <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                    <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                </label>\n                            </div>\n                        </div>\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                        <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n\n                        <div ng-if=\"connection.params.authType === 'OAUTH2_APP'\" class=\"control-group\">\n                            <label class=\"control-label\">Credentials mode</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.credentialsMode\" dku-bs-select>\n                                    <option value=\"GLOBAL\">Global</option>\n                                    <option value=\"PER_USER\">Per user</option>\n                                </select>\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <!-- style=\"border-top: 1px #ccc solid\"-->\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />&nbsp;Please wait, testing connection\n        </div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.connectionOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK - {{testResult.connectionErrorMsg}}\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-bedrock.html", "<div ng-controller=\"BedrockConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">S3 connection</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select=\"{liveSearch:true}\" ng-options=\"s3 for s3 in s3Connections\" placeholder=\"Select a connection\"\n                                                      ng-model=\"connection.params.s3Connection\">\n                                        </select>\n                                        <span class=\"help-inline\">\n                                            The credentials of that connection will be used to connect to Bedrock\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"region\" class=\"control-label\">Region</label>\n                                    <div class=\"controls\">\n                                        <input id=\"region\" type=\"text\" ng-model=\"connection.params.region\" />\n                                        <span class=\"help-inline\">\n                                            AWS region name\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"inference-profile\" class=\"control-label\">Inference profile</label>\n                                    <div class=\"controls\">\n                                        <input id=\"inference-profile\" type=\"text\" ng-model=\"connection.params.inferenceProfile\" />\n                                        <span class=\"help-inline\">\n                                            Optional Bedrock cross-region inference profile (e.g. us, eu, apac).\n                                            See <a href=\"https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-support.html\" title=\"inference profiles support\" target=\"_blank\">the AWS documentation</a> for which models and regions are supported.\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"max-parallelism\" class=\"control-label\">Max parallelism</label>\n                                    <div class=\"controls\">\n                                        <input id=\"max-parallelism\" type=\"number\" force-integer step=\"1\" min=\"1\" max=\"128\" ng-model=\"connection.params.maxParallelism\" />\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Text completion models</h2>\n                                \n                                <p>\n                                    <small class=\"help-inline\" style=\"padding: 0\">Note that prices vary per region. When applicable, this is the <strong>us-east-1</strong> cost. \n                                        <br>\n                                        More information about the pricing: <a href=\"https://aws.amazon.com/bedrock/pricing/\"title=\"the pricing\" target=\"_blank\">Amazon Bedrock Pricing</a>\n                                    </small>\n                                </p>\n\n                                <div class=\"dku-small-sub-title\">Amazon</div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSNovaPro\" class=\"control-label\">Amazon Nova Pro</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSNovaPro\" type=\"checkbox\" ng-model=\"connection.params.allowAWSNovaPro\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0008/1k tokens - Completion cost: $0.0032/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSNovaLite\" class=\"control-label\">Amazon Nova Lite</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSNovaLite\" type=\"checkbox\" ng-model=\"connection.params.allowAWSNovaLite\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00006/1k tokens - Completion cost: $0.00024/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSNovaMicro\" class=\"control-label\">Amazon Nova Micro</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSNovaMicro\" type=\"checkbox\" ng-model=\"connection.params.allowAWSNovaMicro\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.000035/1k tokens - Completion cost: $0.00014/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanTextAgileV1\" class=\"control-label\">Amazon Titan Text Premier</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanTextAgileV1\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanTextPremierV1\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0005/1k tokens - Completion cost: $0.0015/1k tokens\n                                                <br />\n                                                Deprecated / scheduled for retirement on Aug. 15th, 2025</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanTextLiteV1\" class=\"control-label\">Amazon Titan Text G1 Lite</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanTextLiteV1\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanTextLiteV1\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00015/1k tokens - Completion cost: $0.0002/1k tokens\n                                                <br />\n                                                Deprecated / scheduled for retirement on Aug. 15th, 2025</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanTextExpressV1\" class=\"control-label\">Amazon Titan Text G1 Express</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanTextExpressV1\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanTextExpressV1\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0002/1k tokens - Completion cost: $0.0006/1k tokens\n                                                <br />\n                                                Deprecated / scheduled for retirement on Aug. 15th, 2025</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanLarge\" class=\"control-label\">Amazon Titan Large (deprecated)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanLarge\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanLarge\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0013/1k tokens - Completion cost: $0.0017/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">Anthropic</div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude4Sonnet\" class=\"control-label\">Anthropic Claude 4 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude4Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude4Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude4Opus\" class=\"control-label\">Anthropic Claude 4 Opus</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude4Opus\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude4Opus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.015/1k tokens - Completion cost: $0.075/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude37Sonnet\" class=\"control-label\">Anthropic Claude 3.7 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude37Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude37Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude35SonnetV2\" class=\"control-label\">Anthropic Claude 3.5 Sonnet V2 (Oct. 24)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude35SonnetV2\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude35SonnetV2\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude35Sonnet\" class=\"control-label\">Anthropic Claude 3.5 Sonnet V1 (Jun. 24)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude35Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude35Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude3Sonnet\" class=\"control-label\">Anthropic Claude 3 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude3Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude3Sonnet\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude35Haiku\" class=\"control-label\">Anthropic Claude 3.5 Haiku</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude35Haiku\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude35Haiku\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0008/1k tokens - Completion cost: $0.004/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude3Haiku\" class=\"control-label\">Anthropic Claude 3 Haiku</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude3Haiku\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude3Haiku\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00025/1k tokens - Completion cost: $0.00125/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaude3Opus\" class=\"control-label\">Anthropic Claude 3 Opus</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaude3Opus\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaude3Opus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.015/1k tokens - Completion cost: $0.075/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaudeV2\" class=\"control-label\">Anthropic Claude V2</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaudeV2\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaudeV2\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.008/1k tokens - Completion cost: $0.024/1k tokens\n                                                <br />\n                                                Deprecated / scheduled for retirement on Jul. 21st, 2025</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAnthropicClaudeInstantV1\" class=\"control-label\">Anthropic Claude Instant V1</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAnthropicClaudeInstantV1\" type=\"checkbox\" ng-model=\"connection.params.allowAnthropicClaudeInstantV1\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0008/1k tokens - Completion cost: $0.0024/1k tokens\n                                                <br />\n                                                Deprecated / scheduled for retirement on Jul. 21st, 2025</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">AI21 Labs</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAI21Jurassic2Ultra\" class=\"control-label\">AI21 Labs Jurassic 2 Ultra</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAI21Jurassic2Ultra\" type=\"checkbox\" ng-model=\"connection.params.allowAI21Jurassic2Ultra\" />\n                                            <span class=\"help-inline\">Prompt/Completion cost: $0.0188/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAI21Jurassic2Mid\" class=\"control-label\">AI21 Labs Jurassic 2 Mid</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAI21Jurassic2Mid\" type=\"checkbox\" ng-model=\"connection.params.allowAI21Jurassic2Mid\" />\n                                            <span class=\"help-inline\">Prompt/Completion cost: $0.0125/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n\n                                <div class=\"dku-small-sub-title mtop16\">Cohere</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowCohereCommandRPlus\" class=\"control-label\">Cohere Command R+</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowCohereCommandRPlus\" type=\"checkbox\" ng-model=\"connection.params.allowCohereCommandRPlus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowCohereCommandR\" class=\"control-label\">Cohere Command R</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowCohereCommandR\" type=\"checkbox\" ng-model=\"connection.params.allowCohereCommandR\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0005/1k tokens - Completion cost: $0.0015/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">Meta</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama33_70BInstruct\" class=\"control-label\">Meta Llama 3.3 70B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama33_70BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama33_70BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00072/1k tokens - Completion cost: $0.00072/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama31_8BInstruct\" class=\"control-label\">Meta Llama 3.1 8B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama31_8BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama31_8BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00022/1k tokens - Completion cost: $0.00022/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama31_70BInstruct\" class=\"control-label\">Meta Llama 3.1 70B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama31_70BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama31_70BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00072/1k tokens - Completion cost: $0.00072/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama31_405BInstruct\" class=\"control-label\">Meta Llama 3.1 405B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama31_405BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama31_405BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00532/1k tokens - Completion cost: $0.016/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama38BInstruct\" class=\"control-label\">Meta Llama 3 8B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama38BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama38BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0003/1k tokens - Completion cost: $0.0006/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMetaLlama370BInstruct\" class=\"control-label\">Meta Llama 3 70B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMetaLlama370BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMetaLlama370BInstruct\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00265/1k tokens - Completion cost: $0.0035/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">Mistral</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistral7BInstruct\" class=\"control-label\">Mistral 7B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistral7BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMistral7BInstruct\" />\n                                            <span class=\"help-inline\">Pricing varies depending on region</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMixtral8X7BInstruct\" class=\"control-label\">Mixtral 8X7B Instruct</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMixtral8X7BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMixtral8X7BInstruct\" />\n                                            <span class=\"help-inline\">Pricing varies depending on region</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralSmall\" class=\"control-label\">Mistral Small</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralSmall\" type=\"checkbox\" ng-model=\"connection.params.allowMistralSmall\" />\n                                            <span class=\"help-inline\">Pricing varies depending on region</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralLarge\" class=\"control-label\">Mistral Large</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralLarge\" type=\"checkbox\" ng-model=\"connection.params.allowMistralLarge\" />\n                                            <span class=\"help-inline\">Pricing varies depending on region</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralLarge2\" class=\"control-label\">Mistral Large 2</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralLarge2\" type=\"checkbox\" ng-model=\"connection.params.allowMistralLarge2\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.003/1k tokens - Completion cost: $0.009/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">DeepSeek</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowDeepSeekR1\" class=\"control-label\">DeepSeek R1</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowDeepSeekR1\" type=\"checkbox\" ng-model=\"connection.params.allowDeepSeekR1\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00135/1k tokens - Completion cost: $0.0054/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Embedding models</h2>\n\n                                <div class=\"dku-small-sub-title\">Amazon</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanEmbedTextV2\" class=\"control-label\">Amazon Titan Embeddings Text V2</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanEmbedTextV2\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanEmbedTextV2\" />\n                                            <span class=\"help-inline\">Pricing varies by region</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanEmbedText\" class=\"control-label\">Amazon Titan Embeddings G1 Text</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanEmbedText\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanEmbedText\" />\n                                            <span class=\"help-inline\">Embedding cost: $0.0008/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowAWSTitanMultimodalEmbedV1\" class=\"control-label\">Amazon Titan Embeddings G1 Multimodal</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowAWSTitanMultimodalEmbedV1\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanMultimodalEmbedV1\" />\n                                            <span class=\"help-inline\">Embedding cost: $0,0008/1k tokens - $0,00006/1k images</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div class=\"dku-small-sub-title mtop16\">Cohere</div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowCohereEmbedEnglish\" class=\"control-label\">Cohere Embed English</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowCohereEmbedEnglish\" type=\"checkbox\" ng-model=\"connection.params.allowCohereEmbedEnglish\" />\n                                            <span class=\"help-inline\">Embedding cost: $0.0001/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowCohereEmbedMultilingual\" class=\"control-label\">Cohere Embed Multilingual</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowCohereEmbedMultilingual\" type=\"checkbox\" ng-model=\"connection.params.allowCohereEmbedMultilingual\" />\n                                            <span class=\"help-inline\">Embedding cost: $0.0001/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <div>\n                                     <h2 class=\"settings-section-title\">Image generation models</h2>\n\n                                    <div class=\"dku-small-sub-title\">Amazon</div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowAWSTitanImageGeneratorV1\" class=\"control-label\">Amazon Titan Image Generator</label>\n                                        <div class=\"controls\">\n                                            <input id=\"allowAWSTitanImageGeneratorV1\" type=\"checkbox\" ng-model=\"connection.params.allowAWSTitanImageGeneratorV1\" />\n                                            <span class=\"help-inline\">Image generation cost: $0.008 to $0.012 per image\n                                                <br />\n                                                Deprecated / scheduled for retirement on Aug. 15th, 2025</span>\n                                        </div>\n                                    </div>\n\n                                    <div class=\"dku-small-sub-title mtop16\">Stability AI</div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowStabilityAICore\" class=\"control-label\">Stability AI Stable Image Core</label>\n                                        <div class=\"controls\">\n                                            <input id=\"allowStabilityAICore\" type=\"checkbox\" ng-model=\"connection.params.allowStabilityAICore\" />\n                                            <span class=\"help-inline\">Image generation cost: $0.04 per image\n                                                <br />\n                                                Deprecated / scheduled for retirement on Sept. 4th, 2025</span>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowStabilityAIDiffusion3Large\" class=\"control-label\">Stability AI SD3 Large</label>\n                                        <div class=\"controls\">\n                                            <input id=\"allowStabilityAIDiffusion3Large\" type=\"checkbox\" ng-model=\"connection.params.allowStabilityAIDiffusion3Large\" />\n                                            <span class=\"help-inline\">Image generation cost: $0.08 per image\n                                                <br />\n                                                Deprecated / scheduled for retirement on Sept. 4th, 2025</span>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowStabilityAIUltra\" class=\"control-label\">Stability AI Stable Image Ultra</label>\n                                        <div class=\"controls\">\n                                            <input id=\"allowStabilityAIUltra\" type=\"checkbox\" ng-model=\"connection.params.allowStabilityAIUltra\" />\n                                            <span class=\"help-inline\">Image generation cost: $0.14 per image\n                                                <br />\n                                                Deprecated / scheduled for retirement on Sept. 4th, 2025</span>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"allowStabilityAIDiffusion10\" class=\"control-label\">Stability AI SDXL 1.0</label>\n                                        <div class=\"controls\">\n                                            <input id=\"allowStabilityAIDiffusion10\" type=\"checkbox\" ng-model=\"connection.params.allowStabilityAIDiffusion10\" />\n                                            <span class=\"help-inline\">Image generation cost: $0.04 to $0.08 per image</span>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Custom models</h2>\n\n                                <div add-remove ng-model=\"connection.params.customModels\">\n                                    <div ng-repeat=\"customModel in connection.params.customModels\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelId-' + $index}}\" class=\"control-label\">Model id</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelId-' + $index}}\" type=\"text\" required ng-model=\"customModel.id\"/>\n                                                <div class=\"help-inline\">\n                                                    Required. A model ID supported by Bedrock\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelName-' + $index}}\" class=\"control-label\">Model name</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelName-' + $index}}\" type=\"text\" ng-model=\"customModel.displayName\"/>\n                                                <div class=\"help-inline\">\n                                                    Used to identify this model in DSS. If empty defaults to the model id\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelType-' + $index}}\" class=\"control-label\">Model type</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'modelType-' + $index}}\" required ng-model=\"customModel.modelType\"\n                                                              bind-label=\"displayName\" bind-value=\"rawValue\" items=\"modelTypes\" ng-change=\"customModelTypeChanged(customModel)\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"customModel.modelType\">\n                                            <label for=\"{{'handlingMode-' + $index}}\" class=\"control-label\">Model handling mode</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'handlingMode-' + $index}}\" required ng-model=\"customModel.handlingMode\"\n                                                              bind-label=\"displayName\" bind-value=\"rawValue\" items=\"handlingModes[customModel.modelType]\"\n                                                              ng-change=\"customModelHandlingChanged(customModel)\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"customModel.modelType === TEXT_MODEL || customModel.modelType === MULTIMODAL_MODEL\">\n                                            <label for=\"{{'useConverseAPI-' + $index}}\" class=\"control-label\">Use Bedrock Converse API</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'useConverseAPI-' + $index}}\" type=\"checkbox\" ng-model=\"customModel.useConverseAPI\"\n                                                       ng-disabled=\"['GENERIC_CONVERSE', 'AMAZON_NOVA'].includes(customModel.handlingMode)\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"(customModel.modelType === TEXT_MODEL || customModel.modelType === MULTIMODAL_MODEL) && customModel.useConverseAPI\">\n                                            <label for=\"{{'systemPrompt-' + $index}}\" class=\"control-label\">Supports system prompt</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'systemPrompt-' + $index}}\" type=\"checkbox\" ng-model=\"customModel.supportsSystemPrompt\"/>\n                                            </div>\n                                        </div>\n\n                                        <div class=\"control-group\" ng-if=\"customModel.modelType === TEXT_MODEL || customModel.modelType === MULTIMODAL_MODEL\">\n                                            <label for=\"{{'promptCost-' + $index}}\" class=\"control-label\">Prompt cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'promptCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.promptCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"customModel.modelType === TEXT_MODEL || customModel.modelType === MULTIMODAL_MODEL\">\n                                            <label for=\"{{'completionCost-' + $index}}\" class=\"control-label\">Completion cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'completionCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.completionCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"['TEXT_EMBEDDING_EXTRACTION', 'TEXT_IMAGE_EMBEDDING_EXTRACTION'].includes(customModel.modelType)\">\n                                            <label for=\"{{'embeddingCost-' + $index}}\" class=\"control-label\">Embedding cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'embeddingCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.embeddingCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $/1k tokens\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"customModel.modelType === 'TEXT_IMAGE_EMBEDDING_EXTRACTION'\">\n                                            <label for=\"{{'imageEmbeddingCost-' + $index}}\" class=\"control-label\">Image embedding cost</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'imageEmbeddingCost-' + $index}}\" type=\"number\" min=\"0\" ng-model=\"customModel.imageEmbeddingCost\"/>\n                                                <span class=\"help-inline\">\n                                                    In $ per image\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"['TEXT_EMBEDDING_EXTRACTION', 'TEXT_IMAGE_EMBEDDING_EXTRACTION'].includes(customModel.modelType)\">\n                                            <label for=\"{{'maxTokensLimit-' + $index}}\" class=\"control-label\">Max tokens</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'maxTokensLimit-' + $index}}\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"customModel.maxTokensLimit\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\"ng-if=\"['TEXT_EMBEDDING_EXTRACTION', 'TEXT_IMAGE_EMBEDDING_EXTRACTION'].includes(customModel.modelType)\">\n                                            <label for=\"{{'embeddingSize-' + $index}}\" class=\"control-label\">Embedding size</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'embeddingSize-' + $index}}\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"customModel.embeddingSize\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\" ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, false)\">\n                                            <label for=\"{{'finetunable-' + $index}}\" class=\"control-label\">Can be fine-tuned</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'finetunable-' + $index}}\" type=\"checkbox\" ng-model=\"customModel.canBeFineTuned\"/>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\"\n                                            ng-click=\"add({modelType: TEXT_MODEL, useConverseAPI: true, supportsSystemPrompt: true})\">\n                                        <i plus-icon/> Add custom model\n                                    </button>\n                                </div>\n\n                                <h2 class=\"settings-section-title\" ng-if=\"showFineTuningSettings()\">Fine-tuning</h2>\n                                <div class=\"control-group\" ng-if=\"showFineTuningSettings()\">\n                                    <label for=\"allowFinetuning\" class=\"control-label\">Allow fine-tuning</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowFinetuning\" type=\"checkbox\" ng-model=\"connection.params.allowFinetuning\"/>\n                                        <span class=\"help-inline\">\n                                            Enable to allow models from this connection in the fine-tuning recipe.\n                                        </span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\" ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, true)\">\n                                    <label class=\"control-label\">S3 bucket name</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.fineTuningSettings.bucketName\" disabled-if=\"!!!connection.params.allowFinetuning\" />\n                                        <span class=\"help-inline\">Used for storing temporary files during the fine-tuning job. Auto-created if it doesn't exist.</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\" ng-if=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, true)\">\n                                    <label class=\"control-label\">IAM Role</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.fineTuningSettings.roleARN\" disabled-if=\"!!!connection.params.allowFinetuning\" />\n                                        <span class=\"help-inline\">An IAM Role ARN with rights to use Bedrock and read/write access to the S3 bucket set above. For help on how to set this role up, see the <a href=\"https://docs.aws.amazon.com/bedrock/latest/userguide/security-iam.html\" target=\"_blank\">AWS documentation</a>.</span>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Network &amp; Tuning</h2>\n\n                                <div class=\"control-group\">\n                                    <label for=\"network_parallelism\" class=\"control-label\">Network timeout</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" force-integer min=\"0\" ng-model=\"connection.params.networkSettings.queryTimeoutMS\" />\n                                        <span class=\"help-inline\">In milliseconds. 0 disables timeout</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"network_parallelism\" class=\"control-label\">Max retries</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" force-integer min=\"0\" ng-model=\"connection.params.networkSettings.maxRetries\" />\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n\n                                <div class=\"control-group\">\n                                    <h2 class=\"settings-section-title\">Custom properties</h2>\n                                    <label  class=\"control-label\">Advanced connection properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                        <span class=\"help-inline\">\n                                            For specific use cases\n                                        </span>\n                                    </div>\n                                </div>\n\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-image-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-bigquery.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'projectId',type:'string', mandatory:true, label:'Project ID', tooltip:'Mandatory'}\" />\n\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{\n                                    name:'pscEndpointId',\n                                    type:'string',\n                                    mandatory:false,\n                                    label:'PSC Endpoint ID',\n                                    tooltip:'Optional. To use a Private Service Connect Endpoint, provide its ID'\n                                }\"\n                            />\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Credentials</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"connection.params.authType\"\n                                    ng-options=\"x[0] as x[1] for x in [['KEYPAIR', 'Private key'], ['OAUTH', 'OAuth2'], ['ENVIRONMENT', 'Environment']]\"\n                                            options-descriptions=\"['Use Private key for authentication, either specified as a file path or as a JSON string', 'Use OAuth2 for authentication', 'Use Application Default Credentials (ADC) for authentication']\"/>\n                                </div>\n                            </div>\n                            <fieldset ng-if=\"connection.params.authType == 'KEYPAIR'\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{\n                                        name:'keyPath',\n                                        type:'string',\n                                        mandatory:true,\n                                        label:'Private key',\n                                        tooltip:'Mandatory. Must contains either the full path on the DSS server to the key file (.json or .p12) - Recommended, or the key as a JSON formatted string',\n                                        maskIf: 'function(value) { return value && (value.trim().startsWith(\\'{\\') || value.trim().startsWith(\\'e:AES:X\\')) }'\n                                    }\"\n                                />\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'serviceAccountEmail',type:'string', mandatory:false, label:'Service account e-mail', tooltip:'Mandatory if private key contains the path to a .p12 file. Ignored otherwise'}\" />\n                            </fieldset>\n                            <fieldset ng-if=\"connection.params.authType == 'OAUTH'\">\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'oauth2ClientId',type:'string', mandatory:true, label:'Client id', tooltip:'Mandatory'}\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'oauth2ClientSecret',type:'password', mandatory:true, label:'Client secret', tooltip:'Mandatory'}\" />\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Scope</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.oauth2Scope\">\n                                        <span class=\"help-inline\">\n                                            List of scopes separated by spaces. If not defined, using default scope `https://www.googleapis.com/auth/bigquery` (see <a target=\"_blank\" href=\"https://developers.google.com/identity/protocols/oauth2/scopes#bigquery\">Google OAuth2 documentation</a> for the list of scopes).\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'oauth2AuthorizationEndpoint',type:'string', mandatory:false, label:'OAuth2 authorization endpoint', tooltip:'If not using default Google OAuth2 authorization endpoint'}\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'oauth2tokenEndpoint',type:'string',  mandatory:false, label:'OAuth2 token endpoint', tooltip:'If not using default Google OAuth2 token endpoint'}\" />\n                                <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                    <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                            <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                        </label>\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Driver to use</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"connection.params.driverMode\"\n                                            ng-options=\"x[0] as x[1] for x in [['DRIVERLESS', 'Built-in'],['CUSTOM', 'User-provided']]\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 ng-if=\"connection.params.driverMode == 'CUSTOM'\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n\n                            <div ng-if=\"connection.params.driverMode == 'CUSTOM' && connection.useGlobalProxy\">\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">SSL TrustStore path</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.truststorePath\" />\n                                        <span class=\"help-inline\">The full path of the SSL trust store</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">SSL TrustStore secret</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.truststoreSecret\" />\n                                        <span class=\"help-inline\">The secret for the SSL trust store</span>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced {{connection.params.driverMode == 'CUSTOM' ? 'JDBC ' : ''}}properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Automatic fast-write</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useAutoFastPath\"/>\n                                        <span class=\"help-inline multiline\">Automatically uses a GCS connection and fast bulk load into BigQuery when using recipes writing data from the outside into BigQuery.</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Auto. fast-write connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnection\" />\n                                    <span class=\"help-inline\">Name of a GCS connection that will be used as staging area for fast bulk load.</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Path in connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnectionPath\" />\n                                    <span class=\"help-inline\">Path within the auto fast-write connection that will be used for temporary staging data.</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"forbidWritePartitions\" class=\"control-label\">Partitioning consistency</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" id=\"forbidWritePartitions\" ng-model=\"connection.params.forbidPartitionsWriteToNonPartitionedTable\"/>\n                                        <span class=\"help-inline multiline\">Forbids writing to a BigQuery table if a dataset is partitioned and there is a mismatch with the BigQuery table partitioning configuration. Can be overridden at the dataset level.</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.driverMode != 'CUSTOM'\">\n                                <label class=\"control-label\">Job labels</label>\n                                <div class=\"controls\">\n                                    <ng2-key-values-list\n                                        [(items)]=\"connection.params.jobLabels\"\n                                        (on-validity-change)=\"setJobLabelsValidity($event)\"\n                                        add-label=\"Add Label\"\n                                        key-placeholder=\"Label key\"\n                                        value-placeholder=\"Label value\"\n                                        key-required=\"true\"\n                                    ></ng2-key-values-list>\n                                    <span class=\"help-inline\">\n                                        Variable expansion is supported for both keys and values.\n                                        See <doclink page=\"connecting/sql/bigquery#advanced-setup-if-using-the-built-in-driver\" title=\"the documentation\"/> for more information.\n                                    </span>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n\n                            <div class=\"control-group\" ng-if=\"appConfig.featureFlags.includes('sqlConnectionPool') && connection.params.driverMode === 'CUSTOM'\">\n                                <label for=\"enableConnectionPool\" class=\"control-label\">Use connection pooling</label>\n                                <div class=\"controls\">\n                                    <input id=\"enableConnectionPool\" type=\"checkbox\" ng-model=\"connection.params.connectionPoolSettings.enabled\" />\n                                    <span class=\"help-inline\">(Experimental) Allow the reuse of JDBC connections</span>\n                                </div>\n                            </div>\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-cassandra.html", "<div ng-controller=\"CassandraConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n                        <fieldset>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Hosts</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.hosts\" required/>\n                                    <span class=\"help-inline\">\n                                        [Mandatory] Comma-separated list of cluster contact points.\n                                    </span>\n                                </div>\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostsUrl(connection.params.hosts)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Keyspace</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.keyspace\" required/>\n                                    <span class=\"help-inline\">\n                                        [Mandatory] Keyspace for this connection.\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Port</label>\n                                <div class=\"controls\">\n                                    <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"/>\n                                    <span class=\"help-inline\">\n                                        [Optional] Non-default CQL native transport port.\n                                    </span>\n                                </div>\n                            </div>\n                            <fieldset ng-show=\"connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">User</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.user\"/>\n                                        <span class=\"help-inline\">\n                                            [Optional] Authentication username.\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.password\"/>\n                                        <span class=\"help-inline\">\n                                            [Optional] Authentication password.\n                                        </span>\n                                    </div>\n                                </div>\n                            </fieldset>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Protocol version</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.protocolVersion\"/>\n                                    <span class=\"help-inline\">\n                                        [Optional] Force native protocol version (default: autodetect)).\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Read timeout (ms)</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.readTimeout\"/>\n                                    <span class=\"help-inline\">\n                                        [Optional] Non-default read time-out.\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Use SSL</label>\n                                <div class=\"controls\">\n                                    <input type=\"checkbox\" ng-model=\"connection.params.ssl\" />\n                                    <span class=\"help-inline\">\n                                        Use encrypted connections.\n                                    </span>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                            <div class=\"control-group\">\n                                <h2 class=\"settings-section-title\">Custom properties</h2>\n                                <label  class=\"control-label\">Advanced connection properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                    <span class=\"help-inline\">For specific use cases</span>\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        \n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection\n        </div>\n\n        <div ng-show=\"! connectionParamsForm.$invalid && testResult\">\n            <div ng-show=\"!testResult.connectionOK && !testResult.configOK\" class=\"alert alert-error\">\n                <i class=\"icon-dku-error\" />\n                Configuration problem: {{testResult.configErrorMsg}}\n            </div>\n            <div ng-show=\"!testResult.connectionOK && testResult.configOK\" class=\"alert alert-error\">\n                <i class=\"icon-dku-error\" />\n                Connection failed: {{testResult.connectionErrorMsg}}\n            </div>\n            <div ng-show=\"testResult.connectionOK\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK: {{testResult.clusterInfo}}\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-cohere.html", "<div ng-controller=\"CohereConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"api-key-input\" class=\"control-label\">Cohere API key</label>\n                                    <div class=\"controls\">\n                                        <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\" />\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">Usable models</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Cohere Command R</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.allowCohereCommandR\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.00015/1k tokens - Completion cost: $0.0006/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Cohere Command R+</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.allowCohereCommandRPlus\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0025/1k tokens - Completion cost: $0.01/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Cohere Command (standard model) (deprecated)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.allowCohereCommand\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.001/1k tokens - Completion cost: $0.002/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Cohere Command Light (faster) (deprecated)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.allowCohereCommandLight\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0003/1k tokens - Completion cost: $0.0006/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-custom-llm.html", "<div ng-controller=\"CustomLLMConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Plugin</h2>\n\n                                <div class=\"control-group\">\n                                    <label for=\"plugin\" class=\"control-label\">Plugin</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select id=\"plugin\" ng-model=\"selectedPlugin\" ng-options=\"x as x.label for x in customLLMPlugins\" />\n                                    </div>\n                                </div>\n\n                                <div ng-if=\"customLLMPlugins.length === 0\" class=\"alert alert-warning\">\n                                    You need to install at least one compatible plugin that exposes custom LLMs.\n                                </div>\n\n                                <h2 class=\"settings-section-title\" ng-if=\"selectedPlugin\">Models</h2>\n\n                                <div add-remove ng-model=\"connection.params.models\" ng-if=\"selectedPlugin\">\n                                    <div ng-repeat=\"model in connection.params.models\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'id-' + $index}}\" class=\"control-label\">Id</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'id-' + $index}}\" type=\"text\" ng-model=\"model.id\" ng-pattern=\"/^[A-Za-z0-9_\\-]+$/\" required/>\n                                                <span class=\"help-inline\">\n                                                    Used to identify this model in DSS\n                                                </span>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'capability-' + $index}}\" class=\"control-label\">Capability</label>\n                                            <div class=\"controls\">\n                                                <select dku-bs-select id=\"{{'capability-' + $index}}\" ng-model=\"model.capability\" ng-options=\"x[0] as x[1] for x in capabilities\" />\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'type-' + $index}}\" class=\"control-label\">Type</label>\n                                            <div class=\"controls\">\n                                                <select dku-bs-select id=\"{{'type-' + $index}}\" ng-model=\"model.type\" ng-options=\"x.llmType as x.desc.meta.label for x in llmOptions\" ng-change=\"onModelTypeChanged(model)\" />\n                                            </div>\n                                        </div>\n                                        <div ng-if=\"selectedPlugin.type == 'python'\">\n                                            <div class=\"mbot8 cursor-pointer\" ng-click=\"showAdvanced = !showAdvanced\">\n                                                <i ng-if=\"showAdvanced\" class=\"dku-icon-caret-down-12 ng-scope\"></i>\n                                                <i ng-if=\"!showAdvanced\" class=\"dku-icon-caret-right-12 ng-scope\"></i>\n                                                <span>Advanced configuration</span>\n                                            </div>\n                                            <div ng-if=\"showAdvanced\">\n                                                <div class=\"control-group\">\n                                                    <label for=\"{{'max-parallelism-' + $index}}\" class=\"control-label\">Max. parallelism</label>\n                                                    <div class=\"controls\">\n                                                        <input id=\"{{'max-parallelism-' + $index}}\" type=\"number\" force-integer min=\"1\" max=\"128\" ng-model=\"model.maxParallelism\" />\n                                                        <!-- <span class=\"help-inline\">\n                                                            Number of retries allowed before cancelling the request.\n                                                        </span> -->\n                                                    </div>\n                                                </div>\n                                                <div class=\"control-group\">\n                                                    <label for=\"{{'custom-rate-limiting-' + $index}}\" class=\"control-label\">Custom retry settings</label>\n                                                    <div class=\"controls\">\n                                                        <label>\n                                                            <input id=\"{{'custom-rate-limiting-' + $index}}\" type=\"checkbox\" ng-model=\"model.customRateLimitingEnabled\" />\n                                                            <span class=\"help-inline\">Used when the plugin tells DSS to retry the queries later. If unchecked, it will use default values.</span>\n                                                        </label>\n                                                    </div>\n                                                </div>\n                                                <div class=\"control-group\" ng-if=\"model.customRateLimitingEnabled\">\n                                                    <label for=\"{{'custom-rate-limiting-max-retries-' + $index}}\" class=\"control-label\">Max. retries</label>\n                                                    <div class=\"controls\">\n                                                        <input id=\"{{'custom-rate-limiting-max-retries-' + $index}}\" type=\"number\" ng-model=\"model.retrySettings.maxRetries\" force-integer min=\"0\" required/>\n                                                        <span class=\"help-inline\">\n                                                            Number of retries allowed before cancelling the request.\n                                                        </span>\n                                                    </div>\n                                                </div>\n                                                <div class=\"control-group\" ng-if=\"model.customRateLimitingEnabled\">\n                                                    <label for=\"{{'custom-rate-limiting-first-retry-delay-' + $index}}\" class=\"control-label\">First retry delay</label>\n                                                    <div class=\"controls\">\n                                                        <input id=\"{{'custom-rate-limiting-first-retry-delay-' + $index}}\" type=\"number\" ng-model=\"model.retrySettings.initialRetryDelayMS\" force-integer min=\"1000\" required/>\n                                                        <span class=\"help-inline\">\n                                                            In milliseconds. Time between the first failing but retryable request, and the next request.\n                                                        </span>\n                                                    </div>\n                                                </div>\n                                                <div class=\"control-group\" ng-if=\"model.customRateLimitingEnabled\">\n                                                    <label for=\"{{'custom-rate-limiting-retry-delay-scale-' + $index}}\" class=\"control-label\">Retry delay scale</label>\n                                                    <div class=\"controls\">\n                                                        <input id=\"{{'custom-rate-limiting-retry-delay-scale-' + $index}}\" type=\"number\" ng-model=\"model.retrySettings.retryDelayScalingFactor\" force-integer min=\"1\" step=\"0.2\" required/>\n                                                        <span class=\"help-inline\">\n                                                            Multiplier of time between retries.\n                                                        </span>\n                                                    </div>\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <hr ng-if=\"model.$desc.params.length > 0\"/>\n                                        <div class=\"control-group\">\n                                            <div custom-params-form\n                                                 desc=\"model.$desc\"\n                                                 plugin-desc=\"pluginDesc\"\n                                                 component-id=\"model.$desc.id\"\n                                                 config=\"model.customConfig\" />\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\" ng-click=\"addModel()\">\n                                        <i class=\"dku-icon-plus-12\"/> Add model\n                                    </button>\n                                </div>\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-databricks-lakebase.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n                            <div ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Port</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"/>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'db', type:'string', mandatory:true, label:'Database'}\" />\n                            </div>\n                            <div ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                        ng-required=\"true\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                        ng-required=\"false\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div ng-if=\"connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'user', type:'string', mandatory:connection.params.useURL != true, label:'User'}\" />\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n\n                            <div class=\"control-group\" ng-if=\"!connection.params.driver\">\n                                <label for=\"\" class=\"control-label\">Driver to use</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"connection.params.driverMode\"\n                                            ng-options=\"x[0] as x[1] for x in [['MANAGED', 'Dataiku-managed'], ['CUSTOM', 'User-provided']]\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 ng-if=\"connection.params.driverMode == 'CUSTOM' || connection.params.driver\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n\n                            <div class=\"control-group\">\n                                <label for=\"sendDriverJarsToSpark\" class=\"control-label\">Send driver jars to Spark</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input id=\"sendDriverJarsToSpark\" type=\"checkbox\" ng-model=\"connection.params.sendDriverJarsToSpark\">\n                                        <span class=\"help-inline\" ng-if=\"connection.params.jarsDirectory\">\n                                            Experimental: Add driver jars to spark-submit subprocesses\n                                        </span>\n                                        <span class=\"help-inline\" ng-if=\"!connection.params.jarsDirectory\">\n                                            Experimental: Add all jars of [DSS home]/lib/jdbc to spark-submit subprocesses. Use a Jars directory to pass only this connections's driver.\n                                        </span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-databricks-llm.html", "<div ng-controller=\"DatabricksLlmConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Databricks Model Depl.</label>\n                                    <div class=\"controls\">\n                                        <basic-select items=\"databricksModelDeplConnections\" placeholder=\"Select a connection\"\n                                                      ng-model=\"connection.params.modelDeploymentConnection\">\n                                        </basic-select>\n                                        <span class=\"help-inline\">Select a Databricks Model Deployment connection</span>\n                                    </div>\n                                </div>\n\n                                <div ng-if=\"databricksModelDeplConnections.length === 0\" class=\"alert alert-warning\">\n                                    You need to create a Databricks Model Deployment connection.\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Chat models</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"allowClaude3_7_Sonnet\" class=\"control-label\">Claude 3.7 Sonnet</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowClaude3_7_Sonnet\" type=\"checkbox\" ng-model=\"connection.params.allowClaude3_7_Sonnet\" />\n                                        </label>\n                                    </div>\n                                </div>    \n                                <div class=\"control-group\">\n                                    <label for=\"allowLlama4_Maverick\" class=\"control-label\">Llama 4 Maverick</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowLlama4_Maverick\" type=\"checkbox\" ng-model=\"connection.params.allowLlama4_Maverick\" />\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowLlama3_3_70BChat\" class=\"control-label\">Llama 3.3 70B Chat</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowLlama3_3_70BChat\" type=\"checkbox\" ng-model=\"connection.params.allowLlama3_3_70BChat\" />\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowLlama3_1_405BChat\" class=\"control-label\">Llama 3.1 405B Chat</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowLlama3_1_405BChat\" type=\"checkbox\" ng-model=\"connection.params.allowLlama3_1_405BChat\" />\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Embedding models</h2>\n\n                                <div class=\"control-group\">\n                                    <label for=\"allowBGELargeEn\" class=\"control-label\">BGE Large (En)</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowBGELargeEn\" type=\"checkbox\" ng-model=\"connection.params.allowBGELargeEn\" />\n                                        </label>\n                                    </div>\n                                </div>\n\n\n                                <h2 class=\"settings-section-title\">Custom models</h2>\n                                <span class=\"help-inline\">Custom Models need to be available through Databricks Pay-per-token Foundation Model APIs. See available models in the\n                                    <a href=\"https://docs.databricks.com/aws/en/machine-learning/model-serving/foundation-model-overview#per-token\" title=\"Databricks model list\" target=\"_blank\">Databricks documentation <i class=\"icon-external-link\"></i></a>\n                                </span>\n                                <div add-remove ng-model=\"connection.params.customModels\">\n                                    <div ng-repeat=\"customModel in connection.params.customModels\" class=\"repeatable-config-block\">\n                                        <button type=\"button\" class=\"pull-right btn btn--text btn--danger btn--icon btn--dku-icon m8\" ng-click=\"remove($index)\">\n                                            <i class=\"dku-icon-trash-16\"></i>\n                                        </button>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelId-' + $index}}\" class=\"control-label\">Model id</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelId-' + $index}}\" type=\"text\" required ng-model=\"customModel.id\"/>\n                                                <div class=\"help-inline\">\n                                                   Required. A model ID supported by Databricks.\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelName-' + $index}}\" class=\"control-label\">Model display name</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'modelName-' + $index}}\" type=\"text\" ng-model=\"customModel.displayName\"/>\n                                                <div class=\"help-inline\">\n                                                    Used to identify this model in DSS. If empty defaults to the model id.\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\">\n                                            <label for=\"{{'modelType-' + $index}}\" class=\"control-label\">Model type</label>\n                                            <div class=\"controls\">\n                                                <basic-select id=\"{{'modelType-' + $index}}\" required ng-model=\"customModel.modelType\"\n                                                              bind-label=\"displayName\" bind-value=\"rawValue\" items=\"modelTypes\"/>\n                                            </div>\n                                        </div>\n   \n                                        <div class=\"control-group\" ng-if=\"customModel.modelType === 'TEXT_EMBEDDING'\">\n                                            <label for=\"{{'maxTokensLimit-' + $index}}\" class=\"control-label\">Max tokens</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'maxTokensLimit-' + $index}}\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"customModel.maxTokensLimit\"/>\n                                            </div>\n                                        </div>\n                                        <div class=\"control-group\"ng-if=\"customModel.modelType === 'TEXT_EMBEDDING'\">\n                                            <label for=\"{{'embeddingSize-' + $index}}\" class=\"control-label\">Embedding size</label>\n                                            <div class=\"controls\">\n                                                <input id=\"{{'embeddingSize-' + $index}}\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"customModel.embeddingSize\"/>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <button type=\"button\" class=\"btn btn--primary btn--text mtop8\"\n                                            ng-click=\"add({modelType: 'CHAT'})\">\n                                        <i plus-icon/> Add custom model\n                                    </button>\n                                </div>\n\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-databricks.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n\n                            <fieldset ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\"\n                                     form-template-element model=\"connection.params\"\n                                     field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Port</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"\n                                        placeholder=\"Leave empty to use default port\"/>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'httpPath', type:'string', mandatory:true, label:'HTTP path'}\" />\n                            </fieldset>\n                            <fieldset ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                               ng-required=\"true\"\n                                               placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                               ng-required=\"false\"\n                                               placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Driver class</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.driver\"\n                                        ng-required=\"false\" placeholder=\"Leave empty to use default driver class\" />\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Auth type</label>\n                                <div class=\"controls\">\n                                    <select ng-init=\"connection.params.authType=connection.params.authType || 'PERSONAL_ACCESS_TOKEN'\" ng-model=\"connection.params.authType\" dku-bs-select>\n                                        <option value=\"PERSONAL_ACCESS_TOKEN\">Personal access token</option>\n                                        <option value=\"OAUTH2_APP\">OAuth2</option>\n                                    </select>\n                                </div>\n                            </div>\n\n                            <fieldset ng-if=\"connection.params.authType == 'PERSONAL_ACCESS_TOKEN'\">\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Personal access token</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"off\" />\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <fieldset ng-if=\"connection.params.authType == 'OAUTH2_APP'\">\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'clientId',type:'string', mandatory:true, label:'Client id'}\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'clientSecret',type:'password', mandatory:false, label:'Client secret'}\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     ng-if=\"connection.credentialsMode === 'PER_USER'\"\n                                     field=\"{name:'authorizationEndpoint',type:'string', mandatory:true, label:'OAuth2 authorization endpoint' }\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'tokenEndpoint',type:'string', mandatory:true, label:'OAuth2 token endpoint' }\" />\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'scope',type:'string', mandatory:false, label:'Scope', tooltip:'Leave blank for default value'}\" />\n                                <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                    <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                            <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                        </label>\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Default catalog</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input ng-if=\"availableCatalogs == null\" type=\"text\" ng-model=\"connection.params.defaultCatalog\"/>\n                                        <input ng-if=\"availableCatalogs != null\" type=\"text\"\n                                            bs-typeahead=\"availableCatalogs\"\n                                            ng-model=\"connection.params.defaultCatalog\"\n                                            type='text'\n                                            autocomplete=\"off\"\n                                            data-min-length=\"0\"\n                                            id=\"catalog_input\"\n                                        />\n                                        <button ng-if=\"availableCatalogs == null\"\n                                            class=\"btn btn--text btn--icon btn--secondary btn--dku-icon\"\n                                            ng-click=\"fetchCatalogs(connection.name, 'connection-settings', connection.type, 'catalog_input')\"\n                                            ng-disabled=\"refreshCatalogOngoing || creation || connectionDirty()\"\n                                            toggle=\"tooltip\"\n                                            title=\"{{creation ? 'Cannot refresh catalogs in creation mode' :\n                                                connectionDirty() ? 'Save pending changes before being able to refresh' :\n                                                listSqlCatalogsTooltip}}\"\n                                        >\n                                            <i class=\"dku-icon-arrow-circular-16\" ng-class=\"{'icon-spin': refreshCatalogOngoing}\"></i>\n                                        </button>\n                                        <span class=\"help-inline\">Default catalog. Unqualified table lookups will be resolved in this catalog. If not specified, defaults to the default catalog (which may be \"hive_metastore\"). If default catalog is specified, default schema must be specified too.</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Default schema</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input ng-if=\"!!availableSchemasMap[connection.params.defaultCatalog || '']\"\n                                            bs-typeahead=\"availableSchemasMap[connection.params.defaultCatalog || '']\"\n                                            class='exclude-from-smart-change'\n                                            ng-model='connection.params.defaultSchema'\n                                            type='text'\n                                            autocomplete=\"off\"\n                                            data-min-length=\"0\"\n                                            id=\"schema_input\"\n                                        />\n                                        <input ng-if=\"!availableSchemasMap[connection.params.defaultCatalog || '']\" type=\"text\" ng-model=\"connection.params.defaultSchema\"/>\n                                        <button ng-if=\"!availableSchemasMap[connection.params.defaultCatalog || '']\"\n                                            class=\"btn btn--text btn--icon btn--secondary btn--dku-icon\"\n                                            ng-click=\"fetchSchemas(connection.name, connection.params.defaultCatalog || '', 'connection-settings', connection.type, 'schema_input')\"\n                                            ng-disabled=\"refreshSchemaOngoing || creation || connectionDirty()\"\n                                            toggle=\"tooltip\"\n                                            title=\"{{creation ? 'Cannot refresh schemas in creation mode' :\n                                                connectionDirty() ? 'Save pending changes before being able to refresh' :\n                                                listSqlSchemasTooltip}}\"\n                                        >\n                                            <i class=\"dku-icon-arrow-circular-16\" ng-class=\"{'icon-spin': refreshSchemaOngoing}\"></i>\n                                        </button>\n                                        <span class=\"help-inline\">Default schema. Unqualified table lookups will be resolved in this schema. If not specified, defaults to 'default'</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n                            \n                            <div class=\"control-group\" ng-if=\"!connection.params.driver\">\n                                <label for=\"\" class=\"control-label\">Driver to use</label>\n                                <div class=\"controls\">\n                                     <select dku-bs-select ng-model=\"connection.params.driverMode\" \n                                            ng-options=\"x[0] as x[1] for x in [['MANAGED', 'Dataiku-managed'], ['CUSTOM', 'User-provided']]\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                ng-if=\"connection.params.driverMode == 'CUSTOM' || connection.params.driver\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n\n                            <div class=\"control-group\" ng-if=\"connection.allowWrite\">\n                                <label for=\"\" class=\"control-label\">Allow managed folders</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.allowManagedFolders\"/>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.allowWrite && connection.allowManagedFolders\">\n                                <label class=\"control-label\">Volume for managed folders</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.chvolume\" ng-required=\"false\" placeholder=\"Name of a Databricks volume\" />\n                                    <span class=\"help-inline\">Databricks Volume to use for managed folders in the flow, and for fast-load. Default catalog and default schema must be set.</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.allowWrite && connection.allowManagedFolders && connection.params.chvolume\">\n                                <label class=\"control-label\">Managed data subpath</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.defaultManagedPath\" ng-required=\"false\" placeholder=\"Name of a Databricks volume\" />\n                                    <span class=\"help-inline\">Managed folders will be created by default in this subpath of the root path in volume. May contain variables.</span>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Storage credentials</label>\n                                <div class=\"controls\">\n                                    <ng2-key-values-list\n                                            [(items)]=\"connection.params.storageCredentials\"\n                                            key-placeholder=\"Bucket or storage account\"\n                                            value-placeholder=\"Credential name\"\n                                            add-label=\"Add credentials\">\n                                    </ng2-key-values-list>\n                                    <span class=\"help-inline\">Credential name for load/unload to a cloud storage. Leave credential empty to use passthrough. Wildcards allowed for bucket/storage account.</span>\n                                </div>\n                            </div>\n\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Fetch size</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                    <span class=\"help-inline\">Empty = default</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Automatic fast-write</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useAutoFastPath\"/>\n                                        <span class=\"help-inline\">Automatically uses a cloud connection and fast bulk load into Databricks when using recipes writing data from the outside into Databricks.</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Automatic fast-write connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnection\" ng-required=\"true\"/>\n                                    <span class=\"help-inline\">Name of a cloud connection (S3 or Azure Blob Storage) that will be used as staging area for fast bulk load. Also accepts Databricks connections with a volume for managed folders.</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Path in connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnectionPath\" />\n                                    <span class=\"help-inline\">Path within the auto fast-write connection that will be used for temporary staging data.</span>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div  class=\"vertical-flex w100 oh\">\n                <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection</div>\n                <div ng-show=\"testResult\" class=\"vertical-flex-container w100 oh\">\n                    <div ng-show=\"!testResult.connectionOK\" class=\"alert alert-error vertical-flex w100\" style=\"min-height: 100px;\"><span summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  /></div>\n                    <div ng-show=\"testResult.connectionOK\">\n                        <div ng-show=\"!testResult.connectionWarningMsg\" class=\"alert alert-success\">\n                            <i class=\"icon-success\" />Connection OK<span ng-show=\"testResult.postGISversion\">, PostGIS version: {{testResult.postGISversion}}</span>\n                        </div>\n                        <div ng-show=\"testResult.connectionWarningMsg\" class=\"alert alert-warning\">Connection OK, <strong>but</strong> {{testResult.connectionWarningMsg}}.</div>\n                        <div ng-show=\"testResult.testPayload\">Test details: {{testResult.testPayload|json}}</div>\n                    </div>\n                </div>\n            </div>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-databricksmodeldeployment.html", "<div ng-controller=\"DatabricksModelDeploymentConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div block-api-error />\n\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span7\">\n                                <h2 class=\"settings-section-title\">Basic params</h2>\n\n                                <fieldset>\n                                    <div class=\"control-group\"\n                                         form-template-element model=\"connection.params\"\n                                         field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                    <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                        Host should not contain a http(s):// prefix.\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Port</label>\n                                        <div class=\"controls\">\n                                            <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"\n                                            placeholder=\"Leave empty to use default port\"/>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params\"\n                                         field=\"{name:'httpPath', type:'string', mandatory:false, label:'HTTP path', tooltip:'Use if databricks is available in a subpath'}\" />\n                                </fieldset>\n\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Auth type</label>\n                                    <div class=\"controls\">\n                                        <select ng-init=\"connection.params.authType=connection.params.authType || 'PERSONAL_ACCESS_TOKEN'\" ng-model=\"connection.params.authType\" dku-bs-select>\n                                            <option value=\"PERSONAL_ACCESS_TOKEN\">Personal access token</option>\n                                            <option value=\"OAUTH2_APP\">OAuth2 on Azure</option>\n                                        </select>\n                                    </div>\n                                </div>\n\n                                <fieldset ng-if=\"connection.params.authType === 'PERSONAL_ACCESS_TOKEN'\">\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params\"\n                                         field=\"{name:'personalAccessToken', type:'password', mandatory:true, label:'Personal access token'}\" />\n                                </fieldset>\n\n                                <fieldset ng-if=\"connection.params.authType === 'OAUTH2_APP'\">\n                                    <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'oauth2ClientId',type:'string', mandatory:true, label:'Client id'}\" />\n                                    <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'oauth2ClientSecret',type:'password', mandatory:false, label:'Client secret'}\" />\n                                        <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'azureTenantId',type:'string', mandatory:false, label:'Azure Tenant id'}\" />\n                                    <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'oauth2AuthorizationEndpoint',type:'string', mandatory:false, label:'OAuth2 authorization endpoint', tooltip:'Non mandatory if Tenant id is provided'}\" />\n                                    <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'oauth2tokenEndpoint',type:'string', mandatory:false, label:'OAuth2 token endpoint', tooltip:'Non mandatory if Tenant id is provided'}\" />\n                                    <div class=\"control-group\"\n                                        form-template-element\n                                        model=\"connection.params\"\n                                        field=\"{name:'oauth2Scope',type:'string', mandatory:false, label:'Scope', tooltip:'Leave blank for default value'}\" />\n                                </fieldset>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div class=\"control-group\">\n                                    <h2 class=\"settings-section-title\">Custom properties</h2>\n                                    <label  class=\"control-label\">Advanced connection properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                        <span class=\"help-inline\">\n                                            For specific use cases\n                                        </span>\n                                    </div>\n                                </div>\n                                <div\n                                    ng-if=\"connection.params.authType === 'OAUTH2_APP'\"\n                                    include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\"\n                                ></div>\n                            </div>\n                            <div class=\"span5\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <!-- style=\"border-top: 1px #ccc solid\"-->\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />&nbsp;Please wait, testing connection\n        </div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.connectionOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK && testResult.connectionWarning\" class=\"alert alert-warning\">\n                Connection OK, <strong>but</strong> {{testResult.connectionErrorMsg}}.\n            </div>\n            <div ng-show=\"testResult.connectionOK && !testResult.connectionWarning\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-databricksvolume.html", "<div ng-controller=\"DatabricksVolumeConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\"\n                             form-template-element model=\"connection.params\"\n                             field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element model=\"connection.params\"\n                             field=\"{name:'catalog',type:'string', mandatory:true, label:'Catalog'}\" />\n                        <div class=\"control-group\"\n                             form-template-element model=\"connection.params\"\n                             field=\"{name:'schema',type:'string', mandatory:true, label:'Schema'}\" />\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Auth type</label>\n                            <div class=\"controls\">\n                                <select ng-init=\"connection.params.authType=connection.params.authType || 'PERSONAL_ACCESS_TOKEN'\" ng-model=\"connection.params.authType\" dku-bs-select>\n                                    <option value=\"PERSONAL_ACCESS_TOKEN\">Personal access token</option>\n                                    <option value=\"OAUTH2_APP\">OAuth</option>\n                                </select>\n                            </div>\n                        </div>\n\n                        <fieldset ng-if=\"connection.params.authType == 'PERSONAL_ACCESS_TOKEN'\">\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Personal access token</label>\n                                <div class=\"controls\">\n                                    <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"off\" />\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <fieldset ng-if=\"connection.params.authType == 'OAUTH2_APP'\">\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'clientId',type:'string', mandatory:true, label:'Client id'}\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'tenantId',type:'string', mandatory:true, label:'Tenant id'}\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'clientSecret',type:'password', mandatory:false, label:'Client secret'}\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'authorizationEndpoint',type:'string', mandatory:true, label:'OAuth authorization endpoint' }\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'tokenEndpoint',type:'string', mandatory:true, label:'OAuth token endpoint' }\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'scope',type:'string', mandatory:false, label:'Scope', tooltip:'Leave blank for default value'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                        <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                    </label>\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <h2 class=\"settings-section-title\">Path restrictions</h2>\n\n                        <div class=\"control-group\" form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'chvolume', type:'string', label:'Volume', tooltip:'Optional. Limit accesses on this connection to the contents of this volume. If empty, users will be able to select volume (among volules allowed by these credentials)'}\" />\n                        <div class=\"control-group\" form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'chroot', type:'string', label:'Path in bucket', tooltip:'Optional. Limit accesses on this connection to the contents of this folder. If empty, users will be able to use the whole volume (or volumes)'}\" />\n\n                        <fieldset ng-disabled=\"!connection.allowManagedDatasets && !connection.allowManagedFolders\">\n                            <h2 class=\"settings-section-title\">Managed datasets &amp; folders</h2>\n                            <div class=\"control-group\" ng-if=\"!connection.params.chvolume\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'defaultManagedVolume',type:'string',\n                            label:'Default volume',\n                            tooltip:'Managed datasets will be created by default in this volume. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"!connection.params.chvolume\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Default path',\n                            tooltip:'Managed datasets will be created by default in this path. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.params.chvolume\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Managed data subpath',\n                            tooltip:'Managed datasets and folders will be created by default in this subpath of the root path in volume. May contain variables.'}\" />\n                        </fieldset>\n\n                        <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n\n                        <h2 class=\"settings-section-title\">Advanced</h2>\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                    </form>\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\" include-no-scope=\"/templates/admin/fragments/connection-name-test-save-with-results.html\" />\n</div>");
$templateCache.put("/templates/admin/connection-denodo.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n                            <div ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain an http(s):// prefix.\n                                </div>\n\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'db', type:'string', mandatory:true, label:'Database', tooltip:'Mandatory'}\"\n                                />\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Port</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"/>\n                                    </div>\n                                </div>\n                            </div>\n                            <div ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                        ng-required=\"true\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                        ng-required=\"false\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Auth type</label>\n                                <div class=\"controls\">\n                                    <select ng-model=\"connection.params.authType\" dku-bs-select>\n                                        <option value=\"PASSWORD\">User/Password</option>\n                                        <option value=\"OAUTH2\">OAuth2</option>\n                                    </select>\n                                </div>\n                            </div>\n\n                            <div ng-if=\"connection.params.authType == 'PASSWORD' && connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'user', type:'string', mandatory:connection.params.useURL != true, label:'User'}\" />\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div ng-if=\"connection.params.authType == 'OAUTH2'\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'appId',type:'string', mandatory:true, label:'Client id'}\" />\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'appSecret',type:'password', mandatory:false, label:'Client secret'}\" />\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'scope',type:'string', mandatory:false, label:'Scope'}\" />\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'authorizationEndpoint',type:'string', false, label:'OAuth2 Authorization endpoint'}\" />\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                     field=\"{name:'tokenEndpoint',type:'string', false, label:'OAuth2 Token endpoint'}\" />\n                                <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                    <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                            <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                        </label>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.'}\" />\n                            <div class=\"control-group\">\n                                <label for=\"sendDriverJarsToSpark\" class=\"control-label\">Send driver jars to Spark</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input id=\"sendDriverJarsToSpark\" type=\"checkbox\" ng-model=\"connection.params.sendDriverJarsToSpark\">\n                                        <span class=\"help-inline\" ng-if=\"connection.params.jarsDirectory\">\n                                            Experimental: Add driver jars to spark-submit subprocesses\n                                        </span>\n                                        <span class=\"help-inline\" ng-if=\"!connection.params.jarsDirectory\">\n                                            Experimental: Add all jars of [DSS home]/lib/jdbc to spark-submit subprocesses. Use a Jars directory to pass only this connections's driver.\n                                        </span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Fetch size</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                    <span class=\"help-inline\">Empty = default</span>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-dynamodb.html", "<div ng-controller=\"DynamoDBConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\" on-smart-change=\"testConnection()\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">\n                                Mode\n                            </label>\n                            <div class=\"controls\">\n                                <label class=\"radio inline\">\n                                    <input type=\"radio\" name=\"modeRadio\" ng-model=\"connection.params.mode\" value=\"WEBSERVICE\">\n                                    Use Web Service\n                                </label>\n                                <label class=\"radio inline\">\n                                    <input type=\"radio\" name=\"modeRadio\" ng-model=\"connection.params.mode\" value=\"LOCAL\"> Use Local Instance\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"useDefaultCredentials\" class=\"control-label\">Use default credentials</label>\n                            <div class=\"controls\">\n                                <input id=\"useDefaultCredentials\" type=\"checkbox\" ng-model=\"connection.params.useDefaultCredentials\" />\n                                <span class=\"help-inline\">Use credentials from environment, configuration files or instance profile.</span>\n                            </div>\n                        </div>\n                        <fieldset ng-if=\"!connection.params.useDefaultCredentials\">\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'accessKey',type:'string', mandatory:!connection.params.useDefaultCredentials, label:'Access key'}\" />\n\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'secretKey',type:'password', mandatory:!connection.params.useDefaultCredentials, label:'Secret key'}\" />\n                        </fieldset>\n                        <div dku-if=\"connection.params.mode == 'WEBSERVICE'\">\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'regionOrEndpoint', type:'string', mandatory:true, label:'Region / Endpoint',\n                                tooltip:'AWS region (e.g. eu-west-1) or custom endpoint (e.g. http[s]://my.dynamodb.endpoint/)'}\" />\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">\n                                    Read/Write Capacity Mode\n                                </label>\n                                <div class=\"controls\">\n                                    <label class=\"radio inline\">\n                                        <input type=\"radio\" name=\"rwCapacityModeRadio\" ng-model=\"connection.params.rwCapacityMode\" value=\"ON_DEMAND\">\n                                        On-Demand Mode\n                                    </label>\n                                    <label class=\"radio inline\">\n                                        <input type=\"radio\" name=\"rwCapacityModeRadio\" ng-model=\"connection.params.rwCapacityMode\" value=\"PROVISIONED\"> Provisioned Mode\n                                    </label>\n                                </div>\n                            </div>\n                            <div dku-if=\"connection.params.rwCapacityMode == 'PROVISIONED'\">\n                                <fieldset>\n                                    <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                         field=\"{name:'readCapacity', type:'long', mandatory:true, label:'Read Capacity Units'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                         field=\"{name:'writeCapacity', type:'long', mandatory:true, label:'Write Capacity Units'}\" />\n                                </fieldset>\n                            </div>\n                        </div>\n                        <div dku-if=\"connection.params.mode == 'LOCAL'\">\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'hostname', type:'string', mandatory:true, label:'HostName'}\" />\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'port', type:'int', mandatory:true, label:'Port'}\" />\n                        </div>\n                        <div class=\"control-group\">\n                            <h2 class=\"settings-section-title\">Custom properties</h2>\n                            <label  class=\"control-label\">Advanced connection properties</label>\n                            <div class=\"controls\">\n                                <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                <span class=\"help-inline\">For specific use cases</span>\n                            </div>\n                        </div>\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection\n        </div>\n\n        <div ng-show=\"!connectionParamsForm.$invalid && testResult\">\n            <div ng-show=\"!testResult.connectionOK && !testResult.configOK\" class=\"alert alert-error\"> \n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed, configuration problem: {{testResult.configErrorMsg}}</span>\n            </div>\n\n            <div ng-show=\"!testResult.connectionOK && testResult.configOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-ec2.html", "<div ng-controller=\"EC2ConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Credentials</label>\n                            <div class=\"controls\">\n                                <select dku-bs-select ng-model=\"connection.params.credentialsMode\" \n                                ng-options=\"x[0] as x[1] for x in [['KEYPAIR', 'AWS keypair'], ['ENVIRONMENT', 'Environment'], ['STS_ASSUME_ROLE', 'STS with AssumeRole'], ['CUSTOM_PROVIDER', 'Custom']]\" \n                                options-descriptions=\"['AccessId + SecretId', 'Use credentials from environment variables, or ~/.aws/credentials file, or instance profile', 'Assume a role, with master credentials coming from the environment', 'Custom provider class']\"/>\n                            </div>\n                        </div>\n                        <fieldset ng-if=\"connection.params.credentialsMode == 'KEYPAIR' && connection.credentialsMode != 'PER_USER'\">\n                            <div class=\"control-group\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'accessKey',type:'string', label:'Access key'}\" />\n\n                            <div class=\"control-group\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'secretKey',type:'password', label:'Secret key'}\" />\n                        </fieldset>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.credentialsMode == 'STS_ASSUME_ROLE'\">\n                            <label class=\"control-label\">STS role to assume</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.stsRoleToAssume\" />\n                                <span class=\"help-inline\">\n                                     Variable expansion, notably per-user properties are supported here.\n                                 </span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"appConfig.deploymentMode == 'CLOUD' && appConfig.dataikuCloudUISettings && connection.params.credentialsMode == 'STS_ASSUME_ROLE'\">\n                            <div class=\"alert alert-info\">\n                                This role needs to have adequate permissions so that the following role can assume it:<br />\n                                <pre>{{appConfig.dataikuCloudUISettings.spaceRoleARN}}</pre>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.credentialsMode == 'STS_ASSUME_ROLE'\">\n                            <label class=\"control-label\">STS endpoint</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.stsEndpoint\" />\n                                <span class=\"help-inline\">\n                                     AWS region or custom endpoint URL. Leave empty to use the global endpoint.\n                                 </span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"connection.params.credentialsMode == 'STS_ASSUME_ROLE'\">\n                            <label class=\"control-label\">STS token duration</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.stsAssumeDurationSeconds\" />\n                                <span class=\"help-inline\">\n                                    Optional. Validity of the STS token, in seconds. Leave empty for default (1 hour). \n                                    Value must be an integer between 900 and the maximum session duration setting for the role (which can go up to 12 hours / 43200 seconds). Variable expansion, notably per-user properties are supported here.\n                                </span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"connection.params.credentialsMode == 'STS_ASSUME_ROLE'\">\n                            <label class=\"control-label\">Assume role external Id</label>\n                            <div class=\"controls\">\n                                 <input type=\"text\" ng-model=\"connection.params.stsAssumeExternalId\" />\n                                 <span class=\"help-inline\">\n                                     Optional. If the role to assume requires an external id, enter it here. Variable expansion, notably per-user properties are supported here.\n                                 </span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.credentialsMode == 'CUSTOM_PROVIDER'\">\n                            <label class=\"control-label\">Custom provider class</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.customAWSCredentialsProviderClass\" />\n                                <span class=\"help-inline\">\n                                    Class name of a custom DSS AWS credentials provider\n                                </span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\" ng-if=\"connection.params.customAWSCredentialsProviderClass\">\n                            <label class=\"control-label\">Custom provider settings</label>\n                            <div class=\"controls\">\n                                <ng2-credentials-list \n                                    [(items)]=\"connection.params.customAWSCredentialsProviderParams\"\n                                    key-identifier=\"name\"\n                                    key-placeholder=\"Provider key\"\n                                    value-placeholder=\"Provider value\"\n                                    [can-be-final]=\"false\"\n                                    add-label=\"Add provider setting\">\n                                </ng2-credentials-list>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\"\n                        form-template-element\n                        model=\"connection.params\"\n                        field=\"{name:'regionOrEndpoint',\n                        type:'string',\n                        label:'Region / Endpoint',\n                        tooltip:'Optional AWS region (e.g. eu-west-1) or custom endpoint (e.g. http[s]://my.s3.endpoint/)'}\" />\n\n                        <div class=\"control-group\">\n                            <label for=\"switchToRegionFromBucket\" class=\"control-label\">Switch to bucket region</label>\n                            <div class=\"controls\">\n                                <input id=\"switchToRegionFromBucket\" type=\"checkbox\" ng-model=\"connection.params.switchToRegionFromBucket\" ng-if=\"canSwitchToRegionFromBucket(connection.params.regionOrEndpoint)\" />\n                                <input id=\"switchToRegionFromBucket\" type=\"checkbox\" disabled=\"true\" ng-if=\"!canSwitchToRegionFromBucket(connection.params.regionOrEndpoint)\" />\n                                <span class=\"help-inline\">Switch to the bucket's region even if the region for connecting is set (to avoid redirects). Not applicable when the endpoint is HTTPS.</span>\n                            </div>\n                        </div>\n\n                        <h2 class=\"settings-section-title\">Snowflake fast loading/unloading</h2>\n\n                        <p>\n                            <small class=\"help-inline\" style=\"padding: 0\">\n                                These optional settings are used for direct data loading from/unloading to Snowflake.\n                            </small>\n                        </p>\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStageName',type:'string', mandatory:false, label:'External stage name', tooltip:'If necessary, add double quotes for case sensitivity, and qualify the stage name with the database and schema'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStagePath',type:'string', mandatory:false, label:'External stage path', tooltip: 'Enter the path starting from and including the bucket. This should match the path used when creating the stage.'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeStorageIntegration',type:'string', mandatory:false, label:'Storage integration', tooltip: 'Not needed if using an external stage'}\" />\n\n                        <h2 class=\"settings-section-title\">Path restrictions</h2>\n\n                        <div class=\"control-group\" form-template-element\n                        model=\"connection.params\"\n                        field=\"{name:'chbucket', type:'string', label:'Bucket', tooltip:'Optional. Limit accesses on this connection to the contents of this bucket. If empty, users will be able to select bucket (among buckets allowed by this access key)'}\" />\n                        <div class=\"control-group\" form-template-element\n                        model=\"connection.params\"\n                        field=\"{name:'chroot', type:'string', label:'Path in bucket', tooltip:'Optional. Limit accesses on this connection to the contents of this folder. If empty, users will be able to use the whole bucket (or buckets)'}\" />\n\n                        <fieldset ng-disabled=\"!connection.allowManagedDatasets && !connection.allowManagedFolders\">\n                            <h2 class=\"settings-section-title\">Managed datasets &amp; folders</h2>\n                            <div class=\"control-group\" ng-if=\"!connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedBucket',type:'string',\n                            label:'Default bucket',\n                            tooltip:'Managed datasets will be created by default in this bucket. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"!connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Default path',\n                            tooltip:'Managed datasets will be created by default in this path. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Managed data subpath',\n                            tooltip:'Managed datasets and folders will be created by default in this subpath of the root path in bucket. May contain variables.'}\" />\n                        </fieldset>\n\n                        <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n\n                        <h2 class=\"settings-section-title\">Advanced</h2>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">HDFS interface</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.hdfsInterface\" dku-bs-select>\n                                    <option value=\"S3A\">Hadoop S3A</option>\n                                    <option value=\"S3A_DATABRICKS\">Databricks</option>\n                                    <option value=\"EMRFS\">Amazon EMRFS</option>\n                                    <option value=\"NONE\">None</option>\n                                </select>\n                                <span class=\"help-inline\">Protocol to use for direct access to S3 datasets from Spark.</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\" ng-if=\"['S3A', 'S3A_DATABRICKS'].indexOf(connection.params.hdfsInterface) >= 0\">\n                            <label for=\"usePathMode\" class=\"control-label\">Use path style</label>\n                            <div class=\"controls\">\n                                <input id=\"usePathMode\" type=\"checkbox\" ng-model=\"connection.params.usePathMode\" />\n                                <span class=\"help-inline\">Changes calls to S3 from using virtual hosting style urls to path style urls.</span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Encryption Mode</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.encryptionMode\" dku-bs-select>\n                                    <option value=\"NONE\">None</option>\n                                    <option value=\"SSE_S3\">SSE-S3</option>\n                                    <option value=\"SSE_KMS\">SSE-KMS</option>\n                                </select>\n                                <span ng-if=\"connection.params.encryptionMode == 'SSE_KMS'\">\n                                    Key ID (optional)\n                                    <input type=\"text\" ng-model=\"connection.params.encryptionKeyId\" placeholder=\"default\" />\n                                </span>\n                                <span class=\"help-inline\">\n                                    Server-Side Encryption for files, see\n                                    <a target=\"_blank\" rel=\"noopener noreferrer\"\n                                       href=\"http://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html\"\n                                    >S3 documentation</a>.\n                                </span>\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Associated Athena conn.</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.associatedAthenaConnection\" />\n                            </div>\n                        </div>\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Metastore synchronization</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.metastoreSynchronizationMode\" dku-bs-select>\n                                    <option value=\"KEEP_IN_SYNC\">Keep datasets synced</option>\n                                    <option value=\"NO_SYNC\">No sync</option>\n                                </select>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Fallback metastore DB</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.defaultMetastoreDatabase\" name=\"defaultMetastoreDatabase\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n                                <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.defaultMetastoreDatabase.$invalid\">\n                                    Metastore database names can only contains letters, numbers and underscores.\n                                </div>\n                                <div class=\"help-inline\">\n                                    This database is used as default for datasets that do not declare one\n                                </div>\n                            </div>\n                        </div>\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\" include-no-scope=\"/templates/admin/fragments/connection-name-test-save-with-results.html\" />\n</div>");
$templateCache.put("/templates/admin/connection-elasticsearch.html", "<div ng-controller=\"ElasticSearchConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'port', type:'int', mandatory:true, label:'Port'}\" />\n                                <div class=\"control-group\">\n                                    <label for=\"elasticConnParam_SSL\" class=\"control-label\">Use HTTPS</label>\n                                    <div class=\"controls\">\n                                        <input id=\"elasticConnParam_SSL\" type=\"checkbox\" ng-model=\"connection.params.ssl\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"elasticConnParam_SSL_any\" class=\"control-label\">Trust any SSL certificate</label>\n                                    <div class=\"controls\">\n                                        <input id=\"elasticConnParam_SSL_any\" type=\"checkbox\" ng-disabled=\"!connection.params.ssl\"\n                                            ng-model=\"connection.params.trustAnySSLCertificate\" />\n                                        <span class=\"help-inline\">Disable validation of SSL certificate</span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Auth type</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select ng-model=\"connection.params.authType\"\n                                                ng-options=\"x[0] as x[1] for x in availableAuthTypes\"\n                                                options-descriptions=\"availableAuthTypesDesc\" />\n                                    </div>\n                                </div>\n                                <div ng-if=\"connection.params.authType == 'OAUTH2_APP'\">\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params.oauth\"\n                                         field=\"{name:'clientId',type:'string', label:'Client id'}\" />\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params.oauth\"\n                                         field=\"{name:'clientSecret',type:'password', label:'Client secret'}\" />\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params.oauth\"\n                                         field=\"{name:'scope',type:'string', label:'Scope'}\" />\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params.oauth\"\n                                         field=\"{name:'authorizationEndpoint',type:'string', label:'Auth authorization endpoint'}\" />\n                                    <div class=\"control-group\"\n                                         form-template-element\n                                         model=\"connection.params.oauth\"\n                                         field=\"{name:'tokenEndpoint',type:'string', label:'Auth token endpoint'}\" />\n                                    <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                        <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input type=\"checkbox\" ng-model=\"connection.params.oauth.refreshTokenRotation\"/>\n                                                <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                            </label>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div ng-if=\"connection.params.authType == 'PASSWORD'\">\n                                    <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                        field=\"{name:'username',type:'string', mandatory:false, label:'Username'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                        field=\"{name:'password',type:'password', mandatory:false, label:'Password'}\" />\n                                </div>\n\n                                <div ng-if=\"connection.params.authType == 'AWS_KEYPAIR'\">\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'accessKey',type:'string', mandatory:false, label:'Access Key'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'secretKey',type:'password', mandatory:false, label:'Secret Access Key'}\" />\n                                </div>\n\n                                <div ng-if=\"connection.params.authType == 'AWS_STS'\">\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'stsRoleToAssume',type:'string', mandatory:false, label:'STS role to assume', tooltip:'Variable expansion, notably per-user properties are supported here.'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'stsEndpoint',type:'string', mandatory:false, label:'STS Endpoint', tooltip:'AWS region or custom endpoint URL. Leave empty to use the global endpoint.'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'stsAssumeDurationSeconds',type:'string', mandatory:false, label:'Session duration (seconds)', tooltip:'Optional. Validity of the STS token, in seconds. Leave empty for default (1 hour). Value must be an integer between 900 and the maximum session duration setting for the role (which can go up to 12 hours / 43200 seconds). Variable expansion, notably per-user properties are supported here.'}\" />\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'stsAssumeExternalId',type:'string', mandatory:false, label:'External ID', tooltip:'Optional. If the role to assume requires an external id, enter it here. Variable expansion, notably per-user properties are supported here.'}\" />\n                                </div>\n\n                                <div ng-if=\"connection.params.authType == 'AWS_CUSTOM'\">\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'customAWSCredentialsProviderClass',type:'string', mandatory:false, label:'Custom provider class', tooltip: 'Class name of a custom DSS AWS credentials provider.'}\" />\n                                    <div class=\"control-group\" ng-if=\"connection.params.aws.customAWSCredentialsProviderClass\">\n                                        <label  class=\"control-label\">Custom provider settings</label>\n                                        <div class=\"controls\">\n                                            <ng2-connection-properties-list [(items)]=\"connection.params.aws.customAWSCredentialsProviderParams\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div ng-if=\"connection.params.authType.startsWith('AWS_')\">\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Service</label>\n                                        <div class=\"controls\">\n                                            <select dku-bs-select ng-model=\"connection.params.aws.service\"\n                                                    ng-options=\"x[0] as x[1] for x in availableAWSServiceTypes\"\n                                                    options-descriptions=\"availableAWSServiceTypesDesc\" />\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" form-template-element model=\"connection.params.aws\"\n                                         field=\"{name:'region',type:'string', mandatory:false, label:'Region'}\" />\n                                </div>\n\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'dialect', type:'advanced_select', mandatory:true, label:'Dialect',\n                                        advancedChoices: [{value: 'ES_7', label: '7.x, 8.x or OpenSearch'}, {value: 'ES_5', label: '5.x or 6.x'}, {value: 'ES_LE_2', label: '1.x or 2.x (deprecated)'}]}\" />\n                                <div class=\"control-group\">\n                                    <h2 class=\"settings-section-title\">Custom properties</h2>\n                                    <label  class=\"control-label\">Advanced connection properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                        <span class=\"help-inline\">For specific use cases</span>\n                                    </div>\n                                </div>\n                                <div ng-show=\"connection.allowManagedDatasets\">\n                                    <h2 class=\"settings-section-title\">Naming rules for new datasets</h2>\n                                    <p>\n                                        <small class=\"help-inline\" style=\"padding: 0\">\n                                            These settings define how managed ElasticSearch datasets are mapped to\n                                            indexes. These settings are only applied when creating a new managed ElasticSearch dataset.\n                                            You can always modify these afterwards in the ElasticSearch dataset settings.\n                                            See <doclink page=\"/connecting/relocation\" title=\"the documentation\" /> for more information.\n                                        </small>\n                                    </p>\n\n\n                                    <div class=\"control-group\">\n                                        <label for=\"indexNameDatasetNamePrefix\" class=\"control-label\">Index prefix</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.namingRule.indexNameDatasetNamePrefix\" id=\"indexNameDatasetNamePrefix\" name=\"indexNameDatasetNamePrefix\" class=\"exclude-from-smart-change\" custom-validation=\"isIndexNameAllowed\"/>\n                                            <span class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.indexNameDatasetNamePrefix.$invalid\">\n                                                Index prefix contain illegal characters\n                                            </span>\n                                            <div class=\"help-inline\">\n                                                Index name for new managed datasets will be prefixed by this. You may reference variables here, they will\n                                                be expanded dynamically. The content will be lower-cased when creating the index.\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"indexNameDatasetNameSuffix\" class=\"control-label\">Index suffix</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.namingRule.indexNameDatasetNameSuffix\" id=\"indexNameDatasetNameSuffix\" name=\"indexNameDatasetNameSuffix\" class=\"exclude-from-smart-change\" custom-validation=\"isIndexNameAllowed\"/>\n                                            <span class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.indexNameDatasetNameSuffix.$invalid\">\n                                                Index suffix contain illegal characters\n                                            </span>\n                                            <div class=\"help-inline\">\n                                                Index name for new managed datasets will be suffixed by this. You may reference variables here, they will\n                                                be expanded dynamically. The content will be lower-cased when creating the index.\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"alert alert-warning\" ng-show=\"warnings.noVariableInIndex\">\n                                        Index name does not include any variable reference. Datasets will be created with absolute names, which is\n                                        not recommended for relocation purposes and may cause name clashes.\n                                    </div>\n                                </div>\n                                <div ng-if=\"connection.params.authType == 'OAUTH2_APP'\" include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" class=\"span6\"/>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        <div class=\"alert alert-success\" ng-if=\"testResult.connectionOK && !testResult.dialectMismatch\">\n            <strong>Connection OK</strong>, found {{testResult.distributionName}} v. {{testResult.version}}\n        </div>\n        <div class=\"alert alert-warning\" ng-if=\"testResult.dialectMismatch\">\n            <strong>Connection OK</strong>, but dialect parameter does not match the detected version (found v. {{testResult.version}}).\n            <a ng-click=\"fixDialectMismatch()\">Update dialect to match detected version</a>.\n        </div>\n        <div class=\"alert alert-error\" ng-if=\"testResult && !testResult.connectionOK\">\n            <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n            <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-fabric-warehouse.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid mtop20\" ng-show=\"connection.params.azureDWH\">\n                        <div class=\"alert alert-warning mbot0\">\n                            <i class=\"icon-dku-warning\" /><span>The option \"Azure Data Warehouse\" is deprecated, please migrate to an \"Azure Synapse\" connection</span>\n                        </div>\n                    </div>\n\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n                            <fieldset ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'host',type:'string', mandatory:true, label:'Host', tooltip:'Mandatory'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                            </fieldset>\n                            <fieldset ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                        ng-required=\"true\"\n                                        placeHolder=\"jdbc:sqlserver://HOST\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                        ng-required=\"false\"\n                                        placeHolder=\"jdbc:sqlserver://HOST\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                            </fieldset>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Database</label>\n                                <div class=\"controls\">\n                                    <input ng-trim=\"false\" ng-if=\"availableCatalogs == null\" ng-model=\"connection.params.db\" type=\"text\" />\n                                    <input ng-trim=\"false\" ng-if=\"availableCatalogs != null\"\n                                        bs-typeahead=\"availableCatalogs\"\n                                        ng-model=\"connection.params.db\"\n                                        type='text'\n                                        autocomplete=\"off\"\n                                        data-min-length=\"0\"\n                                        id=\"catalog_input\"\n                                    />\n                                    <button ng-if=\"availableCatalogs == null\"\n                                        class=\"btn btn--text btn--icon btn--secondary btn--dku-icon\"\n                                        ng-click=\"fetchCatalogs(connection.name, 'connection-settings', connection.type, 'catalog_input')\"\n                                        ng-disabled=\"refreshCatalogOngoing || creation || connectionDirty()\"\n                                        toggle=\"tooltip\"\n                                        title=\"{{creation ? 'Cannot refresh catalogs in creation mode' :\n                                            connectionDirty() ? 'Save pending changes before being able to refresh' :\n                                            listSqlCatalogsTooltip}}\"\n                                    >\n                                        <i class=\"dku-icon-arrow-circular-16\" ng-class=\"{'icon-spin': refreshCatalogOngoing}\"></i>\n                                    </button>\n                                </div>\n                            </div>\n\n                            <fieldset>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">OAuth2 Authorization endpoint</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.azureOAuth2AuthorizationEndpoint\"/>\n                                        <span class=\"help-inline\">https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/authorize</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">OAuth2 Token endpoint</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.azureOAuth2TokenEndpoint\"/>\n                                        <span class=\"help-inline\">https://login.microsoftonline.com/{tenantId}/oauth2/v2.0/token</span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Client id</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.azureOAuthLoginClientId\"/>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Client secret</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.azureOAuthLoginClientSecret\"/>\n                                        <span class=\"help-inline\">\n                                            Not required if you use per-user authentication\n                                        </span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER' && connection.params.azureOAuthLoginEnabled\">\n                                    <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                            <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                        </label>\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n                            <div class=\"control-group\">\n                                <label for=\"sendDriverJarsToSpark\" class=\"control-label\">Send driver jars to Spark</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input id=\"sendDriverJarsToSpark\" type=\"checkbox\" ng-model=\"connection.params.sendDriverJarsToSpark\">\n                                        <span class=\"help-inline\" ng-if=\"connection.params.jarsDirectory\">\n                                            Experimental: Add driver jars to spark-submit subprocesses\n                                        </span>\n                                        <span class=\"help-inline\" ng-if=\"!connection.params.jarsDirectory\">\n                                            Experimental: Add all jars of [DSS home]/lib/jdbc to spark-submit subprocesses. Use a Jars directory to pass only this connections's driver.\n                                        </span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Fetch size</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                </div>\n                            </div>\n                            <!-- hidden autocommit, since it's always true -->\n                            <input type=\"checkbox\" ng-model=\"connection.params.autocommitMode\" ng-show=\"false\" />\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Automatic fast-write</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useAutoFastPath\"/>\n                                        <span class=\"help-inline\">Experimental. Automatically uses a Azure Blob connection and fast bulk load into The Fabric Warehouse when using recipes writing data from the outside into the Fabric Warehouse.</span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Auto. fast-write connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnection\" />\n                                    <span class=\"help-inline\">Name of a Azure Blob connection that will be used as staging area for fast bulk load.</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"connection.params.useAutoFastPath\">\n                                <label for=\"\" class=\"control-label\">Path in connection</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.autoFastPathConnectionPath\" />\n                                    <span class=\"help-inline\">Path within the auto fast-write connection that will be used for temporary staging data.</span>\n                                </div>\n                            </div>\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div ng-if=\"!connection.params.kerberosLoginEnabled\" include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n\n</div>\n");
$templateCache.put("/templates/admin/connection-filesystem.html", "<div ng-controller=\"FilesystemConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Location</h2>\n                        <div class=\"control-group\" form-template-element model=\"connection.params\"\n                        field=\"{name:'root',type:'string', mandatory:true, label:'Root path'}\" />\n\n                        <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n\n\n                        <div ng-if=\"!creation\">\n                            <h2 class=\"settings-section-title\">Advanced</h2>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Manage ACLs for folders</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.manageLocalACLsForManagedFolders\" />\n                                        <span class=\"help-inline\">Allows direct access to files in managed folders without using the APIs. Disable if the root path does not support POSIX ACLs</span>\n                                    </label>\n                                </div>\n                            </div>\n                        </div>\n                    </form>\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\" include-no-scope=\"/templates/admin/fragments/connection-name-test-save-with-results.html\" />\n</div>");
$templateCache.put("/templates/admin/connection-ftp.html", "\n<div ng-controller=\"FTPConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\" form-template-element\n                                model=\"connection.params\"\n                                field=\"{name:'host', type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"control-group\" form-template-element\n                                model=\"connection.params\"\n                                field=\"{name:'port', type:'int', mandatory:true, label:'Port'}\" />\n                                <div class=\"control-group\" form-template-element\n                                model=\"connection.params\"\n                                field=\"{name:'user', type:'string', label:'User'}\" />\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Use passive mode</label>\n                                    <div class=\"controls\">\n                                        <input type=\"checkbox\" ng-model=\"connection.params.passive\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\" form-template-element\n                                model=\"connection.params\"\n                                field=\"{name:'path', type:'string', label:'Path'}\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                                <div class=\"alert alert-warning\" ng-show=\"connection.useGlobalProxy && connection.$canHaveProxy && !connection.params.passive\">\n                                    Active-mode FTP over HTTP proxy is not supported.\n                                </div>\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\" include-no-scope=\"/templates/admin/fragments/connection-name-test-save-with-results.html\" />\n</div>");
$templateCache.put("/templates/admin/connection-gcs.html", "<div ng-controller=\"GCSConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div block-api-error />\n\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'projectId',type:'string', mandatory:true, label:'Project key'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{\n                                name:'pscEndpointId',\n                                type:'string',\n                                mandatory:false,\n                                label:'PSC Endpoint ID',\n                                tooltip: 'Optional. To use a Private Service Connect Endpoint, provide its ID'\n                            }\"\n                        />\n\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Credentials</label>\n                            <div class=\"controls\">\n                                <select dku-bs-select ng-model=\"connection.params.authType\"\n                                ng-options=\"x[0] as x[1] for x in [['KEYPAIR', 'Private key'], ['OAUTH', 'OAuth2'], ['ENVIRONMENT', 'Environment']]\"/>\n                            </div>\n                        </div>\n                        <fieldset ng-if=\"connection.params.authType == 'KEYPAIR'\">\n                            <div class=\"control-group\"\n                                form-template-element\n                                model=\"connection.params\"\n                                field=\"{\n                                    name:'appSecretContent',\n                                    type:'string',\n                                    mandatory:true,\n                                    label:'Private key',\n                                    tooltip: 'Mandatory. Must contains either the full path on the DSS server to the key file (.json or .p12) - Recommended, or the key as a JSON formatted string',\n                                    maskIf: 'function(value) { return value && (value.trim().startsWith(\\'{\\') || value.trim().startsWith(\\'e:AES:X\\')) }'\n                                }\" />\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'serviceAccountEmail',type:'string', mandatory:false, label:'Service account e-mail', tooltip:'Mandatory if private key contains the path to a .p12 file. Ignored otherwise'}\" />\n                        </fieldset>\n\n                        <fieldset ng-if=\"connection.params.authType == 'OAUTH'\">\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'oauth2ClientId',type:'string', mandatory:true, label:'Client id', tooltip:'Mandatory'}\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'oauth2ClientSecret',type:'password', mandatory:true, label:'Client secret', tooltip:'Mandatory'}\" />\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Scope</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.oauth2Scope\">\n                                    <span class=\"help-inline\">\n                                            List of scopes separated by spaces. If not defined, using default scope `https://www.googleapis.com/auth/cloud-platform` (see <a target=\"_blank\" href=\"https://developers.google.com/identity/protocols/oauth2/scopes#storage\">Google OAuth2 documentation</a> for the list of scopes).\n                                        </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'oauth2AuthorizationEndpoint',type:'string', mandatory:false, label:'Auth authorization endpoint', tooltip:'If not using default Google OAuth authorization endpoint'}\" />\n                            <div class=\"control-group\"\n                                 form-template-element\n                                 model=\"connection.params\"\n                                 field=\"{name:'oauth2tokenEndpoint',type:'string',  mandatory:false, label:'Auth token endpoint', tooltip:'If not using default Google OAuth token endpoint'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.credentialsMode === 'PER_USER'\">\n                                <label for=\"\" class=\"control-label\">Rotate refresh tokens</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.refreshTokenRotation\"/>\n                                        <span class=\"help-inline\">Whether DSS should expect refresh tokens to be renewed when an access token is retrieved</span>\n                                    </label>\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <h2 class=\"settings-section-title\">Snowflake fast loading/unloading</h2>\n\n                        <p>\n                            <small class=\"help-inline\" style=\"padding: 0\">\n                                These optional settings are used for direct data loading from/unloading to Snowflake.\n                            </small>\n                        </p>\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStageName',type:'string', mandatory:false, label:'External stage name', tooltip:'If necessary, add double quotes for case sensitivity, and qualify the stage name with the database and schema'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeExternalStagePath',type:'string', mandatory:false, label:'External stage path', tooltip: 'Enter the path starting from and including the bucket. This should match the path used when creating the stage.'}\" />\n\n                        <div class=\"control-group\"\n                             form-template-element\n                             model=\"connection.params\"\n                             field=\"{name:'snowflakeStorageIntegration',type:'string', mandatory:false, label:'Storage integration', tooltip: 'Not needed if using an external stage'}\" />\n\n                        <h2 class=\"settings-section-title\">Path restrictions</h2>\n\n                        <div class=\"control-group\" form-template-element\n                        model=\"connection.params\"\n                        field=\"{name:'chbucket', type:'string', label:'Bucket', tooltip:'Optional. Limit accesses on this connection to the contents of this bucket. If empty, users will be able to select bucket (among buckets allowed by this key)'}\" />\n                        <div class=\"control-group\" form-template-element\n                        model=\"connection.params\"\n                        field=\"{name:'chroot', type:'string', label:'Path from', tooltip:'Optional. Limit accesses on this connection to the contents of this folder. If empty, users will be able to use the whole bucket (or buckets)'}\" />\n\n                        <fieldset ng-disabled=\"!connection.allowManagedDatasets && !connection.allowManagedFolders\">\n                            <h2 class=\"settings-section-title\">Managed datasets &amp; folders</h2>\n\n                            <div class=\"control-group\" ng-if=\"!connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedBucket',type:'string',\n                            label:'Default bucket',\n                            tooltip:'Managed datasets will be created by default in this bucket. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"!connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Default path',\n                            tooltip:'Managed datasets will be created by default in this path. May contain variables.'}\" />\n                            <div class=\"control-group\" ng-if=\"connection.params.chbucket\"\n                            form-template-element\n                            model=\"connection.params\"\n                            field=\"{name:'defaultManagedPath',type:'string',\n                            label:'Managed data subpath',\n                            tooltip:'Managed datasets and folders will be created by default in this subpath of the root path in bucket. May contain variables.'}\" />\n                        </fieldset>\n\n                        <div include-no-scope=\"/templates/admin/fragments/fs-naming-rule.html\" />\n\n                        <h2 class=\"settings-section-title\">Advanced</h2>\n                        <div class=\"control-group\">\n\n                            <label class=\"control-label\">HDFS interface</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.hdfsInterface\" dku-bs-select>\n                                    <option value=\"GS\">GS</option>\n                                    <option value=\"NONE\">None (go through DSS)</option>\n                                </select>\n                                <span class=\"help-inline\">Protocol to use for direct access to GCS datasets from Spark.</span>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label class=\"control-label\">Metastore synchronization</label>\n                            <div class=\"controls\">\n                                <select ng-model=\"connection.params.metastoreSynchronizationMode\" dku-bs-select>\n                                    <option value=\"KEEP_IN_SYNC\">Keep datasets synced</option>\n                                    <option value=\"NO_SYNC\">No sync</option>\n                                </select>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Fallback metastore DB</label>\n                            <div class=\"controls\">\n                                <input type=\"text\" ng-model=\"connection.params.defaultMetastoreDatabase\" name=\"defaultMetastoreDatabase\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n                                <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.defaultMetastoreDatabase.$invalid\">\n                                    Metastore database names can only contains letters, numbers and underscores.\n                                </div>\n                                <div class=\"help-inline\">\n                                    This database is used as default for datasets that do not declare one\n                                </div>\n                            </div>\n                        </div>\n\n\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <!-- style=\"border-top: 1px #ccc solid\"-->\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />&nbsp;Please wait, testing connection\n        </div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.connectionOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK && testResult.connectionWarning\" class=\"alert alert-warning\">\n                Connection OK, <strong>but</strong> {{testResult.connectionErrorMsg}}.\n            </div>\n            <div ng-show=\"testResult.connectionOK && !testResult.connectionWarning\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-greenplum.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n\n                            <fieldset ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\"\n                                     form-template-element model=\"connection.params\"\n                                     field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'db', type:'string', mandatory:true, label:'Database'}\" />\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Port</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"/>\n                                    </div>\n                                </div>\n                            </fieldset>\n                            <fieldset ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                               ng-required=\"true\"\n                                               placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                               ng-required=\"false\"\n                                               placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Driver class</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.driver\"\n                                        ng-required=\"false\" placeholder=\"Leave empty to use default driver class\" />\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <fieldset ng-if=\"connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\"\n                                     form-template-element\n                                     model=\"connection.params\"\n                                     field=\"{name:'user', type:'string', mandatory:connection.params.useURL != true, label:'User'}\" />\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                    </div>\n                                </div>\n                            </fieldset>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Database version</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"connection.params.version\">\n                                        <option value=\"4.0\">&lt;5.0</option>\n                                        <option value=\"5.0\">&gt;=5.0</option>\n                                    </select>\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"!connection.params.driver\">\n                                <label for=\"\" class=\"control-label\">Driver to use</label>\n                                <div class=\"controls\">\n                                     <select dku-bs-select ng-model=\"connection.params.driverMode\" \n                                            ng-options=\"x[0] as x[1] for x in [['MANAGED_LEGACY_POSTGRESQL', 'PostgreSQL driver (managed by Dataiku)'], ['CUSTOM_LEGACY_POSTGRESQL', 'PostgreSQL driver (user-provided)']]\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                ng-if=\"connection.params.driverMode == 'CUSTOM_LEGACY_POSTGRESQL' || connection.params.driver\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the JDBC driver jars. The path can be absolute or relative to the DSS data directory. If empty, jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n                            <div class=\"control-group\">\n                                <label for=\"sendDriverJarsToSpark\" class=\"control-label\">Send driver jars to Spark</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input id=\"sendDriverJarsToSpark\" type=\"checkbox\" ng-model=\"connection.params.sendDriverJarsToSpark\">\n                                        <span class=\"help-inline\" ng-if=\"connection.params.driverMode != 'CUSTOM_LEGACY_POSTGRESQL' || connection.params.jarsDirectory\">\n                                            Experimental: Add driver jars to spark-submit subprocesses\n                                        </span>\n                                        <span class=\"help-inline\" ng-if=\"connection.params.driverMode == 'CUSTOM_LEGACY_POSTGRESQL' && !connection.params.jarsDirectory\">\n                                            Experimental: Add all jars of [DSS home]/lib/jdbc to spark-submit subprocesses. Use a Jars directory to pass only this connections's driver.\n                                        </span>\n                                    </label>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Fetch size</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                    <span class=\"help-inline\">Empty = default</span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Default distribution strategy</label>\n                                <div class=\"controls\">\n                                    <select dku-bs-select ng-model=\"connection.params.defaultDistributionStrategy\" ng-options=\"x[0] as x[1] for x in [['AUTO', 'Auto (use first column)'], ['RANDOMLY', 'Distribute randomly']]\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\" ng-if=\"warnAboutSearchPath()\">\n                                <label><i class=\"icon-warning-sign\"></i>&nbsp;Either default schema should be non-empty or the schema search path should include 'public'</label>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Schema search path</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.schemaSearchPath\" />\n                                    <div class=\"help-inline\">\n                                        This search path will be set on all sessions.\n                                        Useful for SQL queries and notebooks\n                                    </div>\n                                </div>\n                            </div>\n                            \n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </form>\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-hdfs.html", "<div ng-controller=\"HDFSConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span7\">\n                                <h2 class=\"settings-section-title\">Hadoop connection</h2>\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'root',type:'string', mandatory:true, label:'Root path URI'}\" />\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Extra Hadoop conf.</label>\n                                    <div class=\"controls\" ng-init=\"connection.params.extraConf = connection.params.extraConf || []\">\n                                        <ng2-connection-properties-list\n                                            [(items)]=\"connection.params.extraConf\"\n                                            key-identifier=\"name\"\n                                            key-placeholder=\"Configuration key\"\n                                            value-placeholder=\"Configuration value\"\n                                            [required]=\"true\"\n                                            [can-be-final]=\"false\"\n                                            add-label=\"Add extra configuration\"\n                                            (on-validity-change)=\"setExtraHadoopConfigurationValidity($event)\">\n                                        </ng2-connection-properties-list>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Hive integration</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Hive synchronization mode</label>\n                                    <div class=\"controls\">\n                                        <select ng-model=\"connection.params.hiveSynchronizationMode\">\n                                            <option value=\"KEEP_IN_SYNC\">Keep datasets synced</option>\n                                            <option value=\"NO_SYNC\">No sync</option>\n                                        </select>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\" ng-if=\"connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                    <label for=\"\" class=\"control-label\">Fallback Hive DB</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.defaultDatabase\" name=\"hiveDefaultDatabaseName\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n                                        <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.hiveDefaultDatabaseName.$invalid\">\n                                            Hive database names can only contains letters, numbers and underscores.\n                                        </div>\n                                        <div class=\"help-inline\">\n                                            This database is used as fallback for datasets which do not have a database set.\n                                        </div>\n                                    </div>\n                                </div>\n\n                                <div ng-show=\"connection.allowManagedDatasets && !appConfig.impersonationEnabled && connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                    <h2 class=\"settings-section-title\">Advanced</h2>\n\n                                    <div class=\"control-group\" ng-if=\"!appConfig.impersonationEnabled && connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                        <label class=\"control-label\">Override pre-create folder for recipes</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input type=\"checkbox\" ng-model=\"connection.params.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes\"/>\n                                                <span class=\"help-inline\">Override the value in the general settings for this connection</span>\n                                            </label>\n                                        </div>\n                                    </div>\n\n\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Custom provider (advanced)</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.customPropertiesProviderClass\" />\n                                            <span class=\"help-inline\">\n                                                Class name of a custom HDFS properties\n                                            </span>\n                                        </div>\n                                    </div>\n\n                                    <div class=\"control-group\" ng-if=\"connection.params.customPropertiesProviderClass\">\n                                        <label class=\"control-label\">Custom provider settings</label>\n                                        <div class=\"controls\">\n                                        <ng2-credentials-list \n                                            [(items)]=\"connection.params.customPropertiesProviderParams\"\n                                            key-identifier=\"name\"\n                                            key-placeholder=\"Provider key\"\n                                            value-placeholder=\"Provider value\"\n                                            [can-be-final]=\"false\"\n                                            add-label=\"Add provider setting\">\n                                        </ng2-credentials-list>\n                                    </div>\n                                </div>\n\n                                </div>\n                                <div ng-show=\"connection.allowManagedDatasets || connection.allowManagedFolders\">\n                                    <h2 class=\"settings-section-title\">Naming rules for new datasets</h2>\n                                    <p>\n                                        <small class=\"help-inline\" style=\"padding: 0\">\n                                            These settings define how managed HDFS datasets are located and mapped to\n                                            Hive tables. These settings are only applied when creating a new managed HDFS dataset.\n                                            You can always modify these afterwards in the HDFS dataset settings.\n                                            See <doclink page=\"/connecting/relocation\" title=\"the documentation\" /> for more information.\n                                        </small>\n                                    </p>\n\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Path prefix</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.hdfsPathDatasetNamePrefix\" type=\"text\" />\n                                            <div class=\"help-inline\">\n                                                This will be prepended before the dataset name in the path, relative\n                                                to the connection root. You may reference variables here, they will\n                                                be expanded dynamically\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Path suffix</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.hdfsPathDatasetNameSuffix\" type=\"text\" />\n                                            <div class=\"help-inline\">\n                                                This will be appended after the dataset name in the path, relative\n                                                to the connection root. You may reference variables here, they will\n                                                be expanded dynamically\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" ng-if=\"connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                        <label for=\"\" class=\"control-label\">Hive database</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.hiveDatabaseName\" type=\"text\"  name=\"hiveDatabaseName\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n\n                                            <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.hiveDatabaseName.$invalid\">\n                                                Hive database names can only contains letters, numbers and underscores.\n                                            </div>\n                                            <br/>\n                                            <div class=\"help-inline\">\n                                                You may reference variables here, they will be expanded dynamically\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" ng-if=\"connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                        <label for=\"\" class=\"control-label\">Hive table name prefix</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.tableNameDatasetNamePrefix\" type=\"text\" name=\"hiveTableNamePrefix\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\" />\n\n                                            <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.hiveTableNamePrefix.$invalid\">\n                                                Hive table names can only contains letters, numbers and underscores.\n                                            </div>\n                                            <br/>\n                                            <div class=\"help-inline\">\n                                                This will be prepended before the dataset name in the hive table name.\n                                                You may reference variables here, they will be expanded dynamically\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" ng-if=\"connection.params.hiveSynchronizationMode != 'NO_SYNC'\">\n                                        <label for=\"\" class=\"control-label\">Hive table name suffix</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.tableNameDatasetNameSuffix\" type=\"text\" name=\"hiveTableNameSuffix\" ng-pattern=\"/^(?:\\w|\\$\\{[^}]*\\})+$/\"  />\n                                            <div class=\"help-inline error-text-color\" ng-show=\"connectionParamsForm.hiveTableNameSuffix.$invalid\">\n                                                Hive table names can only contains letters, numbers and underscores.\n                                            </div>\n                                            <br/>\n                                            <div class=\"help-inline\">\n                                                This will be appended after the dataset name in the hive table name.\n                                                You may reference variables here, they will be expanded dynamically\n                                            </div>\n                                        </div>\n                                    </div>\n\n                                    <div class=\"alert alert-warning\" ng-show=\"warnings.noVariableInPath\">\n                                        Path does not include any variable reference. Datasets will be created in an absolute path,\n                                        which is not recommended for relocation purposes and may cause name clashes.\n                                    </div>\n                                    <div class=\"alert alert-warning\" ng-show=\"warnings.noVariableInHive\">\n                                        Table and schema name do not include any variable reference. Datasets will be created with\n                                        absolute names, which is not recommended for relocation purposes and may cause name clashes.\n                                    </div>\n\n                                    <div class=\"control-group\">\n                                        <label for=\"\" class=\"control-label\">Uploads path prefix</label>\n                                        <div class=\"controls\">\n                                            <input ng-model=\"connection.params.namingRule.uploadsPathPrefix\" type=\"text\"/>\n                                            <div class=\"help-inline\">\n                                                This will be prepended to the path for uploaded datasets.\n                                                Variables expansion is not supported.\n                                            </div>\n                                        </div>\n                                    </div>\n                                </div>\n\n\t\t\t\t\t\t\t\t<div class=\"control-group\">\n\t\t\t\t\t\t\t\t    <h2 class=\"settings-section-title\">Custom properties</h2>\n\t\t\t\t\t\t\t\t    <label  class=\"control-label\">Advanced connection properties</label>\n\t\t\t\t\t\t\t\t    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n\t\t\t\t\t\t\t\t        <span class=\"help-inline\">\n\t\t\t\t\t\t\t\t            For specific use cases\n\t\t\t\t\t\t\t\t        </span>\n\t\t\t\t\t\t\t\t    </div>\n\t\t\t\t\t\t\t\t</div>\n                            </div>\n                            <div class=\"span5\">\n\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n\n                                <div ng-show=\"appConfig.impersonationEnabled\">\n\n                                    <h2 class=\"settings-section-title\">Impersonation-related settings</h2>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">ACL synchronization mode</label>\n                                        <div class=\"controls\">\n                                            <select ng-model=\"connection.params.aclSynchronizationMode\">\n                                                <option value=\"NONE\">None</option>\n                                                <option value=\"SUBDIRECTORY\">Through subdirectory</option>\n                                            </select>\n                                        </div>\n                                    </div>\n\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Clear as</label>\n                                        <div class=\"controls\">\n                                            <select ng-model=\"connection.params.clearMode\">\n                                                <option value=\"DSS_USER\">DSS User</option>\n                                            </select>\n                                        </div>\n                                    </div>\n\n                                    <div>\n                                        <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"resyncRootPermissions()\">\n                                            Resync root permissions\n                                        </button>\n                                        <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"resyncPermissions()\">\n                                            Resync dataset permissions\n                                        </button>\n\n                                    </div>\n                                </div>\n\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"noflex small-lr-padding page-top-padding\" include-no-scope=\"/templates/admin/fragments/connection-name-test-save-with-results.html\" />\n</div>");
$templateCache.put("/templates/admin/connection-huggingface-inference-api.html", "<div ng-controller=\"HuggingFaceLocalConnectionController\" class=\"h100 vertical-flex\">\n  <div class=\"flex\">\n    <div class=\"fh oa\">\n      <div class=\"h100 small-lr-padding\">\n        <div class=\"generic-white-box\">\n          <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n          <div block-api-error />\n\n          <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n            <div class=\"row-fluid\">\n              <div class=\"span6\">\n                <h2 class=\"settings-section-title\">Connection</h2>\n                <div class=\"control-group\">\n                  <label for=\"api-key-input\" class=\"control-label\">Hugging Face API key</label>\n                  <div class=\"controls\">\n                    <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\" />\n                  </div>\n                </div>\n              </div>\n              <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" class=\"span6\"/>\n            </div>\n          </form>\n          <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n        </div>\n        <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n          <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"noflex small-lr-padding page-top-padding\">\n    <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n    <div>\n      <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection\n      </div>\n      <div ng-show=\"testResult\">\n        <div ng-show=\"!testResult.ok\" class=\"alert alert-error\"> <i class=\"icon-dku-error\" />Connection to Hugging Face failed: {{testResult.message}}\n        </div>\n        <div ng-show=\"testResult.ok\" class=\"alert alert-success\">\n          <i class=\"icon-success\" />\n          Connection to Hugging Face OK\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-huggingface-local-add-model.html", "<div class=\"modal modal3 modal-w1200--responsive\" auto-size=\"false\">\n    <div dku-modal-header modal-title=\"Add model from library\" modal-totem=\"dku-icon-huggingface-24\" />\n    <div class=\"modal-body modal-taller pad0\">\n        <div block-api-error/>\n        <div class=\"add-model-filters\">\n            <select dku-bs-select=\"{style: 'dku-select-button'}\" ng-model=\"selectedFacets['mainUsagePurpose']\" ng-change=\"filterPresets()\" ng-options=\"facet.id as facet.name for facet in filterFacets['mainUsagePurpose'].values\"></select>\n            <select dku-bs-select=\"{style: 'dku-select-button'}\" ng-model=\"selectedFacets['family']\" ng-change=\"filterPresets()\" options-descriptions=\"facetFamilyDescriptions\" layout=\"list\" ng-options=\"facet.id as facet.name for facet in filterFacets['family'].values\"></select>\n            <div class=\"tags\">\n                <span ng-repeat=\"tag in facets.tags.values\">\n                    <span ng-show=\"selectedFacets['tags'].includes(tag.id)\"\n                        class=\"help-text tag\" style=\"background-color:{{tagColor(tag.id)}};\"\n                        ng-click=\"unSelectTag(tag.id)\"\n                    >\n                        <span ui-global-tag=\"tag.name\" object-type=\"objectType\" \n                            toggle=\"tooltip\" container=\"body\" title=\"{{tag.description}}\"\n                        ></span>\n                    </span>\n                    <span ng-show=\"!selectedFacets['tags'].includes(tag.id)\"\n                        class=\"help-text tag\"\n                        ng-click=\"selectTag(tag.id)\"\n                    >\n                        <span ui-global-tag=\"tag.name\" object-type=\"objectType\" \n                            toggle=\"tooltip\" container=\"body\" title=\"{{tag.description}}\"\n                        ></span>\n                    </span>\n                </span>\n            </div>\n            <div class=\"clear-filters-btn mleft0\" ng-click=\"resetFilters()\" ng-if=\"isFiltering()\">Clear filters</div>\n            <basic-search-box class=\"mleftauto\" ng-model=\"uiState.facetFilter\" placeholder=\"Search models...\"></basic-search-box></basic-search-box>\n        </div>\n        <div class=\"add-model-selector\">\n            <div class=\"add-model-selector__cards\">\n                <!-- Model cards -->\n                <div ng-repeat=\"preset in filteredPresets\" class=\"add-model-selector__card selectable\" ng-click=\"selectPreset(preset)\" ng-class=\"{ 'selected': preset.model.id === selectedPreset.model.id }\">\n                    <div class=\"df aic\">\n                        <h5 class=\"add-model-selector__card-title minw0\" show-tooltip-on-text-overflow text-tooltip=\"preset.model.displayName\"></h5>\n                        <a href=\"https://huggingface.co/{{ preset.model.huggingFaceId }}\" target=\"_blank\" class=\"mleftauto no-underline\" ng-click=\"$event.stopPropagation()\" toggle=\"tooltip\" title=\"View model {{ preset.model.huggingFaceId }}\">\n                            <i class=\"dku-icon-arrow-external-link-16\"></i>\n                        </a>\n                    </div>\n                    <span class=\"add-model-selector__card-subtitle\">\n                        {{ mainPresetModelPurpose(preset).name }}\n                    </span>\n                    <tag-edit-popover\n                        ng-if=\"preset.facets.tags && preset.facets.tags.length\"\n                        ng-model=\"preset.tagNames\"\n                        no-tag-icon=\"true\"\n                        editable=\"false\"\n                        tags-tooltip=\"tagsDescription\"\n                    />\n                </div>\n                <div ng-if=\"!filteredPresets.length\" class=\"alert alert-info ng-star-inserted\">\n                    <h4>No match</h4>\n                    <p>\n                        Clear your filters to see more <button class=\"btn btn--secondary mleft8\" ng-click=\"resetFilters()\">Clear filters</button></p>\n                    </p>\n                </div>\n            </div>\n            <!-- Model details -->\n            <div class=\"add-model-selector__selected\">\n                <div ng-if=\"selectedPreset\">\n                    <h4 class=\"add-model-selector__selected-header\">{{ selectedPreset.model.displayName }}</h4>\n                    <p ng-if=\"selectedPreset.description\">{{ selectedPreset.description }}</p>\n                    <ul>\n                        <li>Hugging Face ID: <a href=\"https://huggingface.co/{{selectedPreset.model.huggingFaceId}}\" target=\"_blank\">{{selectedPreset.model.huggingFaceId}} <i class=\"dku-icon-arrow-external-link-12 dibvab\"></i></a></li>\n                        <li ng-if=\"selectedPreset.model.quantizationMode && selectedPreset.model.quantizationMode !=='NONE'\">Quantization mode: {{selectedPreset.model.quantizationMode}}</li>\n                    </ul>\n                    <tag-edit-popover\n                        ng-if=\"selectedPreset.tagNames && selectedPreset.tagNames.length\"\n                        ng-model=\"selectedPreset.tagNames\"\n                        no-tag-icon=\"true\"\n                        editable=\"false\"\n                        tags-tooltip=\"tagsDescription\"\n                    />\n                </div>\n                <div ng-if=\"!selectedPreset\" class=\"add-model-selector__no-selection\">\n                    <i class=\"dku-icon-cursor-click-48\"></i>\n                    <p>Click on a model to view details</p>\n                </div>\n            </div>\n        </div>\n    </div>\n\n    <div class=\"modal-footer modal-footer-std-buttons\">\n        <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"submit\" class=\"btn btn--text btn--primary\" ng-disabled=\"selectedPreset == null\" ng-click=\"addModel(selectedPreset)\">Add model</button>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-huggingface-local-custom-status-modal.html", "<div class=\"modal modal3 modal-wide\" auto-size=\"false\" tab-model=\"uiState.activeTab\" ng-init=\"uiState.activeTab = 'running'\">\n    <dku-modal-header modal-title=\"Model instances status\">\n        <dku-modal-tabs>\n            <li class=\"tab\" tab-active=\"running\"><a tab-set=\"running\">Running</a></li>\n            <li class=\"tab\" tab-active=\"stopped\"><a tab-set=\"stopped\">Stopped</a></li>\n        </dku-modal-tabs>\n    </dku-modal-header>\n\n    <div class=\"dkuform-modal-horizontal dkuform-modal-wrapper hf-kernel-status-modal\" name=\"hfKernelStatus\">\n        <div class=\"modal-body\" style=\"max-height: min(500px, 80vh)\" ng-switch=\"uiState.activeTab\">\n            <div block-api-error />\n\n            <div ng-switch-when=\"running\">\n                <span ng-if=\"runningKernelsStatus.length == 0\">No model instances are running currently.</span>\n                <div ng-repeat=\"kernel in runningKernelsStatus track by kernel.id\" id=\"kernel-{{ $index }}\" class=\"vertical-flex\">\n                    <div class=\"kernel\">\n                        <div class=\"horizontal-flex jcsb\">\n                            <span ng-if=\"kernel.podName\"><b>Pod name:</b> {{ kernel.podName }}</span>\n                            <span ng-if=\"!kernel.podName\"><b>Id:</b> {{ kernel.id }}</span>\n                            <div class=\"abort\" ng-click=\"confirming=true\" ng-mouseenter=\"hoverStop=true\" ng-mouseleave=\"hoverStop=false\" ng-class=\"{hovered: hoverStop, disabled: stopShouldBeDisabled(kernel)}\">\n                                <span>Stop this instance</span>\n                                <del>×</del>\n                            </div>\n                        </div>\n                        <span><b>State:</b> <span style=\"color: {{ getStateColor(kernel) }}\">{{ getStateText(kernel) }}</span></span>\n                        <div class=\"mbot8 cursor-pointer\" ng-click=\"showLogs = !showLogs\">\n                            <i ng-if=\"showLogs\" class=\"dku-icon-caret-down-12 ng-scope\"></i>\n                            <i ng-if=\"!showLogs\" class=\"dku-icon-caret-right-12 ng-scope\"></i>\n                            <span>Show logs</span>\n                        </div>\n                        <pre class=\"mh300\" ng-if=\"showLogs\" smart-log-tail=\"logs[kernel.id]\" empty-placeholder=\"Awaiting logs...\"></pre>\n\n                        <!-- Stop kernel overlay -->\n                        <div style=\"float:left\" ng-show=\"!stopShouldBeDisabled(kernel) && confirming\">\n                            <div class=\"fh glass\"></div>\n                            <div class=\"fh confirming-content\">\n                                <span>Stop this model instance?</span>\n                                <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"confirming=false\">Cancel</button>\n                                <button type=\"submit\" class=\"btn btn--danger\" ng-click=\"confirming=false; killKernel(kernel);\">Stop</button>\n                            </div>\n                        </div>\n                    </div>\n                    <hr class=\"mtop0 mbot8\" ng-if=\"!$last\" />\n                </div>\n            </div>\n\n            <div ng-switch-when=\"stopped\">\n                <span ng-if=\"deadKernelsStatus.length == 0\">No model instances stopped in the last {{ graveyardTimeout | friendlyDurationSec }}.</span>\n                <div ng-repeat=\"kernel in deadKernelsStatus track by kernel.id\" id=\"kernel-{{ $index }}\" class=\"vertical-flex\">\n                    <span ng-if=\"kernel.podName\"><b>Pod name:</b> {{ kernel.podName }}</span>\n                    <span ng-if=\"!kernel.podName\"><b>Id:</b> {{ kernel.id }}</span>\n                    <span><b>State:</b> <span style=\"color: {{ getStateColor(kernel) }}\">{{ getStateText(kernel) }}</span></span>\n                    <div class=\"mbot8 cursor-pointer\" ng-click=\"showLogs = !showLogs\">\n                        <i ng-if=\"showLogs\" class=\"dku-icon-caret-down-12 ng-scope\"></i>\n                        <i ng-if=\"!showLogs\" class=\"dku-icon-caret-right-12 ng-scope\"></i>\n                        <span>Show logs</span>\n                    </div>\n                    <pre class=\"mh300\" ng-if=\"showLogs\" smart-log-tail=\"logs[kernel.id]\" empty-placeholder=\"No logs for this model instance.\"></pre>\n                    <hr class=\"mtop0 mbot8\" ng-if=\"!$last\" />\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Dismiss</button>\n        </div>\n    </div>\n\n</div>\n");
$templateCache.put("/templates/admin/connection-huggingface-local-edit-modal.html", "<div class=\"modal modal3 modal-wide\" auto-size=\"false\" tab-model=\"uiState.activeTab\" ng-init=\"uiState.activeTab = 'model'\">\n    <dku-modal-header modal-title=\"{{ titleText }}\">\n        <dku-modal-tabs>\n            <li class=\"tab\" tab-active=\"model\"><a tab-set=\"model\">Model settings</a></li>\n            <li ng-if=\"hasInferenceSettings()\" class=\"tab\" tab-active=\"inference\"><a tab-set=\"inference\">Inference settings</a></li>\n            <li class=\"tab\" tab-active=\"deployment\"><a tab-set=\"deployment\">Deployment settings</a></li>\n        </dku-modal-tabs>\n    </dku-modal-header>\n\n    <div class=\"dkuform-modal-horizontal dkuform-modal-wrapper hf-model-edit-modal\" name=\"hfModelEdit\">\n        <div class=\"modal-body\" style=\"max-height: min(500px, 80vh)\" ng-switch=\"uiState.activeTab\">\n            <div block-api-error />\n\n            <div ng-switch-when=\"model\">\n                <div class=\"dkuform-horizontal\">\n                    <div class=\"control-group\">\n                        <label class=\"control-label\" for=\"presetId\">Preset</label>\n                        <div class=\"controls\">\n                            <div>\n                                <basic-select id=\"presetId\" required ng-model=\"tempModel.presetId\"\n                                                bind-label=\"displayName\" bind-value=\"presetId\" items=\"presetIdOptions\" ng-change=\"applyPreset()\" />\n                                <button ng-click=\"resetModel()\" class=\"btn btn--text btn--icon btn--secondary\" title=\"Reset to preset\" toggle=\"tooltip-right\"><i class=\"dku-icon-arrow-counter-clockwise-16\"></i></button>\n                            </div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-class=\"{'error': checkDuplicatedModelId()}\">\n                        <label class=\"control-label\" for=\"modelid\">Model ID</label>\n                        <div class=\"controls\">\n                            <div>\n                                <input id=\"modelid\" required type=\"text\" ng-model=\"tempModel.id\" ng-change=\"fixupNullValuesForTextInput('id')\"/>\n                                <i ng-if=\"getCustomModelWarningMessages()\" class=\"dku-icon-warning-fill-16 mleft8 warning-text-color dibvam\" data-html=\"true\" title=\"{{getCustomModelWarningMessages()}}\" toggle=\"tooltip-top\"/>\n                            </div>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\" for=\"hfid\">HuggingFace ID</label>\n                        <div class=\"controls\">\n                            <input id=\"hfid\" required type=\"text\" ng-model=\"tempModel.huggingFaceId\" ng-change=\"fixupNullValuesForTextInput('huggingFaceId')\" />\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label class=\"control-label\" for=\"displayName\">Model display name</label>\n                        <div class=\"controls\">\n                            <input id=\"displayName\" type=\"text\" ng-model=\"tempModel.displayName\" ng-change=\"fixupNullValuesForTextInput('displayName')\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'TOXICITY_DETECTION' || purpose === 'SUMMARIZATION'\">\n                        <label for=\"handlingMode\" class=\"control-label\">Model handling mode</label>\n                        <div class=\"controls\">\n                            <basic-select id=\"handlingMode\" required ng-model=\"tempModel.handlingMode\"\n                                            bind-label=\"displayName\" bind-value=\"rawValue\" items=\"supportedHandlingModes\" ng-disabled=\"supportedHandlingModes.length === 1\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"supportsLlmFineTuning && purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"finetunable\" class=\"control-label\">Can be fine-tuned</label>\n                        <div class=\"controls\">\n                            <label class=\"dku-toggle dku-toggle--yes-no\">\n                                <input id=\"finetunable\" type=\"checkbox\" ng-model=\"tempModel.canBeFineTuned\"/>\n                                <span></span>\n                            </label>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"supportsImageInputs\" class=\"control-label\">Supports image inputs</label>\n                        <div class=\"controls\">\n                            <label class=\"dku-toggle dku-toggle--yes-no\">\n                                <input id=\"supportsImageInputs\" type=\"checkbox\" ng-model=\"tempModel.supportsImageInputs\"/>\n                                <span></span>\n                            </label>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['GENERIC_COMPLETION'].includes(purpose)\">\n                        <label for=\"prompt-cost\" class=\"control-label\">Prompt cost</label>\n                        <div class=\"controls\">\n                            <input id=\"prompt-cost\" type=\"number\" min=\"0\" ng-model=\"tempModel.promptCost\"/>\n                            <span class=\"help-inline\">\n                                In $/1k tokens\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['GENERIC_COMPLETION'].includes(purpose)\">\n                        <label for=\"completion-cost\" class=\"control-label\">Completion cost</label>\n                        <div class=\"controls\">\n                            <input id=\"completion-cost\" type=\"number\" min=\"0\" ng-model=\"tempModel.completionCost\"/>\n                            <span class=\"help-inline\">\n                                In $/1k tokens\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"['TEXT_EMBEDDING_EXTRACTION'].includes(purpose)\">\n                        <label for=\"embedding-cost\" class=\"control-label\">Embedding cost</label>\n                        <div class=\"controls\">\n                            <input id=\"embedding-cost\" type=\"number\" min=\"0\" ng-model=\"tempModel.embeddingCost\"/>\n                            <span class=\"help-inline\">\n                                In $/1k tokens\n                            </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"inference\">\n                <div class=\"dkuform-horizontal\">\n                    <div class=\"control-group\" ng-if=\"['TEXT_EMBEDDING_EXTRACTION', 'GENERIC_COMPLETION'].includes(purpose)\">\n                        <label for=\"maxTokensLimit\" class=\"control-label\">\n                            <span>Max tokens</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"maxTokensLimit\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"tempModel.maxTokensLimit\" placeholder=\"Default model context length\"/>\n                            <span class=\"help-block mtop0\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                                Set the maximum number of tokens that can be processed in a single request (including both input and output). Reducing the context length can help avoid out-of-memory errors.\n                            </span>\n                            <span class=\"help-block mtop0\" ng-if=\"purpose === 'TEXT_EMBEDDING_EXTRACTION'\">\n                                Set the maximum number of tokens that can be processed in a single request.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION' && tempModel.supportsImageInputs\">\n                        <label for=\"limitImagesPerPrompt\" class=\"control-label\">\n                            <span>Max images per query</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"limitImagesPerPrompt\" type=\"number\" min=\"0\" step=\"1\" ng-model=\"tempModel.limitImagesPerPrompt\" placeholder=\"Use default value\"/>\n                            <span class=\"help-block mtop0\">\n                                Set the maximum number of images allowed in a single query. Reducing this parameter can help avoid out-of-memory errors with multimodal models.\n                            </span>\n                        </div>\n                    </div>\n            \n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"enableTools\" class=\"control-label\">\n                            Enable tools (experimental)\n                        </label>\n                        <div class=\"controls\">\n                            <label class=\"dku-toggle\">\n                                <input id=\"enableTools\" type=\"checkbox\" ng-model=\"tempModel.toolSettings.enableTools\"/>\n                                <span></span>\n                            </label>\n                            <span class=\"help-block mtop0\">\n                                Tools are not supported on all models. Please refer to vLLM documentation for more details.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION' && tempModel.toolSettings.enableTools\">\n                        <label class=\"control-label\" for=\"toolParser\">\n                            Tool parser\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"toolParser\" type=\"text\" required ng-model=\"tempModel.toolSettings.toolParser\" />\n                            <span class=\"help-block mtop0\">\n                                Required\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"overrideChatTemplate\" class=\"control-label\">\n                            Override chat template\n                        </label>\n                        <div class=\"controls\">\n                            <label class=\"dku-toggle\">\n                                <input id=\"overrideChatTemplate\" type=\"checkbox\" ng-model=\"tempModel.chatTemplateSettings.overrideChatTemplate\">\n                                <span></span>\n                            </label>\n                            <span class=\"help-block mtop0\">\n                                Overriding the default chat template is not recommended in general. However, some models require a custom chat template in order to support tool calling.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION' && tempModel.chatTemplateSettings.overrideChatTemplate\">\n                        <label class=\"control-label\" for=\"chatTemplate\">\n                            Chat template\n                        </label>\n                        <div class=\"controls\">\n                            <textarea id=\"chatTemplate\" rows=\"5\" ng-model=\"tempModel.chatTemplateSettings.chatTemplate\" />\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"trustRemoteCode\" class=\"control-label\">\n                            Trust remote code\n                        </label>\n                        <div class=\"controls\">\n                            <basic-select id=\"trustRemoteCode\" required ng-model=\"tempModel.trustRemoteCode\"\n                                            bind-label=\"displayName\" bind-value=\"rawValue\" items=\"trustRemoteCodeModes\"/>\n                            <span class=\"help-block mtop0\">\n                                Needed for some models. Use with caution, as it may allow execution of untrusted code.\n                            </span>\n                        </div>\n                    </div>\n            \n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"quantizationMode\" class=\"control-label\">\n                            Model quantization mode\n                            <i class=\"text-warning icon-dku-warning mleft4\" toggle=\"tooltip\" title=\"This setting currently disables the vLLM engine, which may result in performance and capability penalties. It is preferable to use 4 bit quantization or a pre-quantized model in a compatible format such as FP8, AWQ, GPTQ or BNB.\" ng-if=\"tempModel.quantizationMode == 'Q_8BIT'\"></i>\n                        </label>\n                        <div class=\"controls\">\n                            <basic-select id=\"quantizationMode\" required ng-model=\"tempModel.quantizationMode\"\n                                            bind-label=\"displayName\" bind-value=\"rawValue\" items=\"quantizationModes\"/>\n                            <span class=\"help-block mtop0\">\n                                Inflight quantization with bitsandbytes. Reduces the memory requirements to run large models on smaller GPUs, but may negatively impact performances.\n                            </span>\n                        </div>\n                    </div>\n\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"tensorParallelSize\" class=\"control-label\">\n                            <span>Tensor parallelism</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"tensorParallelSize\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"tempModel.tensorParallelSize\" placeholder=\"Use default value\"/>\n                            <span class=\"help-block mtop0\">\n                                Set the number of tensor parallel groups. Leave empty for auto-detection by DSS, set to 1 to disable, or enter a value greater than 1 to enforce a specific number.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"pipelineParallelSize\" class=\"control-label\">\n                            <span>Pipeline parallelism</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"pipelineParallelSize\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"tempModel.pipelineParallelSize\" placeholder=\"Use default value\"/>\n                            <span class=\"help-block mtop0\">\n                                Set the number of pipeline parallel groups. Leave empty for auto-detection by DSS, set to 1 to disable, or enter a value greater than 1 to enforce a specific number.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"enableExpertParallelism\" class=\"control-label\">\n                            Enable Expert Parallelism\n                        </label>\n                        <div class=\"controls\">\n                            <basic-select id=\"enableExpertParallelism\" required ng-model=\"tempModel.enableExpertParallelism\"\n                                            bind-label=\"displayName\" bind-value=\"rawValue\" items=\"enableExpertParallelismModes\"/>\n                            <span class=\"help-block mtop0\">\n                                In Mixture-of-Experts (MoE) models, allows for experts to be distributed over separate GPUs.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"gpuMemoryUtilization\" class=\"control-label\">\n                            <span>GPU memory utilization</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"gpuMemoryUtilization\" type=\"number\" min=\"0\" max=\"1\" step=\"0.01\" ng-model=\"tempModel.gpuMemoryUtilization\" placeholder=\"Use default value\"/>\n                            <span class=\"help-block mtop0\">\n                                This is an advanced setting of the vLLM engine (ignored when vLLM engine is disabled). Tune it with caution as it may result in performance degradation or engine failure.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label class=\"control-label\" for=\"dtype\">\n                            Weights data type\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"dtype\" type=\"text\" ng-model=\"tempModel.dtype\" placeholder=\"Use default value\" />\n                            <span class=\"help-block mtop0\">\n                                Data type for model weights and activations.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"enforceEager\" class=\"control-label\">\n                            Eager mode and CUDA graph\n                        </label>\n                        <div class=\"controls\">\n                            <basic-select id=\"enforceEager\" required ng-model=\"tempModel.enforceEager\"\n                                            bind-label=\"displayName\" bind-value=\"rawValue\" items=\"enforceEagerModes\"/>\n                            <span class=\"help-block mtop0\">\n                                Enabling CUDA graph improves inference speed but increases memory requirements. Enforcing eager mode can help avoid out-of-memory errors.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"purpose === 'GENERIC_COMPLETION'\">\n                        <label for=\"maxNumSeqs\" class=\"control-label\">\n                            <span>Max num. sequences</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"maxNumSeqs\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"tempModel.maxNumSeqs\" placeholder=\"Use default value\"/>\n                            <span class=\"help-block mtop0\">\n                                Set the maximum number of sequences that can be processed per iteration. Reducing this parameter value can help avoid out-of-memory errors, in particular with multimodal models.\n                            </span>\n                        </div>\n                    </div>\n\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"refiner\" class=\"control-label\">Refiner for SD-XL models (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"refiner\" type=\"text\" ng-model=\"tempModel.refinerId\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"defaultStrength\" class=\"control-label\">Refiner default Strength (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"defaultStrength\" type=\"number\" min=\"0.0\" step=\"0.01\" ng-model=\"tempModel.defaultStrength\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"defaultHeight\" class=\"control-label\">Default image height (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"defaultHeight\" type=\"number\" min=\"1\" ng-model=\"tempModel.defaultHeight\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"defaultWidth\" class=\"control-label\">Default image width (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"defaultWidth\" type=\"number\" min=\"1\" ng-model=\"tempModel.defaultWidth\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"defaultNumInferenceSteps\" class=\"control-label\">Default inference steps (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"defaultNumInferenceSteps\" type=\"number\" min=\"1\" step=\"1\" ng-model=\"tempModel.defaultNumInferenceSteps\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"defaultGuidanceScale\" class=\"control-label\">Default guidance scale (optional)</label>\n                        <div class=\"controls\">\n                            <input id=\"defaultGuidanceScale\" type=\"number\" min=\"0\" ng-model=\"tempModel.defaultGuidanceScale\"/>\n                        </div>\n                    </div>\n                    <div class=\"control-group\" ng-if=\"tempModel.handlingMode === 'IMAGE_GENERATION_DIFFUSION'\">\n                        <label for=\"maxSequenceLength\" class=\"control-label\">Max sequence length (only for Flux models)</label>\n                        <div class=\"controls\">\n                            <input id=\"maxSequenceLength\" type=\"number\" min=\"1\" ng-model=\"tempModel.maxSequenceLength\"/>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-switch-when=\"deployment\">\n                <div class=\"dkuform-horizontal\">\n                    <div class=\"container-selection\" container-selection-form=\"tempModel.containerSelection\" selection-label=\"'Container execution'\" inherited-from=\"'connection'\"></div>\n                    <div class=\"control-group\">\n                        <label for=\"min-kernel-count\" class=\"control-label\">\n                            <span>Min. model instances</span>\n                        </label>\n                        <div class=\"controls\">\n                            <input id=\"min-kernel-count\" type=\"number\" min=\"0\" placeholder=\"0\" ng-model=\"tempModel.minKernelCount\"/>\n                            <span class=\"help-block mtop0\">\n                                The minimum number of instances that DSS will keep running. This setting only applies if \"Reserved capacity\" is enabled.\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"max-kernel-count\" class=\"control-label\">Max. model instances</label>\n                        <div class=\"controls\">\n                            <input id=\"max-kernel-count\" type=\"number\" min=\"0\" placeholder=\"no max limit\" ng-model=\"tempModel.maxKernelCount\"/>\n                            <span ng-if=\"tempModel.minKernelCount == null || tempModel.maxKernelCount == null || tempModel.minKernelCount <= tempModel.maxKernelCount\" class=\"help-block mtop0\">\n                                This will limit the number of model instances that can be running at once.\n                            </span>\n                            <span ng-if=\"tempModel.minKernelCount != null && tempModel.maxKernelCount != null && tempModel.minKernelCount >  tempModel.maxKernelCount\" class=\"help-block mtop0 text-warning\">\n                                <i class=\"icon-dku-warning\" /> Minimum is greater than maximum!\n                            </span>\n                        </div>\n                    </div>\n                    <div class=\"control-group\">\n                        <label for=\"cuda-visible-devices\" class=\"control-label\">Cuda visible devices</label>\n                        <div class=\"controls\">\n                            <input id=\"cuda-visible-devices\" type=\"text\" placeholder=\"Empty (use all GPUs)\" ng-model=\"tempModel.cudaVisibleDevices\"/>\n                            <span class=\"help-block mtop0\">\n                                Set the CUDA_VISIBLE_DEVICES environment variable with a comma-separated list of GPU IDs (e.g., 0,1) to select specific GPUs. Leave this setting empty to use all available GPUs or for containerized execution.\n                            </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"modal-footer modal-footer-std-buttons\">\n            <button type=\"button\" class=\"btn btn--text btn--secondary\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"btn btn--text btn--primary\" ng-click=\"saveModel(); dismiss()\">{{ confirmText }}</button>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-huggingface-local-models-table.html", "<table class=\"table hf-model-table\">\n    <thead>\n        <tr>\n            <th>Model</th>\n            <th>Enabled</th>\n            <th>Status</th>\n            <th>Actions</th>\n        </tr>\n    </thead>\n    <tbody ng-repeat=\"(purpose, obj) in $ctrl.purposes\">\n        <tr class=\"collapse-purpose\">\n            <th colspan=\"4\" ng-click=\"collapsePurpose = !collapsePurpose\">\n                <i class=\"caret-icon\" ng-class=\"collapsePurpose ? 'icon-caret-right' : 'icon-caret-down'\"></i>&nbsp;{{ obj['categoryName'] }}\n            </th>\n        </tr>\n        <tr\n            ng-repeat=\"model in $ctrl.models\"\n            id=\"custom-hf-model-{{ $index }}\"\n            ng-if=\"$ctrl.isHandlingModeSupportedForPurpose(purpose, model.handlingMode) && !collapsePurpose\"\n            ng-class=\"model.enabled ? '' : 'row-disabled'\"\n            >\n            <td class=\"model\">\n                <span ng-if=\"model.displayName || model.id\">{{ model.displayName || model.id }}</span>\n                <span ng-if=\"!(model.displayName || model.id)\" class=\"text-weak\"><i>Empty name</i></span>\n                <i ng-if=\"$ctrl.getCustomModelWarningMessages(model)\" class=\"dku-icon-warning-fill-16 mleft8 warning-text-color dibvam\" data-html=\"true\" title=\"{{$ctrl.getCustomModelWarningMessages(model)}}\" toggle=\"tooltip-top\"/>\n                <a href=\"https://huggingface.co/{{ model.huggingFaceId }}\" target=\"_blank\" class=\"btn btn--text btn--icon btn--primary\" ng-click=\"$event.stopPropagation()\" toggle=\"tooltip\" title=\"View model {{ model.huggingFaceId }}\">\n                    <i class=\"dku-icon-arrow-external-link-16\"></i>\n                </a>\n                <copy-to-clipboard-icon icon-class=\"'btn btn--text btn--icon btn--primary'\" value=\"$ctrl.getEnrichedLLMId(model)\" name=\"'LLM ID'\" tooltip-position=\"'right'\"></copy-to-clipboard-icon>\n            </td>\n            <td class=\"fit-content\">\n                <label class=\"dku-toggle dku-toggle-mini dku-toggle-no-content\">\n                    <input type=\"checkbox\" ng-model=\"model.enabled\">\n                    <span></span>\n                </label>\n            </td>\n            <td class=\"status-column\" ng-bind-html=\"$ctrl.getHumanStatus(model.id)\"></td>\n            <td class=\"fit-content\">\n                <button type=\"button\" class=\"btn btn--text btn--icon btn--primary\" toggle=\"tooltip-bottom\" title=\"Status detail\" ng-click=\"$ctrl.openStatusModal(model)\"><i class=\"dku-icon-file-text-16\"></i></button>\n                <button type=\"button\" class=\"btn btn--text btn--icon btn--primary\" toggle=\"tooltip-bottom\" title=\"Edit\" ng-click=\"$ctrl.openEditModal(model, purpose)\"><i class=\"dku-icon-edit-16\"></i></button>\n                <button type=\"button\" class=\"btn btn--text btn--icon btn--danger\" toggle=\"tooltip-bottom\" title=\"Delete\" ng-click=\"$ctrl.delete($index)\"><i class=\"dku-icon-trash-16\"></i></button>\n            </td>\n        </tr>\n        <tr ng-if=\"!collapsePurpose\">\n            <td colspan=\"4\">\n                <button type=\"button\" class=\"btn btn--primary btn--text btn--dku-icon\" ng-click=\"$ctrl.addModelFromPresets(purpose)\"><i class=\"dku-icon-plus-16\"></i>&nbsp;Add model from preset</button>\n                <button type=\"button\" class=\"btn btn--primary btn--text btn--dku-icon\" ng-click=\"$ctrl.addCustomModel(purpose)\"><i class=\"dku-icon-plus-16\"></i>&nbsp;Add custom model</button>\n            </td>\n        </tr>\n    </tbody>\n</table>\n");
$templateCache.put("/templates/admin/connection-huggingface-local.html", "<div ng-controller=\"HuggingFaceLocalConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Authentication (only required for private models)</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"api-key-input\" class=\"control-label\">Hugging Face access token</label>\n                                    <div class=\"controls\">\n                                        <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\"/>\n                                    </div>\n                                </div>\n\n                                <hf-models-table\n                                    models=\"connection.params.models\"\n                                    kernels-status=\"kernelsStatus\"\n                                    preset-models=\"presetModels\"\n                                    api-key=\"connection.params.apiKey\"\n                                    supports-llm-fine-tuning=\"showFineTuningSettingsIfConnectionAllowsIt(connection.params.allowFinetuning, false)\"\n                                    connection-name=\"connection.name\"\n                                    presets=\"presets\"\n                                    facets=\"facets\"\n                                    update-status=\"updateStatus\"\n                                ></hf-models-table>\n                            </div>\n\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Runtime settings</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Cluster</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select type=\"text\" ng-model=\"connection.params.clusterId\" ng-options=\"c.id as c.name for c in k8sClusters\"/>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <div container-selection-form=\"connection.params.containerSelection\" selection-label=\"'Container execution'\" hide-inherit=\"true\"></div>\n                                    <!-- The next block is necessary because INHERIT is now deprecated in HF connection. Only NONE and EXPLICIT are supported -->\n                                    <div class=\"alert alert-warning\" ng-if=\"connection.params.containerSelection.containerMode == 'INHERIT'\">\n                                        <span>Please select a proper setting for container execution. Will default to local execution.</span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"useDSSModelCache\" class=\"control-label\">Use DSS-managed model cache</label>\n                                    <div class=\"controls\">\n                                        <input id=\"useDSSModelCache\" type=\"checkbox\" ng-model=\"connection.params.useDSSModelCache\"/>\n                                        <span class=\"help-inline\">\n                                            Use the DSS-managed model cache, rather than downloading models directly from Hugging Face.\n                                        </span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Code environment</label>\n                                    <div class=\"controls\">\n                                        <basic-select\n                                                class=\"placeholder-as-default-value\"\n                                                items=\"codeEnvItemsListWithDefault\"\n                                                bind-label=\"label\"\n                                                bind-value=\"value\"\n                                                placeholder=\"{{useInternalCodeEnvLabel}}\"\n                                                ng-model=\"connection.params.codeEnvName\"\n                                                searchable=\"true\"\n                                                invalidate-on-ghosts=\"true\"\n                                                ghost-items-tooltip=\"This code env has been deleted: re-create it or select another\"\n                                                ng-change=\"fixupNullishForDirtynessCheck()\"\n                                        ></basic-select>\n                                    </div>\n                                </div>\n                                <div class=\"alert alert-warning\" ng-if=\"showHFLocalCodeEnvWarning()\">\n                                    <span ng-if=\"!hfLocalCodeEnvIsInternal()\">It is recommended to use the dedicated internal code env for local Hugging Face models.</span>\n                                    <span ng-if=\"!hfLocalInternalCodeEnvExists()\">\n                                        <span ng-if=\"hfLocalCodeEnvIsInternal()\">The internal code env for local Hugging Face models has not been installed yet.</span>\n                                        <span ng-if=\"!mayCreateCodeEnvs()\">Contact your admin to install it.</span>\n                                        <span ng-if=\"mayCreateCodeEnvs()\"><a href=\"{{internalCodeEnvsHRef()}}\">Install it</a> in the Administration Settings.</span>\n                                    </span>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Reserved capacity settings</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"enable-reserve-capacity\" class=\"control-label\">Enable</label>\n                                    <div class=\"controls\">\n                                        <input id=\"enable-reserve-capacity\" type=\"checkbox\" ng-model=\"connection.params.enableReserveCapacity\" />\n                                        <span class=\"help-inline\">When enabled, DSS will keep model instances running according to model settings. This option may incur high costs as models will be running 24/7.</span>\n                                    </div>\n                                </div>\n\n                                <div class=\"alert alert-info\">\n                                    <p>Global max. model instances: <b>{{ globalMaxKernels }}</b> (edit this parameter <a href=\"/admin/general/genai/\">here</a>)</p>\n                                    <div ng-if=\"hasAtLeastOneReservedCapacity()\">\n                                        <p>Current minimum model instances for this connection (excludes disabled and improperly configured models):</p>\n                                        <ul>\n                                            <li ng-repeat=\"customModel in connection.params.models\" ng-if=\"isValidHFModel(customModel) && customModel.enabled && customModel.minKernelCount > 0\">\n                                                <b>{{ customModel.displayName || customModel.id }}</b>: {{ customModel.minKernelCount }}\n                                            </li>\n                                        </ul>\n                                    </div>\n                                    <div ng-if=\"!hasAtLeastOneReservedCapacity()\">\n                                        No reserved capacity set up on this connection. Configure reserved capacity by setting \"Min. model instances\" in individual model settings.\n                                    </div>\n                                </div>\n                                \n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-image-control.html\" />\n\n                                <h2 class=\"settings-section-title\" ng-if=\"showFineTuningSettings(false)\">Fine-tuning</h2>\n                                <div class=\"control-group\" ng-if=\"showFineTuningSettings(false)\">\n                                    <label for=\"allowFinetuning\" class=\"control-label\">Allow fine-tuning</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowFinetuning\" type=\"checkbox\" ng-model=\"connection.params.allowFinetuning\"/>\n                                        <span class=\"help-inline\">\n                                            Enable to allow models from this connection in the fine-tuning recipe.\n                                        </span>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Advanced tuning</h2>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                        </div>\n                    </form>\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n\n\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-jdbc.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n                            <div class=\"control-group\"\n                                form-template-element model=\"connection.params\"\n                                field=\"{name:'driver', type:'string', mandatory:true, label:'JDBC driver class'}\">\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">JDBC URL</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.jdbcurl\"\n                                           ng-required=\"true\"\n                                           placeHolder=\"jdbc:<VENDOR>://<HOST>/?<connection_params>\" />\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Displayed URL</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                           ng-required=\"false\"\n                                           placeHolder=\"jdbc:<VENDOR>://<HOST>/?<connection_params>\" />\n                                    <span class=\"help-inline\">Visible URL for the logs</span>\n                                </div>\n                            </div>\n\n \t\t\t\t\t\t\t<div class=\"control-group\" form-template-element model=\"connection.params\"\n                                 field=\"{name:'jarsDirectory',type:'string', mandatory:false, label:'Driver jars directory', tooltip:'Path to a directory containing the driver jars (The path can be absolute or relative to the DSS home directory). If empty, Jars must be copied in [DSS home]/lib/jdbc directory.',size:'xxlarge'}\" />\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">SQL dialect (experimental):</label>\n\n                                <div class=\"controls\">\n                                    <select dku-bs-select=\"{liveSearch:true}\"\n                                        ng-model=\"connection.params.dialectName\"\n                                        ng-options=\"c.value as c.label for c in dialects\">\n                                    </select>\n                                </div>\n                            </div>\n\n                            <div ng-if=\"connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">User</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.user\" />\n                                        <span class=\"help-inline\">\n                                            Optional. May also be defined using JDBC properties.\n                                        </span>\n                                    </div>\n                                </div>\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                        <span class=\"help-inline\">\n                                            Optional. May also be defined using JDBC properties.\n                                        </span>\n                                    </div>\n                                </div>\n                            </div>\n\n                           <div class=\"control-group\">\n                                <label class=\"control-label\">Can browse catalogs</label>\n\n                                <div class=\"controls\">\n                                    <input type=\"checkbox\" ng-model=\"connection.params.supportsBrowsingCatalogs\" />\n                                    <span class=\"help-inline\">Does the driver support listing multiple catalogs. When this is enabled, a catalog selector becomes available in the Database explorer</span>\n                                </div>\n                            </div>\n\n                            <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n\n                            <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                            <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Metastore source</label>\n                                    <div class=\"controls\">\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useAsMetastoreSource\" />\n                                        <span class=\"help-inline\">\n                                            Advanced usage\n                                        </span>\n                                    </div>\n                                </div>\n                        </div>\n\n                        <div class=\"span5\">\n                            <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                            <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                        </div>\n                    </div>\n                </form>\n                <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n\n</div>");
$templateCache.put("/templates/admin/connection-kafka.html", "<div ng-controller=\"KafkaConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n        \n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Bootstrap servers</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.bootstrapServers\"/>\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">Security</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Mode</label>\n                                    <div class=\"controls\">\n                                        <select dku-bs-select ng-model=\"connection.params.securityMode\" ng-options=\"m.id as m.label for m in securityModes\"></select>\n                                    </div>\n                                </div>\n                                <div ng-if=\"connection.params.securityMode == 'KERBEROS'\">\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Use DSS keytab</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input type=\"checkbox\" ng-model=\"connection.params.kerberosUseDSSKeytab\"/>\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" ng-if=\"!connection.params.kerberosUseDSSKeytab\">\n                                        <label class=\"control-label\">Kerberos principal</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.kerberosPrincipal\"/>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\" ng-if=\"!connection.params.kerberosUseDSSKeytab\">\n                                        <label class=\"control-label\">Kerberos keytab</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.kerberosKeytab\"/>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Kerberos service name</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.kerberosServiceName\"/>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div ng-if=\"connection.params.securityMode == 'SASL'\">\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">JAAS config</label>\n                                        <div class=\"controls\">\n                                            <textarea ng-model=\"connection.params.saslJAASConfig\" ui-codemirror=\"codeMirrorSettingService.get('text/plain')\"/>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Sasl mechanism</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.saslMechanism\"/>\n                                        </div>\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">SSL</h2>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Enable SSL</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.sslEnabled\"/>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div ng-if=\"connection.params.sslEnabled\">\n                                   <div class=\"control-group\">\n                                       <label class=\"control-label\">Truststore location</label>\n                                       <div class=\"controls\">\n                                           <input type=\"text\" ng-model=\"connection.params.sslTruststoreLocation\"/>\n                                       </div>\n                                   </div>\n                                   <div class=\"control-group\">\n                                       <label class=\"control-label\">Truststore password</label>\n                                       <div class=\"controls\">\n                                           <input type=\"password\" ng-model=\"connection.params.sslTruststorePassword\"/>\n                                       </div>\n                                   </div>\n                                   <div class=\"control-group\">\n                                       <label class=\"control-label\">Client authentication</label>\n                                       <div class=\"controls\">\n                                           <label>\n                                               <input type=\"checkbox\" ng-model=\"connection.params.sslClientAuth\"/>\n                                           </label>\n                                       </div>\n                                   </div>\n                                   <div class=\"control-group\" ng-if=\"connection.params.sslClientAuth\">\n                                       <label class=\"control-label\">Keystore location</label>\n                                       <div class=\"controls\">\n                                           <input type=\"text\" ng-model=\"connection.params.sslKeystoreLocation\"/>\n                                       </div>\n                                   </div>\n                                   <div class=\"control-group\" ng-if=\"connection.params.sslClientAuth\">\n                                       <label class=\"control-label\">Keystore password</label>\n                                       <div class=\"controls\">\n                                           <input type=\"password\" ng-model=\"connection.params.sslKeystorePassword\"/>\n                                       </div>\n                                   </div>\n                                   <div class=\"control-group\" ng-if=\"connection.params.sslClientAuth\">\n                                       <label class=\"control-label\">Key password</label>\n                                       <div class=\"controls\">\n                                           <input type=\"password\" ng-model=\"connection.params.sslKeyPassword\"/>\n                                       </div>\n                                   </div>\n                                </div>\n\n                                <div ng-if=\"showKsqlSettings()\">\n                                    <h2 class=\"settings-section-title\">KSQL</h2>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">KSQL server URL</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.ksqlConnectionParams.serverUrl\"/>\n                                            <span class=\"help-inline\">URL of a node of a KSQL cluster that is connected to the Kafka cluster</span>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <div class=\"control-label\">\n                                            <button type=\"button\" class=\"btn btn--secondary\" ng-click=\"testKsql()\" ng-disabled=\"!connection.params.ksqlConnectionParams.serverUrl\">Check KSQL settings</button>\n                                        </div>\n                                        <div class=\"controls\">\n                                            <div class=\"alert alert-success\" ng-if=\"testKsqlResult && testKsqlResult.ok\">\n                                                <span>\n                                                    Connection to KSQL OK, retrieved info\n                                                </span>\n                                                <pre class=\"debug\">{{testKsqlResult.info | json}}</pre>\n                                            </div>\n                                            <div class=\"alert alert-error\" ng-if=\"testKsqlResult && !testKsqlResult.ok\">\n                                                Connection to KSQL failed: {{testKsqlResult.message}}\n                                            </div>\n                                            <div ng-if=\"testingKsql\">\n                                                <i class=\"icon-spin icon-spinner\" />Please wait, testing KSQL connection\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">KSQL server version</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" ng-model=\"connection.params.ksqlConnectionParams.serverVersion\"/>\n                                            <span class=\"help-inline\">Used to determine whether to use pre-0.10 style ROWKEYs</span>\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Enable basic auth.</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input type=\"checkbox\" ng-model=\"connection.params.ksqlConnectionParams.basicAuthentication\"/>\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div ng-if=\"connection.params.ksqlConnectionParams.basicAuthentication\">\n                                       <div class=\"control-group\">\n                                           <label class=\"control-label\">User</label>\n                                           <div class=\"controls\">\n                                               <input type=\"text\" ng-model=\"connection.params.ksqlConnectionParams.basicAuthUser\"/>\n                                           </div>\n                                       </div>\n                                       <div class=\"control-group\">\n                                           <label class=\"control-label\">Password</label>\n                                           <div class=\"controls\">\n                                               <input type=\"password\" ng-model=\"connection.params.ksqlConnectionParams.basicAuthPassword\"/>\n                                           </div>\n                                       </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Enable SSL client auth.</label>\n                                        <div class=\"controls\">\n                                            <label>\n                                                <input type=\"checkbox\" ng-model=\"connection.params.ksqlConnectionParams.sslClientAuthEnabled\"/>\n                                            </label>\n                                        </div>\n                                    </div>\n                                    <div ng-if=\"connection.params.ksqlConnectionParams.sslClientAuthEnabled\">\n                                       <div class=\"control-group\">\n                                           <label class=\"control-label\">Keystore location</label>\n                                           <div class=\"controls\">\n                                               <input type=\"text\" ng-model=\"connection.params.ksqlConnectionParams.sslKeystoreLocation\"/>\n                                           </div>\n                                       </div>\n                                       <div class=\"control-group\">\n                                           <label class=\"control-label\">Keystore password</label>\n                                           <div class=\"controls\">\n                                               <input type=\"password\" ng-model=\"connection.params.ksqlConnectionParams.sslKeystorePassword\"/>\n                                           </div>\n                                       </div>\n                                       <div class=\"control-group\">\n                                           <label class=\"control-label\">Key password</label>\n                                           <div class=\"controls\">\n                                               <input type=\"password\" ng-model=\"connection.params.ksqlConnectionParams.sslKeyPassword\"/>\n                                           </div>\n                                       </div>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Advanced</h2>\n                                <div class=\"control-group\">\n                                    <label  class=\"control-label\">Additional Kafka properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.properties\"></ng2-connection-properties-list>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"span6\">\n                                <div class=\"control-group\">\n                                    <h2 class=\"settings-section-title\">Custom properties</h2>\n                                    <label  class=\"control-label\">Advanced connection properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                        <span class=\"help-inline\">For specific use cases</span>\n                                    </div>\n                                </div>\n\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                            </div>\n                        </div>\n\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n      <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n      <div>\n        <div ng-show=\"testing\" class=\"alert alert-info\">\n            <i class=\"icon-spin icon-spinner\" />Please wait, testing connection\n        </div>\n        <div ng-show=\"testResult\">\n            <div ng-show=\"!testResult.ok\" class=\"alert alert-error\">\n                <i class=\"icon-dku-error\" /> Connection to Kafka failed: {{testResult.message}}\n            </div>\n            <div ng-show=\"testResult.ok\" class=\"alert alert-success\">\n                <i class=\"icon-success\" /> Connection to Kafka OK, found {{testResult.topics.length}} topics\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("/templates/admin/connection-kdbplus.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span7\">\n                                <h2 class=\"settings-section-title\">Basic params</h2>\n\n                                <fieldset ng-if=\"connection.params.useURL != true\">\n                                    <div form-template-element\n                                    class=\"control-group\"\n                                    model=\"connection.params\"\n                                    field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n\n                                    <div form-template-element\n                                    class=\"control-group\"\n                                    model=\"connection.params\"\n                                    field=\"{name:'port',type:'int', mandatory:true, label:'Port'}\" />\n                                </fieldset>\n                                \n                                <fieldset ng-if=\"connection.params.useURL == true\">\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Connection URL</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" class=\"input-xlarge\" ng-model=\"connection.params.url\"\n                                            ng-required=\"true\"\n                                            placeHolder=\"jdbc:teradata://HOST/USER=USER,PASSWORD=PASSWORD,DATABASE=DB\" />\n                                        </div>\n                                    </div>\n                                    <div class=\"control-group\">\n                                        <label class=\"control-label\">Displayed URL</label>\n                                        <div class=\"controls\">\n                                            <input type=\"text\" class=\"input-xlarge\" ng-model=\"connection.params.displayedUrl\"\n                                            ng-required=\"false\"\n                                            placeHolder=\"jdbc:teradata://HOST/USER=USER,PASSWORD=****,DATABASE=DB\" />\n                                            <span class=\"help-inline\">Visible URL for the logs</span>\n                                        </div>\n                                    </div>\n                                </fieldset>\n\n\n                                <fieldset ng-if=\"connection.params.useURL != true\">\n                                    <fieldset ng-if=\"connection.credentialsMode == 'GLOBAL'\">\n                                        <div form-template-element\n                                        class=\"control-group\"\n                                        model=\"connection.params\"\n                                        field=\"{name:'user', type:'string', mandatory:false, label:'User'}\" />\n\n                                        <div class=\"control-group\">\n                                            <label for=\"\" class=\"control-label\">Password</label>\n                                            <div class=\"controls\">\n                                                <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                            </div>\n                                        </div>\n                                    </fieldset>\n                                </fieldset>\n\n                                <div class=\"control-group\">\n                                    <label  class=\"control-label\">Advanced JDBC properties</label>\n                                    <div class=\"controls\">\n                                        <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                            <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <h2 class=\"settings-section-title\">Advanced params</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Fetch size</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" ng-model=\"connection.params.fetchSize\" />\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/connection-post-connect-statements.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-sql-flags.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                            </div>\n\n                            <div class=\"span5\">\n                                <div include-no-scope=\"/templates/admin/fragments/sql-naming-rule.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n            </div>\n            <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n            </div>\n        </div>\n    </div>\n\n    <div class=\"small-lr-padding page-top-padding vertical-flex connection-page__connection-testing-section\">\n        <div class=\"vertical-flex h100\">\n            <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\"/>\n            <div class=\"vertical-flex oh\" include-no-scope=\"/templates/admin/fragments/sql-connection-test.html\"/>\n            <div include-no-scope=\"/templates/admin/fragments/connection-sql-mass-import.html\"/>\n        </div>\n    </div>\n\n</div>");
$templateCache.put("/templates/admin/connection-mistralai.html", "<div ng-controller=\"MistralAiConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"api-key-input\" class=\"control-label\">Mistral AI API key</label>\n                                    <div class=\"controls\">\n                                        <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\" />\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Text completion/chat models</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralSmall\" class=\"control-label\">Mistral small</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralSmall\" type=\"checkbox\" ng-model=\"connection.params.allowMistralSmall\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0001/1k tokens - Completion cost: $0.0003/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralMedium\" class=\"control-label\">Mistral medium</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralMedium\" type=\"checkbox\" ng-model=\"connection.params.allowMistralMedium\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.0004/1k tokens - Completion cost: $0.002/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralLarge\" class=\"control-label\">Mistral large</label>\n                                    <div class=\"controls\">\n                                        <label>\n                                            <input id=\"allowMistralLarge\" type=\"checkbox\" ng-model=\"connection.params.allowMistralLarge\" />\n                                            <span class=\"help-inline\">Prompt cost: $0.002/1k tokens - Completion cost: $0.006/1k tokens</span>\n                                        </label>\n                                    </div>\n                                </div>\n\n                                <h2 class=\"settings-section-title\">Text embedding models</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMistralEmbed\" class=\"control-label\">Mistral embed</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowMistralEmbed\" type=\"checkbox\" ng-model=\"connection.params.allowMistralEmbed\" />\n                                        <span class=\"help-inline\">Embedding cost: $0.0001/1k tokens</span>\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-custom-properties.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-mongodb.html", "<div ng-controller=\"MongoDBConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <h2 class=\"settings-section-title\">Connection</h2>\n\n                        <fieldset ng-show=\"!connection.params.useURI\">\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Host</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.host\" ng-required=\"!connection.params.useURI\"/>\n                                </div>\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Port</label>\n                                <div class=\"controls\">\n                                    <input type=\"number\" ng-model=\"connection.params.port\" ng-required=\"!connection.params.useURI\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Database</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.db\" ng-required=\"!connection.params.useURI\"/>\n                                </div>\n                            </div>\n\n                        </fieldset>\n\n                        <fieldset ng-show=\"connection.params.useURI\">\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Connection URI</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.uri\"\n                                    ng-required=\"connection.params.useURI\" placeHolder=\"mongodb://...\" />\n                                    <br>\n                                    <span class=\"help-inline\">\n                                        Must include database name\n                                        <a href=\"http://docs.mongodb.org/manual/reference/connection-string/\"\n                                        target=\"_blank\">Reference</a>\n                                    </span>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Displayed URL</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayURI\"\n                                    ng-required=\"connection.params.useURI\" placeHolder=\"mongodb://...\" />\n                                    <span class=\"help-inline\">Visible URL for the logs</span>\n                                </div>\n                            </div>\n                        </fieldset>\n                        <fieldset ng-show=\"connection.credentialsMode == 'GLOBAL'\">\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">User</label>\n                                <div class=\"controls\">\n                                    <input type=\"text\" ng-model=\"connection.params.user\"/>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Password</label>\n                                <div class=\"controls\">\n                                    <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\"/>\n                                </div>\n                            </div>\n                        </fieldset>\n                        <div class=\"control-group\">\n                            <label for=\"\" class=\"control-label\">Use advanced URI syntax</label>\n                            <div class=\"controls\">\n                                <label>\n                                    <input type=\"checkbox\" ng-model=\"connection.params.useURI\"/>\n                                    <span class=\"help-inline\">Allows to customize connection URI</span>\n                                </label>\n                            </div>\n                        </div>\n                        <div class=\"control-group\">\n                            <h2 class=\"settings-section-title\">Custom properties</h2>\n                            <label  class=\"control-label\">Advanced connection properties</label>\n                            <div class=\"controls\">\n                                <ng2-connection-properties-list [(items)]=\"connection.params.dkuProperties\" (on-validity-change)=\"setAdvancedConnectionPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                <span class=\"help-inline\">For specific use cases</span>\n                            </div>\n                        </div>\n                        <div include-no-scope=\"/templates/admin/fragments/connection-flags.html\" />\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                    <div include-no-scope=\"/templates/admin/fragments/connection-credentials-mode.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"noflex small-lr-padding page-top-padding\">\n        <div include-no-scope=\"/templates/admin/fragments/connection-name-test-save.html\" />\n        \n        <div ng-show=\"testing\" class=\"alert alert-info\"> <i class=\"icon-spin icon-spinner\" />Please wait, testing connection\n        </div>\n\n        <div ng-show=\"! connectionParamsForm.$invalid && testResult\">\n            <div ng-show=\"!testResult.connectionOK && !testResult.configOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed, configuration problem: {{testResult.configErrorMsg}}</span>\n            </div>\n            <div ng-show=\"!testResult.connectionOK && testResult.configOK\" class=\"alert alert-error\">\n                <span ng-show=\"testResult.connectionError\" summary-of-error=\"testResult.connectionError\" class=\"vertical-flex oh\"  />\n                <span ng-show=\"!testResult.connectionError\"><i class=\"icon-remove\" />Connection failed: {{testResult.connectionErrorMsg}}</span>\n            </div>\n            <div ng-show=\"testResult.connectionOK\" class=\"alert alert-success\">\n                <i class=\"icon-success\" />\n                Connection OK\n            </div>\n        </div>\n    </div>\n</div>");
$templateCache.put("/templates/admin/connection-mosaicml.html", "<div ng-controller=\"MosaicMLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"flex\">\n        <div class=\"fh oa\">\n            <div class=\"h100 small-lr-padding\">\n                <div class=\"generic-white-box\">\n                    <div class=\"alert alert-error\">\n                        MosaicML is not supported anymore. You should now use <a href=\"/admin/connections/new/DatabricksLLM/\" >Databricks Mosaic AI</a> instead.\n                    </div>\n                    <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                    <div block-api-error />\n                    <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                        <div class=\"row-fluid\">\n                            <div class=\"span6\">\n                                <h2 class=\"settings-section-title\">Connection</h2>\n                                <div class=\"control-group\">\n                                    <label for=\"api-key-input\" class=\"control-label\">MosaicML API key</label>\n                                    <div class=\"controls\">\n                                        <input id=\"api-key-input\" type=\"password\" ng-model=\"connection.params.apiKey\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMPT7BInstruct\" class=\"control-label\">MPT 7B Instruct</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowMPT7BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMPT7BInstruct\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowMPT30BInstruct\" class=\"control-label\">MPT 30B Instruct</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowMPT30BInstruct\" type=\"checkbox\" ng-model=\"connection.params.allowMPT30BInstruct\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label for=\"allowLLAMA270BChat\" class=\"control-label\">Llama2 70B Chat</label>\n                                    <div class=\"controls\">\n                                        <input id=\"allowLLAMA270BChat\" type=\"checkbox\" ng-model=\"connection.params.allowLLAMA270BChat\" />\n                                        <span class=\"help-inline\">\n                                            See license in MosaicML documentation\n                                        </span>\n                                    </div>\n                                </div>\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-tuning.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/connection-global-proxy.html\" />\n                            </div>\n                            <div class=\"span6\">\n                                <div include-no-scope=\"/templates/admin/fragments/connection-flags-security-only.html\" />\n                                <div include-no-scope=\"/templates/admin/fragments/llm-connection-usage-control.html\" />\n                            </div>\n                        </div>\n                    </form>\n                    <div include-no-scope=\"/templates/admin/cloud-source-ips.html\" />\n                </div>\n                <div class=\"generic-white-box mtop20\" ng-if=\"appConfig.customFieldsMap['CONNECTION'].length > 0\">\n                    <div include-no-scope=\"/templates/admin/fragments/connection-custom-fields.html\" />\n                </div>\n            </div>\n        </div>\n    </div>\n    <div include-no-scope=/templates/admin/fragments/llm-connections-error-handler.html />\n</div>\n");
$templateCache.put("/templates/admin/connection-mysql.html", "<div ng-controller=\"SQLConnectionController\" class=\"h100 vertical-flex\">\n    <div class=\"oa vertical-flex\">\n        <div class=\"w100 small-lr-padding\">\n            <div class=\"generic-white-box\">\n                <div include-no-scope=\"/templates/admin/fragments/connection-name.html\" />\n                <div block-api-error />\n\n                <form name=\"connectionParamsForm\" class=\"dkuform-horizontal\">\n                    <div class=\"row-fluid\">\n                        <div class=\"span7\">\n\n                            <h2 class=\"settings-section-title\">Basic params</h2>\n                            <div ng-if=\"connection.params.useURL != true\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'host',type:'string', mandatory:true, label:'Host'}\" />\n                                <div class=\"alert alert-warning\" ng-show=\"checkForHttpInHostUrl(connection.params.host)\">\n                                    Host should not contain a http(s):// prefix.\n                                </div>\n\n                                <div ng-if=\"connection.type != 'SAPHANA'\" sclass=\"control-group\" form-template-element model=\"connection.params\"\n                                    field=\"{name:'db', type:'string', mandatory:true, label:'Database', tooltip:'Mandatory'}\"\n                                />\n\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Port</label>\n                                    <div class=\"controls\">\n                                        <input type=\"number\" min=\"1\" max=\"65535\" ng-model=\"connection.params.port\"/>\n                                    </div>\n                                </div>\n                            </div>\n                            <div ng-if=\"connection.params.useURL == true\">\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Connection URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.url\"\n                                        ng-required=\"true\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                    </div>\n                                </div>\n                                <div class=\"control-group\">\n                                    <label class=\"control-label\">Displayed URL</label>\n                                    <div class=\"controls\">\n                                        <input type=\"text\" class=\"input-xxlarge\" ng-model=\"connection.params.displayedUrl\"\n                                        ng-required=\"false\"\n                                        placeHolder=\"jdbc:DRIVER://HOST:PORT/DB\" />\n                                        <span class=\"help-inline\">Visible URL for the logs</span>\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div ng-if=\"connection.credentialsMode == 'GLOBAL'\">\n                                <div class=\"control-group\" form-template-element model=\"connection.params\"\n                                field=\"{name:'user', type:'string', mandatory:connection.params.useURL != true, label:'User'}\" />\n\n                                <div class=\"control-group\">\n                                    <label for=\"\" class=\"control-label\">Password</label>\n                                    <div class=\"controls\">\n                                        <input type=\"password\" ng-model=\"connection.params.password\" autocomplete=\"new-password\" />\n                                    </div>\n                                </div>\n                            </div>\n\n                            <div class=\"control-group\">\n                                <label class=\"control-label\">Advanced JDBC properties</label>\n                                <div class=\"controls\">\n                                    <ng2-connection-properties-list [(items)]=\"connection.params.properties\" (on-validity-change)=\"setAdvancedPropertiesValidity($event)\"></ng2-connection-properties-list>\n                                </div>\n                            </div>\n                            <div class=\"control-group\">\n                                <label for=\"\" class=\"control-label\">Use custom JDBC URL</label>\n                                <div class=\"controls\">\n                                    <label>\n                                        <input type=\"checkbox\" ng-model=\"connection.params.useURL\"/>\n                                        <span class=\"help-inline\">Used to customize JDBC connection URL</span>\n                                    </label>\n                                </div>\n                            </div>\n\n                            <h2 class=\"settings-section-title\">Advanced params</h2>\n                            <div class=\"control-group\">\n                                <l