###############################################################
# Manage model cache commands
###############################################################

import os


def import_model_archive_in_cache(cmdargs, apiclient):
    model_archive_abs_path = os.path.abspath(cmdargs.model_archive)
    print("Importing model from %s" % model_archive_abs_path)
    resp = apiclient.import_model_archive_in_cache(model_archive_abs_path)
    print(resp)
    print("OK")


def declare_model_archive_import_in_cache(subparsers, apiclient):
    p = subparsers.add_parser("__import-model-archive-in-cache", help="Imports a model to the instance model cache")
    p.add_argument("model_archive")
    p.set_defaults(func=import_model_archive_in_cache, apiclient=apiclient)


def clear_model_cache(cmdargs, apiclient):
    print("Clearing model cache")
    apiclient.clear_model_cache()
    print("OK")


def declare_clear_model_cache(subparsers, apiclient):
    p = subparsers.add_parser("__clear-model-cache", help="Clears the model cache")
    p.set_defaults(func=clear_model_cache, apiclient=apiclient)


def clean_code_env_cache(cmdargs, apiclient):
    apiclient.clean_code_env_cache()


def declare_clean_code_env_cache(subparsers, apiclient):
    p = subparsers.add_parser("__clean-code-env-cache", help="Delete unused entries from code env cache")
    p.set_defaults(func=clean_code_env_cache, apiclient=apiclient)
