import numpy as np
from scipy import spatial

def score(eval_df, ref_df, model_parameters, **kwargs):
    """
    Computes data drift on 'some_numerical_column' using Jensen-Shannon distance.
    """
    
    # Sample from the evaluation dataset
    evaluation_sample = eval_df['some_numerical_column']
    
    # Sample from the reference dataset
    reference_sample = ref_df['some_numerical_column']
    
    # Create decile distributions:
    num_bins = 10
    min_edge = min(evaluation_sample.min(), reference_sample.min())
    max_edge = max(evaluation_sample.max(), reference_sample.max())
    evaluation_distribution, _ = np.histogram(evaluation_sample, bins=num_bins, range=(min_edge, max_edge))
    reference_distribution, _ = np.histogram(reference_sample, bins=num_bins, range=(min_edge, max_edge))
    
    # Use scipy's implementation of Jensen-Shannon. Normalisation will be done automatically
    return spatial.distance.jensenshannon(evaluation_distribution, reference_distribution)