CREATE FUNCTION jsonb_element_to_jsonb_array_or_empty(input_element jsonb)
RETURNS jsonb AS $$
BEGIN
    IF input_element is NULL OR jsonb_typeof(input_element) = 'null' THEN
        RETURN '[]'::jsonb;
    ELSIF jsonb_typeof(input_element) = 'array' THEN
        RETURN input_element;
    ELSE
        RETURN jsonb_build_array(input_element);
    END IF;
END;
$$ LANGUAGE plpgsql;