#!/bin/bash -e
# Returns the default Python interpreter for this platform

MYDIR=$(cd "$(dirname "$0")" && pwd -P)

detectedDistrib=$("$MYDIR"/_find-distrib.sh 2>/dev/null || echo "unknown unknown")
read distrib distribVersion <<< "$detectedDistrib"

case "$distrib" in
    debian)
        case "$distribVersion" in
            11*) echo "python3.9"; exit;;
            12*) echo "python3.11"; exit;;
        esac;;
    ubuntu)
        case "$distribVersion" in
            "20.04") echo "python3.9"; exit;;
            "22.04") echo "python3.10"; exit;;
        esac;;
    centos | redhat | oraclelinux | almalinux | rocky)
        case "$distribVersion" in
            [89]*) echo "python3.9"; exit;;
        esac;;
    amazonlinux)
        case "$distribVersion" in
            2 | 2023) echo "python3.9"; exit;;
        esac;;
    suse)
        case "$distribVersion" in
            15*) echo "python3.11"; exit;;
        esac;;
    osx)
        echo "/usr/bin/python3"; exit;;
esac
echo "python3"
