/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop.azure;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.log4j.Logger;

public class RemoteDSSOAuth2Provider
implements CustomTokenProviderAdaptee {
    private static Logger logger = Logger.getLogger(RemoteDSSOAuth2Provider.class);
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final String CONFIG_ACCESS_TOKEN_INITIAL_REFRESH = "fs.azure.account.oauth2.access.token.force.initial.refresh";
    public static final String CONFIG_ACCESS_TOKEN = "fs.azure.account.oauth2.access.token";
    public static final String CONFIG_ACCESS_TOKEN_EXPIRES_ON = "fs.azure.account.oauth2.access.token.expires.on";
    public static final String CONFIG_CONNECTION_NAME = "fs.azure.account.oauth2.dss.connection.name";
    public static final String CONFIG_PROJECT_KEY = "fs.azure.account.oauth2.dss.project.key";
    private Configuration config;
    private String accountName;
    private AzureADToken token;

    public RemoteDSSOAuth2Provider() {
        logger.info((Object)"Getting access tokens from remote DSS");
    }

    private String getProp(String key, String def) {
        String val = this.getProp(key);
        if (val == null || val.isEmpty()) {
            return def;
        }
        return val;
    }

    private String getProp(String key) {
        if (this.config == null) {
            return null;
        }
        String val = null;
        if (this.accountName != null && !this.accountName.isEmpty()) {
            String specificKey = key + "." + this.accountName;
            val = this.config.get(specificKey);
        }
        if (val == null) {
            val = this.config.get(key);
        }
        return val;
    }

    public void initialize(Configuration configuration, String accountName) throws IOException {
        this.config = configuration;
        this.accountName = accountName;
        logger.info((Object)("Config set, account name is " + accountName));
        if (this.config != null && !"true".equals(this.getProp(CONFIG_ACCESS_TOKEN_INITIAL_REFRESH)) && this.getProp(CONFIG_ACCESS_TOKEN, "").length() > 0) {
            logger.info((Object)"Starting with token from config");
            String accessTokenValue = this.getProp(CONFIG_ACCESS_TOKEN);
            long accessTokenExpiresOn = -1L;
            try {
                accessTokenExpiresOn = Long.parseLong(this.getProp(CONFIG_ACCESS_TOKEN_EXPIRES_ON, "-1"));
            }
            catch (Exception e) {
                logger.warn((Object)"Invalid token expiration value", (Throwable)e);
            }
            this.token = new AzureADToken();
            this.token.setAccessToken(accessTokenValue);
            this.token.setExpiry(new Date(accessTokenExpiresOn));
        }
    }

    public String getAccessToken() throws IOException {
        return this.getFreshToken().getAccessToken();
    }

    public Date getExpiryTime() {
        return this.getFreshToken().getExpiry();
    }

    private AzureADToken getFreshToken() {
        if (this.token != null) {
            long approximatelyNow = System.currentTimeMillis() + 300000L;
            if (this.token.getExpiry().getTime() >= approximatelyNow) {
                return this.token;
            }
        }
        String connectionName = this.getProp(CONFIG_CONNECTION_NAME);
        String projectKey = this.getProp(CONFIG_PROJECT_KEY, "__DKU_ANY_PROJECT__");
        try {
            Class<?> cloudStorageConnectionClazz;
            try {
                cloudStorageConnectionClazz = this.getClass().getClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            catch (ClassNotFoundException e2) {
                logger.warn((Object)"Class not found in hadoop's classloader");
                cloudStorageConnectionClazz = Thread.currentThread().getContextClassLoader().loadClass("com.dataiku.dip.connections.AbstractCloudStorageConnection");
            }
            Method refreshCredentialsMethod = cloudStorageConnectionClazz.getDeclaredMethod("refreshCredentials", String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            JsonObject creds = (JsonObject)refreshCredentialsMethod.invoke(null, connectionName, projectKey, true, true);
            logger.info((Object)"Retrieved creds from remote");
            AzureADToken newToken = new AzureADToken();
            newToken.setAccessToken(creds.get("oauth2AccessToken").getAsString());
            newToken.setExpiry(new Date(creds.get("oauth2AccessTokenExpiresOn").getAsLong()));
            this.token = newToken;
            return this.token;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't access remote creds", e);
        }
    }
}

