/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kafka010;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenSparkConf$;
import org.apache.spark.kafka010.KafkaTokenUtil;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00014QAB\u0004\u0001\u0013=AQA\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005B!BQ\u0001\u000e\u0001\u0005BUBQa\u0015\u0001\u0005BQCQa\u0015\u0001\u0005\ni\u0013AdS1gW\u0006$U\r\\3hCRLwN\u001c+pW\u0016t\u0007K]8wS\u0012,'O\u0003\u0002\t\u0013\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h'\u0011\u0001\u0001C\u0006\u000f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\"$D\u0001\u0019\u0015\tI\u0012\"\u0001\u0005tK\u000e,(/\u001b;z\u0013\tY\u0002DA\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s!\ti\u0002%D\u0001\u001f\u0015\ty\u0012\"\u0001\u0005j]R,'O\\1m\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\n\t\u0003M\u0001i\u0011aB\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW-F\u0001*!\tQ\u0013G\u0004\u0002,_A\u0011AFE\u0007\u0002[)\u0011afI\u0001\u0007yI|w\u000e\u001e \n\u0005A\u0012\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001\r\n\u0002-=\u0014G/Y5o\t\u0016dWmZ1uS>tGk\\6f]N$BA\u000e\u001fG\u0019B\u0019\u0011cN\u001d\n\u0005a\u0012\"AB(qi&|g\u000e\u0005\u0002\u0012u%\u00111H\u0005\u0002\u0005\u0019>tw\rC\u0003>\u0007\u0001\u0007a(\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t\r|gN\u001a\u0006\u0003\u0007.\ta\u0001[1e_>\u0004\u0018BA#A\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")qi\u0001a\u0001\u0011\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003\u0013*k\u0011!C\u0005\u0003\u0017&\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000b5\u001b\u0001\u0019\u0001(\u0002\u000b\r\u0014X\rZ:\u0011\u0005=\u000bV\"\u0001)\u000b\u0005e\u0011\u0015B\u0001*Q\u0005-\u0019%/\u001a3f]RL\u0017\r\\:\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u001c(+Z9vSJ,G\rF\u0002V1f\u0003\"!\u0005,\n\u0005]\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000f\u0012\u0001\r\u0001\u0013\u0005\u0006{\u0011\u0001\rA\u0010\u000b\u0003+nCQ\u0001X\u0003A\u0002u\u000b1b\u00197vgR,'oQ8oMB\u0011aEX\u0005\u0003?\u001e\u0011QcS1gW\u0006$vn[3o\u00072,8\u000f^3s\u0007>tg\r")
public class KafkaDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String serviceName() {
        return "kafka";
    }

    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        ObjectRef lowestNextRenewalDate = ObjectRef.create((Object)None$.MODULE$);
        try {
            KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(sparkConf).foreach((Function1 & Serializable & scala.Serializable)clusterConf -> {
                KafkaDelegationTokenProvider.$anonfun$obtainDelegationTokens$1(this, sparkConf, creds, lowestNextRenewalDate, clusterConf);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get token cluster configuration", e);
            }
            throw throwable;
        }
        return (Option)lowestNextRenewalDate.elem;
    }

    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        boolean bl;
        try {
            bl = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(sparkConf).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)this.delegationTokensRequired(x$2)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get token cluster configuration", e);
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean delegationTokensRequired(KafkaTokenClusterConf clusterConf) {
        String string = clusterConf.securityProtocol();
        String string2 = SecurityProtocol.SASL_SSL.name;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = clusterConf.securityProtocol();
        String string4 = SecurityProtocol.SSL.name;
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = clusterConf.securityProtocol();
        String string6 = SecurityProtocol.SASL_PLAINTEXT.name;
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$obtainDelegationTokens$1(KafkaDelegationTokenProvider $this, SparkConf sparkConf$1, Credentials creds$1, ObjectRef lowestNextRenewalDate$1, KafkaTokenClusterConf clusterConf) {
        try {
            if ($this.delegationTokensRequired(clusterConf)) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Attempting to fetch Kafka security token for cluster ").append(clusterConf.identifier()).append(".").toString());
                Tuple2<Token<KafkaTokenUtil.KafkaDelegationTokenIdentifier>, Object> tuple2 = KafkaTokenUtil$.MODULE$.obtainToken(sparkConf$1, clusterConf);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Token token = (Token)tuple2._1();
                long nextRenewalDate = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2((Object)token, (Object)BoxesRunTime.boxToLong((long)nextRenewalDate));
                Token token2 = (Token)tuple22._1();
                long nextRenewalDate2 = tuple22._2$mcJ$sp();
                creds$1.addToken(token2.getService(), token2);
                if (((Option)lowestNextRenewalDate$1.elem).isEmpty() || nextRenewalDate2 < BoxesRunTime.unboxToLong((Object)((Option)lowestNextRenewalDate$1.elem).get())) {
                    lowestNextRenewalDate$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)nextRenewalDate2));
                }
            } else {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Cluster ").append(clusterConf.identifier()).append(" does not require delegation token, skipping.").toString());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Failed to get token from service: ").append($this.serviceName()).append(" due to ").append(e).append(" on ").append("cluster: ").append(clusterConf.identifier()).append(". If ").append($this.serviceName()).append(" is not used, ").append("set spark.security.credentials.").append($this.serviceName()).append(".enabled to false").toString());
            }
            throw throwable;
        }
    }

    public KafkaDelegationTokenProvider() {
        Logging.$init$((Logging)this);
    }
}

