/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class NaiveBayesExample$ {
    public static NaiveBayesExample$ MODULE$;

    static {
        new NaiveBayesExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("NaiveBayesExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, data.randomSplit$default$2());
        Option option = Array$.MODULE$.unapplySeq((Object)rDDArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)rDDArray);
        }
        RDD training = (RDD)((SeqLike)option.get()).apply(0);
        RDD test = (RDD)((SeqLike)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        RDD training2 = (RDD)tuple2._1();
        RDD test2 = (RDD)tuple2._2();
        NaiveBayesModel model = NaiveBayes$.MODULE$.train(training2, 1.0, "multinomial");
        RDD predictionAndLabel = test2.map((Function1 & java.io.Serializable & Serializable)p -> new Tuple2.mcDD.sp(model.predict(p.features()), p.label()), ClassTag$.MODULE$.apply(Tuple2.class));
        double accuracy = 1.0 * (double)predictionAndLabel.filter((Function1 & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NaiveBayesExample$.$anonfun$main$2(x))).count() / (double)test2.count();
        model.save(sc, "target/tmp/myNaiveBayesModel");
        NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(sc, "target/tmp/myNaiveBayesModel");
        sc.stop();
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Tuple2 x) {
        return x._1$mcD$sp() == x._2$mcD$sp();
    }

    private NaiveBayesExample$() {
        MODULE$ = this;
    }
}

