/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.converters;

import com.amazonaws.glue.catalog.converters.BaseCatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.CatalogToHiveConverter;
import com.amazonaws.glue.catalog.converters.Hive3CatalogToHiveConverter;
import com.google.common.annotations.VisibleForTesting;
import org.apache.hive.common.util.HiveVersionInfo;

public class CatalogToHiveConverterFactory {
    private static final String HIVE_3_VERSION = "3.";
    private static CatalogToHiveConverter catalogToHiveConverter;

    public static CatalogToHiveConverter getCatalogToHiveConverter() {
        if (catalogToHiveConverter == null) {
            catalogToHiveConverter = CatalogToHiveConverterFactory.loadConverter();
        }
        return catalogToHiveConverter;
    }

    private static CatalogToHiveConverter loadConverter() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        if (hiveVersion.startsWith(HIVE_3_VERSION)) {
            return new Hive3CatalogToHiveConverter();
        }
        return new BaseCatalogToHiveConverter();
    }

    @VisibleForTesting
    static void clearConverter() {
        catalogToHiveConverter = null;
    }
}

