/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.auth;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.auth.DelegationTokenIOException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.service.AbstractService;

public abstract class AbstractDelegationTokenBinding
extends AbstractService {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String SERVICE_NAME = "DelegationTokenBinding";
    private final Text kind;
    protected SecretManager<DelegationTokenIdentifier> secretManager = new TokenSecretManager();
    private Text service;
    private GoogleHadoopFileSystemBase fileSystem;

    protected AbstractDelegationTokenBinding(Text kind) {
        this(SERVICE_NAME, kind);
    }

    protected AbstractDelegationTokenBinding(String name, Text kind) {
        super(name);
        this.kind = kind;
    }

    public Text getKind() {
        return this.kind;
    }

    public GoogleHadoopFileSystemBase getFileSystem() {
        return this.fileSystem;
    }

    public Text getService() {
        return this.service;
    }

    public abstract AccessTokenProvider deployUnbonded() throws IOException;

    public abstract AccessTokenProvider bindToTokenIdentifier(DelegationTokenIdentifier var1) throws IOException;

    public void bindToFileSystem(GoogleHadoopFileSystemBase fs, Text service) {
        this.fileSystem = Objects.requireNonNull(fs);
        this.service = Objects.requireNonNull(service);
    }

    public Token<DelegationTokenIdentifier> createDelegationToken(String renewer) throws IOException {
        Text renewerText = new Text();
        if (renewer != null) {
            renewerText.set(renewer);
        }
        DelegationTokenIdentifier tokenIdentifier = Objects.requireNonNull(this.createTokenIdentifier(renewerText), "Token identifier");
        Token token = new Token((TokenIdentifier)tokenIdentifier, this.secretManager);
        token.setKind(this.getKind());
        token.setService(this.service);
        ((GoogleLogger.Api)logger.atFine()).log("Created token %s with token identifier %s", (Object)token, (Object)tokenIdentifier);
        return token;
    }

    public abstract DelegationTokenIdentifier createTokenIdentifier(Text var1) throws IOException;

    public abstract DelegationTokenIdentifier createTokenIdentifier() throws IOException;

    public abstract DelegationTokenIdentifier createEmptyIdentifier();

    protected <T extends DelegationTokenIdentifier> T convertTokenIdentifier(DelegationTokenIdentifier identifier, Class<T> expectedClass) throws DelegationTokenIOException {
        if (identifier.getClass().equals(expectedClass)) {
            return (T)identifier;
        }
        throw DelegationTokenIOException.wrongTokenType(expectedClass, identifier);
    }

    protected class TokenSecretManager
    extends SecretManager<DelegationTokenIdentifier> {
        private final byte[] pwd = "not-a-password".getBytes(StandardCharsets.UTF_8);

        protected TokenSecretManager() {
        }

        protected byte[] createPassword(DelegationTokenIdentifier identifier) {
            return this.pwd;
        }

        public byte[] retrievePassword(DelegationTokenIdentifier identifier) throws SecretManager.InvalidToken {
            return this.pwd;
        }

        public DelegationTokenIdentifier createIdentifier() {
            return AbstractDelegationTokenBinding.this.createEmptyIdentifier();
        }
    }
}

