/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpMethod;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;

public final class Cors
implements Serializable {
    private static final long serialVersionUID = 3811576113627241235L;
    private final Integer maxAgeSeconds;
    private final ImmutableList<HttpMethod> methods;
    private final ImmutableList<Origin> origins;
    private final ImmutableList<String> responseHeaders;

    private Cors(Builder builder) {
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.methods = builder.methods;
        this.origins = builder.origins;
        this.responseHeaders = builder.responseHeaders;
    }

    public Integer getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public List<HttpMethod> getMethods() {
        return this.methods;
    }

    public List<Origin> getOrigins() {
        return this.origins;
    }

    public List<String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Builder toBuilder() {
        return Cors.newBuilder().setMaxAgeSeconds(this.maxAgeSeconds).setMethods(this.methods).setOrigins(this.origins).setResponseHeaders(this.responseHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.maxAgeSeconds, this.methods, this.origins, this.responseHeaders);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors)obj;
        return Objects.equals(this.maxAgeSeconds, other.maxAgeSeconds) && Objects.equals(this.methods, other.methods) && Objects.equals(this.origins, other.origins) && Objects.equals(this.responseHeaders, other.responseHeaders);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer maxAgeSeconds;
        private ImmutableList<HttpMethod> methods;
        private ImmutableList<Origin> origins;
        private ImmutableList<String> responseHeaders;

        private Builder() {
        }

        public Builder setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public Builder setMethods(Iterable<HttpMethod> methods) {
            this.methods = methods != null ? ImmutableList.copyOf(methods) : null;
            return this;
        }

        public Builder setOrigins(Iterable<Origin> origins) {
            this.origins = origins != null ? ImmutableList.copyOf(origins) : null;
            return this;
        }

        public Builder setResponseHeaders(Iterable<String> headers) {
            this.responseHeaders = headers != null ? ImmutableList.copyOf(headers) : null;
            return this;
        }

        public Cors build() {
            return new Cors(this);
        }
    }

    public static final class Origin
    implements Serializable {
        private static final long serialVersionUID = -3240120183350397818L;
        private static final String ANY_URI = "*";
        private final String value;
        private static final Origin ANY = new Origin("*");

        private Origin(String value) {
            this.value = Preconditions.checkNotNull(value);
        }

        public static Origin any() {
            return ANY;
        }

        public static Origin of(String scheme, String host, int port) {
            try {
                return Origin.of(new URI(scheme, null, host, port, null, null, null).toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static Origin of(String value) {
            if (ANY_URI.equals(value)) {
                return Origin.any();
            }
            return new Origin(value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Origin)) {
                return false;
            }
            Origin origin = (Origin)obj;
            return Objects.equals(this.value, origin.value);
        }

        public String toString() {
            return this.getValue();
        }

        public String getValue() {
            return this.value;
        }
    }
}

