/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.metastore;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hive.metastore.DSSCatalogMetastoreClientDelegate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.parser.FilterLexer;
import org.apache.hadoop.hive.metastore.parser.FilterParser;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class DSSCatalogHiveMetastoreClient
implements IMetaStoreClient {
    private static final Logger logger = Logger.getLogger(DSSCatalogHiveMetastoreClient.class);
    private final HiveConf conf;
    private final Warehouse wh;
    private final DSSCatalogMetastoreClientDelegate delegate;

    public DSSCatalogHiveMetastoreClient(HiveConf conf) throws MetaException {
        this(conf, null);
    }

    public DSSCatalogHiveMetastoreClient(HiveConf conf, HiveMetaHookLoader hook) throws MetaException {
        String apiServerCert;
        String apiProtocol;
        int apiPort;
        String apiHost;
        this.conf = conf;
        String apiPath = "dip/api/tintercom";
        Map env = RemoteRunEnvHelper.getEnvDef().env;
        try {
            String port;
            apiHost = (String)env.get("DKU_BACKEND_HOST");
            if (apiHost == null) {
                apiHost = InetAddress.getLocalHost().getHostName();
            }
            if ((port = (String)env.get("DKU_BACKEND_PORT")) == null) {
                port = "0";
            }
            apiPort = Integer.parseInt(port);
            apiProtocol = (String)env.get("DKU_BACKEND_PROTOCOL");
            if (apiProtocol == null) {
                apiProtocol = "http";
            }
            apiServerCert = (String)env.get("DKU_SERVER_CERT");
            logger.info((Object)("Init: not running in flow, backend port = " + apiPort));
        }
        catch (Exception e) {
            logger.error((Object)"Failure", (Throwable)e);
            throw new MetaException("init failed:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        logger.info((Object)("Init: api host = " + apiHost + " port = " + apiPort));
        ApplicationConfigurator.configureFromEnvNoConfig();
        String ticket = (String)env.get("DKU_API_TICKET");
        TicketBasedIntercomAPIClient client = new TicketBasedIntercomAPIClient(apiProtocol + "://" + apiHost + ":" + apiPort, apiServerCert, ticket);
        this.wh = new Warehouse((Configuration)this.conf);
        this.delegate = new DSSCatalogMetastoreClientDelegate(conf, client, this.wh);
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.delegate.createDatabase(database);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.delegate.getDatabase(name);
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return this.delegate.getDatabases(pattern);
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(".*");
    }

    public void alterDatabase(String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.delegate.alterDatabase(databaseName, database);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.delegate.dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("addPartition is not supported");
    }

    public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("addPartition is not supported");
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        throw new UnsupportedOperationException("addPartition is not supported");
    }

    public int add_partitions_pspec(PartitionSpecProxy pSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("add_partitions_pspec is not supported.");
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("alterFunction is not supported.");
    }

    public void alter_index(String dbName, String tblName, String indexName, Index index) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("Unsupported");
    }

    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alterPartitions is not supported");
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alterPartitions is not supported");
    }

    public void alter_table(String dbName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alterTable is not supported");
    }

    public void alter_table(String dbName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alterTable is not supported");
    }

    public Partition appendPartition(String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("appendPartition is not supported");
    }

    public Partition appendPartition(String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("appendPartition is not supported");
    }

    public boolean create_role(Role role) throws MetaException, TException {
        throw new UnsupportedOperationException("createRole is not supported");
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        throw new UnsupportedOperationException("dropRole is not supported");
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.delegate.listRoles(principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return this.delegate.listRoleNames();
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
        throw new UnsupportedOperationException("getPrincipalsInRole is not supported");
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
        throw new UnsupportedOperationException("getRoleGrantsForPrincipal is not supported");
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("grantRole is not supported");
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("revokeRole is not supported");
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("tokens management is not supported");
    }

    public String getTokenStrForm() throws IOException {
        throw new UnsupportedOperationException("tokens management is not supported");
    }

    public LockResponse checkLock(long lockId) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        throw new UnsupportedOperationException("locks management is not supported");
    }

    public void close() {
    }

    public void commitTxn(long txnId) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("txn management is not supported");
    }

    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        throw new UnsupportedOperationException("compact is unsupported");
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException("functions management is unsupported");
    }

    public void createIndex(Index index, Table indexTable) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException {
        throw new UnsupportedOperationException("createIndex is unsupported");
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.delegate.createTable(tbl);
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public void dropFunction(String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        throw new UnsupportedOperationException("dropFunction is unsupported");
    }

    public boolean dropIndex(String dbName, String tblName, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropIndex is unsupported");
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, PartitionDropOptions options) throws TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public boolean dropPartition(String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ignoreProtection, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.dropTable("default", tableName, deleteData, false);
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(dbname, tableName, true, true, false);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        this.dropTable(dbname, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("dropTable is not supported");
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("exchangePartition is unsupported");
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public List<String> getAllTables(String dbname) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, ".*");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
            throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
        }
        return this.conf.get(name, defaultValue);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        throw new UnsupportedOperationException("tokens management is unsupported");
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.delegate.getFields(db, tableName);
    }

    public Function getFunction(String dbName, String functionName) throws MetaException, TException {
        throw new UnsupportedOperationException("functions management is unsupported");
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        if (pattern.equals("*")) {
            pattern = ".*";
        }
        return this.delegate.getFunctions(dbName, pattern);
    }

    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getIndex is unsupported");
    }

    public String getMetaConf(String key) throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.getMetaConf((String)key);
        if (metaConfVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        return this.conf.get(key, metaConfVar.getDefaultValue());
    }

    public Partition getPartition(String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return this.delegate.getPartition(dbName, tblName, values);
    }

    public Partition getPartition(String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.delegate.getPartition(dbName, tblName, partitionName);
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public Partition getPartitionWithAuthInfo(String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition partition = this.getPartition(databaseName, tableName, values);
        Table table = this.getTable(databaseName, tableName);
        if ("TRUE".equalsIgnoreCase((String)table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), values);
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(databaseName);
            obj.setObjectName(tableName);
            obj.setPartValues(values);
            PrincipalPrivilegeSet privilegeSet = this.get_privilege_set(obj, userName, groupNames);
            partition.setPrivileges(privilegeSet);
        }
        return partition;
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return this.delegate.getPartitionsByNames(databaseName, tableName, partitionNames);
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.delegate.getSchema(db, tableName);
    }

    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.delegate.getTable(dbName, tableName);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList hiveTables = Lists.newArrayList();
        for (String tableName : tableNames) {
            hiveTables.add(this.getTable(dbName, tableName));
        }
        return hiveTables;
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return this.delegate.getTables(dbname, tablePattern);
    }

    public ValidTxnList getValidTxns() throws TException {
        throw new UnsupportedOperationException("txn management is unsupported");
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        throw new UnsupportedOperationException("txn management is unsupported");
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef obj, String user, List<String> groups) throws MetaException, TException {
        return this.delegate.getPrivilegeSet(obj, user, groups);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        throw new UnsupportedOperationException("privileges management is unsupported");
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("privileges management is unsupported");
    }

    public void heartbeat(long txnId, long lockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("heartbeat management is unsupported");
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        throw new UnsupportedOperationException("heartbeat management is unsupported");
    }

    public boolean isCompatibleWith(HiveConf conf) {
        return true;
    }

    public void setHiveAddedJars(String s) {
        throw new UnsupportedOperationException("setHiveAddedJars is not supported");
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("events management is unsupported");
    }

    public List<String> listIndexNames(String db_name, String tbl_name, short max) throws MetaException, TException {
        List<Index> indexes = this.listIndexes(db_name, tbl_name, max);
        ArrayList indexNames = Lists.newArrayList();
        for (Index index : indexes) {
            indexNames.add(index.getIndexName());
        }
        return indexNames;
    }

    public List<Index> listIndexes(String db_name, String tbl_name, short max) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("indexes management is unsupported");
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        try {
            return this.listPartitionNames(dbName, tblName, null, max);
        }
        catch (NoSuchObjectException e) {
            return Collections.emptyList();
        }
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws MetaException, TException, NoSuchObjectException {
        List<String> ret = this.delegate.listPartitionNames(databaseName, tableName, values, max);
        logger.info((Object)("Returning partition names: " + JSON.json(ret)));
        return ret;
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        throw new UnsupportedOperationException("listPartitionSpecs is unsupported");
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("listPartitionSpecsByFilter is unsupported");
    }

    public List<Partition> listPartitions(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(dbName, tblName, null, max);
    }

    public List<Partition> listPartitions(String databaseName, String tableName, List<String> values, short max) throws NoSuchObjectException, MetaException, TException {
        if (!(values == null || values.isEmpty() || values.size() == 1 && "".equals(values.get(0)))) {
            throw new UnsupportedOperationException("filtering partition list is not supported : " + JSON.json(values));
        }
        return this.delegate.getPartitions(databaseName, tableName, null, max);
    }

    public boolean listPartitionsByExpr(String databaseName, String tableName, byte[] expr, String defaultPartitionName, short max, List<Partition> result) throws TException {
        if (expr != null) {
            throw new UnsupportedOperationException("list partition by expr is not supported");
        }
        List<Partition> partitions = this.delegate.getPartitions(databaseName, tableName, null, max);
        result.addAll(partitions);
        return false;
    }

    private FilterParser getFilterParser(String filter) throws MetaException {
        FilterLexer lexer = new FilterLexer((CharStream)new ExpressionTree.ANTLRNoCaseStringStream(filter));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FilterParser parser = new FilterParser((TokenStream)tokens);
        try {
            parser.filter();
        }
        catch (RecognitionException re) {
            throw new MetaException("Error parsing partition filter; lexer error: " + lexer.errorMsg + "; exception " + String.valueOf((Object)re));
        }
        if (lexer.errorMsg != null) {
            throw new MetaException("Error parsing partition filter : " + lexer.errorMsg);
        }
        return parser;
    }

    public List<Partition> listPartitionsByFilter(String databaseName, String tableName, String filter, short max) throws MetaException, NoSuchObjectException, TException {
        logger.info((Object)("filter: " + filter));
        ExpressionTree et = filter != null && !filter.isEmpty() ? this.getFilterParser((String)filter).tree : ExpressionTree.EMPTY_TREE;
        logger.info((Object)("Resulting ET: " + String.valueOf(et)));
        return this.delegate.getPartitions(databaseName, tableName, et, max);
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, maxParts);
        for (Partition p : partitions) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            PrincipalPrivilegeSet set = this.get_privilege_set(obj, user, groups);
            p.setPrivileges(set);
        }
        return partitions;
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, List<String> partVals, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, partVals, maxParts);
        for (Partition p : partitions) {
            PrincipalPrivilegeSet set;
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            try {
                set = this.get_privilege_set(obj, user, groups);
            }
            catch (MetaException e) {
                logger.info((Object)String.format("No privileges found for user: %s, groups: [%s]", user, StringUtils.join(groups, (String)",")));
                set = new PrincipalPrivilegeSet();
            }
            p.setPrivileges(set);
        }
        return partitions;
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        throw new UnsupportedOperationException("listTableNamesByFilter is unsupported");
    }

    public List<HiveObjectPrivilege> list_privileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws MetaException, TException {
        throw new UnsupportedOperationException("privileges management is unsupported");
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException("locks management is unsupported");
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("events management is unsupported");
    }

    public long openTxn(String user) throws TException {
        throw new UnsupportedOperationException("txns management is unsupported");
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        throw new UnsupportedOperationException("txns management is unsupported");
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        if (name.length() == 0) {
            return new HashMap<String, String>();
        }
        return Warehouse.makeSpecFromName((String)name);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return DSSCatalogMetastoreClientDelegate.partitionNameToVals(name);
    }

    public void reconnect() throws MetaException {
        logger.debug((Object)"reconnect() was called.");
    }

    public void renamePartition(String dbName, String tblName, List<String> partitionValues, Partition newPartition) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("Renaming a partition is not supported");
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("tokens management is unsupported");
    }

    public void rollbackTxn(long txnId) throws NoSuchTxnException, TException {
        throw new UnsupportedOperationException("txn management is unsupported");
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
        HiveConf.ConfVars confVar = HiveConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        String validate = confVar.validate(value);
        if (validate != null) {
            throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + validate);
        }
        this.conf.set(key, value);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public ShowCompactResponse showCompactions() throws TException {
        throw new UnsupportedOperationException("compactions management is unsupported");
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException("dynamic partitions management is unsupported");
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        throw new UnsupportedOperationException("notifications management is unsupported");
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        throw new UnsupportedOperationException("notifications management is unsupported");
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        throw new UnsupportedOperationException("listeners management is unsupported");
    }

    public ShowLocksResponse showLocks() throws TException {
        throw new UnsupportedOperationException("locks management is unsupported");
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        throw new UnsupportedOperationException("txn management is unsupported");
    }

    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.delegate.tableExists(databaseName, tableName);
    }

    public void unlock(long lockId) throws NoSuchLockException, TxnOpenException, TException {
        throw new UnsupportedOperationException("locks management is unsupported");
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("statistics management is unsupported");
    }

    public void validatePartitionNameCharacters(List<String> part_vals) throws TException, MetaException {
        try {
            String partitionValidationRegex = this.conf.getVar(HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN);
            Pattern partitionValidationPattern = Strings.isNullOrEmpty((String)partitionValidationRegex) ? null : Pattern.compile(partitionValidationRegex);
            MetaStoreUtils.validatePartitionNameCharacters(part_vals, (Pattern)partitionValidationPattern);
        }
        catch (Exception e) {
            if (e instanceof MetaException) {
                throw (MetaException)((Object)e);
            }
            throw new MetaException(e.getMessage());
        }
    }

    public void abortTxns(List<Long> arg0) throws TException {
        throw new UnsupportedOperationException("abortTxns is not supported.");
    }

    public void addDynamicPartitions(long arg0, String arg1, String arg2, List<String> arg3, DataOperationType arg4) throws TException {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported.");
    }

    public void addForeignKey(List<SQLForeignKey> arg0) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("addForeignKey is not supported.");
    }

    public int addMasterKey(String arg0) throws MetaException, TException {
        throw new UnsupportedOperationException("addMasterKey is not supported.");
    }

    public void addPrimaryKey(List<SQLPrimaryKey> arg0) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("addPrimaryKey is not supported.");
    }

    public boolean addToken(String arg0, String arg1) throws TException {
        throw new UnsupportedOperationException("addToken is not supported.");
    }

    public void alter_partition(String arg0, String arg1, Partition arg2, EnvironmentContext arg3) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partition is not supported.");
    }

    public void alter_partitions(String arg0, String arg1, List<Partition> arg2, EnvironmentContext arg3) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partitions is not supported.");
    }

    public void alter_table_with_environmentContext(String arg0, String arg1, Table arg2, EnvironmentContext arg3) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_table_with_environmentContext is not supported.");
    }

    public boolean cacheFileMetadata(String arg0, String arg1, String arg2, boolean arg3) throws TException {
        throw new UnsupportedOperationException("cacheFileMetadata is not supported.");
    }

    public void clearFileMetadata(List<Long> arg0) throws TException {
        throw new UnsupportedOperationException("clearFileMetadata is not supported.");
    }

    public void compact(String arg0, String arg1, String arg2, CompactionType arg3, Map<String, String> arg4) throws TException {
        throw new UnsupportedOperationException("compact is not supported.");
    }

    public CompactionResponse compact2(String arg0, String arg1, String arg2, CompactionType arg3, Map<String, String> arg4) throws TException {
        throw new UnsupportedOperationException("compact2 is not supported.");
    }

    public void createTableWithConstraints(Table arg0, List<SQLPrimaryKey> arg1, List<SQLForeignKey> arg2) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("createTableWithConstraints is not supported.");
    }

    public void dropConstraint(String arg0, String arg1, String arg2) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("dropConstraint is not supported.");
    }

    public List<Partition> dropPartitions(String arg0, String arg1, List<ObjectPair<Integer, byte[]>> arg2, boolean arg3, boolean arg4) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    public List<Partition> exchange_partitions(Map<String, String> arg0, String arg1, String arg2, String arg3, String arg4) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("exchange_partitions is not supported.");
    }

    public void flushCache() {
        throw new UnsupportedOperationException("flushCache is not supported.");
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return new GetAllFunctionsResponse();
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        throw new UnsupportedOperationException("getAllTokenIdentifiers is not supported.");
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> arg0) throws TException {
        throw new UnsupportedOperationException("getFileMetadata is not supported.");
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> arg0, ByteBuffer arg1, boolean arg2) throws TException {
        throw new UnsupportedOperationException("getFileMetadataBySarg is not supported.");
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest arg0) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getForeignKeys is not supported.");
    }

    public String[] getMasterKeys() throws TException {
        throw new UnsupportedOperationException("getMasterKeys is not supported.");
    }

    public int getNumPartitionsByFilter(String arg0, String arg1, String arg2) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getNumPartitionsByFilter is not supported.");
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest arg0) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getPrimaryKeys is not supported.");
    }

    public List<TableMeta> getTableMeta(String arg0, String arg1, List<String> arg2) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("getTableMeta is not supported.");
    }

    public List<String> getTables(String arg0, String arg1, TableType arg2) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("getTables is not supported.");
    }

    public String getToken(String arg0) throws TException {
        throw new UnsupportedOperationException("getToken is not supported.");
    }

    public void insertTable(Table arg0, boolean arg1) throws MetaException {
        throw new UnsupportedOperationException("insertTable is not supported.");
    }

    public boolean isLocalMetaStore() {
        throw new UnsupportedOperationException("isLocalMetaStore is not supported.");
    }

    public boolean isSameConfObj(HiveConf arg0) {
        throw new UnsupportedOperationException("isSameConfObj is not supported.");
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest arg0) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionValues is not supported.");
    }

    public void putFileMetadata(List<Long> arg0, List<ByteBuffer> arg1) throws TException {
        throw new UnsupportedOperationException("putFileMetadata is not supported.");
    }

    public boolean removeMasterKey(Integer arg0) throws TException {
        throw new UnsupportedOperationException("removeMasterKey is not supported.");
    }

    public boolean removeToken(String arg0) throws TException {
        throw new UnsupportedOperationException("removeToken is not supported.");
    }

    public ShowLocksResponse showLocks(ShowLocksRequest arg0) throws TException {
        throw new UnsupportedOperationException("showLocks is not supported.");
    }

    public void updateMasterKey(Integer arg0, String arg1) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("updateMasterKey is not supported.");
    }
}

