/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class JsonWriter$
extends NativeFormatWriter {
    public static JsonWriter$ MODULE$;
    private final Logger logger;

    static {
        new JsonWriter$();
    }

    public Map<String, String> prepareSaveJsonDataset(DatasetHandler handler, org.apache.spark.sql.Dataset<Row> df) {
        block0: {
            if (!(handler instanceof HDFSableDatasetHandler)) break block0;
            HDFSableDatasetHandler hdfsable = (HDFSableDatasetHandler)handler;
            hdfsable.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
            hdfsable.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        }
        return Predef$.MODULE$.Map().empty();
    }

    public void saveJsonDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : null;
        SaveMode saveMode = HDFSDatasetRDD$.MODULE$.clearDataset(dataset, dssPartition, writeMode, apiTicket);
        String path = partition != null ? handler.getFullyQualifiedPartitionPath(dssPartition) : handler.getFullyQualifiedRootPath();
        Map<String, String> options = this.prepareSaveJsonDataset((DatasetHandler)handler, df);
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        this.logger().info((Object)new StringBuilder(28).append("Saving dataframe as json to ").append(path).toString());
        DataFrameWriter dswBuilder = dssDataframe.write().mode(saveMode);
        dswBuilder.options(options);
        dswBuilder.format("json").save(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            JsonWriter$.$anonfun$adaptDataFrame$1(dssDataframe, df, field);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ void $anonfun$adaptDataFrame$1(ObjectRef dssDataframe$1, org.apache.spark.sql.Dataset df$1, StructField field) {
        DataType dataType;
        DataType dataType2 = field.dataType();
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = field.dataType();
            DataType dataType4 = package$.MODULE$.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                return;
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = field.dataType()) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType))))))))))) {
            return;
        }
        if (dataType instanceof DecimalType) {
            MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as double").toString());
            dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$1.col(field.name()).cast((DataType)DoubleType$.MODULE$));
            return;
        }
        if (dataType instanceof DateType) {
            String tzId = TimeZone.getDefault().getID();
            MODULE$.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
            dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df$1.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
            return;
        }
        MODULE$.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as string").toString());
        dssDataframe$1.elem = ((org.apache.spark.sql.Dataset)dssDataframe$1.elem).withColumn(field.name(), df$1.col(field.name()).cast((DataType)StringType$.MODULE$));
    }

    private JsonWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.csv");
    }
}

