/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.compat;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.compat.DeserializeKafkaAvro;
import com.dataiku.dip.spark.compat.StructuredStreamingReader$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.streaming.endpoints.kafka.AvroKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;

public final class StructuredStreamingReader$ {
    public static StructuredStreamingReader$ MODULE$;
    private final Logger logger;

    static {
        new StructuredStreamingReader$();
    }

    public Dataset<Row> applyKafkaFormat(String input, Dataset<Row> df, String formatType, JsonObject formatParams, StructType sparkSchema, List<String> columnNames, Schema dssSchema, Map<String, String> kafkaOptions, boolean isKey) {
        StructType restrictedSparkSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkSchema.fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)columnNames.contains((Object)f.name()))));
        String string = formatType;
        if ("json".equals(string)) {
            String parsedCol = new StringBuilder(7).append(input).append("_parsed").toString();
            Dataset dfJsonParsed = df.withColumn(parsedCol, functions$.MODULE$.from_json(functions$.MODULE$.col(input).cast((DataType)StringType$.MODULE$), restrictedSparkSchema, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"FailFastMode")}))));
            return (Dataset)columnNames.foldLeft((Object)dfJsonParsed, (Function2 & Serializable & scala.Serializable)(d, columnName) -> d.withColumn(new StringBuilder(1).append(input).append("_").append((String)columnName).toString(), functions$.MODULE$.col(new StringBuilder(1).append(parsedCol).append(".").append((String)columnName).toString())));
        }
        if ("avro".equals(string)) {
            String parsedCol = new StringBuilder(7).append(input).append("_parsed").toString();
            AvroKafkaFormat.AvroKafkaFormatParams parsedFormatParams = (AvroKafkaFormat.AvroKafkaFormatParams)JSON.parse((JsonElement)formatParams, AvroKafkaFormat.AvroKafkaFormatParams.class);
            String avroSchemaJson = parsedFormatParams.getAvroSchema(dssSchema).toString(true);
            this.logger().info((Object)new StringBuilder(15).append("avroSchemaJson=").append(avroSchemaJson).toString());
            UserDefinedFunction from_kafka_avro = functions$.MODULE$.udf((UDF1)new DeserializeKafkaAvro(avroSchemaJson, kafkaOptions, isKey, restrictedSparkSchema), (DataType)restrictedSparkSchema);
            Dataset dfAvroParsed = df.withColumn(parsedCol, from_kafka_avro.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(input)})));
            return (Dataset)columnNames.foldLeft((Object)dfAvroParsed, (Function2 & Serializable & scala.Serializable)(d, columnName) -> d.withColumn(new StringBuilder(1).append(input).append("_").append((String)columnName).toString(), functions$.MODULE$.col(new StringBuilder(1).append(parsedCol).append(".").append((String)columnName).toString())));
        }
        if ("single".equals(string)) {
            SingleValueKafkaFormat.SingleValueKafkaFormatParams typedParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((JsonElement)formatParams, SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
            if (StringUtils.isBlank((String)typedParams.columnName)) {
                return df;
            }
            String outputCol = new StringBuilder(1).append(input).append("_").append(typedParams.columnName).toString();
            SingleValueKafkaFormat.KeyType keyType = typedParams.columnType;
            if (SingleValueKafkaFormat.KeyType.STRING.equals(keyType)) {
                return df.withColumn(outputCol, functions$.MODULE$.col(input).cast((DataType)StringType$.MODULE$));
            }
            if (SingleValueKafkaFormat.KeyType.LONG.equals(keyType)) {
                Function1 & Serializable & scala.Serializable deser = (Function1 & Serializable & scala.Serializable)x -> {
                    if (x == null) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)BoxesRunTime.boxToLong((long)Longs.fromByteArray((byte[])x)));
                };
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator1$4
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator1$4() {
                    }
                }
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator2$3
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator2$3() {
                    }
                }
                UserDefinedFunction deserUDF = functions$.MODULE$.udf((Function1)deser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator1$4()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator2$3()));
                return df.withColumn(outputCol, deserUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(input)})));
            }
            if (SingleValueKafkaFormat.KeyType.INTEGER.equals(keyType)) {
                Function1 & Serializable & scala.Serializable deser = (Function1 & Serializable & scala.Serializable)x -> {
                    if (x == null) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)Predef$.MODULE$.int2Integer(Ints.fromByteArray((byte[])x)));
                };
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator3$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("java.lang.Integer").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator3$2() {
                    }
                }
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator4$1() {
                    }
                }
                UserDefinedFunction deserUDF = functions$.MODULE$.udf((Function1)deser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator3$2()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator4$1()));
                return df.withColumn(outputCol, deserUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(input)})));
            }
            if (SingleValueKafkaFormat.KeyType.DOUBLE.equals(keyType)) {
                Function1 & Serializable & scala.Serializable deser = (Function1 & Serializable & scala.Serializable)x -> {
                    if (x == null) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)BoxesRunTime.boxToDouble((double)Double.longBitsToDouble(Longs.fromByteArray((byte[])x))));
                };
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator5$1() {
                    }
                }
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator6$1() {
                    }
                }
                UserDefinedFunction deserUDF = functions$.MODULE$.udf((Function1)deser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator5$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingReader$$typecreator6$1()));
                return df.withColumn(outputCol, deserUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(input)})));
            }
            if (SingleValueKafkaFormat.KeyType.BYTEARRAY.equals(keyType)) {
                return df.withColumn(outputCol, functions$.MODULE$.col(input).cast((DataType)BinaryType$.MODULE$));
            }
            throw new MatchError((Object)keyType);
        }
        return df;
    }

    public Dataset<Row> getStreamingReader(StreamingEndpoint se, String apiTicket) {
        SparkSession ss = SparkSession$.MODULE$.builder().getOrCreate();
        String string = se.getType();
        if ("kafka".equals(string)) {
            Tuple2<Map<String, String>, Map<String, String>> tuple2;
            KafkaStreamingEndpointParams params = (KafkaStreamingEndpointParams)new KafkaStreamingEndpointMeta().getExpandedParams(com.dataiku.dip.remoterun.package$.MODULE$.getProjectFromEnv(), se, KafkaStreamingEndpointParams.class);
            DataStreamReader dfBuilder = ss.readStream().format("kafka").option("timestampFormat", "yyyy/MM/dd HH:mm:ss ZZ").option("subscribe", params.topic);
            DSSConnection rawConn = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getConnection((AuthCtx)DSSAuthCtx.newNone(), params.connection);
            if (rawConn == null) {
                throw new Exception("Kafka connection details are not available in Spark driver: do you need to authorize it?");
            }
            KafkaConnection conn = (KafkaConnection)rawConn;
            Properties props = conn.buildBasicProperties((AuthCtx)DSSAuthCtx.newNone(), null);
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(params.consumerParams.properties).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)StructuredStreamingReader$.$anonfun$getStreamingReader$1(p)))).foreach((Function1 & Serializable & scala.Serializable)p -> props.put(p.key, StringUtils.defaultIfBlank((String)p.value, (String)"")));
            String string2 = "group.id";
            String string3 = "auto.offset.reset";
            String string4 = "enable.auto.commit";
            String string5 = "interceptor.classes";
            String string6 = "key.deserializer";
            String string7 = "key.serializer";
            String string8 = "value.deserializer";
            String string9 = "value.serializer";
            List excludedProperties = Nil$.MODULE$.$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2);
            Map kafkaOptions = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)StructuredStreamingReader$.$anonfun$getStreamingReader$3(excludedProperties, x$15))).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(6).append("kafka.").append(kv._1()).toString()), kv._2()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Map sparkOptions = Predef$.MODULE$.Map().empty();
            if (props.containsKey("auto.offset.reset") && ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest", "earliest"}))).contains((Object)props.getProperty("auto.offset.reset", ""))) {
                sparkOptions = sparkOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startingOffsets"), (Object)((String)props.get("auto.offset.reset"))));
            }
            if (ss.sqlContext().getConf("spark.dku.disable.failOnDataLoss", "").equals("true")) {
                sparkOptions = sparkOptions.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failOnDataLoss"), (Object)"false"));
            }
            if ((tuple2 = com.dataiku.dip.spark.compat.package$.MODULE$.addGroupIdProperties(props, (Map<String, String>)kafkaOptions, (Map<String, String>)sparkOptions)) == null) {
                throw new MatchError(tuple2);
            }
            Map kafkaOptionsWithGroupId = (Map)tuple2._1();
            Map sparkOptionsWithGroupId = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)kafkaOptionsWithGroupId, (Object)sparkOptionsWithGroupId);
            Map kafkaOptionsWithGroupId2 = (Map)tuple22._1();
            Map sparkOptionsWithGroupId2 = (Map)tuple22._2();
            kafkaOptions = kafkaOptionsWithGroupId2;
            sparkOptions = sparkOptionsWithGroupId2;
            this.logger().info((Object)new StringBuilder(38).append("Reading from kafka with spark options ").append(((TraversableOnce)sparkOptions.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append(kv._1()).append(" -> ").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            this.logger().info((Object)new StringBuilder(38).append("Reading from kafka with kafka options ").append(((TraversableOnce)kafkaOptions.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(4).append(kv._1()).append(" -> ").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            Dataset df = ((DataStreamReader)sparkOptions.$plus$plus((GenTraversableOnce)kafkaOptions).foldLeft((Object)dfBuilder, (Function2 & Serializable & scala.Serializable)(b, option) -> b.option((String)option._1(), (String)option._2()))).load();
            KafkaFormatDeserializer keyDeserializer = KafkaFormatsFactory.getDeserializer((String)params.keyFormatType, (JsonObject)params.keyFormatParams);
            KafkaFormatDeserializer valueDeserializer = KafkaFormatsFactory.getDeserializer((String)params.formatType, (JsonObject)params.formatParams);
            List schemaColumns = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(se.schema.getColumns()).asScala()).toList();
            StructType sparkSchema = package$.MODULE$.dkuToSpark((List<SchemaColumn>)schemaColumns);
            String[] timestampColumnNames = StringUtils.isNotBlank((String)params.timestampColumn) ? (String[])((Object[])new String[]{params.timestampColumn}) : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            Buffer keyColumnNames = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(keyDeserializer.columnNamesForSchema(se.schema)).asScala()).filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StructuredStreamingReader$.$anonfun$getStreamingReader$8(timestampColumnNames, n)));
            Buffer valueColumnNames = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(valueDeserializer.columnNamesForSchema(se.schema)).asScala()).filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StructuredStreamingReader$.$anonfun$getStreamingReader$9(timestampColumnNames, keyColumnNames, n)));
            this.logger().info((Object)new StringBuilder(15).append("keyColumnNames=").append(keyColumnNames.mkString(", ")).toString());
            this.logger().info((Object)new StringBuilder(17).append("valueColumnNames=").append(valueColumnNames.mkString(", ")).toString());
            this.logger().info((Object)new StringBuilder(21).append("timestampColumnNames=").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timestampColumnNames)).mkString(", ")).toString());
            Dataset dfRenamed = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("timestamp"), functions$.MODULE$.col("key").alias("_kafka_key"), functions$.MODULE$.col("value").alias("_kafka_value")}));
            Dataset<Row> dfKeyParsed = this.applyKafkaFormat("_kafka_key", (Dataset<Row>)dfRenamed, params.keyFormatType, params.keyFormatParams, sparkSchema, (List<String>)keyColumnNames.toList(), se.schema, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms()), true);
            Dataset<Row> dfKeyValueParsed = this.applyKafkaFormat("_kafka_value", dfKeyParsed, params.formatType, params.formatParams, sparkSchema, (List<String>)valueColumnNames.toList(), se.schema, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms()), false);
            Set keyOnlyColumnNames = (Set)keyColumnNames.toSet().diff((GenSet)valueColumnNames.toSet());
            Set valueOnlyColumnNames = (Set)valueColumnNames.toSet().diff((GenSet)keyColumnNames.toSet());
            Set keyAndValueColumnNames = (Set)valueColumnNames.toSet().intersect((GenSet)keyColumnNames.toSet());
            Column[] cols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timestampColumnNames)).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col("timestamp").as(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$plus$plus((GenTraversableOnce)keyOnlyColumnNames.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(new StringBuilder(11).append("_kafka_key_").append((String)c).toString()).as(c), Set$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$plus$plus((GenTraversableOnce)valueOnlyColumnNames.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(new StringBuilder(13).append("_kafka_value_").append((String)c).toString()).as(c), Set$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$plus$plus((GenTraversableOnce)keyAndValueColumnNames.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(11).append("_kafka_key_").append((String)c).toString()), functions$.MODULE$.col(new StringBuilder(13).append("_kafka_value_").append((String)c).toString())})).as(c), Set$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            return dfKeyValueParsed.select((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).toList());
        }
        return ss.readStream().format("com.dataiku.dip.spark.compat.RemoteStreamingSourceProvider").option("timestampFormat", "yyyy/MM/dd HH:mm:ss ZZ").option("projectKey", se.projectKey).option("streamingEndpointId", se.id).option("streamingEndpointSchema", JSON.json((Object)se.schema)).option("apiTicket", apiTicket).load();
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ boolean $anonfun$getStreamingReader$1(SimpleKeyValue p) {
        return p.key != null && !p.key.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getStreamingReader$3(List excludedProperties$1, String x$15) {
        return !excludedProperties$1.contains((Object)x$15);
    }

    public static final /* synthetic */ boolean $anonfun$getStreamingReader$8(String[] timestampColumnNames$1, String n) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timestampColumnNames$1)).contains((Object)n);
    }

    public static final /* synthetic */ boolean $anonfun$getStreamingReader$9(String[] timestampColumnNames$1, Buffer keyColumnNames$1, String n) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timestampColumnNames$1)).contains((Object)n) && !keyColumnNames$1.contains((Object)n);
    }

    private StructuredStreamingReader$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.streaming.reader");
    }
}

