/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client;

import com.dataiku.dss.shadelib.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ErrorObject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ErrorResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.RegistrationError;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Immutable
public class ClientRegistrationErrorResponse
extends ClientRegistrationResponse
implements ErrorResponse {
    private final ErrorObject error;

    public static Set<ErrorObject> getStandardErrors() {
        HashSet<ErrorObject> stdErrors = new HashSet<ErrorObject>();
        stdErrors.add(BearerTokenError.MISSING_TOKEN);
        stdErrors.add(BearerTokenError.INVALID_REQUEST);
        stdErrors.add(BearerTokenError.INVALID_TOKEN);
        stdErrors.add(BearerTokenError.INSUFFICIENT_SCOPE);
        stdErrors.add(RegistrationError.INVALID_REDIRECT_URI);
        stdErrors.add(RegistrationError.INVALID_CLIENT_METADATA);
        stdErrors.add(RegistrationError.INVALID_SOFTWARE_STATEMENT);
        stdErrors.add(RegistrationError.UNAPPROVED_SOFTWARE_STATEMENT);
        return Collections.unmodifiableSet(stdErrors);
    }

    public ClientRegistrationErrorResponse(ErrorObject error) {
        this.error = Objects.requireNonNull(error);
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error instanceof BearerTokenError) {
            BearerTokenError bte = (BearerTokenError)this.error;
            httpResponse.setWWWAuthenticate(bte.toWWWAuthenticateHeader());
        } else {
            JSONObject jsonObject = new JSONObject();
            if (this.error.getCode() != null) {
                jsonObject.put("error", this.error.getCode());
            }
            if (this.error.getDescription() != null) {
                jsonObject.put("error_description", this.error.getDescription());
            }
            httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
            httpResponse.setBody(jsonObject.toString());
        }
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        return httpResponse;
    }

    public static ClientRegistrationErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCodeNotOK();
        String wwwAuth = httpResponse.getWWWAuthenticate();
        ErrorObject error = StringUtils.isNotBlank(wwwAuth) ? BearerTokenError.parse(wwwAuth) : ErrorObject.parse(httpResponse);
        return new ClientRegistrationErrorResponse(error);
    }
}

