/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.rp.statement;

import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEObjectType;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.RemoteKeySourceException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.JWKSet;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.source.JWKSource;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.BadJOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.DefaultResourceRetriever;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.rp.statement.InvalidSoftwareStatementException;
import com.dataiku.dss.shadelib.net.jcip.annotations.ThreadSafe;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafe
public class SoftwareStatementProcessor<C extends SecurityContext> {
    private final boolean required;
    private final DefaultJWTProcessor<C> processor;

    public SoftwareStatementProcessor(Issuer issuer, boolean required, Set<JWSAlgorithm> jwsAlgs, JWKSet jwkSet) {
        this(issuer, required, jwsAlgs, new ImmutableJWKSet(jwkSet));
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean required, Set<JWSAlgorithm> jwsAlgs, URL jwkSetURL, int connectTimeoutMs, int readTimeoutMs, int sizeLimitBytes) {
        this(issuer, required, jwsAlgs, new RemoteJWKSet(jwkSetURL, new DefaultResourceRetriever(connectTimeoutMs, readTimeoutMs, sizeLimitBytes)));
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean required, Set<JWSAlgorithm> jwsAlgs, JWKSource<C> jwkSource) {
        this(issuer, required, jwsAlgs, jwkSource, Collections.emptySet());
    }

    @Deprecated
    public SoftwareStatementProcessor(Issuer issuer, boolean required, Set<JWSAlgorithm> jwsAlgs, JWKSource<C> jwkSource, Set<String> additionalRequiredClaims) {
        this(issuer, required, jwsAlgs, null, jwkSource, additionalRequiredClaims);
    }

    public SoftwareStatementProcessor(Issuer issuer, boolean required, Set<JWSAlgorithm> jwsAlgs, Set<JOSEObjectType> jwtTypes, JWKSource<C> jwkSource, Set<String> additionalRequiredClaims) {
        this.required = required;
        HashSet<String> allRequiredClaims = new HashSet<String>();
        allRequiredClaims.add("iss");
        if (CollectionUtils.isNotEmpty(additionalRequiredClaims)) {
            allRequiredClaims.addAll(additionalRequiredClaims);
        }
        this.processor = new DefaultJWTProcessor();
        if (CollectionUtils.isNotEmpty(jwtTypes)) {
            this.processor.setJWSTypeVerifier(new DefaultJOSEObjectTypeVerifier(jwtTypes));
        }
        this.processor.setJWSKeySelector(new JWSVerificationKeySelector<C>(jwsAlgs, jwkSource));
        this.processor.setJWTClaimsSetVerifier(new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer.getValue()).build(), allRequiredClaims));
    }

    public OIDCClientMetadata process(OIDCClientMetadata clientMetadata) throws InvalidSoftwareStatementException, JOSEException {
        return this.process(clientMetadata, null);
    }

    public OIDCClientMetadata process(OIDCClientMetadata clientMetadata, C context) throws InvalidSoftwareStatementException, JOSEException {
        JWTClaimsSet statementClaims;
        SignedJWT softwareStatement = clientMetadata.getSoftwareStatement();
        if (softwareStatement == null) {
            if (this.required) {
                throw new InvalidSoftwareStatementException("Missing required software statement");
            }
            return clientMetadata;
        }
        try {
            statementClaims = this.processor.process(softwareStatement, context);
        }
        catch (BadJOSEException e) {
            throw new InvalidSoftwareStatementException("Invalid software statement JWT: " + e.getMessage(), e);
        }
        catch (RemoteKeySourceException e) {
            throw new InvalidSoftwareStatementException("Software statement JWT validation failed: " + e.getMessage(), e);
        }
        JSONObject mergedMetadataJSONObject = new JSONObject();
        mergedMetadataJSONObject.putAll(clientMetadata.toJSONObject());
        mergedMetadataJSONObject.remove("software_statement");
        JSONObject statementJSONObject = JSONObjectUtils.toJSONObject(statementClaims);
        statementJSONObject.remove("iss");
        mergedMetadataJSONObject.putAll(statementJSONObject);
        try {
            return OIDCClientMetadata.parse(mergedMetadataJSONObject);
        }
        catch (ParseException e) {
            throw new InvalidSoftwareStatementException("Error merging software statement: " + e.getMessage(), e);
        }
    }
}

