/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.parser.processors;

import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.RefResponse;
import com.dataiku.dss.shadelib.io.swagger.models.Response;
import com.dataiku.dss.shadelib.io.swagger.models.Responses;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.Parameter;
import com.dataiku.dss.shadelib.io.swagger.parser.ResolverCache;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ParameterProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ResponseProcessor;
import java.util.List;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.responseProcessor = new ResponseProcessor(cache, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Responses responses = operation.getResponsesObject();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                Response response = (Response)responses.get(responseCode);
                if (response == null) continue;
                if (response instanceof RefResponse) {
                    RefResponse refResponse = (RefResponse)response;
                    this.responseProcessor.processResponse(response);
                    Response resolvedResponse = this.cache.loadRef(refResponse.get$ref(), refResponse.getRefFormat(), Response.class);
                    if (resolvedResponse != null) {
                        response = resolvedResponse;
                        responses.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response);
            }
        }
    }
}

