/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.de;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.de.GermanStemmer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class GermanStemFilter
extends TokenFilter {
    private GermanStemmer stemmer = new GermanStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s2;
            String term = this.termAtt.toString();
            if (!this.keywordAttr.isKeyword() && (s2 = this.stemmer.stem(term)) != null && !s2.equals(term)) {
                this.termAtt.setEmpty().append(s2);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

