/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.Field;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LatLonShapeBoundingBoxQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LatLonShapeDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LatLonShapeDocValuesField;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LatLonShapeDocValuesQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.document.LatLonShapeQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.document.ShapeField;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Circle;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.GeoEncodingUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.LatLonGeometry;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Line;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Point;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Polygon;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Rectangle;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Tessellator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ConstantScoreQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.util.ArrayList;
import java.util.List;

public class LatLonShape {
    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        return LatLonShape.createIndexableFields(fieldName, polygon, false);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Polygon polygon) {
        return LatLonShape.createDocValueField(fieldName, polygon, false);
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        Field[] fields = new ShapeField.Triangle[tessellation.size()];
        for (int i = 0; i < tessellation.size(); ++i) {
            fields[i] = new ShapeField.Triangle(fieldName, tessellation.get(i));
        }
        return fields;
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Polygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(tessellation.size());
        for (Tessellator.Triangle t2 : tessellation) {
            ShapeField.DecodedTriangle dt = new ShapeField.DecodedTriangle();
            dt.type = ShapeField.DecodedTriangle.TYPE.TRIANGLE;
            dt.setValues(t2.getEncodedX(0), t2.getEncodedY(0), t2.isEdgefromPolygon(0), t2.getEncodedX(1), t2.getEncodedY(1), t2.isEdgefromPolygon(0), t2.getEncodedX(2), t2.getEncodedY(2), t2.isEdgefromPolygon(2));
            triangles.add(dt);
        }
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)));
            ++i;
        }
        return fields;
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Line line) {
        int numPoints = line.numPoints();
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(numPoints - 1);
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            ShapeField.DecodedTriangle t2 = new ShapeField.DecodedTriangle();
            t2.type = ShapeField.DecodedTriangle.TYPE.LINE;
            t2.setValues(GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), true, GeoEncodingUtils.encodeLongitude(line.getLon(j)), GeoEncodingUtils.encodeLatitude(line.getLat(j)), true, GeoEncodingUtils.encodeLongitude(line.getLon(i)), GeoEncodingUtils.encodeLatitude(line.getLat(i)), true);
            triangles.add(t2);
            ++i;
        }
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        return new Field[]{new ShapeField.Triangle(fieldName, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat))};
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, double lat, double lon) {
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(1);
        ShapeField.DecodedTriangle t2 = new ShapeField.DecodedTriangle();
        t2.type = ShapeField.DecodedTriangle.TYPE.POINT;
        t2.setValues(GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true, GeoEncodingUtils.encodeLongitude(lon), GeoEncodingUtils.encodeLatitude(lat), true);
        triangles.add(t2);
        return new LatLonShapeDocValuesField(fieldName, triangles);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, BytesRef binaryValue) {
        return new LatLonShapeDocValuesField(fieldName, binaryValue);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, List<ShapeField.DecodedTriangle> tessellation) {
        return new LatLonShapeDocValuesField(fieldName, tessellation);
    }

    public static LatLonShapeDocValuesField createDocValueField(String fieldName, Field[] indexableFields) {
        ArrayList<ShapeField.DecodedTriangle> tess = new ArrayList<ShapeField.DecodedTriangle>(indexableFields.length);
        byte[] scratch = new byte[28];
        for (Field f : indexableFields) {
            BytesRef br = f.binaryValue();
            assert (br.length == 28);
            System.arraycopy(br.bytes, br.offset, scratch, 0, 28);
            ShapeField.DecodedTriangle t2 = new ShapeField.DecodedTriangle();
            ShapeField.decodeTriangle(scratch, t2);
            tess.add(t2);
        }
        return new LatLonShapeDocValuesField(fieldName, tess);
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && minLongitude > maxLongitude) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, 180.0), BooleanClause.Occur.MUST);
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, -180.0, maxLongitude), BooleanClause.Occur.MUST);
            return builder.build();
        }
        Rectangle rectangle = new Rectangle(minLatitude, maxLatitude, minLongitude, maxLongitude);
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, rectangle);
    }

    public static Query newSlowDocValuesBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && minLongitude > maxLongitude) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, 180.0), BooleanClause.Occur.MUST);
            builder.add(LatLonShape.newBoxQuery(field, queryRelation, minLatitude, maxLatitude, -180.0, maxLongitude), BooleanClause.Occur.MUST);
            return builder.build();
        }
        return new LatLonShapeDocValuesQuery(field, queryRelation, new Rectangle(minLatitude, maxLatitude, minLongitude, maxLongitude));
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, Line ... lines) {
        return LatLonShape.newGeometryQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, Polygon ... polygons) {
        return LatLonShape.newGeometryQuery(field, queryRelation, polygons);
    }

    public static Query newPointQuery(String field, ShapeField.QueryRelation queryRelation, double[] ... points) {
        LatLonGeometry[] pointArray = new Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointArray[i] = new Point(points[i][0], points[i][1]);
        }
        return LatLonShape.newGeometryQuery(field, queryRelation, pointArray);
    }

    public static Query newDistanceQuery(String field, ShapeField.QueryRelation queryRelation, Circle ... circle) {
        return LatLonShape.newGeometryQuery(field, queryRelation, circle);
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... latLonGeometries) {
        if (latLonGeometries.length == 1) {
            LatLonGeometry geometry = latLonGeometries[0];
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                return LatLonShape.newBoxQuery(field, queryRelation, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            }
            return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
        }
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            return LatLonShape.makeContainsGeometryQuery(field, latLonGeometries);
        }
        return new LatLonShapeQuery(field, queryRelation, latLonGeometries);
    }

    public static LatLonShapeDocValues createLatLonShapeDocValues(BytesRef bytesRef) {
        return new LatLonShapeDocValues(bytesRef);
    }

    private static Query makeContainsGeometryQuery(String field, LatLonGeometry ... latLonGeometries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LatLonGeometry geometry : latLonGeometries) {
            if (geometry instanceof Rectangle) {
                Rectangle rect = (Rectangle)geometry;
                builder.add(LatLonShape.newBoxQuery(field, ShapeField.QueryRelation.CONTAINS, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon), BooleanClause.Occur.MUST);
                continue;
            }
            builder.add(new LatLonShapeQuery(field, ShapeField.QueryRelation.CONTAINS, geometry), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery(builder.build());
    }
}

