/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.ConjunctionIntervalsSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.Disjunctions;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.FilteringIntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.Intervals;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalsSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class ContainingIntervalsSource
extends ConjunctionIntervalsSource {
    private final IntervalsSource big;
    private final IntervalsSource small;

    static IntervalsSource build(IntervalsSource big, IntervalsSource small) {
        return Intervals.or(Disjunctions.pullUp(big, s2 -> new ContainingIntervalsSource((IntervalsSource)s2, small)));
    }

    private ContainingIntervalsSource(IntervalsSource big, IntervalsSource small) {
        super(Arrays.asList(big, small));
        this.big = big;
        this.small = small;
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        assert (iterators.size() == 2);
        IntervalIterator a = iterators.get(0);
        IntervalIterator b = iterators.get(1);
        return new FilteringIntervalIterator(a, b){

            @Override
            public int nextInterval() throws IOException {
                if (!this.bpos) {
                    return Integer.MAX_VALUE;
                }
                while (this.a.nextInterval() != Integer.MAX_VALUE) {
                    while (this.b.start() < this.a.start() && this.b.end() < this.a.end()) {
                        if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                        this.bpos = false;
                        return Integer.MAX_VALUE;
                    }
                    if (this.a.start() > this.b.start() || this.a.end() < this.b.end()) continue;
                    return this.a.start();
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    @Override
    public int minExtent() {
        return this.big.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.big, s2 -> new ContainingIntervalsSource((IntervalsSource)s2, this.small));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ContainingIntervalsSource)) {
            return false;
        }
        ContainingIntervalsSource o = (ContainingIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "CONTAINING(" + this.big + "," + this.small + ")";
    }
}

