/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.builders;

import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import java.util.List;

public class BooleanQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        BooleanQueryNode booleanNode = (BooleanQueryNode)queryNode;
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        List<QueryNode> children = booleanNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanQueryNodeBuilder.getModifierValue(child));
                }
                catch (IndexSearcher.TooManyClauses ex) {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.TOO_MANY_BOOLEAN_CLAUSES, IndexSearcher.getMaxClauseCount(), queryNode.toQueryString(new EscapeQuerySyntaxImpl())), (Throwable)ex);
                }
            }
        }
        return bQuery.build();
    }

    private static BooleanClause.Occur getModifierValue(QueryNode node) {
        if (node instanceof ModifierQueryNode) {
            ModifierQueryNode mNode = (ModifierQueryNode)node;
            switch (mNode.getModifier()) {
                case MOD_REQ: {
                    return BooleanClause.Occur.MUST;
                }
                case MOD_NOT: {
                    return BooleanClause.Occur.MUST_NOT;
                }
                case MOD_NONE: {
                    return BooleanClause.Occur.SHOULD;
                }
            }
        }
        return BooleanClause.Occur.SHOULD;
    }
}

