/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.security;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.IOResources;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.AbstractLoginService;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.IdentityService;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.RolePrincipal;
import com.dataiku.dss.shadelib.org.eclipse.jetty.security.UserPrincipal;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Loader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.ResourceFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.security.Credential;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCLoginService
extends AbstractLoginService {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCLoginService.class);
    protected String _config;
    protected String _jdbcDriver;
    protected String _url;
    protected String _userName;
    protected String _password;
    protected String _userTableKey;
    protected String _userTablePasswordField;
    protected String _roleTableRoleField;
    protected String _userSql;
    protected String _roleSql;
    protected Connection _con;

    public JDBCLoginService() {
    }

    public JDBCLoginService(String name) {
        this.setName(name);
    }

    public JDBCLoginService(String name, String config) {
        this.setName(name);
        this.setConfig(config);
    }

    public JDBCLoginService(String name, IdentityService identityService, String config) {
        this.setName(name);
        this.setIdentityService(identityService);
        this.setConfig(config);
    }

    @Override
    protected void doStart() throws Exception {
        Properties properties = new Properties();
        try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();
             InputStream in = IOResources.asInputStream(resourceFactory.newResource(this._config));){
            properties.load(in);
        }
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        this._userTableKey = properties.getProperty("usertablekey");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        String userTable = properties.getProperty("usertable");
        String userTableUserField = properties.getProperty("usertableuserfield");
        String roleTable = properties.getProperty("roletable");
        String roleTableKey = properties.getProperty("roletablekey");
        String userRoleTable = properties.getProperty("userroletable");
        String userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        String userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        if (this._jdbcDriver == null || this._jdbcDriver.isEmpty() || this._url == null || this._url.isEmpty() || this._userName == null || this._userName.isEmpty() || this._password == null) {
            LOG.warn("UserRealm {} has not been properly configured", (Object)this.getName());
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + userTable + " where " + userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + roleTable + " r, " + userRoleTable + " u where u." + userRoleTableUserKey + " = ? and r." + roleTableKey + " = u." + userRoleTableRoleKey;
        Loader.loadClass(this._jdbcDriver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        super.doStart();
    }

    public String getConfig() {
        return this._config;
    }

    public void setConfig(String config) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = config;
    }

    public Connection connectDatabase() throws SQLException {
        return DriverManager.getConnection(this._url, this._userName, this._password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserPrincipal loadUserInfo(String username) {
        try {
            if (null == this._con) {
                this._con = this.connectDatabase();
            }
            try (PreparedStatement stat1 = this._con.prepareStatement(this._userSql);){
                stat1.setObject(1, username);
                try (ResultSet rs1 = stat1.executeQuery();){
                    if (!rs1.next()) return null;
                    int key = rs1.getInt(this._userTableKey);
                    String credentials = rs1.getString(this._userTablePasswordField);
                    JDBCUserPrincipal jDBCUserPrincipal = new JDBCUserPrincipal(username, Credential.getCredential(credentials), key);
                    return jDBCUserPrincipal;
                }
            }
        }
        catch (SQLException e) {
            LOG.warn("LoginService {} could not load user {}", new Object[]{this.getName(), username, e});
            this.closeConnection();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RolePrincipal> loadRoleInfo(UserPrincipal user) {
        if (user == null) {
            return null;
        }
        JDBCUserPrincipal jdbcUser = (JDBCUserPrincipal)user;
        try {
            if (null == this._con) {
                this._con = this.connectDatabase();
            }
            ArrayList<String> roles = new ArrayList<String>();
            try (PreparedStatement stat2 = this._con.prepareStatement(this._roleSql);){
                List<RolePrincipal> list;
                block17: {
                    stat2.setInt(1, jdbcUser.getUserKey());
                    ResultSet rs2 = stat2.executeQuery();
                    try {
                        while (rs2.next()) {
                            roles.add(rs2.getString(this._roleTableRoleField));
                        }
                        list = roles.stream().map(RolePrincipal::new).collect(Collectors.toList());
                        if (rs2 == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs2 != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs2.close();
                }
                return list;
            }
        }
        catch (SQLException e) {
            LOG.warn("LoginService {} could not load roles for user {}", new Object[]{this.getName(), user.getName(), e});
            this.closeConnection();
            return null;
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.closeConnection();
        super.doStop();
    }

    private void closeConnection() {
        if (this._con != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing db connection for JDBCLoginService");
            }
            try {
                this._con.close();
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
        }
        this._con = null;
    }

    public static class JDBCUserPrincipal
    extends UserPrincipal {
        final int _userKey;

        public JDBCUserPrincipal(String name, Credential credential, int key) {
            super(name, credential);
            this._userKey = key;
        }

        public int getUserKey() {
            return this._userKey;
        }
    }
}

