/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.AbstractConnection;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SecureRequestCustomizer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.SslConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.util.Iterator;
import java.util.List;

@ManagedObject
public abstract class AbstractConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final String _protocol;
    private final List<String> _protocols;
    private int _inputBufferSize = 8192;

    protected AbstractConnectionFactory(String protocol) {
        this._protocol = protocol;
        this._protocols = List.of(protocol);
    }

    protected AbstractConnectionFactory(String ... protocols) {
        this._protocol = protocols[0];
        this._protocols = List.of(protocols);
    }

    @Override
    @ManagedAttribute(value="The protocol name", readonly=true)
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public List<String> getProtocols() {
        return this._protocols;
    }

    @ManagedAttribute(value="The buffer size used to read from the network")
    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int size) {
        this._inputBufferSize = size;
    }

    protected String findNextProtocol(Connector connector) {
        return AbstractConnectionFactory.findNextProtocol(connector, this.getProtocol());
    }

    protected static String findNextProtocol(Connector connector, String currentProtocol) {
        String nextProtocol = null;
        Iterator<String> it = connector.getProtocols().iterator();
        while (it.hasNext()) {
            String protocol = it.next();
            if (!currentProtocol.equalsIgnoreCase(protocol)) continue;
            nextProtocol = it.hasNext() ? it.next() : null;
            break;
        }
        return nextProtocol;
    }

    protected <T extends AbstractConnection> T configure(T connection, Connector connector, EndPoint endPoint) {
        connector.getEventListeners().forEach(connection::addEventListener);
        this.getEventListeners().forEach(connection::addEventListener);
        connection.setInputBufferSize(this.getInputBufferSize());
        return connection;
    }

    @Override
    public String toString() {
        return String.format("%s@%x%s", this.getClass().getSimpleName(), this.hashCode(), this.getProtocols());
    }

    public static ConnectionFactory[] getFactories(SslContextFactory.Server sslContextFactory, ConnectionFactory ... factories) {
        factories = ArrayUtil.removeNulls(factories);
        if (sslContextFactory == null) {
            return factories;
        }
        for (ConnectionFactory factory : factories) {
            HttpConfiguration config;
            if (!(factory instanceof HttpConfiguration.ConnectionFactory) || (config = ((HttpConfiguration.ConnectionFactory)((Object)factory)).getHttpConfiguration()).getCustomizer(SecureRequestCustomizer.class) != null) continue;
            config.addCustomizer(new SecureRequestCustomizer());
        }
        return ArrayUtil.prependToArray(new SslConnectionFactory(sslContextFactory, factories[0].getProtocol()), factories, ConnectionFactory.class);
    }
}

