/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpFields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.ExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.WebSocketHttpFieldsWrapper;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;
import java.util.ArrayList;
import java.util.List;

public class ServerUpgradeResponseImpl
extends Response.Wrapper
implements ServerUpgradeResponse {
    private final Response response;
    private final WebSocketNegotiation negotiation;
    private final HttpFields.Mutable fields;

    public ServerUpgradeResponseImpl(WebSocketNegotiation negotiation, Response baseResponse) {
        super(baseResponse.getRequest(), baseResponse);
        this.negotiation = negotiation;
        this.response = baseResponse;
        this.fields = new WebSocketHttpFieldsWrapper(this.response.getHeaders(), this, negotiation);
    }

    @Override
    public HttpFields.Mutable getHeaders() {
        return this.fields;
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.negotiation.getSubprotocol();
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
        this.negotiation.setSubprotocol(protocol);
        this.response.getHeaders().put(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        return this.negotiation.getNegotiatedExtensions();
    }

    @Override
    public void addExtensions(List<ExtensionConfig> configs) {
        ArrayList<ExtensionConfig> combinedConfig = new ArrayList<ExtensionConfig>(this.getExtensions());
        combinedConfig.addAll(configs);
        this.setExtensions(combinedConfig);
    }

    @Override
    public void removeExtensions(List<ExtensionConfig> configs) {
        ArrayList<ExtensionConfig> trimmedExtensions = new ArrayList<ExtensionConfig>(this.getExtensions());
        trimmedExtensions.removeAll(configs);
        this.setExtensions(trimmedExtensions);
    }

    @Override
    public void setExtensions(List<ExtensionConfig> configs) {
        for (ExtensionConfig config : configs) {
            if (config.getName().startsWith("@")) continue;
            long matches = this.negotiation.getOfferedExtensions().stream().filter(e -> e.getName().equals(config.getName())).count();
            if (matches < 1L) {
                throw new IllegalArgumentException("Extension not a requested extension");
            }
            matches = configs.stream().filter(e -> e.getName().equals(config.getName())).count();
            if (matches <= 1L) continue;
            throw new IllegalArgumentException("Multiple extensions of the same name");
        }
        this.negotiation.setNegotiatedExtensions(configs);
    }

    public String toString() {
        return String.format("UpgradeResponse=%s", this.response);
    }
}

