/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import jj2000.j2k.util.MsgLogger;
import jj2000.j2k.util.ProgressWatch;
import jj2000.j2k.util.StreamMsgLogger;

public class FacilityManager {
    private static final StreamMsgLogger DEFAULT_LOGGER = new StreamMsgLogger(System.out, System.err, 78);
    private static final Map<Thread, MsgLogger> loggerList = Collections.synchronizedMap(new WeakHashMap());
    private static volatile MsgLogger defMsgLogger = DEFAULT_LOGGER;
    private static final Map<Thread, ProgressWatch> watchProgList = Collections.synchronizedMap(new WeakHashMap());
    private static volatile ProgressWatch defWatchProg = null;

    public static void registerProgressWatch(Thread t, ProgressWatch pw) {
        if (pw == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            defWatchProg = pw;
        } else {
            watchProgList.put(t, pw);
        }
    }

    public static void unregisterProgressWatch(Thread t) {
        if (t == null) {
            defWatchProg = null;
        } else {
            watchProgList.remove(t);
        }
    }

    public static ProgressWatch getProgressWatch() {
        ProgressWatch pw = watchProgList.get(Thread.currentThread());
        return pw == null ? defWatchProg : pw;
    }

    public static void registerMsgLogger(Thread t, MsgLogger ml) {
        if (ml == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            defMsgLogger = ml;
        } else {
            loggerList.put(t, ml);
        }
    }

    public static void unregisterMsgLogger(Thread t) {
        if (t == null) {
            defMsgLogger = DEFAULT_LOGGER;
        } else {
            loggerList.remove(t);
        }
    }

    public static MsgLogger getMsgLogger() {
        MsgLogger ml = loggerList.get(Thread.currentThread());
        return ml == null ? defMsgLogger : ml;
    }

    public static MsgLogger getMsgLogger(Thread t) {
        MsgLogger ml = loggerList.get(t);
        return ml == null ? defMsgLogger : ml;
    }
}

