/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastSafePatternMatcher {
    private final ThreadLocal<Matcher> m = new ThreadLocal();
    private final Pattern compiled;

    public FastSafePatternMatcher(Pattern compiled) {
        this.compiled = compiled;
    }

    public FastSafePatternMatcher(String pattern) {
        this(Pattern.compile(pattern));
    }

    public FastSafePatternMatcher(String pattern, int flags) {
        this(Pattern.compile(pattern, flags));
    }

    public boolean matches(String v) {
        Matcher matcher = this.m.get();
        if (matcher == null) {
            matcher = this.compiled.matcher(v);
            this.m.set(matcher);
            return matcher.matches();
        }
        matcher.reset(v);
        return matcher.matches();
    }

    public boolean find(String v) {
        Matcher matcher = this.m.get();
        if (matcher == null) {
            matcher = this.compiled.matcher(v);
            this.m.set(matcher);
            return matcher.find();
        }
        matcher.reset(v);
        return matcher.find();
    }

    public Matcher getMatcher(String v) {
        Matcher matcher = this.m.get();
        if (matcher == null) {
            matcher = this.compiled.matcher(v);
            this.m.set(matcher);
        } else {
            matcher.reset(v);
        }
        return matcher;
    }
}

