/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.io.ByteBufferIO;
import com.atilika.kuromoji.util.ResourceResolver;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class ConnectionCosts {
    public static final String CONNECTION_COSTS_FILENAME = "connectionCosts.bin";
    private int size;
    private ShortBuffer costs;

    public ConnectionCosts(int size, ShortBuffer costs) {
        this.size = size;
        this.costs = costs;
    }

    public int get(int forwardId, int backwardId) {
        return this.costs.get(backwardId + forwardId * this.size);
    }

    public static ConnectionCosts newInstance(ResourceResolver resolver) throws IOException {
        return ConnectionCosts.read(resolver.resolve(CONNECTION_COSTS_FILENAME));
    }

    private static ConnectionCosts read(InputStream input) throws IOException {
        DataInputStream dataInput = new DataInputStream(new BufferedInputStream(input));
        int size = dataInput.readInt();
        ByteBuffer byteBuffer = ByteBufferIO.read(dataInput);
        ShortBuffer costs = byteBuffer.asShortBuffer();
        return new ConnectionCosts(size, costs);
    }
}

