/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder;

import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.IAEBuilder;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.exceptions.SQLEngineMemoryException;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTDefaultVisitor;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.InvalidOperationException;

public abstract class AEBuilderBase<T extends IAENode>
extends PTDefaultVisitor<T>
implements IAEBuilder {
    private AEQueryScope m_queryScope;

    protected AEBuilderBase(AEQueryScope aEQueryScope) {
        this.m_queryScope = aEQueryScope;
    }

    public T build(IPTNode iPTNode) throws ErrorException {
        try {
            return (T)((IAENode)iPTNode.acceptVisitor(this));
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
    }

    protected AEQueryScope getQueryScope() {
        return this.m_queryScope;
    }

    @Override
    protected final T defaultVisit(IPTNode iPTNode) {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iPTNode + " from base AE tree builder class");
    }
}

