/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Normalization {
    private Pattern isoPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.*(Z|[+-]).*");
    DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTimeParser().withZoneUTC();
    final DateTimeFormatter mllibFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private Pattern rfc822Pattern = Pattern.compile("(Mon|Tue|Wed|Thu|Fri|Sat|Sun)");
    SimpleDateFormat rfc822Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private Pattern dateOnlyPattern;
    DateTimeFormatter dateOnlyFormatter;
    private Pattern datetimeNoTzPattern;
    private final DateTimeParser millisecondsParser;
    DateTimeFormatter datetimeNoTzFormatter;
    public static final long EPOCH_SHIFT = 2208988800L;
    public final Map<String, Action> actions;
    private static final Logger logger = Logger.getLogger("dku.scoring");

    public Normalization(String[] columns, Action[] actions) {
        this(Normalization.toMap(columns, actions));
    }

    public Normalization(Map<String, Action> actions) {
        this.rfc822Format.setLenient(false);
        this.dateOnlyPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
        this.dateOnlyFormatter = ISODateTimeFormat.dateParser().withZoneUTC();
        this.datetimeNoTzPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?");
        this.millisecondsParser = new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(0, 6).toParser();
        this.datetimeNoTzFormatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral(' ').append(ISODateTimeFormat.hourMinuteSecond()).appendOptional(this.millisecondsParser).toFormatter().withZoneUTC();
        this.actions = actions;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Action> action : actions.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(action.getKey()).append("->").append((Object)action.getValue());
        }
        logger.info("Normalize columns " + sb.toString());
    }

    private static Map<String, Action> toMap(String[] columns, Action[] actions) {
        if (columns.length != actions.length) {
            throw new IllegalArgumentException("columns and numeric must have same length");
        }
        HashMap<String, Action> map = new HashMap<String, Action>();
        for (int i = 0; i < columns.length; ++i) {
            map.put(columns[i], actions[i]);
        }
        return map;
    }

    public Object normalize(String column, Object value) {
        Action action = this.actions.get(column);
        if (action != null) {
            switch (action) {
                case CREATE: {
                    return null;
                }
                case TO_EPOCH: {
                    return this.normalizeDateToNumber(value, false);
                }
                case TO_MLLIB_EPOCH: {
                    return this.normalizeDateToNumber(value, true);
                }
                case TO_STRING: {
                    return this.normalizeDateToString(value, false);
                }
                case TO_MLLIB_STRING: {
                    return this.normalizeDateToString(value, true);
                }
            }
        }
        return value;
    }

    private Object normalizeDateToNumber(Object value, boolean isMllib) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.secondsSinceEpoch((String)value, isMllib);
        }
        if (value instanceof Number) {
            if (!isMllib) {
                return ((Number)value).doubleValue() + 2.2089888E9;
            }
            return value;
        }
        throw new IllegalArgumentException("Cannot normalize value of type " + value.getClass().getCanonicalName() + " to ms since epoch");
    }

    private Object normalizeDateToString(Object value, boolean isMllib) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (isMllib) {
                return this.mllibFormattedDate((String)value);
            }
            return this.isoFormatter.withZoneUTC().parseDateTime((String)value).toString();
        }
        if (value instanceof Number) {
            if (isMllib) {
                return this.mllibFormatter.print(((Number)value).longValue());
            }
            return this.isoFormatter.print(((Number)value).longValue());
        }
        throw new IllegalArgumentException("Cannot normalize value of type " + value.getClass().getCanonicalName() + " to iso8601");
    }

    public Double secondsSinceEpoch(String v, boolean isMllib) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        if (v.length() >= 10 && Character.isDigit(v.charAt(0))) {
            if (v.length() == 10 && this.dateOnlyPattern.matcher(v).matches()) {
                try {
                    return (double)(isMllib ? 0L : 2208988800L) + (double)this.dateOnlyFormatter.parseMillis(v) / 1000.0;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (v.charAt(10) == ' ' && this.datetimeNoTzPattern.matcher(v).matches()) {
                try {
                    return (double)(isMllib ? 0L : 2208988800L) + (double)this.datetimeNoTzFormatter.parseMillis(v) / 1000.0;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (this.isoPattern.matcher(v).matches()) {
                try {
                    return (double)(isMllib ? 0L : 2208988800L) + (double)this.isoFormatter.parseMillis(v) / 1000.0;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        if (v.length() >= 15 && Character.isUpperCase(v.charAt(0)) && this.rfc822Pattern.matcher(v).find()) {
            try {
                return (double)(isMllib ? 0L : 2208988800L) + (double)this.rfc822Format.parse(v).getTime() / 1000.0;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String mllibFormattedDate(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        if (v.length() >= 18 && Character.isDigit(v.charAt(0)) && this.isoPattern.matcher(v).matches()) {
            try {
                return this.mllibFormatter.print(this.isoFormatter.parseMillis(v));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (v.length() >= 15 && Character.isUpperCase(v.charAt(0)) && this.rfc822Pattern.matcher(v).find()) {
            try {
                return this.mllibFormatter.print(this.rfc822Format.parse(v).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static enum Action {
        CREATE,
        TO_EPOCH,
        TO_MLLIB_EPOCH,
        TO_STRING,
        TO_MLLIB_STRING;

    }
}

